<?php
namespace TRegx\CleanRegex\Internal\Prepared\Parser\Consumer;

use TRegx\CleanRegex\Internal\Prepared\Parser\Entity\Quote;
use TRegx\CleanRegex\Internal\Prepared\Parser\EntitySequence;
use TRegx\CleanRegex\Internal\Prepared\Parser\Feed\Feed;

class QuoteConsumer implements Consumer
{
    public function condition(Feed $feed): Condition
    {
        return $feed->string('\Q');
    }

    public function consume(Feed $feed, EntitySequence $entities): void
    {
        $entities->append($this->consumeQuote($feed));
    }

    private function consumeQuote(Feed $feed): Quote
    {
        $quote = '';
        $quoteEnd = $feed->string('\E');
        while (!$feed->empty()) {
            if ($quoteEnd->consumable()) {
                $quoteEnd->commit();
                return new Quote($quote, true);
            }
            $letter = $feed->letter();
            $quote .= $letter->asString();
            $letter->commit();
        }
        return new Quote($quote, false);
    }
}
