<?php

/**
 * Plugin Name: Wow Carousel for Divi (PRO)
 * Plugin URI:  https://wowcarousel.com
 * Description: A Divi touch enabled plugin that lets you create a beautiful responsive carousel slider.
 * Version:     2.3.2

 * Update URI: https://api.freemius.com
 * Author:      DiviPeople
 * Author URI:  http://divipeople.com/
 * License:     GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: wdc-wow-divi-carousel
 * Domain Path: /languages
 *
 * Wow Divi Carousel is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * WoW Divi Carousel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Wow Divi Carousel. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
 *
 * @package WOW_DIVI_CAROUSEL
 */
// Exit if accessed directly.
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
define( 'WOW_DIVI_CAROUSEL_VERSION', '2.3.2' );
define( 'WOW_DIVI_CAROUSEL_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'WOW_DIVI_CAROUSEL_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'WOW_DIVI_CAROUSEL_ASSETS', trailingslashit( WOW_DIVI_CAROUSEL_PLUGIN_URL . 'assets' ) );
define( 'WOW_DIVI_CAROUSEL_PLUGIN_FILE', __FILE__ );
define( 'WOW_DIVI_CAROUSEL_PLUGIN_BASE', plugin_basename( __FILE__ ) );
//phpcs:disable
#ET_START_REPLACE

if ( function_exists( 'wdc_fs' ) ) {
    wdc_fs()->set_basename( true, __FILE__ );
} else {
    
    if ( !function_exists( 'wdc_fs' ) ) {
        // Create a helper function for easy SDK access.
        function wdc_fs()
        {
            global  $wdc_fs ;
            
            if ( !isset( $wdc_fs ) ) {
                // Activate multisite network integration.
                if ( !defined( 'WP_FS__PRODUCT_5663_MULTISITE' ) ) {
                    define( 'WP_FS__PRODUCT_5663_MULTISITE', true );
                }
                // Include Freemius SDK.
                require_once dirname( __FILE__ ) . '/freemius/start.php';
                $wdc_fs = fs_dynamic_init( [
                    'id'               => '5663',
                    'slug'             => 'wow-divi-carousel',
                    'type'             => 'plugin',
                    'public_key'       => 'pk_bc2f6a51732117f167fcc8c2d8062',
                    'is_premium'       => true,
                    'is_premium_only'  => true,
                    'has_addons'       => false,
                    'has_paid_plans'   => true,
                    'is_org_compliant' => true,
                    'has_affiliation'  => 'selected',
                    'menu'             => [
                    'slug'        => 'wow-divi-carousel',
                    'first-path'  => 'admin.php?page=wow-divi-carousel',
                    'contact'     => false,
                    'support'     => false,
                    'affiliation' => false,
                ],
                    'is_live'          => true,
                ] );
            }
            
            return $wdc_fs;
        }
        
        // Init Freemius.
        wdc_fs();
        // Signal that SDK was initiated.
        do_action( 'wdc_fs_loaded' );
    }

}

#ET_END_REPLACE
//phpcs:enable
if ( !class_exists( 'Wow_Divi_Carousel' ) ) {
    /**
     * Main Class
     *
     * @since 1.0.0
     */
    final class Wow_Divi_Carousel
    {
        /**
         * This plugin's instance.
         *
         * @since 1.0.0
         */
        private static  $instance ;
        /**
         * Construct Method
         */
        private function __construct()
        {
            register_activation_hook( __FILE__, [ $this, 'activate' ] );
            add_action( 'plugins_loaded', [ $this, 'init_plugin' ] );
        }
        
        /**
         * Main Wow_Divi_Carousel Instance.
         *
         * @since 1.0.0
         */
        public static function instance()
        {
            
            if ( !isset( self::$instance ) && !self::$instance instanceof Wow_Divi_Carousel ) {
                self::$instance = new Wow_Divi_Carousel();
                self::$instance->init();
                self::$instance->includes();
            }
            
            return self::$instance;
        }
        
        /**
         * Load actions
         *
         * @return void
         */
        private function init()
        {
            add_action( 'divi_extensions_init', [ $this, 'initialize_extension' ] );
        }
        
        /**
         * Init Plugin
         */
        public function init_plugin()
        {
            
            if ( is_admin() ) {
                new WowDiviCarousel\Admin();
            } else {
                new WowDiviCarousel\AssetsManager();
            }
        
        }
        
        /**
         * Do stuff upon plugin activate
         *
         * @return void
         */
        public function activate()
        {
            update_option( 'wdc_version', WOW_DIVI_CAROUSEL_VERSION );
        }
        
        /**
         * Include required files.
         *
         *
         *
         *
         * @since 1.0.0
         *
         * @return void
         */
        private function includes()
        {
            if ( is_admin() ) {
                require_once WOW_DIVI_CAROUSEL_PLUGIN_DIR . 'includes/Admin.php';
            }
            require_once WOW_DIVI_CAROUSEL_PLUGIN_DIR . 'includes/AssetsManager.php';
            require_once WOW_DIVI_CAROUSEL_PLUGIN_DIR . 'includes/Api/GMB.php';
            $gmb = new \WowDiviCarousel\Api\Google_My_Business();
            $gmb->init();
            require_once WOW_DIVI_CAROUSEL_PLUGIN_DIR . 'includes/Api/GPR.php';
            require_once WOW_DIVI_CAROUSEL_PLUGIN_DIR . 'includes/functions.php';
            // Traits.
            require_once WOW_DIVI_CAROUSEL_PLUGIN_DIR . 'includes/traits/instagram-feed.php';
            $inactive_modules = get_option( 'wdc_inactive_modules', [] );
            if ( !in_array( 'product-carousel', $inactive_modules, true ) ) {
                require_once WOW_DIVI_CAROUSEL_PLUGIN_DIR . 'includes/modules/ProductCarousel/WowProductHelper.php';
            }
        }
        
        /**
         * Creates the extension's main class instance.
         *
         * @since 1.0.0
         */
        public function initialize_extension()
        {
            require_once WOW_DIVI_CAROUSEL_PLUGIN_DIR . 'includes/DiviExtension.php';
        }
    
    }
}
/**
 * The main function for that returns Wow_Divi_Carousel
 *
 * Instance to functions everywhere.
 *
 *
 *
 *
 * @since 1.0.0
 *
 * @return Wow Divi Carousel
 */
function WOW_DIVI_CAROUSEL()
{
    // phpcs:ignore
    return Wow_Divi_Carousel::instance();
}

// Get the plugin running.
WOW_DIVI_CAROUSEL();