<?php
$qv_gallery    = '';
$qv_rating     = '';
$qv_price      = '';
$qv_excerpt    = '';
$qv_btn        = '';
$qv_categories = '';

if ( 'on' === $args['show_qv_gallery'] ) {
	$qv_gallery = WowProductHelper::render_woo_gallery();

} elseif ( 'off' === $args['show_qv_gallery'] ) {
	$qv_gallery = sprintf(
		'<figure class="wdc-woo-quickview-figure">
			<img class ="wdc-img-cover" src="%1$s" alt = "%2$s" >
		</figure>',
		esc_url( get_the_post_thumbnail_url( $woo_post_id, 'full' ) ),
		esc_attr( $alt )
	);
}

if ( 'on' === $show_qv_ratings ) {
	$qv_rating = WowProductHelper::render_review( $woo_rating );
}

if ( 'on' === $show_qv_price ) {
	$qv_price = WowProductHelper::render_price( 'wdc-woo-price wdc-sale-price' );
}

if ( 'on' === $show_qv_desc ) {
	$qv_excerpt = sprintf( '<div class="wdc-quickview-desc">%1$s</div>', get_the_excerpt() );
}

if ( 'on' === $show_qv_cart_btn ) {
	$qv_btn = sprintf(
		'<div class="wdc-woo-act">
			<a href="%1$s"
				class="product_type_%2$s add_to_cart_button ajax_add_to_cart"
				data-product_id="%3$s"
			>
				<i class="wdc-ico-cart"></i>
				<span class="_default">%4$s</span>
				<span class="_adding">Loading...</span>
				<span class="_added">Added to cart</span>
			</a>
		</div>',
		esc_url( $product->add_to_cart_url() ),
		esc_attr( $product->get_type() ),
		esc_attr( $woo_post_id ),
		$qv_cart_btn_text
	);
}

if ( 'on' === $show_qv_categories ) {
	$qv_categories = WowProductHelper::render_product_category( true, $show_parent_category );
}

printf(
	'<div class="wdc-woo-quickview white-popup mfp-hide wdc-modal" id="wdc-modal-%1$s">
		<div class="wdc-woo-quickview-inner">
			%2$s
			<div class="wdc-woo-quickview-content">
				<h3>%3$s</h3>
				%4$s
				%5$s
				%6$s
				%7$s
				%8$s
			</div>
		</div>
	</div>',
	$woo_post_id, // phpcs:ignore
	et_core_intentionally_unescaped( $qv_gallery, 'html' ), // phpcs:ignore
	et_core_intentionally_unescaped( get_the_title(), 'html' ), // phpcs:ignore
	et_core_intentionally_unescaped( $qv_rating, 'html' ), // phpcs:ignore
	et_core_intentionally_unescaped( $qv_price, 'html' ), // phpcs:ignore
	et_core_intentionally_unescaped( $qv_excerpt, 'html' ), // phpcs:ignore
	et_core_intentionally_unescaped( $qv_btn, 'html' ), // phpcs:ignore
	et_core_intentionally_unescaped( $qv_categories, 'html' ) // phpcs:ignore
);

