<?php

    switch ($review->star_rating) {
	    case "FIVE" :
	        $star_rating = 5;
	        break;
	    case "FOUR" :
	        $star_rating = 4;
	        break;
	    case "THREE" :
	        $star_rating = 3;
	        break;
	    case "two" :
	        $star_rating = 2;
	        break;
	    default:
	       $star_rating = 1;
	}

	$date_class = ' wdc-time-' . $date_position;
?>

<div class="wdc-review-item wdc-carousel-item <?php echo esc_attr( $date_class ); ?>">
	<div class="wdc-review-item-inner">
        <?php
	        $reviewer_image = '';
	        if( $args['show_reviewer_image'] === 'on' ) {
	            $reviewer_image = sprintf(
	            	'<figure class="wdc-reviewer-photo">
	            		<img src="%1$s" alt="%2$s">
	            	</figure>',
	            	$review->reviewer->profilePhotoUrl,
	            	$review->reviewer->displayName
	            );
	        }

	        $reviewer_name = '';
	        if( $args['show_name'] === 'on' ) {

	            $reviewer_name = sprintf(
	            	'<h4 class="wdc-reviewer-name">
	            		%1$s
	            	</h4>',
	            	$review->reviewer->displayName
	            );

	        }

	        $reviewd_date = '';
	        if( $show_time === 'on' ) {

	        	$datetime = gmdate("Y/m/d", $review->createTime );
				$datetime = wdc_time_format( $datetime, false );

	            $reviewd_date = sprintf(
	            	'<div class="wdc-review-date">
	            		%1$s
	            	</div>',
	            	$month
	            );
	        }

	        $review_author = sprintf(
	        	'<div class="wdc-review-head">
	                <div class="wdc-review-author">
	                    %1$s
	                    <div class="wdc-review-author-info">
		                    %2$s
		                    %3$s
	                    </div>
	                </div>
	            </div>',
	            $reviewer_image,
	            $reviewer_name,
	            $date_position === 'default' ? $reviewd_date : ''
	        );

	        $google_full_star = sprintf( '<i data-icon="" class="wdc-et-icon wdc-full-star-icon"></i>' );
	        $google_o_star = sprintf( '<i data-icon="" class="wdc-et-icon wdc-o-star-icon"></i>' );

	        $google_ratings = '';
	        if( $args['show_ratings'] === 'on' ) {
				$google_ratings .= '<div class="wdc-review-stars">';
	        	for ($i=1; $i <= 5; $i++) {
	        		if( $i <= $star_rating ){
	        			$google_ratings .= $google_full_star;
	        		}else {
	        			$google_ratings .= $google_o_star;
	        		}
	        	}
				$google_ratings .= '</div>';
	        }

	        $review_text = '';
	    	if('off' !== $show_review_comment) {
		        if( ! empty( $review->comment ) ) {
			        $review_text = sprintf(
			        	'<div class="wdc-review-text">
			                %1$s
			            </div>',
			            $review->comment
			        );
		    	}
		    }

	    	$review_text_with_readmore = '';
	    	if('off' !== $show_review_comment) {
		    	if( ! empty( $review->comment ) ) {
		    		$review_comment = strip_tags( $review->comment );
					if (strlen($review_comment) > $text_lenght) {
					    $review_comment_cut = substr($review_comment, 0, $text_lenght);
					    $end_point = strrpos($review_comment_cut, ' ');
					    $review_comment_cut_last = substr($review_comment, $end_point);
					    $review_comment = $end_point ? substr($review_comment_cut, 0, $end_point) : substr($review_comment_cut, 0);
					    $review_comment .= '<span>... </span>';
					    $review_comment .= '<span class="wdc-more"> ' . ' '. $review_comment_cut_last . '</span>';
					    $review_comment .= '<span class="wdc-more-toggle">' . $read_more_text . '</span>';
					}

			        $review_text_with_readmore = sprintf(
			        	'<div class="wdc-review-text">
			                %1$s
			            </div>',
			            $review_comment
			        );
		    	}
		    }

	        $review_body = sprintf(
	        	'<div class="wdc-review-body">
	                %1$s
	                %2$s
	            </div>',
	            $google_ratings,
	            ( 'on' == $show_read_more ) ? $review_text_with_readmore : $review_text
	        );

	        $review_footer = '';
	        if( $date_position === 'footer' && !empty($reviewd_date)) {
		        $review_footer = sprintf('
		            <div class="wdc-review-footer">
		                %1$s
		            </div>',
		            $reviewd_date
		        );
	        }

	        /**
	         * Render the google review card
	         */
	        // Google icon
            echo $google_icon; //phpcs:ignore

            // Author - Top
            if( $reviewer_position === 'top' ) :
                echo $review_author; //phpcs:ignore
            endif;

            // Comment
            echo $review_body; //phpcs:ignore

            // Author - Bottom
            if( $reviewer_position === 'bottom' ) :
                echo $review_author; //phpcs:ignore
            endif;

            // Footer
            echo $review_footer; //phpcs:ignore

        ?>
    </div>
</div>