<?php
/**
 * Admin main template
 */

defined( 'ABSPATH' ) || die();
?>
<div class="wrap">
	<h1 class="screen-reader-text"><?php esc_html_e( 'Wow Divi Carousel', 'wdc-wow-divi-carousel' ); ?></h1>
	<form class="wdc-admin" id="wdc-admin-form">
		<div class="wdc-admin-header">
			<div class="wdc-admin-logo-inline">
				<img class="wdc-logo-icon-size" src="<?php echo esc_attr( WOW_DIVI_CAROUSEL_ASSETS ); ?>imgs/admin/wdc-logo-white.svg" alt="">
			</div>
			<div class="wdc-nav" role="tablist">
				<nav class="wdc-tabs-nav">
					<?php
						$navtab_count = 1;
					foreach ( self::get_tabs() as $slug => $navtab ) : //phpcs:ingore

						$slug = esc_attr( strtolower( $slug ) ); //phpcs:ingore

						$class = ' wdc-admin-nav-item-link';

						if ( $navtab_count === 1 ) {
							$class .= ' active-tab';
						}

						if ( ! empty( $navtab['href'] ) ) {
							$href = esc_url( $navtab['href'] );
						} else {
							$href = '#' . $slug;
						}

						printf(
							'
                                <a href="%1$s" aria-controls="tab-content-%2$s" id="tab-nav-%2$s" class="%3$s" role="tab">
                                    %5$s
                                </a>
                                <style type="text/css"> #tab-nav-%2$s { background-image: url(%4$s); } </style>
                                ',
							esc_url( $href ),
							esc_attr( $slug ),
							esc_attr( $class ),
							esc_html( $navtab['icon'] ),
							esc_attr( $navtab['title'] )
						);

						++$navtab_count;

						endforeach;
					?>
				</nav>
			</div>
		</div>

		<div class="wdc-admin-tabs">
			<div class="wdc-admin-tabs-content">
				<?php
				$navtab_count = 1;

				foreach ( self::get_tabs() as $slug => $navtab ) : //phpcs:ingore
					$class = 'wdc-admin-tabs-content-item';
					if ( $navtab_count === 1 ) {
						$class .= ' active-tab';
					}
					$slug = esc_attr( strtolower( $slug ) );
					?>

					<div class="<?php echo esc_attr( $class ); ?>" id="tab-content-<?php echo esc_attr($slug); ?>" role="tabpanel" aria-labelledby="tab-nav-<?php echo esc_attr($slug); ?>">
						<?php call_user_func( $navtab['renderer'], $slug, $navtab ); ?>
					</div>
					<?php
					++$navtab_count;
				endforeach;
			?>

				<div class="wdc-row wdc-admin-button-panel wdc-row-fixed-width">
					<div class="wdc-col">
						<button disabled class="wdc-btn wdc-btn-save wdc-btn-lg" type="submit">
							<?php esc_html_e( 'Save Settings', 'wdc-wow-divi-carousel' ); ?>
						</button>
					</div>
				</div>
			</div>
		</div>

		<div class="wdc-footer wdc-row-copyright">
			<h4>WowCarousel from <a href="http://divipeople.com/" target="_blank">Divipeople</a></h4>
		</div>
	</form>
</div>
