<?php
defined( 'ABSPATH' ) || die();

$wdc_options    = get_option( 'wdc_options' );
$google_api_key = '';
if ( $wdc_options ) {
	$google_api_key = $wdc_options['google_api_key'];
}
?>

<div class="wdc-admin-panel">
	<div class="wdc-google-body">
		<div class="wdc-row wdc-admin-modules-row wdc-row-fixed-width">
			<div class="wdc-col">
				<h3 class="wdc-feature-title">Google API Key</h3>
				<div class="wdc-box-content">
					<input type="text" name='options[google_api_key]' id="wdc_google_api_key" value='<?php echo $google_api_key; //phpcs:ignore ?>' placeholder="Enter Your API Key">
				</div>

				<div class="wdc-instruction-box">
					<h3 class="wdc-feature-title">Instruction</h3>
					<p class="wdc-text f16">
						The Google reviews module uses the Google Maps API and requires a valid Google API Key to function. Before using the google reviews module, please make sure you have added your API key here. Learn more about how to create your Google API Key below:
					</p>
					<h4>How to create Google Places API key</h4>
					<ol class="wdc-list wdc-instruction-list">
						<li>Go to your <a href="https://console.developers.google.com/apis/dashboard?pli=1" target="_blank">Google Console</a></li>
						<li>Click <span>'Create Project'</span> or <span>'Select Project'</span> button</li>
						<li>Create new project or select existing
						<li>On the project page click <span>'ENABLE APIS AND SERVICES'</span></li>
						<li>Type <span>'Places API'</span> in the search area
						<li>Select the first result <span>'Places API'</span> and click <span>'ENABLE'</span> button</li>
						<li>On the <span>'Places API'</span> page select <span>'Credential'</span> tab and <span>'Create credential' / 'API key'</span> option</li>
						<li>Copy created <span>API Key</span>, paste to this setting and save</li>
					</ol>
				</div>
				<div class="wdc-instruction-box">
					<h3 class="wdc-feature-title">I have more than 5 reviews, why can I only see 5 in google review module?</h3>
					<p class="wdc-text f16">The Google API only offers a maximum of 5 relevant reviews at a time.</p>
				</div>
			</div>
		</div>
	</div>
</div>
