<?php
/**
 * Admin home tab template
 */

defined( 'ABSPATH' ) || die();

$modules             = self::get_modules();
$inactive_modules    = self::get_inactive_modules();
$total_modules_count = count( $modules );
$has_wdcl            = get_option( 'has_wdcl' );
$wdc_options         = get_option( 'wdc_options' );
$wdcl_merge          = isset( $wdc_options['wdcl_merge'] ) ? $wdc_options['wdcl_merge'] : 'off';
?>
<div class="wdc-admin-panel">
	<div class="wdc-home-body">
		<div class="wdc-row wdc-row-fixed-width">
			<div class="wdc-col wdc-col-left">
				<img class="wdc-img-fluid wdc-title-icon-size" src="<?php echo esc_attr( WOW_DIVI_CAROUSEL_ASSETS ); ?>imgs/admin/knowledge.svg" alt="knowledge">
				<h3 class="wdc-feature-title">Knowledge Base</h3>
				<p class="wdc-text f18">We understand the need of a helpful knowledge base and have that for you. It will help you to understand how our plugin works.</p>
				<a class="wdc-btn wdc-btn-primary" target="_blank" rel="noopener" href="https://docs.divipeople.com/">Take Me to The Knowledge Page</a>
			</div>
			<div class="wdc-col wdc-col-right">
				<img class="wdc-img-fluid" src="<?php echo esc_attr( WOW_DIVI_CAROUSEL_ASSETS ); ?>imgs/admin/art1.png" alt="Knowledge Base">
			</div>
		</div>

		<div class="wdc-row wdc-align-center wdc-downaload-section wdc-row-fixed-width">
			<div class="wdc-col">
				<div class="wdc-border-box">
					<h2 class="wdc-feature-title">Download Ready Section Template</h2>
					<p class="wdc-text f18">We included 80+ well designed section as template to import it to clients site. Now you will be able to insert any section template to your live site instantly. </p>
					<a class="wdc-btn wdc-btn-primary" target="_blank" rel="noopener" href="https://demo.divipeople.com/wp-content/uploads/2022/01/WowCarousel.zip">Download Now</a>
					<a class="wdc-btn wdc-btn-primary wdc-btn-highlight" target="_blank" rel="noopener" href="https://youtu.be/xMDe2mZaQgQ">How to Use?</a>
				</div>
			</div>
		</div>

		<div class="wdc-row wdc-align-center">
			<div class="wdc-col">
				<span class="wdc-section-title-badge">DIVI</span>
				<h2 class="wdc-section-title wdc-text-primary">Carousel Modules</h2>
				<p class="wdc-text f18"><?php printf( esc_html__( 'Here is the list of our all %2$s %1$s modules%3$s. After enabling or disabling any module make sure to click the %2$sSave Changes%3$s button.', 'wdc-wow-divi-carousel' ), esc_attr( $total_modules_count ), '<strong>', '</strong>' ); ?></p>
			</div>
		</div>

		<div class="wdc-row wdc-admin-modules-row wdc-row wdc-row-fixed-width">
			<div class="wdc-col">
				<div class="wdc-admin-modules">

					<?php
					foreach ( $modules as $module_key => $module_data ) :
						$title      = isset( $module_data['title'] ) ? $module_data['title'] : ''; //phpcs:ignore
						$icon       = isset( $module_data['icon'] ) ? $module_data['icon'] : '';
						$demo_url   = isset( $module_data['demo'] ) && $module_data['demo'] ? $module_data['demo'] : '';
						$class_attr = 'wdc-admin-modules-item'; //phpcs:ignore

						$checked = '';

						if ( ! in_array( $module_key, $inactive_modules ) ) {
							$checked = 'checked="checked"';
						}

						if ( empty( $module_data['demo'] ) ) {
							$class_attr .= ' wdc-admin-modules-item-placeholder';
							$checked     = 'disabled="disabled"';
						}
						?>

						<div class="<?php echo esc_attr( $class_attr ); ?>">
							<span class="wdc-admin-modules-item-icon"><i class="<?php echo esc_attr( $icon ); ?>"></i></span>
							<h3 class="wdc-admin-modules-item-title">
								<label for="wdc-module-<?php echo esc_attr( $module_key ); ?>"><?php echo esc_attr( $title ); ?></label>
							<?php if ( $demo_url ) : ?>
									<a href="<?php echo esc_url( $demo_url ); ?>"
										target="_blank"
										rel="noopener"
										data-tooltip="<?php esc_attr_e( 'Click and view demo', 'wdc-wow-divi-carousel' ); ?>"
										class="wdc-admin-modules-item-preview">
										<img class="wdc-img-fluid wdc-item-icon-size" src="<?php echo esc_attr( WOW_DIVI_CAROUSEL_ASSETS ); ?>imgs/admin/desktop.svg" alt="demo-link">
									</a>
								<?php endif; ?>
							</h3>
							<div class="wdc-admin-modules-item-toggle wdc-toggle">
								<input
								id="wdc-module-<?php echo esc_attr( $module_key ); ?>" <?php echo esc_attr( $checked ); ?>
								type="checkbox"
								class="wdc-toggle-check"
								name="modules[]"
								value="<?php echo esc_attr( $module_key ); ?>">
								<b class="wdc-toggle-switch"></b>
								<b class="wdc-toggle-track"></b>
							</div>
						</div>
					<?php endforeach; ?>
					<?php
					if ( $has_wdcl ) :
						?>
					<div class="merge-modules">
						<label>
							<input
								type="checkbox"
								class="checkbox"
								id="cf7-styler-grid"
								name='options[wdcl_merge]'
								value='on'
								<?php checked( $wdcl_merge, 'on', true ); ?>
							>
							<span>Merge Wow Carousel lite modules to the Wow Carousel pro.</span>
						</label>
					</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</div>
