<?php
namespace WowDiviCarousel\Traits;

defined( 'ABSPATH' ) || die();

trait InstgramFeed {

	public static function ig_get_icon( $svg_color ) {
		$svg = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="Layer_1" x="0px" y="0px" width="32px" height="32px" viewBox="0 0 32 32" style="enable-background:new 0 0 32 32;" xml:space="preserve"><path d="M23,32H9c-5,0-9-4-9-9V9c0-5,4-9,9-9h14c5,0,9,4,9,9v14C32,28,28,32,23,32z M9,2C5.1,2,2,5.1,2,9v14c0,3.9,3.1,7,7,7h14  c3.9,0,7-3.1,7-7V9c0-3.9-3.1-7-7-7H9z"></path><path d="M16,24.2c-4.5,0-8.2-3.7-8.2-8.2c0-4.5,3.7-8.2,8.2-8.2c4.5,0,8.2,3.7,8.2,8.2C24.2,20.5,20.5,24.2,16,24.2z M16,9.8  c-3.4,0-6.2,2.8-6.2,6.2s2.8,6.2,6.2,6.2s6.2-2.8,6.2-6.2S19.4,9.8,16,9.8z"></path><circle cx="16" cy="16" r="1.9"></circle></svg>';

		if ( isset( $svg_color ) ) {
			$svg = preg_replace( '[fill\s*?=\s*?("(?!(?:\s*?none\s*?)")[^"]*")]', 'fill="currentColor"', $svg );
			$svg = preg_replace( '[stroke\s*?=\s*?("(?!(?:\s*?none\s*?)")[^"]*")]', 'stroke="currentColor"', $svg );
		}

		return $svg;
	}

	public static function ig_feed( $args, $link, $image_url, $caption, $comments, $likes, $highlight ) {

		$item_html    = '';
		$caption_html = '';
		$overlay_html = '';

		// Image.
		$insta_image = sprintf(
			'<img class="wdc-insta-image" src="%1$s" alt="%2$s" loading="lazy">',
			esc_url( $image_url ),
			esc_attr( $caption )
		);

		// With Permalink img.
		if ( 'on' === $args['enable_image_link'] ) {
			$insta_image = sprintf(
				'<a class="wdc-insta-link" href="%1$s" target="_blank" rel="nofollow">%2$s</a>',
				esc_url( $link ),
				$insta_image
			);
		}

		// Caption.
		$insta_caption = sprintf(
			'<div class="wdc-insta-caption">
				<p>%1$s</p>
			</div>',
			esc_attr( $caption )
		);

		// If caption enable.
		if ( 'on' === $args['show_caption'] ) {
			$caption_html = sprintf(
				'<div class="wdc-insta-content">%1$s</div>',
				$insta_caption
			);
		}

		// Overlay.
		$insta_icon    = sprintf( '<div class="wdc-insta-icon">%1$s</div>', self::ig_get_icon( $args['svg_color'] ) );
		$show_on_hover = explode( '|', $args['show_on_hover'] );

		if ( 'on' === $show_on_hover[0] || 'on' === $show_on_hover[1] ) {
			if ( 'on' === $args['enable_image_link'] ) {
				$overlay_html = sprintf(
					'<a class="wdc-insta-overlay" href="%1$s" target="_blank" rel="nofollow">
						%2$s
						%3$s
					</a>',
					esc_url( $link ),
					'on' === $show_on_hover[0] ? $insta_icon : '',
					'on' === $show_on_hover[1] ? $insta_caption : ''
				);
			} else {
				$overlay_html = sprintf(
					'<div class="wdc-insta-overlay">
						%1$s
						%2$s
					</div>',
					'on' === $show_on_hover[0] ? $insta_icon : '',
					'on' === $show_on_hover[1] ? $insta_caption : ''
				);
			}
		}

		// Image with Container.
		$image_html = sprintf(
			'<div class="wdc-insta-media-container">
				%1$s
				%2$s
			</div>',
			$insta_image,
			$overlay_html
		);

		$custom_item_class = '';

		// Layout.
		$item_html = sprintf(
			'<div class="wdc-insta-layout-cell %3$s">
				<div class="wdc-insta-layout-cell-content wdc-insta-layout-flex-column">
					%1$s
					%2$s
				</div>
			</div>',
			$image_html,
			$caption_html,
			$custom_item_class
		);

		// Kickoff.
		echo et_core_intentionally_unescaped( $item_html, 'html' ); //phpcs:ignore

	}

}
