import React from "react";

export const process_margin_padding = (
    val = "0|0|0|0",
    type = "padding",
    imp = false
) => {
    if (val) {
        let _val = val.split("|"),
            top = "",
            right = "",
            bottom = "",
            left = "",
            important = "";

        if (imp) {
            important = "!important";
        }

        if (Array.isArray(_val)) {
            top = `${type}-top:${_val[0]}${important};`;
            right = `${type}-right:${_val[1]}${important};`;
            bottom = `${type}-bottom:${_val[2]}${important};`;
            left = `${type}-left:${_val[3]}${important};`;
        }

        return `${top} ${right} ${bottom} ${left}`;
    }
};

export const process_flex_style = (data, type, important) => {
    let flex_val = "center";
    if (data === "left") {
        flex_val = "flex-start";
    } else if (data === "right") {
        flex_val = "flex-end";
    }

    return `${type}:${flex_val}${important ? "!important" : ""}`;
};

export const get_conditional_responsive_styles = (styles = {}, data, style) => {
    let important = styles["important"] ? styles["important"] : false;
    if (
        style === "align-self" ||
        style === "align-items" ||
        style === "justify-content"
    ) {
        return process_flex_style(data, style, important);
    } else if (style === "padding" || style === "margin") {
        return process_margin_padding(data, style, important);
    } else if (style === "flex") {
        return `flex: 0 0 ${data}`;
    } else {
        return `
			  ${style}:${data}${important ? "!important" : ""}
			  `;
    }
};

export const get_responsive_styles = (
    props,
    opt_name,
    selector,
    styles = {},
    pre_values = {}
) => {
    let additionalCss = [],
        _data = props[opt_name],
        _style = styles["primary"],
        _data_tablet = props[opt_name + "_tablet"],
        _data_phone = props[opt_name + "_phone"],
        opt_last_edited = props[opt_name + "_last_edited"],
        is_enabled = opt_last_edited && opt_last_edited.startsWith("on");

    if (!_data && pre_values) {
        let is_default = true;
        if (pre_values["conditional"]) {
            pre_values["conditional"]["values"].forEach((value) => {
                let property_val = props[pre_values["conditional"]["name"]];
                if (property_val === value["a"]) {
                    _data = value["b"];
                    is_default = false;
                }
            });
        }
        if (is_default) {
            _data = pre_values["default"];
        }
    }

    if (_data) {
        additionalCss.push([
            {
                selector,
                declaration: get_conditional_responsive_styles(
                    styles,
                    _data,
                    _style
                ),
            },
        ]);

        if (styles["secondary"]) {
            additionalCss.push([
                {
                    selector,
                    declaration: styles["secondary"],
                },
            ]);
        }
    }

    if (is_enabled) {
        if (_data_tablet) {
            additionalCss.push([
                {
                    selector,
                    device: "tablet",
                    declaration: get_conditional_responsive_styles(
                        styles,
                        _data_tablet,
                        _style
                    ),
                },
            ]);

            if (styles["secondary"]) {
                additionalCss.push([
                    {
                        selector,
                        device: "tablet",
                        declaration: styles["secondary"],
                    },
                ]);
            }
        }

        if (_data_phone) {
            additionalCss.push([
                {
                    selector,
                    device: "phone",
                    declaration: get_conditional_responsive_styles(
                        styles,
                        _data_phone,
                        _style
                    ),
                },
            ]);

            if (styles["secondary"]) {
                additionalCss.push([
                    {
                        selector,
                        device: "phone",
                        declaration: styles["secondary"],
                    },
                ]);
            }
        }
    }

    return additionalCss;
};

export const _getCarouselSettings = (props, type, ref) => {
    let content_length = 0,
        slide_count = props.slide_count,
        slide_count_tablet = props.slide_count_tablet
            ? props.slide_count_tablet
            : props.slide_count,
        slide_count_phone = props.slide_count_phone
            ? props.slide_count_phone
            : slide_count_tablet,
        nav_pagi_tablet = props.nav_pagi_tablet
            ? props.nav_pagi_tablet
            : props.nav_pagi,
        nav_pagi_phone = props.nav_pagi_phone
            ? props.nav_pagi_phone
            : nav_pagi_tablet,
        is_pagi_active =
            props.nav_pagi === "pagi" || props.nav_pagi === "nav_pagi"
                ? true
                : false,
        is_pagi_active_tablet =
            nav_pagi_tablet === "pagi" || nav_pagi_tablet === "nav_pagi"
                ? true
                : false,
        is_pagi_active_phone =
            nav_pagi_phone === "pagi" || nav_pagi_phone === "nav_pagi"
                ? true
                : false,
        is_arrow_active =
            props.nav_pagi === "nav" || props.nav_pagi === "nav_pagi"
                ? true
                : false,
        is_arrow_active_tablet =
            nav_pagi_tablet === "nav" || nav_pagi_tablet === "nav_pagi"
                ? true
                : false,
        is_arrow_active_phone =
            nav_pagi_phone === "nav" || nav_pagi_phone === "nav_pagi"
                ? true
                : false,
        wait_for_animate = props.wait_for_animate === "on" ? true : false,
        center_mode_type = props.center_mode_type,
        center_padding = props.center_padding,
        center_padding_tablet = props.center_padding_tablet,
        center_padding_phone = props.center_padding_phone,
        is_variable_width = props.is_variable_width,
        is_auto_height = props.is_auto_height,
        slide_to_scroll = props.slide_to_scroll,
        slide_to_scroll_tablet = props.slide_to_scroll_tablet,
        slide_to_scroll_phone = props.slide_to_scroll_phone,
        is_fade = props.is_fade,
        slide_infinite = null,
        slide_infinite_tablet = null,
        slide_infinite_phone = null,
        fade = false,
        use_tab = props.use_tab ? props.use_tab : "off";
    is_auto_height =
        slide_count < 2 &&
        is_variable_width === "off" &&
        is_auto_height === "on"
            ? true
            : false;

    if (
        "off" === is_variable_width &&
        "1" === slide_count &&
        "on" === is_fade
    ) {
        fade = true;
    }

    // Center Mode Responsive
    if (!center_padding_tablet) {
        center_padding_tablet = center_padding;
    }

    if (!center_padding_phone) {
        center_padding_phone = center_padding_tablet;
    }

    // Center Mode Responsive
    if (!slide_to_scroll_tablet) {
        slide_to_scroll_tablet = slide_to_scroll;
    }

    if (!slide_to_scroll_phone) {
        slide_to_scroll_phone = slide_to_scroll_tablet;
    }

    //fixing slide infinite issue
    if (type !== "jQuery") {
        content_length = props.content.length;
        slide_infinite =
            content_length >= slide_count && props.is_infinite === "on"
                ? true
                : false;
        slide_infinite_tablet =
            content_length >= slide_count_tablet && props.is_infinite === "on"
                ? true
                : false;
        slide_infinite_phone =
            content_length >= slide_count_phone && props.is_infinite === "on"
                ? true
                : false;
    } else {
        slide_infinite = props.is_infinite === "on" ? true : false;
        slide_infinite_tablet = slide_infinite;
        slide_infinite_phone = slide_infinite;
    }

    // variable width won't work for multiple slides
    if (is_variable_width === "on" || use_tab === "on") {
        slide_count = 1;
        slide_count_tablet = 1;
        slide_count_phone = 1;
    }

    // global carousel settings
    let settings = {
        dots: is_pagi_active,
        arrows: is_arrow_active,
        adaptiveHeight: is_auto_height,
        cssEase: props.css_transition,
        waitForAnimate: wait_for_animate,
        swipe: props.is_center === "on" ? false : true,
        infinite: slide_infinite,
        autoplay: props.is_autoplay === "on" ? true : false,
        autoplaySpeed: parseInt(props.autoplay_speed),
        speed: parseInt(props.animation_speed),
        slidesToShow: parseInt(slide_count),
        variableWidth:
            use_tab === "off" && is_variable_width === "on" ? true : false,
        slidesToScroll: parseInt(slide_to_scroll),
        centerMode:
            use_tab === "off" && props.is_center === "on" ? true : false,
        centerPadding:
            is_variable_width === "off" && center_mode_type === "classic"
                ? center_padding
                : 0,
        vertical: props.is_vertical === "on" ? true : false,
        fade: use_tab === "on" ? true : fade,
        responsive: [
            {
                breakpoint: 980,
                settings: {
                    slidesToShow: parseInt(slide_count_tablet),
                    dots: is_pagi_active_tablet ? true : false,
                    arrows: is_arrow_active_tablet ? true : false,
                    infinite: slide_infinite_tablet,
                    centerPadding:
                        is_variable_width === "off" &&
                        center_mode_type === "classic"
                            ? center_padding_tablet
                            : 0,
                    slidesToScroll: parseInt(slide_to_scroll_tablet),
                },
            },
            {
                breakpoint: 767,
                settings: {
                    slidesToShow: parseInt(slide_count_phone),
                    dots: is_pagi_active_phone ? true : false,
                    arrows: is_arrow_active_phone ? true : false,
                    infinite: slide_infinite_phone,
                    centerPadding:
                        is_variable_width === "off" &&
                        center_mode_type === "classic"
                            ? center_padding_phone
                            : 0,
                    slidesToScroll: parseInt(slide_to_scroll_phone),
                },
            },
        ],
    };

    if (use_tab === "on") {
        settings.asNavFor = ref;
    }

    return settings;
};

export const _getTabCarouselSettings = (props, type, ref) => {
    let content_length = 0,
        tab_slide_count = props.tab_slide_count,
        tab_slide_count_tablet = props.tab_slide_count_tablet,
        tab_slide_count_phone = props.tab_slide_count_phone,
        tab_placement = props.tab_placement,
        is_vertical = false,
        slide_infinite = false;

    //fixing slide infinite issue
    if (type !== "jQuery") {
        content_length = props.content.length;
        slide_infinite =
            content_length >= tab_slide_count && props.is_infinite === "on"
                ? true
                : false;
    } else {
        slide_infinite = props.is_infinite === "on" ? true : false;
    }

    if (tab_placement === "left" || tab_placement === "right") {
        is_vertical = true;
    }

    // Tab carousel settings
    let settings = {
        dots: false,
        arrows: false,
        infinite: slide_infinite,
        autoplay: props.is_autoplay === "on" ? true : false,
        autoplaySpeed: parseInt(props.autoplay_speed),
        speed: parseInt(props.animation_speed),
        slidesToShow: parseInt(tab_slide_count),
        focusOnSelect: true,
        variableWidth: false,
        slidesToScroll: 1,
        swipeToSlide: true,
        centerMode: true,
        centerPadding: 0,
        vertical: is_vertical,
        responsive: [
            {
                breakpoint: 980,
                settings: {
                    slidesToShow: parseInt(tab_slide_count_tablet),
                },
            },
            {
                breakpoint: 767,
                settings: {
                    slidesToShow: parseInt(tab_slide_count_phone),
                },
            },
        ],
    };

    if (props.use_tab === "on") {
        settings.asNavFor = ref;
    }

    return settings;
};

export const _getTabCarouselCss = (props) => {
    let additionalCss = [],
        use_tab = props.use_tab,
        tab_hide_mobile = props.tab_hide_mobile,
        tab_bg = props.tab_bg,
        tab_active_bg = props.tab_active_bg,
        tab_spacing = props.tab_spacing,
        title_spacing = props.tab_title_spacing,
        thumb_spacing = props.tab_thumb_spacing,
        thumb_radius = props.thumb_radius,
        thumb_width = props.thumb_width,
        thumb_width_tablet = props.thumb_width_tablet,
        thumb_width_phone = props.thumb_width_phone,
        thumb_width_responsive_status =
            props.thumb_width_last_edited &&
            props.thumb_width_last_edited.startsWith("on"),
        thumb_height = props.thumb_height,
        thumb_height_tablet = props.thumb_height_tablet,
        thumb_height_phone = props.thumb_height_phone,
        thumb_height_responsive_status =
            props.thumb_height_last_edited &&
            props.thumb_height_last_edited.startsWith("on"),
        tab_padding = props.tab_padding.split("|"),
        tab_item_bg = props.tab_item_bg,
        tab_position = props.tab_position,
        tab_placement = props.tab_placement,
        tab_width = props.tab_width,
        tab_width_tablet = props.tab_width_tablet,
        tab_width_phone = props.tab_width_phone,
        tab_width_responsive_status =
            props.tab_width_last_edited &&
            props.tab_width_last_edited.startsWith("on"),
        tab_opacity = props.tab_opacity,
        tab_border_active = props.tab_border_active,
        tab_border_color_active = props.tab_border_color_active,
        tab_opacity_active = props.tab_opacity_active,
        animation_speed = props.animation_speed,
        tab_scale = props.tab_scale,
        tab_scale_active = props.tab_scale_active,
        tab_item_height = props.tab_item_height,
        tab_alignment = props.tab_alignment,
        tab_spacing_top = props.tab_spacing_top,
        tab_spacing_top_tablet = props.tab_spacing_top_tablet,
        tab_spacing_top_phone = props.tab_spacing_top_phone,
        tab_spacing_top_responsive_status =
            props.tab_spacing_top_last_edited &&
            props.tab_spacing_top_last_edited.startsWith("on"),
        tab_spacing_bottom = props.tab_spacing_bottom,
        tab_spacing_bottom_tablet = props.tab_spacing_bottom_tablet,
        tab_spacing_bottom_phone = props.tab_spacing_bottom_phone,
        tab_spacing_bottom_responsive_status =
            props.tab_spacing_bottom_last_edited &&
            props.tab_spacing_bottom_last_edited.startsWith("on");

    if (use_tab === "off") {
        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel-nav",
                declaration: `display: none!important;`,
            },
        ]);
    }

    if (tab_hide_mobile === "on") {
        additionalCss.push([
            {
                selector:
                    "%%order_class%% .wdc-carousel-parent .wdc-carousel-nav",
                device: "phone",
                declaration: `display: none!important;`,
            },
        ]);
        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel-parent",
                device: "phone",
                declaration: `padding-left:0!important;padding-right:0!important;`,
            },
        ]);
    }

    if (use_tab === "on") {
        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel-nav .slick-slide",
                declaration: `transition: transform ${animation_speed}!important;`,
            },
        ]);

        if (tab_scale_active) {
            additionalCss.push([
                {
                    selector:
                        "%%order_class%% .wdc-carousel-nav .slick-slide.slick-current",
                    declaration: `transform: scale(${tab_scale_active});`,
                },
            ]);
        }

        if (tab_scale) {
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel-nav .slick-slide",
                    declaration: `transform: scale(${tab_scale});`,
                },
            ]);
        }

        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel-nav",
                declaration: `${tab_placement}:0;`,
            },
        ]);

        if (tab_opacity) {
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel-nav .slick-slide",
                    declaration: `opacity: ${tab_opacity};`,
                },
            ]);
        }

        if (tab_opacity_active) {
            additionalCss.push([
                {
                    selector:
                        "%%order_class%% .wdc-carousel-nav .slick-slide.slick-center",
                    declaration: `opacity: ${tab_opacity_active};`,
                },
            ]);
        }

        if (tab_border_active && tab_border_color_active) {
            tab_border_active = tab_border_active.split("|");
            additionalCss.push([
                {
                    selector:
                        "%%order_class%% .wdc-carousel-nav .slick-slide.slick-center .wdc-carousel-nav-item",
                    declaration: `
                        border-top:  ${tab_border_active[0]} solid ${tab_border_color_active};
                        border-right:  ${tab_border_active[1]} solid ${tab_border_color_active};
                        border-bottom:  ${tab_border_active[2]} solid ${tab_border_color_active};
                        border-left:  ${tab_border_active[3]} solid ${tab_border_color_active};`,
                },
            ]);
        }

        // tab width
        if (tab_placement === "left" || tab_placement === "right") {
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel-nav",
                    declaration: `width: ${tab_width};`,
                },
            ]);

            if (tab_position !== "absolute") {
                additionalCss.push([
                    {
                        selector: "%%order_class%% .wdc-carousel-parent",
                        declaration: `padding-${tab_placement}: ${tab_width};`,
                    },
                ]);
            }

            if (tab_width_tablet && tab_width_responsive_status) {
                additionalCss.push([
                    {
                        selector: "%%order_class%% .wdc-carousel-nav",
                        device: "tablet",
                        declaration: `width: ${tab_width_tablet};`,
                    },
                ]);

                if (tab_position !== "absolute") {
                    additionalCss.push([
                        {
                            selector: "%%order_class%% .wdc-carousel-parent",
                            device: "tablet",
                            declaration: `padding-${tab_placement}: ${tab_width_tablet};`,
                        },
                    ]);
                }
            }

            if (tab_width_phone && tab_width_responsive_status) {
                additionalCss.push([
                    {
                        selector: "%%order_class%% .wdc-carousel-nav",
                        device: "phone",
                        declaration: `width: ${tab_width_phone};`,
                    },
                ]);

                if (tab_position !== "absolute") {
                    additionalCss.push([
                        {
                            selector: "%%order_class%% .wdc-carousel-parent",
                            device: "phone",
                            declaration: `padding-${tab_placement}: ${tab_width_phone};`,
                        },
                    ]);
                }
            }
        }

        if (tab_bg) {
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel-nav",
                    declaration: `background-color: ${tab_bg};`,
                },
            ]);
        }

        if (tab_active_bg) {
            additionalCss.push([
                {
                    selector:
                        "%%order_class%% .wdc-carousel-nav .slick-current .wdc-carousel-nav-item",
                    declaration: `background-color: ${tab_active_bg};`,
                },
            ]);
        }

        if (tab_item_bg) {
            additionalCss.push([
                {
                    selector:
                        "%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item",
                    declaration: `background-color: ${tab_item_bg};`,
                },
            ]);
        }

        additionalCss.push([
            {
                selector:
                    "%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item",
                declaration: `
                    text-align: ${tab_alignment};
                    padding-top: ${tab_padding[0]};
                    padding-right: ${tab_padding[1]};
                    padding-bottom: ${tab_padding[2]};
                    padding-left: ${tab_padding[3]};`,
            },
        ]);

        additionalCss.push([
            {
                selector:
                    "%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item",
                declaration: `display: flex!important; flex-direction: column; justify-content: center;`,
            },
        ]);

        if (tab_alignment === "right") {
            additionalCss.push([
                {
                    selector:
                        "%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item",
                    declaration: `align-items: flex-end;`,
                },
            ]);
        } else if (tab_alignment === "center") {
            additionalCss.push([
                {
                    selector:
                        "%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item",
                    declaration: `align-items: center;`,
                },
            ]);
        }

        // thumb
        additionalCss.push([
            {
                selector:
                    "%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure",
                declaration: `border-radius: ${thumb_radius};`,
            },
        ]);

        // thumb width
        additionalCss.push([
            {
                selector:
                    "%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure",
                declaration: `width: ${thumb_width};`,
            },
        ]);

        if (thumb_width_tablet && thumb_width_responsive_status) {
            additionalCss.push([
                {
                    selector:
                        "%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure",
                    device: "tablet",
                    declaration: `width: ${thumb_width_tablet};`,
                },
            ]);
        }

        if (thumb_width_phone && thumb_width_responsive_status) {
            additionalCss.push([
                {
                    selector:
                        "%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure",
                    device: "phone",
                    declaration: `width: ${thumb_width_phone};`,
                },
            ]);
        }

        // Thumb height
        if (thumb_height) {
            additionalCss.push([
                {
                    selector:
                        "%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure",
                    declaration: `height: ${thumb_height};`,
                },
            ]);

            additionalCss.push([
                {
                    selector:
                        "%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure img",
                    declaration: `height: 100%;`,
                },
            ]);
        }

        if (thumb_height_tablet && thumb_height_responsive_status) {
            additionalCss.push([
                {
                    selector:
                        "%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure",
                    device: "tablet",
                    declaration: `height: ${thumb_height_tablet};`,
                },
            ]);

            additionalCss.push([
                {
                    selector:
                        "%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure img",
                    device: "tablet",
                    declaration: `height: 100%;`,
                },
            ]);
        }

        if (thumb_height_phone && thumb_height_responsive_status) {
            additionalCss.push([
                {
                    selector:
                        "%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure",
                    device: "phone",
                    declaration: `height: ${thumb_height_phone};`,
                },
            ]);

            additionalCss.push([
                {
                    selector:
                        "%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure img",
                    device: "phone",
                    declaration: `height: 100%;`,
                },
            ]);
        }

        if (tab_item_height !== "auto") {
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel-nav .slick-slide",
                    declaration: `height: ${tab_item_height};`,
                },
            ]);
            additionalCss.push([
                {
                    selector:
                        "%%order_class%% .wdc-carousel-nav .slick-slide>div, %%order_class%% .wdc-carousel-nav .slick-slide .wdc-carousel-nav-item",
                    declaration: `height: 100%;`,
                },
            ]);
        }

        if (tab_placement === "left" || tab_placement === "right") {
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel-nav .slick-slide",
                    declaration: `padding-bottom: ${tab_spacing};`,
                },
            ]);

            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel-nav .slick-list",
                    declaration: `margin-bottom: -${tab_spacing}!important; margin-top: -${tab_spacing}!important;`,
                },
            ]);
        } else {
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel-nav .slick-slide",
                    declaration: `padding-right: ${tab_spacing};`,
                },
            ]);

            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel-nav .slick-list",
                    declaration: `margin-right: -${tab_spacing}!important;`,
                },
            ]);
        }

        // texts
        if (thumb_spacing) {
            additionalCss.push([
                {
                    selector:
                        "%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure",
                    declaration: `margin-bottom: ${thumb_spacing}!important;`,
                },
            ]);
        }

        if (title_spacing) {
            additionalCss.push([
                {
                    selector:
                        "%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item h2",
                    declaration: `margin-bottom: ${title_spacing}!important;`,
                },
            ]);
        }

        if (tab_placement === "top" || tab_placement === "bottom") {
            //  Tab Carousel Spacing Top - Bottom
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel-nav .slick-track",
                    declaration: `padding-top: ${tab_spacing_top}; padding-bottom: ${tab_spacing_bottom};`,
                },
            ]);

            // Tab Carousel Spacing Top Tablet
            if (tab_spacing_top_tablet && tab_spacing_top_responsive_status) {
                additionalCss.push([
                    {
                        selector:
                            "%%order_class%% .wdc-carousel-nav .slick-track",
                        device: "tablet",
                        declaration: `padding-top: ${tab_spacing_top_tablet};`,
                    },
                ]);
            }

            // Tab Carousel Spacing Top Phone
            if (tab_spacing_top_phone && tab_spacing_top_responsive_status) {
                additionalCss.push([
                    {
                        selector:
                            "%%order_class%% .wdc-carousel-nav .slick-track",
                        device: "phone",
                        declaration: `padding-top: ${tab_spacing_top_phone};`,
                    },
                ]);
            }

            // tab Carousel Spacing Bottom Tablet
            if (
                tab_spacing_bottom_tablet &&
                tab_spacing_bottom_responsive_status
            ) {
                additionalCss.push([
                    {
                        selector:
                            "%%order_class%% .wdc-carousel-nav .slick-track",
                        device: "tablet",
                        declaration: `padding-bottom: ${tab_spacing_bottom_tablet};`,
                    },
                ]);
            }

            // Tab Carousel Spacing Bottom Phone
            if (
                tab_spacing_bottom_phone &&
                tab_spacing_bottom_responsive_status
            ) {
                additionalCss.push([
                    {
                        selector:
                            "%%order_class%% .wdc-carousel-nav .slick-track",
                        device: "phone",
                        declaration: `padding-bottom: ${tab_spacing_bottom_phone};`,
                    },
                ]);
            }
        }
    }

    return additionalCss;
};

export const _getCarouselCss = (props) => {
    const additionalCss = [];

    let sliding_dir = props.sliding_dir,
        arrow_height = props.arrow_height,
        arrow_height_tablet = props.arrow_height_tablet
            ? props.arrow_height_tablet
            : arrow_height,
        arrow_height_phone = props.arrow_height_phone
            ? props.arrow_height_phone
            : arrow_height_tablet,
        arrow_width = props.arrow_width,
        arrow_width_tablet = props.arrow_width_tablet
            ? props.arrow_width_tablet
            : arrow_width,
        arrow_width_phone = props.arrow_width_phone
            ? props.arrow_width_phone
            : arrow_width_tablet,
        arrow_color = props.arrow_color,
        arrow_color__hover = props.arrow_color__hover
            ? props.arrow_color__hover
            : arrow_color,
        arrow_bg = props.arrow_bg,
        arrow_bg__hover = props.arrow_bg__hover
            ? props.arrow_bg__hover
            : arrow_bg,
        arrow_icon_size = props.arrow_icon_size,
        arrow_icon_size_tablet = props.arrow_icon_size_tablet
            ? props.arrow_icon_size_tablet
            : arrow_icon_size,
        arrow_icon_size_phone = props.arrow_icon_size_phone
            ? props.arrow_icon_size_phone
            : arrow_icon_size_tablet,
        icon_right = props.icon_right,
        icon_left = props.icon_left,
        arrow_border_width = props.arrow_border_width,
        arrow_border_color = props.arrow_border_color,
        arrow_border_color__hover = props.arrow_border_color__hover
            ? props.arrow_border_color__hover
            : arrow_border_color,
        arrow_border_style = props.arrow_border_style,
        arrow_pos_y = props.arrow_pos_y,
        arrow_pos_y_tablet = props.arrow_pos_y_tablet
            ? props.arrow_pos_y_tablet
            : arrow_pos_y,
        arrow_pos_y_phone = props.arrow_pos_y_phone
            ? props.arrow_pos_y_phone
            : arrow_pos_y_tablet,
        arrow_x_center = props.arrow_x_center,
        arrow_pos_x = props.arrow_pos_x,
        arrow_pos_x_tablet = props.arrow_pos_x_tablet
            ? props.arrow_pos_x_tablet
            : arrow_pos_x,
        arrow_pos_x_phone = props.arrow_pos_x_phone
            ? props.arrow_pos_x_phone
            : arrow_pos_x_tablet,
        arrow_type = props.arrow_type,
        arrow_pos = props.arrow_pos,
        arrow_pos_hz = props.arrow_pos_hz,
        arrow_gap = props.arrow_gap,
        arrow_gap_tablet = props.arrow_gap_tablet
            ? props.arrow_gap_tablet
            : arrow_gap,
        arrow_gap_phone = props.arrow_gap_phone
            ? props.arrow_gap_phone
            : arrow_gap_tablet,
        arrow_skew = props.arrow_skew,
        int_skew = parseInt(arrow_skew),
        arrow_skew_inner =
            int_skew < 0 ? `${Math.abs(int_skew)}` : `-${Math.abs(int_skew)}`,
        pagi_alignment = props.pagi_alignment,
        pagi_color = props.pagi_color,
        pagi_color__hover = props.pagi_color__hover
            ? props.pagi_color__hover
            : pagi_color,
        pagi_pos_y = props.pagi_pos_y,
        pagi_spacing = props.pagi_spacing,
        pagi_color_active = props.pagi_color_active,
        pagi_height = props.pagi_height,
        pagi_width = props.pagi_width,
        pagi_radius = props.pagi_radius.split("|"),
        pagi_width_active = props.pagi_width_active,
        left_border_radius = props.left_border_radius.split("|"),
        right_border_radius = props.right_border_radius.split("|"),
        slide_spacing = props.slide_spacing,
        use_both_side_spacing = props.use_both_side_spacing,
        is_vertical = props.is_vertical,
        use_tab = props.use_tab ? props.use_tab : "off",
        is_variable_width = props.is_variable_width
            ? props.is_variable_width
            : "off",
        slide_width = props.slide_width,
        slide_width_tablet = props.slide_width_tablet,
        slide_width_phone = props.slide_width_phone,
        slide_width_responsive_status =
            props.slide_width_last_edited &&
            props.slide_width_last_edited.startsWith("on"),
        animation_speed = props.animation_speed,
        custom_cursor = props.custom_cursor,
        cursor_name = props.cursor_name,
        carousel_spacing_top = props.carousel_spacing_top,
        carousel_spacing_top_tablet = props.carousel_spacing_top_tablet,
        carousel_spacing_top_phone = props.carousel_spacing_top_phone,
        carousel_spacing_top_responsive_status =
            props.carousel_spacing_top_last_edited &&
            props.carousel_spacing_top_last_edited.startsWith("on"),
        carousel_spacing_bottom = props.carousel_spacing_bottom,
        carousel_spacing_bottom_tablet = props.carousel_spacing_bottom_tablet,
        carousel_spacing_bottom_phone = props.carousel_spacing_bottom_phone,
        carousel_spacing_bottom_responsive_status =
            props.carousel_spacing_bottom_last_edited &&
            props.carousel_spacing_bottom_last_edited.startsWith("on");

    const utils = window.ET_Builder.API.Utils,
        rightIcon = icon_right ? utils.processFontIcon(icon_right) : "5",
        leftIcon = icon_left ? utils.processFontIcon(icon_left) : "4";

    let left = sliding_dir === "ltr" ? "left" : "right",
        right = sliding_dir === "ltr" ? "right" : "left";

    let cursor_data = {
        pizza:
            "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgBAMAAACBVGfHAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAAIVBMVEUAAAAAAAD/////zGb/mTOZAAAAzAD/zDP/AAD/Zmb/mZm5WRymAAAAAXRSTlMAQObYZgAAAAFiS0dEAmYLfGQAAAAJcEhZcwAAAMgAAADIAGP6560AAAAHdElNRQfkBRkTCRh4PlpnAAAA8ElEQVQoz12QsbnDIAyExQaWQ0ySztngfW8BMgIFA3gEVardEXfu3KbzmJEgTrCvEfo5wQEgABjMakDVNgZP/1l/GbX9p81ISHuvgJL23tfgIUAs5VCxWgWyjKoQ8GRlpO2lwXOM3TkG9IACAkoTg7pKKsc6hWKzGg1ZhVKohHVMGUkhr8Bw57Kjc5RfA0626Jmk2A9g7m7LNDL6AsRNlynNNJQezOL4ktK4TQDcRr5OMtJswMxMaXXkv2BkJ3kJvkIamAb7A441mv8Bo+9AqIR8fdoadJjWpgaGltnvwfqCnXB/hH6kPwCCg+wRbJe+ATasSMvHEwtpAAAAJXRFWHRkYXRlOmNyZWF0ZQAyMDIwLTA1LTI1VDE5OjA5OjIzKzAwOjAwCTF7LQAAACV0RVh0ZGF0ZTptb2RpZnkAMjAyMC0wNS0yNVQxOTowOTowNiswMDowMGhx60sAAAAASUVORK5CYII=",
        burger:
            "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAB8AAAAfBAMAAADtgAsKAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAALVBMVEUAAAAAAAD////MZgBmMwCZMwD/zDP/mQD/zAB4eHhGRkbc3NygoKDIyMhmAAAKaD9VAAAAAXRSTlMAQObYZgAAAAFiS0dEAmYLfGQAAAAJcEhZcwAAAMgAAADIAGP6560AAAAHdElNRQfkBRkTGhFgDaNRAAAAEGNhTnYAAAAgAAAAIAAAAAAAAAAAYrnu+gAAATdJREFUKM9lkbFOwzAQhl2lM4qrLLW68AYgG2VtlIu6sVTxCzCwA5XzACCydmyUpWNNl670CVLyBkxImXkG7i6oSOFXlv+7/85nR4RiIDkEk2FkcvkPUCSA9DyDvMlyDVc9CKmca9Q5FMAS7c2dNr/ELNmiDHcFmdaWPms1R0zOVa1j98gRwCp1xKt7R4A60FlnnXugnnGK3pFs8doDi92OAiVPHWd4JvmyLDWBEa0Vk33Bydd4l4j3cCs63ExDIbfAq7OSdwQ7GQHkdD0jpwqBqrYSSImsP99CMVLN2kvS7ORnByEupG/aTdWu1/VOHSMEX1Ltvd+3zWnzcQAEt1IqX3tfHb2MDIKuS3iEwtkLTIhvMMAkguJpLiiSaj52UZTAb9oBb+ncM8z7Vx4DvwnA3+/jlr78AzvMazraOl3vAAAAJXRFWHRkYXRlOmNyZWF0ZQAyMDIwLTA1LTI1VDE5OjI2OjE2KzAwOjAwfOGxJQAAACV0RVh0ZGF0ZTptb2RpZnkAMjAyMC0wNS0yNVQxOToyNjoxNiswMDowMA28CZkAAAAASUVORK5CYII=",
    };

    if (arrow_type === "default" && sliding_dir === "ltr") {
        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel-parent .slick-prev",
                declaration: `right: auto!important;`,
            },
        ]);
        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel-parent .slick-next",
                declaration: `left: auto!important;`,
            },
        ]);
    }

    if (arrow_type === "alongside" && sliding_dir === "ltr") {
        if( props.arrow_pos_hz === 'right'){
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel-parent .slick-next",
                    declaration: `left: auto!important;`,
                },
            ]);
        }
    }

    // center mode animation speed
    additionalCss.push([
        {
            selector: "%%order_class%% .wdc-centered--highlighted .slick-slide",
            declaration: `transition: transform ${animation_speed};`,
        },
    ]);

    // Custom Cursor
    if (custom_cursor === "on") {
        let cursor_type = cursor_name.split("_")[0];
        let cursor_icon = cursor_name.split("_")[1];

        if (cursor_type === "css") {
            additionalCss.push([
                {
                    selector: "%%order_class%%",
                    declaration: `cursor: ${cursor_icon}!important;`,
                },
            ]);
        } else if (cursor_type === "custom") {
            additionalCss.push([
                {
                    selector: "%%order_class%%",
                    declaration: `cursor: url('${cursor_data[cursor_icon]}'), auto!important;`,
                },
            ]);
        }
    }

    // Carousel Spacing Top - Bottom
    additionalCss.push([
        {
            selector: "%%order_class%% .wdc-carousel .slick-track",
            declaration: `padding-top: ${carousel_spacing_top}; padding-bottom: ${carousel_spacing_bottom};`,
        },
    ]);

    // Carousel Spacing Top Tablet
    if (carousel_spacing_top_tablet && carousel_spacing_top_responsive_status) {
        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel .slick-track",
                device: "tablet",
                declaration: `padding-top: ${carousel_spacing_top_tablet};`,
            },
        ]);
    }

    // Carousel Spacing Top Phone
    if (carousel_spacing_top_phone && carousel_spacing_top_responsive_status) {
        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel .slick-track",
                device: "phone",
                declaration: `padding-top: ${carousel_spacing_top_phone};`,
            },
        ]);
    }

    // Carousel Spacing Bottom Tablet
    if (
        carousel_spacing_bottom_tablet &&
        carousel_spacing_bottom_responsive_status
    ) {
        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel .slick-track",
                device: "tablet",
                declaration: `padding-bottom: ${carousel_spacing_bottom_tablet};`,
            },
        ]);
    }

    // Carousel Spacing Bottom Phone
    if (
        carousel_spacing_bottom_phone &&
        carousel_spacing_bottom_responsive_status
    ) {
        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel .slick-track",
                device: "phone",
                declaration: `padding-bottom: ${carousel_spacing_bottom_phone};`,
            },
        ]);
    }

    // Slide Variable Width
    if (use_tab === "off" && is_variable_width === "on") {
        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel .slick-slide",
                declaration: `width: ${slide_width};`,
            },
        ]);

        // Slide Variable Width Tablet
        if (slide_width_tablet && slide_width_responsive_status) {
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel .slick-slide",
                    device: "tablet",
                    declaration: `width: ${slide_width_tablet};`,
                },
            ]);
        }

        // Slide Variable Width Phone
        if (slide_width_phone && slide_width_responsive_status) {
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel .slick-slide",
                    device: "phone",
                    declaration: `width: ${slide_width_phone};`,
                },
            ]);
        }
    }

    // Arrow
    additionalCss.push([
        {
            selector: "%%order_class%% .wdc-carousel .slick-arrow",
            declaration: `
                height: ${arrow_height};
                width: ${arrow_width};
                color: ${arrow_color};
                background: ${arrow_bg};
                border: ${arrow_border_width} ${arrow_border_style} ${arrow_border_color};
                margin-top: -${parseInt(arrow_height) / 2}px;
                transform: skew(${arrow_skew});`,
        },
    ]);

    additionalCss.push([
        {
            selector: "%%order_class%% .wdc-carousel .slick-arrow:before",
            declaration: `
                font-size: ${arrow_icon_size};
                transform: skew(${arrow_skew_inner}deg);
                display: inline-block;`,
        },
    ]);

    additionalCss.push([
        {
            selector: "%%order_class%% .wdc-carousel .slick-next",
            declaration: `
                border-radius: ${right_border_radius[1]} ${right_border_radius[2]} ${right_border_radius[3]} ${right_border_radius[4]};`,
        },
    ]);

    additionalCss.push([
        {
            selector: "%%order_class%% .wdc-carousel .slick-prev",
            declaration: `
                border-radius: ${left_border_radius[1]} ${left_border_radius[2]} ${left_border_radius[3]} ${left_border_radius[4]};`,
        },
    ]);

    // Arrow tablet
    additionalCss.push([
        {
            selector: "%%order_class%% .wdc-carousel .slick-arrow",
            device: "tablet",
            declaration: `height: ${arrow_height_tablet}; width: ${arrow_width_tablet};`,
        },
    ]);

    additionalCss.push([
        {
            selector: "%%order_class%% .wdc-carousel .slick-arrow:before",
            device: "tablet",
            declaration: `font-size: ${arrow_icon_size_tablet};`,
        },
    ]);

    //Arrow phone
    additionalCss.push([
        {
            selector: "%%order_class%% .wdc-carousel .slick-arrow",
            device: "phone",
            declaration: `height: ${arrow_height_phone}; width: ${arrow_width_phone};`,
        },
    ]);

    additionalCss.push([
        {
            selector: "%%order_class%% .wdc-carousel .slick-arrow:before",
            device: "phone",
            declaration: `font-size: ${arrow_icon_size_phone};`,
        },
    ]);

    //Arrow hover
    additionalCss.push([
        {
            selector: "%%order_class%% .wdc-carousel .slick-arrow:hover",
            declaration: ` color: ${arrow_color__hover}; background: ${arrow_bg__hover}; border-color: ${arrow_border_color__hover};`,
        },
    ]);

    // Arrow type
    if (
        sliding_dir === "rtl" ||  arrow_type === "default"
    ) {
        // default arrow type
        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel .slick-arrow",
                declaration: `top: ${arrow_pos_y};`,
            },
        ]);

        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel .slick-next",
                declaration: `${right}: ${arrow_pos_x};`,
            },
        ]);

        additionalCss.push([
            {
                selector: "%%order_class%% .slick-prev",
                declaration: `left: auto; ${left}: ${arrow_pos_x};`,
            },
        ]);

        // default arrow tablet
        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel .slick-arrow",
                device: "tablet",
                declaration: `top: ${arrow_pos_y_tablet};`,
            },
        ]);

        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel .slick-next",
                device: "tablet",
                declaration: `${right}: ${arrow_pos_x_tablet};`,
            },
        ]);

        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel .slick-prev",
                device: "tablet",
                declaration: `${left}: ${arrow_pos_x_tablet};`,
            },
        ]);

        // default arrow phone
        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel .slick-arrow",
                device: "phone",
                declaration: `top: ${arrow_pos_y_phone};`,
            },
        ]);

        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel .slick-next",
                device: "phone",
                declaration: `${right}: ${arrow_pos_x_phone};`,
            },
        ]);

        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel .slick-prev",
                device: "phone",
                declaration: `${left}: ${arrow_pos_x_phone};`,
            },
        ]);
    }

    // alongside arrow type
    if (sliding_dir === "ltr" && arrow_type === "alongside") {
        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel .slick-arrow",
                declaration: `top: auto; ${arrow_pos}: ${arrow_pos_y};`,
            },
        ]);

        if (arrow_x_center && arrow_x_center === "on") {
            //desktop
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel .slick-next",
                    declaration: `right: calc(50% - ${parseInt(arrow_width) +
                        parseInt(arrow_gap) / 2}px);`,
                },
            ]);

            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel .slick-prev",
                    declaration: `left: calc(50% - ${parseInt(arrow_width) +
                        parseInt(arrow_gap) / 2}px);`,
                },
            ]);

            // tablet
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel .slick-next",
                    device: "tablet",
                    declaration: `right: calc(50% - ${parseInt(
                        arrow_width_tablet
                    ) +
                        parseInt(arrow_gap_tablet) / 2}px);`,
                },
            ]);

            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel .slick-prev",
                    device: "tablet",
                    declaration: `left: calc(50% - ${parseInt(
                        arrow_width_tablet
                    ) +
                        parseInt(arrow_gap_tablet) / 2}px);`,
                },
            ]);

            // phone
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel .slick-next",
                    device: "phone",
                    declaration: `right: calc(50% - ${parseInt(
                        arrow_width_phone
                    ) +
                        parseInt(arrow_gap_phone) / 2}px);`,
                },
            ]);

            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel .slick-prev",
                    device: "phone",
                    declaration: `left: calc(50% - ${parseInt(
                        arrow_width_phone
                    ) +
                        parseInt(arrow_gap_phone) / 2}px);`,
                },
            ]);
        } else {
            // position X
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel .slick-next",
                    declaration: `${arrow_pos_hz}: ${arrow_pos_x};`,
                },
            ]);

            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel .slick-prev",
                    declaration: `left: auto; ${arrow_pos_hz}: ${arrow_pos_x};`,
                },
            ]);

            // position X tablet
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel .slick-next",
                    device: "tablet",
                    declaration: `${arrow_pos_hz}: ${arrow_pos_x_tablet};`,
                },
            ]);

            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel .slick-prev",
                    device: "tablet",
                    declaration: `left: auto; ${arrow_pos_hz}: ${arrow_pos_x_tablet};`,
                },
            ]);

            // position X phone
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel .slick-next",
                    device: "phone",
                    declaration: `${arrow_pos_hz}: ${arrow_pos_x_phone};`,
                },
            ]);

            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel .slick-prev",
                    device: "phone",
                    declaration: `left: auto; ${arrow_pos_hz}: ${arrow_pos_x_phone};`,
                },
            ]);

            // arrow gap
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel .slick-prev",
                    declaration: `margin-${arrow_pos_hz}: calc(${arrow_width} + ${arrow_gap});`,
                },
            ]);

            // arrow gap tablet
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel .slick-prev",
                    device: "tablet",
                    declaration: `margin-${arrow_pos_hz}: calc(${arrow_width_tablet} + ${arrow_gap_tablet});`,
                },
            ]);

            // arrow gap phone
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-carousel .slick-prev",
                    device: "phone",
                    declaration: `margin-${arrow_pos_hz}: calc(${arrow_width_phone} + ${arrow_gap_phone});`,
                },
            ]);
        }

        // position Y tablet
        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel .slick-arrow",
                device: "tablet",
                declaration: `top: auto;${arrow_pos}: ${arrow_pos_y_tablet};`,
            },
        ]);

        // position Y phone
        additionalCss.push([
            {
                selector: "%%order_class%% .wdc-carousel .slick-arrow",
                device: "phone",
                declaration: `top: auto; ${arrow_pos}: ${arrow_pos_y_phone};`,
            },
        ]);
    }

    // arrow custom icon
    additionalCss.push([
        {
            selector: "%%order_class%% .wdc-carousel .slick-next:before",
            declaration: `content: "${rightIcon}";`,
        },
    ]);

    additionalCss.push([
        {
            selector: "%%order_class%% .wdc-carousel .slick-prev:before",
            declaration: `content:" ${leftIcon}";`,
        },
    ]);

    // slide spacing
    if (is_vertical === "off") {
        additionalCss.push([
            {
                selector:
                    "%%order_class%% .wdc-carousel .slick-slide, .et-db #et-boc %%order_class%% .wdc-carousel .slick-slide",
                declaration: `padding-left: ${slide_spacing}; padding-right: ${slide_spacing};`,
            },
        ]);

        if ("off" === use_both_side_spacing) {
            additionalCss.push([
                {
                    selector:
                        "%%order_class%% .wdc-carousel .slick-list, .et-db #et-boc %%order_class%% .wdc-carousel .slick-list",
                    declaration: `margin-left: -${slide_spacing}!important; margin-right: -${slide_spacing}!important;`,
                },
            ]);
        }
    } else {
        additionalCss.push([
            {
                selector:
                    "%%order_class%% .wdc-carousel .slick-slide, .et-db #et-boc %%order_class%% .wdc-carousel .slick-slide",
                declaration: `padding-top: ${slide_spacing}!important; padding-bottom: ${slide_spacing}!important;`,
            },
        ]);

        additionalCss.push([
            {
                selector:
                    "%%order_class%% .wdc-carousel .slick-list, .et-db #et-boc %%order_class%% .wdc-carousel .slick-list",
                declaration: `margin-top: -${slide_spacing}!important; margin-bottom: -${slide_spacing}!important;`,
            },
        ]);
    }

    // Pagination
    additionalCss.push([
        {
            selector: "%%order_class%% .wdc-carousel .slick-dots",
            declaration: `text-align: ${pagi_alignment}; transform: translateY(${pagi_pos_y});`,
        },
    ]);

    additionalCss.push([
        {
            selector: "%%order_class%% .wdc-carousel .slick-dots li",
            declaration: `margin: 0 ${pagi_spacing};`,
        },
    ]);

    additionalCss.push([
        {
            selector: "%%order_class%% .wdc-carousel .slick-dots li button",
            declaration: `
                background: ${pagi_color};
                height: ${pagi_height};
                width: ${pagi_width};
                border-radius: ${pagi_radius[1]} ${pagi_radius[2]} ${pagi_radius[3]} ${pagi_radius[4]};`,
        },
    ]);

    additionalCss.push([
        {
            selector:
                "%%order_class%% .wdc-carousel .slick-dots li:hover button",
            declaration: `background: ${pagi_color__hover};`,
        },
    ]);

    additionalCss.push([
        {
            selector:
                "%%order_class%% .wdc-carousel .slick-dots li.slick-active button",
            declaration: `background: ${pagi_color_active}; width: ${pagi_width_active};`,
        },
    ]);

    let leftIconStyle = renderFontStyle(
        props,
        "icon_left",
        "%%order_class%% .wdc-carousel .slick-prev:before"
    );
    let rightIconStyle = renderFontStyle(
        props,
        "icon_right",
        "%%order_class%% .wdc-carousel .slick-next:before"
    );

    return additionalCss.concat( leftIconStyle ).concat( rightIconStyle);
};

export const _getCustomBgCss = (
    props,
    opt_name,
    selector,
    hover_selector,
    default_color
) => {
    let _bg_style = "";
    let _bg_images = [];
    let additionalCss = [];

    let has_bg_color_gradient = false;

    // A. Background Gradient.
    let use_background_color_gradient =
        props[opt_name + "_bg_use_color_gradient"] || "off";
    let _bg_gradient_overlays_image =
        props[opt_name + "_bg_color_gradient_overlays_image"] || "off";

    if ("on" === use_background_color_gradient) {
        let _bg_gradient_type =
            props[opt_name + "_bg_color_gradient_type"] || "linear";
        let _bg_gradient_direction =
            props[opt_name + "_bg_color_gradient_direction"] || "180deg";
        let _bg_gradient_radial_direction =
            props[opt_name + "_bg_color_gradient_direction_radial"] || "center";
        let _bg_gradient_color_start =
            props[opt_name + "_bg_color_gradient_start"] || "#2b87da";
        let _bg_gradient_color_end =
            props[opt_name + "_bg_color_gradient_end"] || "#29c4a9";
        let _bg_gradient_start_position =
            props[opt_name + "_bg_color_gradient_start_position"] || "0%";
        let _bg_gradient_end_position =
            props[opt_name + "_bg_color_gradient_end_position"] || "100%";

        _bg_gradient_direction =
            _bg_gradient_type === "linear"
                ? _bg_gradient_direction
                : `circle at ${_bg_gradient_radial_direction}`;

        let _bg_gradient_css = `${_bg_gradient_type}-gradient( ${_bg_gradient_direction}, ${_bg_gradient_color_start} ${_bg_gradient_start_position}, ${_bg_gradient_color_end} ${_bg_gradient_end_position} )`;

        _bg_images.push(_bg_gradient_css);

        has_bg_color_gradient = true;
    }

    if (_bg_images !== "") {
        // The browsers stack the images in the opposite order to what you'd expect.
        if ("on" !== _bg_gradient_overlays_image) {
            _bg_images = _bg_images.reverse();
        }
        // Set background image styles only it's different compared to the larger device.
        _bg_style += `background-image: ${_bg_images.join(", ")} !important;`;
    }

    if (!has_bg_color_gradient) {
        let _bg_output = props[opt_name + "_bg_color"]
            ? props[opt_name + "_bg_color"]
            : default_color;
        // The background color
        _bg_style += `background-color: ${_bg_output} !important;`;
    }

    additionalCss.push([
        {
            selector: selector,
            declaration: `${_bg_style}`,
        },
    ]);

    // hover
    let _bg_style_hover = "";
    let _bg_images_hover = [];
    let _hover_enabled = props[opt_name + "_bg_color__hover_enabled"];
    let has_bg_color_gradient_hover = false;

    _hover_enabled = _hover_enabled ? _hover_enabled.startsWith("on") : false;

    if (_hover_enabled) {
        // A. Background Gradient.
        let use_background_color_gradient_hover =
            props[opt_name + "_bg_use_color_gradient__hover"] || "off";
        let _bg_gradient_overlays_image_hover =
            props[opt_name + "_bg_color_gradient_overlays_image__hover"] ||
            "off";

        if (
            "on" === use_background_color_gradient_hover ||
            props[opt_name + "_bg_color_gradient_start__hover"]
        ) {
            let _bg_gradient_type_hover =
                props[opt_name + "_bg_color_gradient_type__hover"] || "linear";
            let _bg_gradient_direction_hover =
                props[opt_name + "_bg_color_gradient_direction__hover"] ||
                "180deg";
            let _bg_gradient_radial_direction_hover =
                props[
                    opt_name + "_bg_color_gradient_direction_radial__hover"
                ] || "circle";
            let _bg_gradient_color_start_hover =
                props[opt_name + "_bg_color_gradient_start__hover"] ||
                "#2b87da";
            let _bg_gradient_color_end_hover =
                props[opt_name + "_bg_color_gradient_end__hover"] || "#29c4a9";
            let _bg_gradient_start_position_hover =
                props[opt_name + "_bg_color_gradient_start_position__hover"] ||
                "0%";
            let _bg_gradient_end_position_hover =
                props[opt_name + "_bg_color_gradient_end_position__hover"] ||
                "100%";

            _bg_gradient_direction_hover =
                _bg_gradient_type_hover === "linear"
                    ? _bg_gradient_direction_hover
                    : `circle at ${_bg_gradient_radial_direction_hover}`;

            let _bg_gradient_css_hover = `${_bg_gradient_type_hover}-gradient( ${_bg_gradient_direction_hover}, ${_bg_gradient_color_start_hover} ${_bg_gradient_start_position_hover}, ${_bg_gradient_color_end_hover} ${_bg_gradient_end_position_hover} )`;
            _bg_images_hover.push(_bg_gradient_css_hover);
            has_bg_color_gradient_hover = true;
        }

        if (_bg_images_hover !== "") {
            // The browsers stack the images in the opposite order to what you'd expect.
            if ("on" !== _bg_gradient_overlays_image_hover) {
                _bg_images_hover = _bg_images_hover.reverse();
            }
            // Set background image styles only it's different compared to the larger device.
            _bg_style_hover += `background-image: ${_bg_images_hover.join(
                ", "
            )} !important;`;
        }

        if (!has_bg_color_gradient_hover) {
            // The background color
            if (typeof props[opt_name + "_bg_color__hover"] !== "undefined") {
                _bg_style_hover += `background-color: ${
                    props[opt_name + "_bg_color__hover"]
                } !important;`;
            }
        }

        if (props.hover_enabled === 1) {
            additionalCss.push([
                {
                    selector: selector,
                    declaration: `${_bg_style_hover}`,
                },
            ]);
        }

        additionalCss.push([
            {
                selector: hover_selector,
                declaration: `${_bg_style_hover}`,
            },
        ]);
    }

    return additionalCss;
};

export const _getOverlayStyleCss = (props) => {
    let additionalCss = [],
        overlay_icon_color = props.overlay_icon_color
            ? props.overlay_icon_color
            : "#2EA3F2",
        overlay_icon_color__hover = props.overlay_icon_color__hover,
        overlay_icon_size = props.overlay_icon_size
            ? props.overlay_icon_size
            : "32px",
        overlay_icon_size__hover = props.overlay_icon_size__hover,
        overlay_icon_opacity = props.overlay_icon_opacity
            ? props.overlay_icon_opacity
            : "1",
        overlay_icon_opacity__hover = props.overlay_icon_opacity__hover;

    additionalCss.push([
        {
            selector: "%%order_class%% .wdc-overlay .wdc-overlay-icon",
            declaration: `color: ${overlay_icon_color};`,
        },
    ]);

    if (overlay_icon_color__hover) {
        additionalCss.push([
            {
                selector: "%%order_class%%:hover .wdc-overlay .wdc-overlay-icon",
                declaration: `color: ${overlay_icon_color__hover};`,
            },
        ]);
    }

    additionalCss.push([
        {
            selector: "%%order_class%% .wdc-overlay .wdc-overlay-icon",
            declaration: `font-size: ${overlay_icon_size};`,
        },
    ]);

    if (overlay_icon_size__hover) {
        additionalCss.push([
            {
                selector: "%%order_class%%:hover .wdc-overlay .wdc-overlay-icon",
                declaration: `font-size: ${overlay_icon_size__hover};`,
            },
        ]);
    }

    additionalCss.push([
        {
            selector: "%%order_class%% .wdc-overlay .wdc-overlay-icon",
            declaration: `opacity: ${overlay_icon_opacity};`,
        },
    ]);

    if (overlay_icon_opacity__hover) {
        additionalCss.push([
            {
                selector: "%%order_class%%:hover .wdc-overlay .wdc-overlay-icon",
                declaration: `opacity: ${overlay_icon_opacity__hover};`,
            },
        ]);
    }

    if (props.hover_enabled === 1) {
        if (overlay_icon_opacity__hover) {
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-overlay .wdc-overlay-icon",
                    declaration: `opacity: ${overlay_icon_opacity__hover};`,
                },
            ]);
        }
        if (overlay_icon_size__hover) {
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-overlay .wdc-overlay-icon",
                    declaration: `font-size: ${overlay_icon_size__hover};`,
                },
            ]);
        }
        if (overlay_icon_color__hover) {
            additionalCss.push([
                {
                    selector: "%%order_class%% .wdc-overlay .wdc-overlay-icon",
                    declaration: `color: ${overlay_icon_color__hover};`,
                },
            ]);
        }
    }

    // Overlay Background
    let overlay_bg_style = _getCustomBgCss(
        props,
        "overlay",
        "%%order_class%% .wdc-overlay",
        "%%order_class%% .wdc-carousel-item:hover .wdc-overlay"
    );

    return additionalCss.concat(overlay_bg_style);
};

export const _render_swapped_image = (
    opt_name,
    props,
    figure_callback,
    state
) => {
    let photo_status = props[opt_name + "_last_edited"]
            ? props[opt_name + "_last_edited"]
            : "off|desktop",
        is_photo_edited = photo_status.split("|")[0],
        device =
            is_photo_edited === "on" ? photo_status.split("|")[1] : "desktop",
        photo_hover_enabled = props[opt_name + "__hover_enabled"]
            ? props[opt_name + "__hover_enabled"]
            : "off|desktop",
        has_photo_hover =
            photo_hover_enabled.split("|")[0] === "on" ? true : false,
        hover_status = props.hover_enabled ? props.hover_enabled : "0",
        photo = props.dynamic[opt_name]["value"]
            ? props.dynamic[opt_name]["value"]
            : props[opt_name]
            ? props[opt_name]
            : undefined,
        photo_tablet = props.dynamic[opt_name + "_tablet"]["value"]
            ? props.dynamic[opt_name + "_tablet"]["value"]
            : props[opt_name + "_tablet"]
            ? props[opt_name + "_tablet"]
            : photo,
        photo_phone = props.dynamic[opt_name + "_phone"]["value"]
            ? props.dynamic[opt_name + "_phone"]["value"]
            : props[opt_name + "_phone"]
            ? props[opt_name + "_phone"]
            : photo_tablet,
        photo_hover = props.dynamic[opt_name + "__hover"]["value"]
            ? props.dynamic[opt_name + "__hover"]["value"]
            : props[opt_name + "__hover"]
            ? props[opt_name + "__hover"]
            : photo,
        figure = null;

    if (device === "desktop") {
        if (has_photo_hover && hover_status === 1) {
            figure = figure_callback(photo_hover);
        } else {
            figure = figure_callback(photo);
        }
    } else if (device === "tablet") {
        if (state.width > 800) {
            figure = figure_callback(photo);
        } else {
            figure = figure_callback(photo_tablet);
        }
    } else if (device === "phone") {
        if (state.width > 500) {
            figure = figure_callback(photo);
        } else {
            figure = figure_callback(photo_phone);
        }
    }

    return figure;
};

function _render_tab_title(el, _title) {
    let title = el.props.attrs.tab_title;

    if (!title) {
        title = el.props.attrs[_title] ? el.props.attrs[_title] : "Title";
    }

    return <h2>{title}</h2>;
}

function _render_tab_subtitle(el, _subtitle) {
    let subtitle = el.props.attrs.tab_subtitle;

    if (!subtitle) {
        subtitle = el.props.attrs[_subtitle]
            ? el.props.attrs[_subtitle]
            : "Subtitle";
    }

    return <p>{subtitle}</p>;
}

function _render_tab_thumb(el, _thumb) {
    let thumb = el.props.attrs.tab_thumb;
    if (!thumb) {
        thumb = el.props.attrs[_thumb];
    }
    if (thumb) {
        return <figure>{<img src={thumb} alt='' />}</figure>;
    }
}

export const _renderCarouselNav = (props, _title, _subtitle, _thumb) => {
    let tab_elements = props.tab_elements.split("|");
    let ChildData;

    if (props.content) {
        ChildData = props.content.map((el, i) => {
            return (
                <div key={i} className='wdc-carousel-nav-item'>
                    {tab_elements[2] === "on" && _render_tab_thumb(el, _thumb)}
                    {tab_elements[0] === "on" && _render_tab_title(el, _title)}
                    {tab_elements[1] === "on" &&
                        _render_tab_subtitle(el, _subtitle)}
                </div>
            );
        });
    }

    return ChildData;
};

export const _getButtonsStyles = (prefix, props, selector) => {
    let additionalCss = [],
        padding_hover_status = props[prefix + "_custom_padding__hover_enabled"],
        is_padding_hover = padding_hover_status
            ? padding_hover_status.split("|")[0] === "on"
                ? true
                : false
            : false,
        border_color = props[prefix + "_border_color"],
        border_radius = props[prefix + "_border_radius"],
        custom_padding = props[prefix + "_custom_padding"],
        custom_padding_tablet = props[prefix + "_custom_padding_tablet"],
        custom_padding_phone = props[prefix + "_custom_padding_phone"],
        custom_padding_responsive_status =
            props[prefix + "_custom_padding_last_edited"] &&
            props[prefix + "_custom_padding_last_edited"].startsWith("on"),
        custom_padding__hover = props[prefix + "_custom_padding__hover"],
        is_custom = props["custom_" + prefix],
        hover_enabled = props.hover_enabled;

    if (is_custom === "on") {
        if (border_color) {
            additionalCss.push([
                {
                    selector,
                    declaration: `border-color: ${border_color} !important;`,
                },
            ]);
        }

        if (border_radius) {
            additionalCss.push([
                {
                    selector,
                    declaration: `border-radius: ${border_radius} !important;`,
                },
            ]);
        }

        // Custom padding
        if (custom_padding) {
            let _custom_padding = custom_padding.split("|");
            additionalCss.push([
                {
                    selector: `body #page-container ${selector}, .et-db #et-boc ${selector}`,
                    declaration: `
					  padding-top: ${_custom_padding[0]}!important;
					  padding-right: ${_custom_padding[1]}!important;
					  padding-bottom: ${_custom_padding[2]}!important;
					  padding-left: ${_custom_padding[3]}!important;`,
                },
            ]);
        }

        if (is_padding_hover && custom_padding__hover) {
            let _custom_padding__hover = custom_padding__hover.split("|");
            additionalCss.push([
                {
                    selector: `body #page-container ${selector}:hover, .et-db #et-boc ${selector}:hover`,
                    declaration: `
					  padding-top: ${_custom_padding__hover[0]}!important;
					  padding-right: ${_custom_padding__hover[1]}!important;
					  padding-bottom: ${_custom_padding__hover[2]}!important;
					  padding-left: ${_custom_padding__hover[3]}!important;`,
                },
            ]);
            if (hover_enabled === 1) {
                additionalCss.push([
                    {
                        selector: `body #page-container ${selector}, .et-db #et-boc ${selector}`,
                        declaration: `
						  padding-top: ${_custom_padding__hover[0]}!important;
						  padding-right: ${_custom_padding__hover[1]}!important;
						  padding-bottom: ${_custom_padding__hover[2]}!important;
						  padding-left: ${_custom_padding__hover[3]}!important;`,
                    },
                ]);
            }
        } else {
            if (custom_padding) {
                let custom_padding_hover = custom_padding.split("|");
                additionalCss.push([
                    {
                        selector: `body #page-container ${selector}:hover, .et-db #et-boc ${selector}:hover`,
                        declaration: `
						  padding-top: ${custom_padding_hover[0]}!important;
						  padding-right: ${custom_padding_hover[1]}!important;
						  padding-bottom: ${custom_padding_hover[2]}!important;
						  padding-left: ${custom_padding_hover[3]}!important;`,
                    },
                ]);
                if (hover_enabled === 1) {
                    additionalCss.push([
                        {
                            selector: `body #page-container ${selector}, .et-db #et-boc ${selector}`,
                            declaration: `
							  padding-top: ${custom_padding_hover[0]}!important;
							  padding-right: ${custom_padding_hover[1]}!important;
							  padding-bottom: ${custom_padding_hover[2]}!important;
							  padding-left: ${custom_padding_hover[3]}!important;`,
                        },
                    ]);
                }
            }
        }

        if (custom_padding_tablet && custom_padding_responsive_status) {
            custom_padding_tablet = custom_padding_tablet.split("|");
            additionalCss.push([
                {
                    selector: `body #page-container ${selector}, .et-db #et-boc ${selector}`,
                    device: "tablet",
                    declaration: `
					  padding-top: ${custom_padding_tablet[0]}!important;
					  padding-right: ${custom_padding_tablet[1]}!important;
					  padding-bottom: ${custom_padding_tablet[2]}!important;
					  padding-left: ${custom_padding_tablet[3]}!important;`,
                },
            ]);
        }

        if (custom_padding_phone && custom_padding_responsive_status) {
            custom_padding_phone = custom_padding_phone.split("|");
            additionalCss.push([
                {
                    selector: `body #page-container ${selector}, .et-db #et-boc ${selector}`,
                    device: "phone",
                    declaration: `
					  padding-top: ${custom_padding_phone[0]}!important;
					  padding-right: ${custom_padding_phone[1]}!important;
					  padding-bottom: ${custom_padding_phone[2]}!important;
					  padding-left: ${custom_padding_phone[3]}!important;`,
                },
            ]);
        }

        // Custom padding end
    }

    return additionalCss;
};

export const renderFontStyle = (props, slug, selector) => {
    if (props[slug]) {
        let fontFamily = {
                divi: "ETmodules !important",
                fa: "FontAwesome!important",
            },
            icon = props[slug] ? props[slug].split("|") : [],
            additionalCss = [];

        additionalCss.push([
            {
                selector,
                declaration: `
                font-family: ${fontFamily[icon[2]]};
                font-weight: ${icon[4]}!important;`,
            },
        ]);
        return additionalCss;
    }
};
