<?php
class WDC_Builder_Module extends ET_Builder_Module {

    protected function custom_advanced_background_fields(
        $option_name,
        $option_label,
        $tab_slug,
        $toggle_slug,
        $background_tab,
        $show_if,
        $default
    ) {

        $color    = [];
        $gradient = [];

        if ( in_array( 'color', $background_tab, true ) ) {
            $color = $this->generate_background_options( "{$option_name}_bg", 'color', $tab_slug, $toggle_slug, "{$option_name}_bg_color" );
        }

        if ( in_array( 'gradient', $background_tab, true ) ) {
            $gradient = $this->generate_background_options( "{$option_name}_bg", 'gradient', $tab_slug, $toggle_slug, "{$option_name}_bg_color" );
        }

        $advanced_fields = [];

        $advanced_fields["{$option_name}_bg_color"] = [
            'label'             => sprintf( '%1$s Background', $option_label ),
            'type'              => 'background-field',
            'base_name'         => "{$option_name}_bg",
            'context'           => "{$option_name}_bg_color",
            'option_category'   => 'layout',
            'custom_color'      => true,
            'default'           => $default,
            'tab_slug'          => $tab_slug,
            'toggle_slug'       => $toggle_slug,
            'hover'             => 'tabs',
            'show_if'           => $show_if,
            'background_fields' => array_merge( $color, $gradient ),
        ];

        $skip = $this->generate_background_options( "{$option_name}_bg", 'skip', $tab_slug, $toggle_slug, "{$option_name}_bg_color" );

        $advanced_fields = array_merge( $advanced_fields, $skip );

        return $advanced_fields;
    }

    protected function get_custom_gradient( $args ) {

        $defaults = apply_filters(
            'et_pb_default_gradient',
            [
                'type'             => ET_Global_Settings::get_value( 'all_background_gradient_type' ),
                'direction'        => ET_Global_Settings::get_value( 'all_background_gradient_direction' ),
                'radial_direction' => ET_Global_Settings::get_value( 'all_background_gradient_direction_radial' ),
                'color_start'      => ET_Global_Settings::get_value( 'all_background_gradient_start' ),
                'color_end'        => ET_Global_Settings::get_value( 'all_background_gradient_end' ),
                'start_position'   => ET_Global_Settings::get_value( 'all_background_gradient_start_position' ),
                'end_position'     => ET_Global_Settings::get_value( 'all_background_gradient_end_position' ),
            ]
        );

        $args           = wp_parse_args( array_filter( $args ), $defaults );
        $direction      = 'linear' === $args['type'] ? $args['direction'] : "circle at {$args['radial_direction']}";
        $start_position = et_sanitize_input_unit( $args['start_position'], false, '%' );
        $end_position   = et_sanitize_input_unit( $args['end_position'], false, '%' );

        return esc_html(
            "{$args['type']}-gradient(
			{$direction},
			{$args['color_start']} ${start_position},
			{$args['color_end']} ${end_position}
		)"
        );

    }

    protected function processcustom_advanced_background_fields( $option_name, $hover_suffix ) {

        // Background Options Styling.
        $background_base_name          = "{$option_name}_bg";
        $background_prefix             = "{$background_base_name}_";
        $background_style              = '';
        $background_image_style        = '';
        $background_images             = [];
        $has_background_color_gradient = false;

        // A. Background Gradient.
        $use_background_color_gradient = isset( $this->props["{$background_prefix}use_color_gradient{$hover_suffix}"] ) ? $this->props["{$background_prefix}use_color_gradient{$hover_suffix}"] : '';

        if ( 'on' === $use_background_color_gradient ) {

            $background_color_gradient_overlays_image = isset( $this->props["{$background_prefix}color_gradient_overlays_image{$hover_suffix}"] ) ? $this->props["{$background_prefix}color_gradient_overlays_image{$hover_suffix}"] : '';

            $type = isset( $this->props["{$background_prefix}color_gradient_type{$hover_suffix}"] ) ? $this->props["{$background_prefix}color_gradient_type{$hover_suffix}"] : '';

            $direction = isset( $this->props["{$background_prefix}color_gradient_direction{$hover_suffix}"] ) ? $this->props["{$background_prefix}color_gradient_direction{$hover_suffix}"] : '';

            $radial_direction = isset( $this->props["{$background_prefix}color_gradient_direction_radial{$hover_suffix}"] ) ? $this->props["{$background_prefix}color_gradient_direction_radial{$hover_suffix}"] : '';

            $color_start = isset( $this->props["{$background_prefix}color_gradient_start{$hover_suffix}"] ) ? $this->props["{$background_prefix}color_gradient_start{$hover_suffix}"] : '';

            $color_end = isset( $this->props["{$background_prefix}color_gradient_end{$hover_suffix}"] ) ? $this->props["{$background_prefix}color_gradient_end{$hover_suffix}"] : '';

            $start_position = isset( $this->props["{$background_prefix}color_gradient_start_position{$hover_suffix}"] ) ? $this->props["{$background_prefix}color_gradient_start_position{$hover_suffix}"] : '';

            $end_position = isset( $this->props["{$background_prefix}color_gradient_end_position{$hover_suffix}"] ) ? $this->props["{$background_prefix}color_gradient_end_position{$hover_suffix}"] : '';

            $gradient_properties = [
                'type'             => $type,
                'direction'        => $direction,
                'radial_direction' => $radial_direction,
                'color_start'      => $color_start,
                'color_end'        => $color_end,
                'start_position'   => $start_position,
                'end_position'     => $end_position,
            ];

            // Save background gradient into background images list.
            $background_gradient = $this->get_custom_gradient( $gradient_properties );
            $background_images[] = $background_gradient;

            // Flag to inform BG Color if current module has Gradient.
            $has_background_color_gradient = true;

        }

        if ( !empty( $background_images ) ) {

// The browsers stack the images in the opposite order to what you'd expect.
            if ( 'on' !== $background_color_gradient_overlays_image ) {
                $background_images = array_reverse( $background_images );
            }

            // Set background image styles only it's different compared to the larger device.
            $background_image_style = join( ', ', $background_images );

            $background_style .= sprintf(
                'background-image: %1$s !important;',
                esc_html( $background_image_style )
            );

        }

// B. Background Color.
        if ( !$has_background_color_gradient ) {
            $background_color = isset( $this->props["{$background_prefix}color{$hover_suffix}"] ) ? $this->props["{$background_prefix}color{$hover_suffix}"] : '';
            if ( '' !== $background_color ) {
                $background_style .= sprintf(
                    'background-color: %1$s%2$s; ',
                    esc_html( $background_color ),
                    esc_html( ' !important' )
                );
            }

        }

        return $background_style;

    }

    protected function get_swapped_img_schema( $opt_name ) {

        $photo_last_edited    = isset( $this->props["{$opt_name}_last_edited"] ) ? $this->props["{$opt_name}_last_edited"] : 'off|desktop';
        $photo__hover_enabled = isset( $this->props["{$opt_name}__hover_enabled"] ) ? $this->props["{$opt_name}__hover_enabled"] : 'off|desktop';

        $photo_device_status = explode( '|', $photo_last_edited )[0];
        $photo_hover_status  = explode( '|', $photo__hover_enabled )[0];
        $photo_schema_status = 'on' === $photo_device_status || 'on' === $photo_hover_status ? 'on' : 'off';

        $photo        = $this->props["{$opt_name}"];
        $photo_hover  = $this->get_hover_value( "{$opt_name}" );
        $photo_tablet = $this->props["{$opt_name}_tablet"];
        $photo_phone  = $this->props["{$opt_name}_phone"];

        $schema = [];
        $i      = 0;

        if ( 'on' === $photo_device_status || 'on' === $photo_hover_status ) {
            $schema[$i] = '"desktop":"' . $photo . '"';
            $i++;
        }

        if ( 'on' === $photo_hover_status && !empty( $photo_hover ) ) {
            $schema[$i] = '"hover":"' . $photo_hover . '"';
            $i++;
        }

        if ( 'on' === $photo_device_status && !empty( $photo_tablet ) ) {
            $schema[$i] = '"tablet":"' . $photo_tablet . '"';
            $i++;
        }

        if ( 'on' === $photo_device_status && !empty( $photo_phone ) ) {
            $schema[$i] = '"phone":"' . $photo_phone . '"';
        }

        if ( 'on' === $photo_schema_status ) {
            return sprintf( 'data-schema=\'{%1$s}\'', join( ',', $schema ) );
        }

    }

    public static function wdc_process_padding( $val, $imp ) {

        $_val = explode( '|', $val );

        $padding_top    = '';
        $padding_right  = '';
        $padding_bottom = '';
        $padding_left   = '';
        $imp_text       = '';

        if ( $imp ) {
            $imp_text = '!important';
        }

        if ( '' !== $_val[0] ) {
            $padding_top = 'padding-top:' . $_val[0] . $imp_text . ';';
        }

        if ( '' !== $_val[1] ) {
            $padding_right = 'padding-right:' . $_val[1] . $imp_text . ';';
        }

        if ( '' !== $_val[2] ) {
            $padding_bottom = 'padding-bottom:' . $_val[2] . $imp_text . ';';
        }

        if ( '' !== $_val[3] ) {
            $padding_left = 'padding-left:' . $_val[3] . $imp_text . ';';
        }

        return esc_html( "{$padding_top} {$padding_right} {$padding_bottom} {$padding_left}" );
    }

    public static function render_carousel( $args, $conditional_tags, $current_page ) {
        return false;
    }

    public static function get_carousel_option_fields( $design_slug, $supports ) {
        $aditional = [];

        $fields = [
            'animation_speed'         => [
                'label'           => esc_html__( 'Animation Speed', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '700ms',
                'fixed_unit'      => 'ms',
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'general',
                'range_settings'  => [
                    'step' => 100,
                    'min'  => 0,
                    'max'  => 10000,
                ],
            ],

            'is_autoplay'             => [
                'label'           => esc_html__( 'Autoplay', 'wdc-wow-divi-carousel' ),
                'type'            => 'yes_no_button',
                'option_category' => 'configuration',
                'default'         => 'on',
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'general',
                'options'         => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
            ],

            'autoplay_speed'          => [
                'label'           => esc_html__( 'Autoplay Speed', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '2000ms',
                'fixed_unit'      => 'ms',
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'general',
                'range_settings'  => [
                    'step' => 100,
                    'min'  => 1000,
                    'max'  => 10000,
                ],
                'show_if'         => [
                    'is_autoplay' => 'on',
                ],
            ],

            'nav_pagi'                => [
                'label'          => esc_html__( 'Navigation & Pagination', 'wdc-wow-divi-carousel' ),
                'type'           => 'select',
                'default'        => 'nav',
                'toggle_slug'    => 'settings',
                'sub_toggle'     => 'general',
                'mobile_options' => true,
                'options'        => [
                    'none'     => esc_html__( 'None', 'wdc-wow-divi-carousel' ),
                    'nav'      => esc_html__( 'Navigation', 'wdc-wow-divi-carousel' ),
                    'pagi'     => esc_html__( 'Pagination', 'wdc-wow-divi-carousel' ),
                    'nav_pagi' => esc_html__( 'Navigation & Pagination', 'wdc-wow-divi-carousel' ),
                ],
            ],

            'is_variable_width'       => [
                'label'           => esc_html__( 'Use Fixed Width Slide', 'wdc-wow-divi-carousel' ),
                'type'            => 'yes_no_button',
                'option_category' => 'configuration',
                'default'         => 'off',
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'general',
                'options'         => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
                'show_if_not'     => [
                    'use_tab' => 'on',
                ],
            ],

            'slide_width'             => [
                'label'           => esc_html__( 'Slide Width', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'default'         => '360px',
                'option_category' => 'basic_option',
                'fixed_unit'      => 'px',
                'mobile_options'  => true,
                'range_settings'  => [
                    'min'  => 0,
                    'step' => 1,
                    'max'  => 1000,
                ],
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'general',
                'show_if_not'     => [
                    'use_tab' => 'on',
                ],
                'show_if'         => [
                    'is_variable_width' => 'on',
                ],
            ],

            'slide_count'             => [
                'label'          => esc_html__( 'Slides To Show', 'wdc-wow-divi-carousel' ),
                'type'           => 'select',
                'default'        => '3',
                'toggle_slug'    => 'settings',
                'sub_toggle'     => 'general',
                'mobile_options' => true,
                'options'        => [
                    '1' => esc_html__( '1', 'wdc-wow-divi-carousel' ),
                    '2' => esc_html__( '2', 'wdc-wow-divi-carousel' ),
                    '3' => esc_html__( '3', 'wdc-wow-divi-carousel' ),
                    '4' => esc_html__( '4', 'wdc-wow-divi-carousel' ),
                    '5' => esc_html__( '5', 'wdc-wow-divi-carousel' ),
                    '6' => esc_html__( '6', 'wdc-wow-divi-carousel' ),
                    '7' => esc_html__( '7', 'wdc-wow-divi-carousel' ),
                    '8' => esc_html__( '8', 'wdc-wow-divi-carousel' ),
                ],
                'show_if'        => [
                    'is_variable_width' => 'off',
                ],
            ],

            'is_fade'                 => [
                'label'           => esc_html__( 'Fade Effect', 'wdc-wow-divi-carousel' ),
                'type'            => 'yes_no_button',
                'option_category' => 'configuration',
                'default'         => 'off',
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'general',
                'options'         => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
                'show_if'         => [
                    'is_variable_width' => 'off',
                    'slide_count'       => '1',
                ],
            ],

            'slide_spacing'           => [
                'label'           => esc_html__( 'Slide Spacing', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '10px',
                'fixed_unit'      => 'px',
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'general',
                'range_settings'  => [
                    'step' => 1,
                    'min'  => 0,
                    'max'  => 100,
                ],
            ],

            'use_both_side_spacing'   => [
                'label'           => esc_html__( 'Apply Spacing on First & Last Item', 'wdc-wow-divi-carousel' ),
                'type'            => 'yes_no_button',
                'option_category' => 'configuration',
                'default'         => 'off',
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'general',
                'options'         => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
                'show_if'         => [
                    'is_vertical' => 'off',
                ],
            ],

            'is_infinite'             => [
                'label'           => esc_html__( 'Infinite looping', 'wdc-wow-divi-carousel' ),
                'type'            => 'yes_no_button',
                'option_category' => 'configuration',
                'default'         => 'on',
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'general',
                'options'         => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
            ],

            'sliding_dir'             => [
                'label'       => esc_html__( 'Sliding Direction', 'wdc-wow-divi-carousel' ),
                'description' => esc_html__( 'Define sliding direction. RTL sliding will only work on frontend. ', 'wdc-wow-divi-carousel' ),
                'type'        => 'select',
                'toggle_slug' => 'settings',
                'sub_toggle'  => 'advanced',
                'default'     => 'ltr',
                'options'     => [
                    'ltr' => esc_html__( 'Left to Right', 'wdc-wow-divi-carousel' ),
                    'rtl' => esc_html__( 'Right to Left', 'wdc-wow-divi-carousel' ),
                ],
            ],

            'css_transition'          => [
                'label'       => esc_html__( 'Sliding CSS Transition', 'wdc-wow-divi-carousel' ),
                'type'        => 'select',
                'default'     => 'ease-in-out',
                'toggle_slug' => 'settings',
                'sub_toggle'  => 'advanced',
                'options'     => [
                    'linear'      => esc_html__( 'linear', 'wdc-wow-divi-carousel' ),
                    'ease-in'     => esc_html__( 'ease-in', 'wdc-wow-divi-carousel' ),
                    'ease-in-out' => esc_html__( 'ease-in-out', 'wdc-wow-divi-carousel' ),
                ],
            ],

            'is_lazyload'             => [
                'label'           => esc_html__( 'Lazy loading', 'wdc-wow-divi-carousel' ),
                'type'            => 'yes_no_button',
                'option_category' => 'configuration',
                'default'         => 'on',
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'advanced',
                'options'         => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
            ],

            'lazyload_type'           => [
                'label'       => esc_html__( 'Lazy loading Type', 'wdc-wow-divi-carousel' ),
                'type'        => 'select',
                'default'     => 'progressive',
                'toggle_slug' => 'settings',
                'sub_toggle'  => 'advanced',
                'options'     => [
                    'progressive' => esc_html__( 'Progressive', 'wdc-wow-divi-carousel' ),
                    'ondemand'    => esc_html__( 'Ondemand', 'wdc-wow-divi-carousel' ),
                ],
                'show_if'     => [
                    'is_lazyload' => 'on',
                ],
            ],

            'is_auto_height'          => [
                'label'           => esc_html__( 'Auto Height', 'wdc-wow-divi-carousel' ),
                'type'            => 'yes_no_button',
                'option_category' => 'configuration',
                'default'         => 'off',
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'advanced',
                'options'         => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
            ],

            'is_swipe'                => [
                'label'           => esc_html__( 'Swipe', 'wdc-wow-divi-carousel' ),
                'type'            => 'yes_no_button',
                'option_category' => 'configuration',
                'default'         => 'on',
                'mobile_options'  => true,
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'advanced',
                'options'         => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
            ],

            'slide_to_scroll'         => [
                'label'          => esc_html__( 'Items to Scroll', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default'        => '1',
                'unitless'       => true,
                'mobile_options' => true,
                'range_settings' => [
                    'min'  => 1,
                    'step' => 1,
                    'max'  => 20,
                ],
                'toggle_slug'    => 'settings',
                'sub_toggle'     => 'advanced',
            ],

            'is_vertical'             => [
                'label'           => esc_html__( 'Vertical Mode', 'wdc-wow-divi-carousel' ),
                'type'            => 'yes_no_button',
                'option_category' => 'configuration',
                'default'         => 'off',
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'advanced',
                'options'         => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
            ],

            'is_center'               => [
                'label'           => esc_html__( 'Center Mode', 'wdc-wow-divi-carousel' ),
                'type'            => 'yes_no_button',
                'option_category' => 'configuration',
                'default'         => 'off',
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'advanced',
                'options'         => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
            ],

            'center_mode_type'        => [
                'label'       => esc_html__( 'Center Mode Type', 'wdc-wow-divi-carousel' ),
                'type'        => 'select',
                'default'     => 'classic',
                'toggle_slug' => 'settings',
                'sub_toggle'  => 'advanced',
                'options'     => [
                    'classic'     => esc_html__( 'Classic', 'wdc-wow-divi-carousel' ),
                    'highlighted' => esc_html__( 'Highlighted', 'wdc-wow-divi-carousel' ),
                ],
                'show_if'     => [
                    'is_center' => 'on',
                ],
            ],

            'center_padding'          => [
                'label'           => esc_html__( 'Center Padding', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'default'         => '70px',
                'option_category' => 'basic_option',
                'fixed_unit'      => 'px',
                'range_settings'  => [
                    'min'  => 0,
                    'step' => 1,
                    'max'  => 400,
                ],
                'mobile_options'  => true,
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'advanced',
                'show_if'         => [
                    'is_center'         => 'on',
                    'center_mode_type'  => 'classic',
                    'is_variable_width' => 'off',
                ],
            ],

            'wait_for_animate'        => [
                'label'           => esc_html__( 'Wait For Animate', 'wdc-wow-divi-carousel' ),
                'type'            => 'yes_no_button',
                'option_category' => 'configuration',
                'default'         => 'on',
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'advanced',
                'options'         => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
            ],

            'custom_cursor'           => [
                'label'           => esc_html__( 'Use Custom Cursor', 'wdc-wow-divi-carousel' ),
                'type'            => 'yes_no_button',
                'option_category' => 'configuration',
                'default'         => 'off',
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'advanced',
                'options'         => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
            ],

            'cursor_name'             => [
                'label'       => esc_html__( 'Cursor Name', 'wdc-wow-divi-carousel' ),
                'type'        => 'select',
                'default'     => 'css_default',
                'toggle_slug' => 'settings',
                'sub_toggle'  => 'advanced',
                'options'     => [
                    'css_default'   => esc_html__( 'Default', 'wdc-wow-divi-carousel' ),
                    'css_none'      => esc_html__( 'None', 'wdc-wow-divi-carousel' ),
                    'css_grab'      => esc_html__( 'Grab', 'wdc-wow-divi-carousel' ),
                    'css_pointer'   => esc_html__( 'Pointer', 'wdc-wow-divi-carousel' ),
                    'css_move'      => esc_html__( 'Move', 'wdc-wow-divi-carousel' ),
                    'custom_pizza'  => esc_html__( 'Pizza', 'wdc-wow-divi-carousel' ),
                    'custom_burger' => esc_html__( 'Burger', 'wdc-wow-divi-carousel' ),
                ],
                'show_if'     => [
                    'custom_cursor' => 'on',
                ],
            ],

            // carousel style.
            'carousel_spacing_top'    => [
                'label'           => esc_html__( 'Wrapper Spacing Top', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '0px',
                'fixed_unit'      => 'px',
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'advanced',
                'mobile_options'  => true,
                'range_settings'  => [
                    'step' => 1,
                    'min'  => 0,
                    'max'  => 200,
                ],
            ],

            'carousel_spacing_bottom' => [
                'label'           => esc_html__( 'Wrapper Spacing Bottom', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '0px',
                'fixed_unit'      => 'px',
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'advanced',
                'mobile_options'  => true,
                'range_settings'  => [
                    'step' => 1,
                    'min'  => 0,
                    'max'  => 200,
                ],
            ],

            // Arrow.
            'arrow_type'              => [
                'label'       => esc_html__( 'Type', 'wdc-wow-divi-carousel' ),
                'type'        => 'select',
                'default'     => 'default',
                'toggle_slug' => 'arrow',
                'tab_slug'    => 'advanced',
                'sub_toggle'  => 'arrow_common',
                'options'     => [
                    'default'   => esc_html__( 'Default', 'wdc-wow-divi-carousel' ),
                    'alongside' => esc_html__( 'Alongside', 'wdc-wow-divi-carousel' ),
                ],
                'show_if'     => [
                    'sliding_dir' => 'ltr',
                ],
            ],

            'arrow_pos'               => [
                'label'       => esc_html__( 'Vertical Placement', 'wdc-wow-divi-carousel' ),
                'type'        => 'select',
                'default'     => 'top',
                'toggle_slug' => 'arrow',
                'tab_slug'    => 'advanced',
                'sub_toggle'  => 'arrow_common',
                'options'     => [
                    'top'    => esc_html__( 'Top', 'wdc-wow-divi-carousel' ),
                    'bottom' => esc_html__( 'Bottom', 'wdc-wow-divi-carousel' ),
                ],
                'show_if'     => [
                    'arrow_type' => 'alongside',
                ],
            ],

            'arrow_pos_hz'            => [
                'label'       => esc_html__( 'Horizontal Placement', 'wdc-wow-divi-carousel' ),
                'type'        => 'select',
                'default'     => 'left',
                'toggle_slug' => 'arrow',
                'tab_slug'    => 'advanced',
                'sub_toggle'  => 'arrow_common',
                'options'     => [
                    'left'  => esc_html__( 'Left', 'wdc-wow-divi-carousel' ),
                    'right' => esc_html__( 'Right', 'wdc-wow-divi-carousel' ),
                ],
                'show_if'     => [
                    'arrow_type' => 'alongside',
                ],
            ],

            'arrow_height'            => [
                'label'           => esc_html__( 'Height', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '40px',
                'fixed_unit'      => 'px',
                'toggle_slug'     => 'arrow',
                'tab_slug'        => 'advanced',
                'sub_toggle'      => 'arrow_common',
                'mobile_options'  => true,
                'range_settings'  => [
                    'step' => 1,
                    'min'  => 0,
                    'max'  => 200,
                ],
            ],

            'arrow_width'             => [
                'label'           => esc_html__( 'Width', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '40px',
                'fixed_unit'      => 'px',
                'toggle_slug'     => 'arrow',
                'tab_slug'        => 'advanced',
                'sub_toggle'      => 'arrow_common',
                'mobile_options'  => true,
                'range_settings'  => [
                    'step' => 1,
                    'min'  => 0,
                    'max'  => 200,
                ],
            ],

            'arrow_icon_size'         => [
                'label'           => esc_html__( 'Icon Size', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '30px',
                'toggle_slug'     => 'arrow',
                'tab_slug'        => 'advanced',
                'sub_toggle'      => 'arrow_common',
                'mobile_options'  => true,
                'range_settings'  => [
                    'step' => 1,
                    'min'  => 0,
                    'max'  => 200,
                ],
            ],

            'arrow_color'             => [
                'label'       => esc_html__( 'Icon Color', 'wdc-wow-divi-carousel' ),
                'type'        => 'color-alpha',
                'tab_slug'    => 'advanced',
                'toggle_slug' => 'arrow',
                'default'     => '#333',
                'sub_toggle'  => 'arrow_common',
                'hover'       => 'tabs',
            ],

            'arrow_bg'                => [
                'label'       => esc_html__( 'Background', 'wdc-wow-divi-carousel' ),
                'type'        => 'color-alpha',
                'tab_slug'    => 'advanced',
                'toggle_slug' => 'arrow',
                'default'     => '#ddd',
                'sub_toggle'  => 'arrow_common',
                'hover'       => 'tabs',
            ],

            'arrow_skew'              => [
                'label'           => esc_html__( 'Skew', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '0deg',
                'fixed_unit'      => 'deg',
                'default_unit'    => 'deg',
                'toggle_slug'     => 'arrow',
                'tab_slug'        => 'advanced',
                'sub_toggle'      => 'arrow_common',
                'range_settings'  => [
                    'min'  => -90,
                    'max'  => 90,
                    'step' => 1,
                ],
            ],

            'arrow_gap'               => [
                'label'           => esc_html__( 'Spacing Between', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '10px',
                'default_unit'    => 'px',
                'toggle_slug'     => 'arrow',
                'tab_slug'        => 'advanced',
                'sub_toggle'      => 'arrow_common',
                'mobile_options'  => true,
                'show_if'         => [
                    'arrow_type' => 'alongside',
                ],
                'range_settings'  => [
                    'min'  => 0,
                    'max'  => 100,
                    'step' => 1,
                ],
            ],

            'arrow_pos_y'             => [
                'label'           => esc_html__( 'Vertical Position', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '50%',
                'mobile_options'  => true,
                'toggle_slug'     => 'arrow',
                'tab_slug'        => 'advanced',
                'sub_toggle'      => 'arrow_common',
                'range_settings'  => [
                    'min'  => -150,
                    'max'  => 500,
                    'step' => 1,
                ],
            ],

            'arrow_x_center'          => [
                'label'       => esc_html__( 'Use Horizontal Position Center', 'wdc-wow-divi-carousel' ),
                'type'        => 'yes_no_button',
                'default'     => 'off',
                'toggle_slug' => 'arrow',
                'tab_slug'    => 'advanced',
                'sub_toggle'  => 'arrow_common',
                'options'     => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
                'show_if'     => [
                    'arrow_type' => 'alongside',
                ],
            ],

            'arrow_pos_x'             => [
                'label'           => esc_html__( 'Horizontal Position', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'mobile_options'  => true,
                'default'         => '-25px',
                'toggle_slug'     => 'arrow',
                'tab_slug'        => 'advanced',
                'sub_toggle'      => 'arrow_common',
                'range_settings'  => [
                    'min'  => -300,
                    'max'  => 300,
                    'step' => 1,
                ],
                'show_if_not'     => [
                    'arrow_x_center' => 'on',
                ],
            ],

            'arrow_border_width'      => [
                'label'           => esc_html__( 'Border Width', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '0px',
                'default_unit'    => 'px',
                'toggle_slug'     => 'arrow',
                'tab_slug'        => 'advanced',
                'sub_toggle'      => 'arrow_common',
                'range_settings'  => [
                    'min'  => 0,
                    'max'  => 100,
                    'step' => 1,
                ],
            ],

            'arrow_border_color'      => [
                'label'       => esc_html__( 'Border Color', 'wdc-wow-divi-carousel' ),
                'type'        => 'color-alpha',
                'default'     => '#333',
                'toggle_slug' => 'arrow',
                'tab_slug'    => 'advanced',
                'sub_toggle'  => 'arrow_common',
                'hover'       => 'tabs',
            ],

            'arrow_border_style'      => [
                'label'       => esc_html__( 'Border Type', 'wdc-wow-divi-carousel' ),
                'type'        => 'select',
                'default'     => 'solid',
                'toggle_slug' => 'arrow',
                'tab_slug'    => 'advanced',
                'sub_toggle'  => 'arrow_common',
                'options'     => [
                    'solid'  => esc_html__( 'Solid', 'wdc-wow-divi-carousel' ),
                    'dashed' => esc_html__( 'Dashed', 'wdc-wow-divi-carousel' ),
                    'dotted' => esc_html__( 'Dotted', 'wdc-wow-divi-carousel' ),
                    'double' => esc_html__( 'Double', 'wdc-wow-divi-carousel' ),
                    'groove' => esc_html__( 'Groove', 'wdc-wow-divi-carousel' ),
                    'ridge'  => esc_html__( 'Ridge', 'wdc-wow-divi-carousel' ),
                    'inset'  => esc_html__( 'Inset', 'wdc-wow-divi-carousel' ),
                    'outset' => esc_html__( 'Outset', 'wdc-wow-divi-carousel' ),
                    'none'   => esc_html__( 'None', 'wdc-wow-divi-carousel' ),
                ],
            ],

            // Left Arrow.
            'icon_left'               => [
                'label'           => esc_html__( 'Select Icon', 'wdc-wow-divi-carousel' ),
                'type'            => 'select_icon',
                'option_category' => 'basic_option',
                'toggle_slug'     => 'arrow',
                'tab_slug'        => 'advanced',
                'sub_toggle'      => 'arrow_left',
            ],

            'left_border_radius'      => [
                'label'       => esc_html__( 'Border Radius', 'wdc-wow-divi-carousel' ),
                'type'        => 'border-radius',
                'default'     => 'on|40px|40px|40px|40px',
                'toggle_slug' => 'arrow',
                'tab_slug'    => 'advanced',
                'sub_toggle'  => 'arrow_left',
            ],

            // Right Arrow.
            'icon_right'              => [
                'label'           => esc_html__( 'Select Icon', 'wdc-wow-divi-carousel' ),
                'type'            => 'select_icon',
                'option_category' => 'basic_option',
                'toggle_slug'     => 'arrow',
                'tab_slug'        => 'advanced',
                'sub_toggle'      => 'arrow_right',
            ],

            'right_border_radius'     => [
                'label'       => esc_html__( 'Border Radius', 'wdc-wow-divi-carousel' ),
                'type'        => 'border-radius',
                'default'     => 'on|40px|40px|40px|40px',
                'toggle_slug' => 'arrow',
                'tab_slug'    => 'advanced',
                'sub_toggle'  => 'arrow_right',
            ],

            // pagination.
            'pagi_alignment'          => [
                'label'            => esc_html__( 'Alignment', 'wdc-wow-divi-carousel' ),
                'type'             => 'text_align',
                'option_category'  => 'layout',
                'options'          => et_builder_get_text_orientation_options( ['justified'] ),
                'options_icon'     => 'module_align',
                'default_on_front' => 'center',
                'default'          => 'center',
                'toggle_slug'      => 'pagination',
                'sub_toggle'       => 'pagi_common',
                'tab_slug'         => 'advanced',
            ],

            'pagi_color'              => [
                'label'       => esc_html__( 'Color', 'wdc-wow-divi-carousel' ),
                'type'        => 'color-alpha',
                'tab_slug'    => 'advanced',
                'toggle_slug' => 'pagination',
                'sub_toggle'  => 'pagi_common',
                'default'     => '#dddddd',
                'hover'       => 'tabs',
            ],

            'pagi_height'             => [
                'label'           => esc_html__( 'Height', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '10px',
                'toggle_slug'     => 'pagination',
                'sub_toggle'      => 'pagi_common',
                'tab_slug'        => 'advanced',
                'range_settings'  => [
                    'min'  => 1,
                    'step' => 1,
                    'max'  => 50,
                ],
            ],

            'pagi_width'              => [
                'label'           => esc_html__( 'Width', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '10px',
                'toggle_slug'     => 'pagination',
                'sub_toggle'      => 'pagi_common',
                'tab_slug'        => 'advanced',
                'range_settings'  => [
                    'min'  => 1,
                    'step' => 1,
                    'max'  => 50,
                ],
            ],

            'pagi_radius'             => [
                'label'       => esc_html__( 'Border Radius', 'wdc-wow-divi-carousel' ),
                'type'        => 'border-radius',
                'default'     => 'on|10px|10px|10px|10px',
                'toggle_slug' => 'pagination',
                'sub_toggle'  => 'pagi_common',
                'tab_slug'    => 'advanced',
            ],

            'pagi_pos_y'              => [
                'label'           => esc_html__( 'Vertical Position', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '10px',
                'toggle_slug'     => 'pagination',
                'sub_toggle'      => 'pagi_common',
                'tab_slug'        => 'advanced',
                'range_settings'  => [
                    'min'  => -400,
                    'max'  => 400,
                    'step' => 1,
                ],
            ],

            'pagi_spacing'            => [
                'label'           => esc_html__( 'Spacing', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '10px',
                'fixed_unit'      => 'px',
                'toggle_slug'     => 'pagination',
                'sub_toggle'      => 'pagi_common',
                'tab_slug'        => 'advanced',
                'range_settings'  => [
                    'step' => 1,
                    'min'  => 0,
                    'max'  => 100,
                ],
            ],

            'pagi_color_active'       => [
                'label'       => esc_html__( 'Color', 'wdc-wow-divi-carousel' ),
                'type'        => 'color-alpha',
                'tab_slug'    => 'advanced',
                'toggle_slug' => 'pagination',
                'sub_toggle'  => 'pagi_active',
                'default'     => '#000000',
            ],

            'pagi_width_active'       => [
                'label'           => esc_html__( 'Width', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '10px',
                'fixed_unit'      => 'px',
                'toggle_slug'     => 'pagination',
                'sub_toggle'      => 'pagi_active',
                'tab_slug'        => 'advanced',
                'range_settings'  => [
                    'step' => 1,
                    'min'  => 0,
                    'max'  => 100,
                ],
            ],

        ];

        if ( in_array( 'tab', $supports, true ) ) {

            $aditional['__carousel'] = [
                'type'                => 'computed',
                'computed_callback'   => ['WDC_Builder_Module', 'render_carousel'],
                'computed_depends_on' => [
                    'use_tab',
                    'is_autoplay',
                ],

            ];

            // tab carousel.
            $aditional['use_tab'] = [
                'label'          => esc_html__( 'Use Tab', 'wdc-wow-divi-carousel' ),
                'type'           => 'yes_no_button',
                'default'        => 'off',
                'toggle_slug'    => 'tab_settings',
                'mobile_options' => true,
                'options'        => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
            ];
            $aditional['tab_hide_mobile'] = [
                'type'        => 'multiple_checkboxes',
                'default'     => 'on',
                'toggle_slug' => 'tab_settings',
                'options'     => [
                    'title' => esc_html__( 'Hide Tab on Mobile', 'wdc-wow-divi-carousel' ),
                ],
                'show_if'     => [
                    'use_tab' => 'on',
                ],
            ];

            $aditional['tab_elements'] = [
                'label'       => esc_html__( 'Select Tab Elements', 'wdc-wow-divi-carousel' ),
                'type'        => 'multiple_checkboxes',
                'default'     => 'on|on|off',
                'toggle_slug' => 'tab_settings',
                'options'     => [
                    'title'    => esc_html__( 'Title', 'wdc-wow-divi-carousel' ),
                    'subtitle' => esc_html__( 'Subtitle', 'wdc-wow-divi-carousel' ),
                    'thumb'    => esc_html__( 'Thumbnail', 'wdc-wow-divi-carousel' ),
                ],
                'show_if'     => [
                    'use_tab' => 'on',
                ],
            ];

            $aditional['tab_slide_count'] = [
                'label'          => esc_html__( 'Tab Items', 'wdc-wow-divi-carousel' ),
                'type'           => 'select',
                'default'        => '3',
                'mobile_options' => true,
                'toggle_slug'    => 'tab_settings',
                'sub_toggle'     => 'general',
                'options'        => [
                    '2' => esc_html__( '2', 'wdc-wow-divi-carousel' ),
                    '3' => esc_html__( '3', 'wdc-wow-divi-carousel' ),
                    '4' => esc_html__( '4', 'wdc-wow-divi-carousel' ),
                    '5' => esc_html__( '5', 'wdc-wow-divi-carousel' ),
                    '6' => esc_html__( '6', 'wdc-wow-divi-carousel' ),
                    '7' => esc_html__( '7', 'wdc-wow-divi-carousel' ),
                    '8' => esc_html__( '8', 'wdc-wow-divi-carousel' ),
                ],
                'show_if'        => [
                    'use_tab' => 'on',
                ],
            ];

            $aditional['tab_spacing'] = [
                'label'          => esc_html__( 'Item Spacing', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default'        => '0px',
                'fixed_unit'     => 'px',
                'toggle_slug'    => 'tab_settings',
                'sub_toggle'     => 'general',
                'range_settings' => [
                    'step' => 1,
                    'min'  => 0,
                    'max'  => 100,
                ],
                'show_if'        => [
                    'use_tab' => 'on',
                ],
            ];

            // Tab styles.
            $aditional['tab_placement'] = [
                'label'       => esc_html__( 'Tab Position', 'wdc-wow-divi-carousel' ),
                'type'        => 'select',
                'default'     => 'bottom',
                'toggle_slug' => 'tab',
                'sub_toggle'  => 'common',
                'tab_slug'    => 'advanced',
                'options'     => [
                    'top'    => esc_html__( 'Top', 'wdc-wow-divi-carousel' ),
                    'bottom' => esc_html__( 'Bottom', 'wdc-wow-divi-carousel' ),
                    'left'   => esc_html__( 'Left', 'wdc-wow-divi-carousel' ),
                    'right'  => esc_html__( 'RIght', 'wdc-wow-divi-carousel' ),
                ],
            ];

            $aditional['tab_position'] = [
                'label'       => esc_html__( 'Tab Position', 'wdc-wow-divi-carousel' ),
                'type'        => 'select',
                'default'     => 'normal',
                'toggle_slug' => 'tab',
                'sub_toggle'  => 'common',
                'tab_slug'    => 'advanced',
                'options'     => [
                    'normal'   => esc_html__( 'Normal', 'wdc-wow-divi-carousel' ),
                    'absolute' => esc_html__( 'Absolute', 'wdc-wow-divi-carousel' ),
                ],
            ];

            $aditional['tab_width'] = [
                'label'          => esc_html__( 'Tab Width', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default'        => '200px',
                'fixed_unit'     => 'px',
                'tab_slug'       => 'advanced',
                'sub_toggle'     => 'common',
                'toggle_slug'    => 'tab',
                'mobile_options' => true,
                'range_settings' => [
                    'step' => 1,
                    'min'  => 0,
                    'max'  => 500,
                ],
                'show_if'        => [
                    'tab_placement' => ['left', 'right'],
                ],
            ];

            $aditional['tab_alignment'] = [
                'label'           => esc_html__( 'Content Alignment', 'wdc-wow-divi-carousel' ),
                'type'            => 'text_align',
                'option_category' => 'layout',
                'options'         => et_builder_get_text_orientation_options( ['justified'] ),
                'options_icon'    => 'module_align',
                'default'         => 'center',
                'toggle_slug'     => 'tab',
                'sub_toggle'      => 'common',
                'tab_slug'        => 'advanced',
            ];

            $aditional['tab_bg'] = [
                'label'       => esc_html__( 'Tab Background', 'wdc-wow-divi-carousel' ),
                'type'        => 'color-alpha',
                'tab_slug'    => 'advanced',
                'default'     => '#dddddd',
                'sub_toggle'  => 'common',
                'toggle_slug' => 'tab',
            ];

            $aditional['tab_item_bg'] = [
                'label'       => esc_html__( 'Item Background', 'wdc-wow-divi-carousel' ),
                'type'        => 'color-alpha',
                'tab_slug'    => 'advanced',
                'sub_toggle'  => 'common',
                'toggle_slug' => 'tab',
            ];

            $aditional['tab_padding'] = [
                'label'       => esc_html__( 'Item Padding', 'wdc-wow-divi-carousel' ),
                'type'        => 'custom_padding',
                'default'     => '10px|10px|10px|10px',
                'fixed_unit'  => 'px',
                'tab_slug'    => 'advanced',
                'sub_toggle'  => 'common',
                'toggle_slug' => 'tab',
            ];

            $aditional['tab_item_height'] = [
                'label'          => esc_html__( 'Item Height', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default'        => 'auto',
                'fixed_unit'     => 'px',
                'tab_slug'       => 'advanced',
                'sub_toggle'     => 'common',
                'toggle_slug'    => 'tab',
                'range_settings' => [
                    'step' => 1,
                    'min'  => 0,
                    'max'  => 100,
                ],
            ];

            $aditional['tab_scale'] = [
                'label'          => esc_html__( 'Item Scale', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default'        => '1',
                'unitless'       => true,
                'tab_slug'       => 'advanced',
                'sub_toggle'     => 'common',
                'toggle_slug'    => 'tab',
                'range_settings' => [
                    'step' => .01,
                    'min'  => 0,
                    'max'  => 2,
                ],
            ];

            $aditional['tab_opacity'] = [
                'label'          => esc_html__( 'Item Opacity', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default'        => '1',
                'unitless'       => true,
                'tab_slug'       => 'advanced',
                'sub_toggle'     => 'common',
                'toggle_slug'    => 'tab',
                'range_settings' => [
                    'step' => .01,
                    'min'  => 0,
                    'max'  => 1,
                ],
            ];

            $aditional['tab_spacing_top'] = [
                'label'          => esc_html__( 'Wrapper Spacing Top', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default'        => '15px',
                'fixed_unit'     => 'px',
                'tab_slug'       => 'advanced',
                'sub_toggle'     => 'common',
                'toggle_slug'    => 'tab',
                'mobile_options' => true,
                'range_settings' => [
                    'step' => 1,
                    'min'  => 0,
                    'max'  => 200,
                ],
                'show_if'        => [
                    'tab_placement' => ['top', 'bottom'],
                ],
            ];

            $aditional['tab_spacing_bottom'] = [
                'label'          => esc_html__( 'Wrapper Spacing Bottom', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default'        => '15px',
                'fixed_unit'     => 'px',
                'tab_slug'       => 'advanced',
                'sub_toggle'     => 'common',
                'toggle_slug'    => 'tab',
                'mobile_options' => true,
                'range_settings' => [
                    'step' => 1,
                    'min'  => 0,
                    'max'  => 200,
                ],
                'show_if'        => [
                    'tab_placement' => ['top', 'bottom'],
                ],
            ];

            // active style.
            $aditional['tab_active_bg'] = [
                'label'       => esc_html__( 'Active Background', 'wdc-wow-divi-carousel' ),
                'type'        => 'color-alpha',
                'tab_slug'    => 'advanced',
                'sub_toggle'  => 'active',
                'default'     => '#bfbfbf',
                'toggle_slug' => 'tab',
            ];

            $aditional['tab_scale_active'] = [
                'label'          => esc_html__( 'Active Item Scale', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default'        => '1',
                'unitless'       => true,
                'tab_slug'       => 'advanced',
                'sub_toggle'     => 'active',
                'toggle_slug'    => 'tab',
                'range_settings' => [
                    'step' => .01,
                    'min'  => 0,
                    'max'  => 2,
                ],
            ];

            $aditional['tab_opacity_active'] = [
                'label'          => esc_html__( 'Active Item Opacity', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default'        => '1',
                'unitless'       => true,
                'tab_slug'       => 'advanced',
                'sub_toggle'     => 'active',
                'toggle_slug'    => 'tab',
                'range_settings' => [
                    'step' => .01,
                    'min'  => 0,
                    'max'  => 1,
                ],
            ];

            $aditional['tab_border_active'] = [
                'label'       => esc_html__( 'Border Width', 'wdc-wow-divi-carousel' ),
                'type'        => 'custom_padding',
                'default'     => '0px|0px|0px|0px',
                'fixed_unit'  => 'px',
                'tab_slug'    => 'advanced',
                'sub_toggle'  => 'active',
                'toggle_slug' => 'tab',
            ];

            $aditional['tab_border_color_active'] = [
                'label'       => esc_html__( 'Border Color', 'wdc-wow-divi-carousel' ),
                'type'        => 'color-alpha',
                'tab_slug'    => 'advanced',
                'tab_slug'    => 'advanced',
                'sub_toggle'  => 'active',
                'toggle_slug' => 'tab',
            ];

            // tab elements.
            $aditional['tab_title_spacing'] = [
                'label'          => esc_html__( 'Title Spacing', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default'        => '0px',
                'fixed_unit'     => 'px',
                'toggle_slug'    => 'tab_elements',
                'sub_toggle'     => 'title',
                'tab_slug'       => 'advanced',
                'range_settings' => [
                    'step' => 1,
                    'min'  => 0,
                    'max'  => 100,
                ],
            ];

            $aditional['tab_thumb_spacing'] = [
                'label'          => esc_html__( 'Thumbnail Spacing', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default'        => '0px',
                'fixed_unit'     => 'px',
                'toggle_slug'    => 'tab_elements',
                'sub_toggle'     => 'thumb',
                'tab_slug'       => 'advanced',
                'range_settings' => [
                    'step' => 1,
                    'min'  => 0,
                    'max'  => 100,
                ],
            ];

            $aditional['thumb_height'] = [
                'label'          => esc_html__( 'Thumbnail Height', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default_unit'   => 'px',
                'toggle_slug'    => 'tab_elements',
                'sub_toggle'     => 'thumb',
                'tab_slug'       => 'advanced',
                'mobile_options' => true,
                'range_settings' => [
                    'step' => 1,
                    'min'  => 0,
                    'max'  => 800,
                ],
            ];

            $aditional['thumb_width'] = [
                'label'          => esc_html__( 'Thumbnail Width', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default'        => '70%',
                'default_unit'   => 'px',
                'mobile_options' => true,
                'range_settings' => [
                    'step' => 1,
                    'min'  => 0,
                    'max'  => 800,
                ],
                'toggle_slug'    => 'tab_elements',
                'sub_toggle'     => 'thumb',
                'tab_slug'       => 'advanced',
            ];

            $aditional['thumb_radius'] = [
                'label'          => esc_html__( 'Thumbnail  Border Radius', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default'        => '0px',
                'default_unit'   => 'px',
                'range_settings' => [
                    'min'  => 0,
                    'step' => 1,
                    'max'  => 500,
                ],
                'toggle_slug'    => 'tab_elements',
                'sub_toggle'     => 'thumb',
                'tab_slug'       => 'advanced',
            ];

        }

        if ( in_array( 'lightbox', $supports, true ) ) {

            $aditional['use_lightbox'] = [
                'label'           => esc_html__( 'Open Image in Lightbox', 'wdc-wow-divi-carousel' ),
                'type'            => 'yes_no_button',
                'option_category' => 'configuration',
                'default'         => 'off',
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'advanced',
                'options'         => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
            ];
        }

        if ( in_array( 'equal_height', $supports, true ) ) {

            $aditional['is_equal_height'] = [
                'label'           => esc_html__( 'Equalize Item Height', 'wdc-wow-divi-carousel' ),
                'type'            => 'yes_no_button',
                'option_category' => 'configuration',
                'description'     => esc_html__( 'Enable this to Equalize all Carousel items with same height.' ),
                'options'         => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
                'default'         => 'on',
                'toggle_slug'     => 'settings',
                'sub_toggle'      => 'advanced',
            ];
        }

        return array_merge( $fields, $aditional );

    }

    protected function get_tab_fields() {

        $fields = [
            'layout_notice' => [
                'label'           => 'Notice',
                'type'            => 'warning',
                'value'           => true,
                'display_if'      => true,
                'message'         => esc_html__( '\'Use Tab\' option is not Enable in the Tab Settings, This fields will only visible if \'Use Tab\' option is on.', 'wdc-wow-divi-carousel' ),
                'option_category' => 'configuration',
                'toggle_slug'     => 'tab_content',
                'show_if_not'     => [
                    'parentModule:use_tab' => 'on',
                ],
            ],

            'tab_title'     => [
                'label'       => esc_html__( 'Title', 'wdc-wow-divi-carousel' ),
                'type'        => 'text',
                'toggle_slug' => 'tab_content',
            ],

            'tab_subtitle'  => [
                'label'       => esc_html__( 'Subtitle', 'wdc-wow-divi-carousel' ),
                'type'        => 'text',
                'toggle_slug' => 'tab_content',
            ],

            'tab_thumb'     => [
                'label'              => esc_html__( 'Thumbnail', 'wdc-wow-divi-carousel' ),
                'type'               => 'upload',
                'option_category'    => 'basic_option',
                'upload_button_text' => esc_attr__( 'Upload an image', 'wdc-wow-divi-carousel' ),
                'choose_text'        => esc_attr__( 'Choose an Image', 'wdc-wow-divi-carousel' ),
                'update_text'        => esc_attr__( 'Set As Image', 'wdc-wow-divi-carousel' ),
                'toggle_slug'        => 'tab_content',
            ],
        ];

        return $fields;
    }

    protected function render_default_arrow_css( $render_slug ) {

        $sliding_dir                   = $this->props['sliding_dir'];
        $left                          = 'ltr' === $sliding_dir ? 'left' : 'right';
        $right                         = 'ltr' === $sliding_dir ? 'right' : 'left';
        $arrow_pos_y                   = $this->props['arrow_pos_y'];
        $arrow_pos_y_tablet            = $this->props['arrow_pos_y_tablet'];
        $arrow_pos_y_phone             = $this->props['arrow_pos_y_phone'];
        $arrow_pos_y_last_edited       = $this->props['arrow_pos_y_last_edited'];
        $arrow_pos_y_responsive_status = et_pb_get_responsive_status( $arrow_pos_y_last_edited );
        $arrow_pos_x                   = $this->props['arrow_pos_x'];
        $arrow_pos_x_tablet            = $this->props['arrow_pos_x_tablet'];
        $arrow_pos_x_phone             = $this->props['arrow_pos_x_phone'];
        $arrow_pos_x_last_edited       = $this->props['arrow_pos_x_last_edited'];
        $arrow_pos_x_responsive_status = et_pb_get_responsive_status( $arrow_pos_x_last_edited );

        if ( 'ltr' === $sliding_dir ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel-parent .slick-prev',
                    'declaration' => 'right: auto!important;',
                ]
            );

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel-parent .slick-next',
                    'declaration' => 'left: auto!important;',
                ]
            );

        }

        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .slick-arrow',
                'declaration' => sprintf( ' top: %1$s; ', $arrow_pos_y ),
            ]
        );

        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .slick-next',
                'declaration' => sprintf( '%2$s: %1$s;', $arrow_pos_x, $right ),
            ]
        );

        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .slick-prev',
                'declaration' => sprintf( '%2$s: %1$s; ', $arrow_pos_x, $left ),
            ]
        );

        if ( !empty( $arrow_pos_x_tablet ) && $arrow_pos_x_responsive_status ):
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .slick-next',
                    'declaration' => sprintf( '%2$s: %1$s;', $arrow_pos_x_tablet, $right ),
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                ]
            );

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .slick-prev',
                    'declaration' => sprintf( '%2$s: %1$s; ', $arrow_pos_x_tablet, $left ),
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                ]
            );
        endif;

        if ( !empty( $arrow_pos_x_phone ) && $arrow_pos_x_responsive_status ):
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .slick-next',
                    'declaration' => sprintf( '%2$s: %1$s;', $arrow_pos_x_phone, $right ),
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                ]
            );

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .slick-prev',
                    'declaration' => sprintf( '%2$s: %1$s; ', $arrow_pos_x_phone, $left ),
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                ]
            );
        endif;

        if ( !empty( $arrow_pos_y_tablet ) && $arrow_pos_y_responsive_status ):
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .slick-arrow',
                    'declaration' => sprintf( 'top: %1$s; ', $arrow_pos_y_tablet ),
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                ]
            );
        endif;

        if ( !empty( $arrow_pos_y_phone ) && $arrow_pos_y_responsive_status ):
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .slick-arrow',
                    'declaration' => sprintf( 'top: %1$s; ', $arrow_pos_y_phone ),
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                ]
            );
        endif;
    }

    protected function render_alongside_arrow_css( $render_slug ) {

        $sliding_dir                   = $this->props['sliding_dir'];
        $arrow_pos                     = $this->props['arrow_pos'];
        $arrow_pos_hz                  = $this->props['arrow_pos_hz'];
        $arrow_pos_y                   = $this->props['arrow_pos_y'];
        $arrow_pos_y_tablet            = $this->props['arrow_pos_y_tablet'];
        $arrow_pos_y_phone             = $this->props['arrow_pos_y_phone'];
        $arrow_pos_y_last_edited       = $this->props['arrow_pos_y_last_edited'];
        $arrow_pos_y_responsive_status = et_pb_get_responsive_status( $arrow_pos_y_last_edited );
        $arrow_x_center                = $this->props['arrow_x_center'];
        $arrow_pos_x                   = $this->props['arrow_pos_x'];
        $arrow_pos_x_tablet            = $this->props['arrow_pos_x_tablet'];
        $arrow_pos_x_phone             = $this->props['arrow_pos_x_phone'];
        $arrow_pos_x_last_edited       = $this->props['arrow_pos_x_last_edited'];
        $arrow_pos_x_responsive_status = et_pb_get_responsive_status( $arrow_pos_x_last_edited );
        $arrow_width                   = $this->props['arrow_width'];
        $arrow_width_tablet            = $this->props['arrow_width_tablet'] ? $this->props['arrow_width_tablet'] : $arrow_width;
        $arrow_width_phone             = $this->props['arrow_width_phone'] ? $this->props['arrow_width_phone'] : $arrow_width_tablet;
        $arrow_gap                     = $this->props['arrow_gap'];
        $arrow_gap_tablet              = $this->props['arrow_gap_tablet'] ? $this->props['arrow_gap_tablet'] : $arrow_gap;
        $arrow_gap_phone               = $this->props['arrow_gap_phone'] ? $this->props['arrow_gap_phone'] : $arrow_gap_tablet;

        if ( 'ltr' === $sliding_dir ) {

            if ( 'right' === $this->props['arrow_pos_hz'] ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-parent .slick-next',
                        'declaration' => 'left: auto!important;',
                    ]
                );
            }

        }

        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .slick-arrow',
                'declaration' => sprintf( ' top: auto; %1$s: %2$s;', $arrow_pos, $arrow_pos_y ),
            ]
        );

        if ( 'on' === $arrow_x_center ) {

            // desktop.
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .slick-next',
                    'declaration' => sprintf( 'right: calc(50%% - %1$spx);', intval( $arrow_width ) + ( intval( $arrow_gap ) / 2 ) ),
                ]
            );

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .slick-prev',
                    'declaration' => sprintf( 'left: calc(50%% - %1$spx);', intval( $arrow_width ) + ( intval( $arrow_gap ) / 2 ) ),
                ]
            );

            // tablet.
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .slick-next',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    'declaration' => sprintf( 'right: calc(50%% - %1$spx);', intval( $arrow_width_tablet ) + ( intval( $arrow_gap_tablet ) / 2 ) ),
                ]
            );

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .slick-prev',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    'declaration' => sprintf( 'left: calc(50%% - %1$spx);', intval( $arrow_width_tablet ) + ( intval( $arrow_gap_tablet ) / 2 ) ),
                ]
            );

            // phone.
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .slick-next',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                    'declaration' => sprintf( 'right: calc(50%% - %1$spx);', intval( $arrow_width_phone ) + ( intval( $arrow_gap_phone ) / 2 ) ),
                ]
            );

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .slick-prev',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                    'declaration' => sprintf( 'left: calc(50%% - %1$spx);', intval( $arrow_width_phone ) + ( intval( $arrow_gap_phone ) / 2 ) ),
                ]
            );

        } else {

            // position X.
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .slick-next',
                    'declaration' => sprintf( ' %2$s: %1$s; ', $arrow_pos_x, $arrow_pos_hz ),
                ]
            );

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .slick-prev',
                    'declaration' => sprintf( ' left: auto; %2$s: %1$s; ', $arrow_pos_x, $arrow_pos_hz ),
                ]
            );

// position X tablet.
            if ( !empty( $arrow_pos_x_tablet ) && $arrow_pos_x_responsive_status ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .slick-next',
                        'declaration' => sprintf( ' %2$s: %1$s; ', $arrow_pos_x_tablet, $arrow_pos_hz ),
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    ]
                );

                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .slick-prev',
                        'declaration' => sprintf( 'left: auto; %2$s: %1$s;', $arrow_pos_x_tablet, $arrow_pos_hz ),
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    ]
                );
            }

// position X phone.
            if ( !empty( $arrow_pos_x_phone ) && $arrow_pos_x_responsive_status ) {

                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .slick-next',
                        'declaration' => sprintf( ' %2$s: %1$s; ', $arrow_pos_x_phone, $arrow_pos_hz ),
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                    ]
                );

                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .slick-prev',
                        'declaration' => sprintf( 'left: auto; %2$s: %1$s;', $arrow_pos_x_phone, $arrow_pos_hz ),
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                    ]
                );
            }

            // arrow gap.
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .slick-prev',
                    'declaration' => sprintf( 'margin-%3$s: calc(%1$s + %2$s);', $arrow_width, $arrow_gap, $arrow_pos_hz ),
                ]
            );

            // arrow gap tablet.
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .slick-prev',
                    'declaration' => sprintf( 'margin-%3$s: calc(%1$s + %2$s);', $arrow_width_tablet, $arrow_gap_tablet, $arrow_pos_hz ),
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                ]
            );

            // arrow gap phone.
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .slick-prev',
                    'declaration' => sprintf( ' margin-%3$s: calc(%1$s + %2$s); ', $arrow_width_phone, $arrow_gap_phone, $arrow_pos_hz ),
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                ]
            );

        }

// position Y tablet.
        if ( !empty( $arrow_pos_y_tablet ) && $arrow_pos_y_responsive_status ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .slick-arrow',
                    'declaration' => sprintf( 'top: auto; %1$s: %2$s; ', $arrow_pos, $arrow_pos_y_tablet ),
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                ]
            );
        }

// position Y phone.
        if ( !empty( $arrow_pos_y_phone ) && $arrow_pos_y_responsive_status ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .slick-arrow',
                    'declaration' => sprintf( 'top: auto; %1$s: %2$s;', $arrow_pos, $arrow_pos_y_phone ),
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                ]
            );
        }

    }

    protected function render_pagination_css( $render_slug ) {

        $pagi_color        = $this->props['pagi_color'];
        $pagi_color_hover  = $this->get_hover_value( 'pagi_color' );
        $pagi_color_active = $this->props['pagi_color_active'];
        $pagi_alignment    = $this->props['pagi_alignment'];
        $pagi_pos_y        = $this->props['pagi_pos_y'];
        $pagi_spacing      = $this->props['pagi_spacing'];
        $pagi_height       = $this->props['pagi_height'];
        $pagi_width        = $this->props['pagi_width'];
        $pagi_width_active = $this->props['pagi_width_active'];
        $pagi_radius       = explode( '|', $this->props['pagi_radius'] );

        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-carousel .slick-dots',
                'declaration' => sprintf( ' text-align: %1$s; transform: translateY(%2$s); ', $pagi_alignment, $pagi_pos_y ),
            ]
        );

        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-carousel .slick-dots li',
                'declaration' => sprintf( ' margin: 0 %1$s;', $pagi_spacing ),
            ]
        );

        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-carousel .slick-dots li button',
                'declaration' => sprintf(
                    ' background: %1$s; height: %2$s; width: %3$s; border-radius: %4$s %5$s %6$s %7$s;',
                    $pagi_color,
                    $pagi_height,
                    $pagi_width,
                    $pagi_radius[1],
                    $pagi_radius[2],
                    $pagi_radius[3],
                    $pagi_radius[4]
                ),
            ]
        );

        if ( !empty( $pagi_color_hover ) ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel .slick-dots li:hover button',
                    'declaration' => sprintf( ' background: %1$s;', $pagi_color_hover ),
                ]
            );
        }

        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-carousel .slick-dots li.slick-active button',
                'declaration' => sprintf( 'background: %1$s; width: %2$s;', $pagi_color_active, $pagi_width_active ),
            ]
        );
    }

    protected function apply_carousel_css( $render_slug ) {

        $sliding_dir                               = $this->props['sliding_dir'];
        $arrow_height                              = $this->props['arrow_height'];
        $arrow_height_tablet                       = $this->props['arrow_height_tablet'];
        $arrow_height_phone                        = $this->props['arrow_height_phone'];
        $arrow_height_last_edited                  = $this->props['arrow_height_last_edited'];
        $arrow_height_responsive_status            = et_pb_get_responsive_status( $arrow_height_last_edited );
        $arrow_width                               = $this->props['arrow_width'];
        $arrow_width_tablet                        = $this->props['arrow_width_tablet'] ? $this->props['arrow_width_tablet'] : $arrow_width;
        $arrow_width_phone                         = $this->props['arrow_width_phone'] ? $this->props['arrow_width_phone'] : $arrow_width_tablet;
        $arrow_width_last_edited                   = $this->props['arrow_width_last_edited'];
        $arrow_width_responsive_status             = et_pb_get_responsive_status( $arrow_width_last_edited );
        $arrow_border_width                        = $this->props['arrow_border_width'];
        $arrow_border_style                        = $this->props['arrow_border_style'];
        $arrow_border_color                        = $this->props['arrow_border_color'];
        $arrow_border_color_hover                  = $this->get_hover_value( 'arrow_border_color' );
        $arrow_color                               = $this->props['arrow_color'];
        $arrow_bg                                  = $this->props['arrow_bg'];
        $arrow_skew                                = $this->props['arrow_skew'];
        $arrow_color_hover                         = $this->get_hover_value( 'arrow_color' );
        $arrow_bg_hover                            = $this->get_hover_value( 'arrow_bg' );
        $arrow_icon_size_tablet                    = $this->props['arrow_icon_size_tablet'];
        $arrow_icon_size_phone                     = $this->props['arrow_icon_size_phone'];
        $arrow_icon_size_last_edited               = $this->props['arrow_icon_size_last_edited'];
        $arrow_icon_size_responsive_status         = et_pb_get_responsive_status( $arrow_icon_size_last_edited );
        $arrow_icon_size                           = $this->props['arrow_icon_size'];
        $right_border_radius                       = explode( '|', $this->props['right_border_radius'] );
        $left_border_radius                        = explode( '|', $this->props['left_border_radius'] );
        $slide_spacing                             = $this->props['slide_spacing'];
        $use_both_side_spacing                     = $this->props['use_both_side_spacing'];
        $custom_cursor                             = $this->props['custom_cursor'];
        $cursor_name                               = $this->props['cursor_name'];
        $is_variable_width                         = $this->props['is_variable_width'];
        $slide_width                               = $this->props['slide_width'];
        $slide_width_tablet                        = $this->props['slide_width_tablet'];
        $slide_width_phone                         = $this->props['slide_width_phone'];
        $slide_width_last_edited                   = $this->props['slide_width_last_edited'];
        $slide_width_responsive_status             = et_pb_get_responsive_status( $slide_width_last_edited );
        $is_vertical                               = $this->props['is_vertical'];
        $use_tab                                   = isset( $this->props['use_tab'] ) ? $this->props['use_tab'] : 'off';
        $arrow_type                                = $this->props['arrow_type'];
        $int_skew                                  = intval( $this->props['arrow_skew'] );
        $arrow_skew_inner                          = $int_skew < 0 ? abs( $int_skew ) : '-' . abs( $int_skew );
        $carousel_spacing_top                      = $this->props['carousel_spacing_top'];
        $carousel_spacing_top_tablet               = $this->props['carousel_spacing_top_tablet'];
        $carousel_spacing_top_phone                = $this->props['carousel_spacing_top_phone'];
        $carousel_spacing_top_last_edited          = $this->props['carousel_spacing_top_last_edited'];
        $carousel_spacing_top_responsive_status    = et_pb_get_responsive_status( $carousel_spacing_top_last_edited );
        $animation_speed                           = $this->props['animation_speed'];
        $carousel_spacing_bottom                   = $this->props['carousel_spacing_bottom'];
        $carousel_spacing_bottom_tablet            = $this->props['carousel_spacing_bottom_tablet'];
        $carousel_spacing_bottom_phone             = $this->props['carousel_spacing_bottom_phone'];
        $carousel_spacing_bottom_last_edited       = $this->props['carousel_spacing_bottom_last_edited'];
        $carousel_spacing_bottom_responsive_status = et_pb_get_responsive_status( $carousel_spacing_bottom_last_edited );
        wdc_inject_fa_icons( $this->props['icon_left'] );
        wdc_inject_fa_icons( $this->props['icon_right'] );

        $data_cursor = [
            'pizza'  => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgBAMAAACBVGfHAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAAIVBMVEUAAAAAAAD/////zGb/mTOZAAAAzAD/zDP/AAD/Zmb/mZm5WRymAAAAAXRSTlMAQObYZgAAAAFiS0dEAmYLfGQAAAAJcEhZcwAAAMgAAADIAGP6560AAAAHdElNRQfkBRkTCRh4PlpnAAAA8ElEQVQoz12QsbnDIAyExQaWQ0ySztngfW8BMgIFA3gEVardEXfu3KbzmJEgTrCvEfo5wQEgABjMakDVNgZP/1l/GbX9p81ISHuvgJL23tfgIUAs5VCxWgWyjKoQ8GRlpO2lwXOM3TkG9IACAkoTg7pKKsc6hWKzGg1ZhVKohHVMGUkhr8Bw57Kjc5RfA0626Jmk2A9g7m7LNDL6AsRNlynNNJQezOL4ktK4TQDcRr5OMtJswMxMaXXkv2BkJ3kJvkIamAb7A441mv8Bo+9AqIR8fdoadJjWpgaGltnvwfqCnXB/hH6kPwCCg+wRbJe+ATasSMvHEwtpAAAAJXRFWHRkYXRlOmNyZWF0ZQAyMDIwLTA1LTI1VDE5OjA5OjIzKzAwOjAwCTF7LQAAACV0RVh0ZGF0ZTptb2RpZnkAMjAyMC0wNS0yNVQxOTowOTowNiswMDowMGhx60sAAAAASUVORK5CYII=',
            'burger' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAB8AAAAfBAMAAADtgAsKAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAALVBMVEUAAAAAAAD////MZgBmMwCZMwD/zDP/mQD/zAB4eHhGRkbc3NygoKDIyMhmAAAKaD9VAAAAAXRSTlMAQObYZgAAAAFiS0dEAmYLfGQAAAAJcEhZcwAAAMgAAADIAGP6560AAAAHdElNRQfkBRkTGhFgDaNRAAAAEGNhTnYAAAAgAAAAIAAAAAAAAAAAYrnu+gAAATdJREFUKM9lkbFOwzAQhl2lM4qrLLW68AYgG2VtlIu6sVTxCzCwA5XzACCydmyUpWNNl670CVLyBkxImXkG7i6oSOFXlv+7/85nR4RiIDkEk2FkcvkPUCSA9DyDvMlyDVc9CKmca9Q5FMAS7c2dNr/ELNmiDHcFmdaWPms1R0zOVa1j98gRwCp1xKt7R4A60FlnnXugnnGK3pFs8doDi92OAiVPHWd4JvmyLDWBEa0Vk33Bydd4l4j3cCs63ExDIbfAq7OSdwQ7GQHkdD0jpwqBqrYSSImsP99CMVLN2kvS7ORnByEupG/aTdWu1/VOHSMEX1Ltvd+3zWnzcQAEt1IqX3tfHb2MDIKuS3iEwtkLTIhvMMAkguJpLiiSaj52UZTAb9oBb+ncM8z7Vx4DvwnA3+/jlr78AzvMazraOl3vAAAAJXRFWHRkYXRlOmNyZWF0ZQAyMDIwLTA1LTI1VDE5OjI2OjE2KzAwOjAwfOGxJQAAACV0RVh0ZGF0ZTptb2RpZnkAMjAyMC0wNS0yNVQxOToyNjoxNiswMDowMA28CZkAAAAASUVORK5CYII=',
        ];

        if ( class_exists( 'ET_Builder_Module_Helper_Style_Processor' ) ) {
            $this->generate_styles(
                [
                    'utility_arg'    => 'icon_font_family',
                    'render_slug'    => $render_slug,
                    'base_attr_name' => 'icon_left',
                    'important'      => true,
                    'selector'       => '%%order_class%% .wdc-carousel .slick-prev:before',
                    'processor'      => [
                        'ET_Builder_Module_Helper_Style_Processor',
                        'process_extended_icon',
                    ],
                ]
            );

            $this->generate_styles(
                [
                    'utility_arg'    => 'icon_font_family',
                    'render_slug'    => $render_slug,
                    'base_attr_name' => 'icon_right',
                    'important'      => true,
                    'selector'       => '%%order_class%% .wdc-carousel .slick-next:before',
                    'processor'      => [
                        'ET_Builder_Module_Helper_Style_Processor',
                        'process_extended_icon',
                    ],
                ]
            );
        }

        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-centered--highlighted .slick-slide',
                'declaration' => sprintf( 'transition: transform %1$s;', $animation_speed ),
            ]
        );

// Custom Cursor.
        if ( 'on' === $custom_cursor ) {
            $cursor_type = explode( '_', $cursor_name )[0];
            $cursor_icon = explode( '_', $cursor_name )[1];

            if ( 'css' === $cursor_type ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%%',
                        'declaration' => sprintf( 'cursor: %1$s!important;', $cursor_icon ),
                    ]
                );
            } elseif ( 'custom' === $cursor_type ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%%',
                        'declaration' => "cursor: url('{$data_cursor[$cursor_icon]}'), auto!important;",
                    ]
                );
            }

        }

        // Carousel Spacing Top - Bottom.
        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-carousel .slick-track',
                'declaration' => sprintf( 'padding-top: %1$s; padding-bottom: %2$s;', $carousel_spacing_top, $carousel_spacing_bottom ),
            ]
        );

// Carousel Spacing Top Tablet.
        if ( $carousel_spacing_top_tablet && $carousel_spacing_top_responsive_status ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel .slick-track',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    'declaration' => sprintf( 'padding-top: %1$s;', $carousel_spacing_top_tablet ),
                ]
            );
        }

// Carousel Spacing Top Phone.
        if ( $carousel_spacing_top_phone && $carousel_spacing_top_responsive_status ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel .slick-track',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                    'declaration' => sprintf( 'padding-top: %1$s;', $carousel_spacing_top_phone ),
                ]
            );
        }

// Carousel Spacing Bottom Tablet.
        if ( $carousel_spacing_bottom_tablet && $carousel_spacing_bottom_responsive_status ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel .slick-track',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    'declaration' => sprintf( 'padding-bottom: %1$s;', $carousel_spacing_bottom_tablet ),
                ]
            );
        }

// Carousel Spacing Bottom Phone.
        if ( $carousel_spacing_bottom_phone && $carousel_spacing_bottom_responsive_status ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel .slick-track',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                    'declaration' => sprintf( 'padding-bottom: %1$s;', $carousel_spacing_bottom_phone ),
                ]
            );
        }

// Slide  Width.
        if ( 'off' === $use_tab && 'on' === $is_variable_width ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel .slick-slide',
                    'declaration' => sprintf( 'width: %1$s;', $slide_width ),
                ]
            );

// Slide  Width Tablet.
            if ( !empty( $slide_width_tablet ) && $slide_width_responsive_status ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel .slick-slide',
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                        'declaration' => sprintf( 'width: %1$s;', $slide_width_tablet ),
                    ]
                );
            }

// Slide  Width Phone.
            if ( !empty( $slide_width_phone ) && $slide_width_responsive_status ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel .slick-slide',
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                        'declaration' => sprintf( 'width: %1$s;', $slide_width_phone ),
                    ]
                );
            }

        }

// Slide Spacing.
        if ( 'off' === $is_vertical ) {

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel .slick-slide, .et-db #et-boc %%order_class%% .wdc-carousel .slick-slide',
                    'declaration' => sprintf( 'padding-left: %1$s!important; padding-right: %1$s!important;', $slide_spacing ),
                ]
            );

            if ( 'off' === $use_both_side_spacing ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel .slick-list, .et-db #et-boc %%order_class%% .wdc-carousel .slick-list',
                        'declaration' => sprintf( ' margin-left: -%1$s!important; margin-right: -%1$s!important;', $slide_spacing ),
                    ]
                );
            }

        } else {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel .slick-slide, .et-db #et-boc %%order_class%% .wdc-carousel .slick-slide',
                    'declaration' => sprintf( ' padding-top: %1$s!important; padding-bottom: %1$s!important;', $slide_spacing ),
                ]
            );

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel .slick-list, .et-db #et-boc %%order_class%% .wdc-carousel .slick-list',
                    'declaration' => sprintf( ' margin-top: -%1$s!important; margin-bottom: -%1$s!important;', $slide_spacing ),
                ]
            );
        }

        // Arrow.
        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-carousel .slick-arrow',
                'declaration' => sprintf(
                    'height: %1$s; width: %2$s; color: %3$s; background: %4$s; border: %5$s %6$s %7$s; transform: skew(%8$s);margin-top:-%9$spx;',
                    $arrow_height,
                    $arrow_width,
                    $arrow_color,
                    $arrow_bg,
                    $arrow_border_width,
                    $arrow_border_style,
                    $arrow_border_color,
                    $arrow_skew,
                    (int) $arrow_height / 2
                ),
            ]
        );

// Arrow hover.
        if ( $arrow_color_hover ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel .slick-arrow:hover',
                    'declaration' => sprintf( 'color: %1$s;', $arrow_color_hover ),
                ]
            );
        }

        if ( $arrow_bg_hover ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel .slick-arrow:hover',
                    'declaration' => sprintf( 'background: %1$s;', $arrow_bg_hover ),
                ]
            );
        }

        if ( $arrow_border_color_hover ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel .slick-arrow:hover',
                    'declaration' => sprintf( 'border-color: %1$s;', $arrow_border_color_hover ),
                ]
            );
        }

// Arrow Responsive Height.
        if ( !empty( $arrow_height_tablet ) && $arrow_height_responsive_status ):
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel .slick-arrow',
                    'declaration' => sprintf( 'height: %1$s; ', $arrow_height_tablet ),
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                ]
            );
        endif;

        if ( !empty( $arrow_height_phone ) && $arrow_height_responsive_status ):
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel .slick-arrow',
                    'declaration' => sprintf( 'height: %1$s; ', $arrow_height_phone ),
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                ]
            );
        endif;

// Arrow Responsive Width.
        if ( !empty( $arrow_width_tablet ) && $arrow_width_responsive_status ):
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel .slick-arrow',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    'declaration' => sprintf( ' width: %1$s; ', $arrow_width_tablet ),
                ]
            );
        endif;

        if ( !empty( $arrow_width_phone ) && $arrow_width_responsive_status ):
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel .slick-arrow',
                    'declaration' => sprintf( 'width: %1$s; ', $arrow_width_phone ),
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                ]
            );
        endif;

        // Arrow Icon.
        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-carousel .slick-arrow:before',
                'declaration' => sprintf(
                    'font-size: %1$s; transform: skew(%2$sdeg); display: inline-block;',
                    $arrow_icon_size,
                    $arrow_skew_inner
                ),
            ]
        );

// Arrow Icon Responsive.
        if ( !empty( $arrow_icon_size_tablet ) && $arrow_icon_size_responsive_status ):
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel .slick-arrow:before',
                    'declaration' => sprintf( ' font-size: %1$s; ', $arrow_icon_size_tablet ),
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                ]
            );
        endif;

        if ( !empty( $arrow_icon_size_phone ) && $arrow_icon_size_responsive_status ):
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel .slick-arrow:before',
                    'declaration' => sprintf( ' font-size: %1$s; ', $arrow_icon_size_phone ),
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                ]
            );
        endif;

        // Arrow Border Radius.
        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-carousel .slick-next',
                'declaration' => sprintf(
                    'border-radius: %1$s %2$s %3$s %4$s;',
                    $right_border_radius[1],
                    $right_border_radius[2],
                    $right_border_radius[3],
                    $right_border_radius[4]
                ),
            ]
        );

        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-carousel .slick-prev',
                'declaration' => sprintf(
                    'border-radius: %1$s %2$s %3$s %4$s;',
                    $left_border_radius[1],
                    $left_border_radius[2],
                    $left_border_radius[3],
                    $left_border_radius[4]
                ),
            ]
        );

// Array Type.
        if ( 'rtl' === $sliding_dir || 'default' === $arrow_type ) {
            $this->render_default_arrow_css( $render_slug );
        }

        if ( 'ltr' === $sliding_dir && 'alongside' === $arrow_type ) {
            $this->render_alongside_arrow_css( $render_slug );
        }

        // Carousel Pagination : Dots.
        $this->render_pagination_css( $render_slug );
    }

    protected function apply_tab_css( $render_slug ) {

        $use_tab         = $this->props['use_tab'];
        $tab_hide_mobile = $this->props['tab_hide_mobile'];
        $tab_bg          = $this->props['tab_bg'];
        $tab_active_bg   = $this->props['tab_active_bg'];
        $tab_spacing     = $this->props['tab_spacing'];
        $title_spacing   = $this->props['tab_title_spacing'];
        $thumb_spacing   = $this->props['tab_thumb_spacing'];
        $tab_item_height = $this->props['tab_item_height'];

        $thumb_radius = $this->props['thumb_radius'];

        $thumb_width                   = $this->props['thumb_width'];
        $thumb_width_tablet            = $this->props['thumb_width_tablet'];
        $thumb_width_phone             = $this->props['thumb_width_phone'];
        $thumb_width_last_edited       = $this->props['thumb_width_last_edited'];
        $thumb_width_responsive_status = et_pb_get_responsive_status( $thumb_width_last_edited );

        $thumb_height                   = $this->props['thumb_height'];
        $thumb_height_tablet            = $this->props['thumb_height_tablet'];
        $thumb_height_phone             = $this->props['thumb_height_phone'];
        $thumb_height_last_edited       = $this->props['thumb_height_last_edited'];
        $thumb_height_responsive_status = et_pb_get_responsive_status( $thumb_height_last_edited );

        $tab_padding   = $this->props['tab_padding'];
        $tab_item_bg   = $this->props['tab_item_bg'];
        $tab_position  = $this->props['tab_position'];
        $tab_placement = $this->props['tab_placement'];

        $tab_width                   = $this->props['tab_width'];
        $tab_width_tablet            = $this->props['tab_width_tablet'];
        $tab_width_phone             = $this->props['tab_width_phone'];
        $tab_width_last_edited       = $this->props['tab_width_last_edited'];
        $tab_width_responsive_status = et_pb_get_responsive_status( $tab_width_last_edited );

        $tab_opacity             = $this->props['tab_opacity'];
        $tab_opacity_active      = $this->props['tab_opacity_active'];
        $animation_speed         = $this->props['animation_speed'];
        $tab_scale               = $this->props['tab_scale'];
        $tab_scale_active        = $this->props['tab_scale_active'];
        $tab_alignment           = $this->props['tab_alignment'];
        $tab_border_color_active = $this->props['tab_border_color_active'];
        $tab_border_active       = $this->props['tab_border_active'];

        if ( 'on' === $use_tab ) {

            if ( 'on' === $tab_hide_mobile ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-parent .wdc-carousel-nav',
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                        'declaration' => 'display: none!important;',
                    ]
                );
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-parent',
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                        'declaration' => 'padding-left:0!important;padding-right:0!important;',
                    ]
                );
            }

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel-nav .slick-slide',
                    'declaration' => sprintf( ' transition: transform %1$s;', $animation_speed ),
                ]
            );

            if ( !empty( $tab_scale_active ) ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .slick-slide.slick-current',
                        'declaration' => sprintf( ' transform: scale(%1$s);', $tab_scale_active ),
                    ]
                );
            }

            if ( !empty( $tab_scale ) ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .slick-slide',
                        'declaration' => sprintf( ' transform: scale(%1$s);', $tab_scale ),
                    ]
                );
            }

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel-nav',
                    'declaration' => sprintf( ' %1$s: 0;', $tab_placement ),
                ]
            );

            if ( !empty( $tab_opacity ) ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .slick-slide',
                        'declaration' => sprintf( 'opacity:%1$s;', $tab_opacity ),
                    ]
                );
            }

            if ( !empty( $tab_opacity_active ) ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .slick-slide.slick-current',
                        'declaration' => sprintf( 'opacity:%1$s;', $tab_opacity_active ),
                    ]
                );
            }

            if ( !empty( $tab_border_color_active ) && !empty( $tab_border_active ) ) {
                $tab_border_active = explode( '|', $tab_border_active );

                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .slick-current .nav-item-inner',
                        'declaration' => sprintf(
                            '
                        border-top:  %1$s solid %5$s;
                        border-right:  %2$s solid %5$s;
                        border-bottom:  %3$s solid %5$s;
                        border-left:  %4$s solid %5$s;',
                            $tab_border_active[0],
                            $tab_border_active[1],
                            $tab_border_active[2],
                            $tab_border_active[3],
                            $tab_border_color_active
                        ),
                    ]
                );
            }

// tab width.
            if ( 'left' === $tab_placement || 'right' === $tab_placement ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav',
                        'declaration' => sprintf( 'width:%1$s;', $tab_width ),
                    ]
                );

                if ( 'absolute' !== $tab_position ) {
                    ET_Builder_Element::set_style(
                        $render_slug,
                        [
                            'selector'    => '%%order_class%% .wdc-carousel-parent',
                            'declaration' => sprintf( 'padding-%1$s:%2$s;', $tab_placement, $tab_width ),
                        ]
                    );
                }

                if ( !empty( $tab_width_tablet ) && $tab_width_responsive_status ) {

                    ET_Builder_Element::set_style(
                        $render_slug,
                        [
                            'selector'    => '%%order_class%% .wdc-carousel-nav',
                            'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                            'declaration' => sprintf( 'width:%1$s;', $tab_width_tablet ),
                        ]
                    );

                    if ( 'absolute' !== $tab_position ) {
                        ET_Builder_Element::set_style(
                            $render_slug,
                            [
                                'selector'    => '%%order_class%% .wdc-carousel-parent',
                                'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                                'declaration' => sprintf( 'padding-%1$s:%2$s;', $tab_placement, $tab_width_tablet ),
                            ]
                        );
                    }

                }

                if ( !empty( $tab_width_phone ) && $tab_width_responsive_status ) {

                    ET_Builder_Element::set_style(
                        $render_slug,
                        [
                            'selector'    => '%%order_class%% .wdc-carousel-nav',
                            'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                            'declaration' => sprintf( 'width:%1$s;', $tab_width_phone ),
                        ]
                    );

                    if ( 'absolute' !== $tab_position ) {
                        ET_Builder_Element::set_style(
                            $render_slug,
                            [
                                'selector'    => '%%order_class%% .wdc-carousel-parent',
                                'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                                'declaration' => sprintf( 'padding-%1$s:%2$s;', $tab_placement, $tab_width_phone ),
                            ]
                        );
                    }

                }

            }

            if ( !empty( $tab_bg ) ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav',
                        'declaration' => sprintf( 'background-color:%1$s;', $tab_bg ),
                    ]
                );
            }

            if ( !empty( $tab_active_bg ) ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .slick-current .nav-item-inner',
                        'declaration' => sprintf( 'background-color:%1$s!important;', $tab_active_bg ),
                    ]
                );
            }

            if ( !empty( $tab_item_bg ) ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .nav-item-inner',
                        'declaration' => sprintf( 'background-color:%1$s;', $tab_item_bg ),
                    ]
                );
            }

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item .nav-item-inner',
                    'declaration' => sprintf( 'text-align:%1$s;%2$s', $tab_alignment, $this->wdc_process_padding( $tab_padding, false ) ),
                ]
            );

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item .nav-item-inner',
                    'declaration' => 'display: flex!important; flex-direction: column; justify-content: center; height: 100%;',
                ]
            );

            if ( 'right' === $tab_alignment ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item .nav-item-inner',
                        'declaration' => 'align-items: flex-end;',
                    ]
                );
            } elseif ( 'center' === $tab_alignment ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item .nav-item-inner',
                        'declaration' => 'align-items: center;',
                    ]
                );
            }

            // thumb.
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure',
                    'declaration' => sprintf( 'border-radius:%1$s;', $thumb_radius ),
                ]
            );

            // thumb width.
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure',
                    'declaration' => sprintf( 'width:%1$s;', $thumb_width ),
                ]
            );

            if ( !empty( $thumb_width_tablet ) && $thumb_width_responsive_status ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure',
                        'declaration' => sprintf( 'width:%1$s;', $thumb_width_tablet ),
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    ]
                );
            }

            if ( !empty( $thumb_width_phone ) && $thumb_width_responsive_status ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure',
                        'declaration' => sprintf( 'width:%1$s;', $thumb_width_phone ),
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                    ]
                );
            }

// thumb height.
            if ( !empty( $thumb_height ) ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure',
                        'declaration' => sprintf( 'height:%1$s;', $thumb_height ),
                    ]
                );
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure img',
                        'declaration' => 'height:100%;',
                    ]
                );
            }

            if ( !empty( $thumb_height_tablet ) && $thumb_height_responsive_status ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure',
                        'declaration' => sprintf( 'height:%1$s;', $thumb_height_tablet ),
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    ]
                );
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure img',
                        'declaration' => 'height:100%;',
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    ]
                );
            }

            if ( !empty( $thumb_height_phone ) && $thumb_height_responsive_status ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure',
                        'declaration' => sprintf( 'height:%1$s;', $thumb_height_phone ),
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                    ]
                );
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure img',
                        'declaration' => 'height:100%;',
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                    ]
                );
            }

            if ( 'auto' !== $tab_item_height ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .slick-slide',
                        'declaration' => sprintf( 'height: %1$s!important;', $tab_item_height ),
                    ]
                );
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .slick-slide>div, %%order_class%% .wdc-carousel-nav .slick-slide .wdc-carousel-nav-item',
                        'declaration' => 'height: 100%!important;',
                    ]
                );
            }

            if ( 'left' === $tab_placement || 'right' === $tab_placement ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .slick-slide',
                        'declaration' => sprintf( 'padding-bottom: %1$s!important;', $tab_spacing ),
                    ]
                );

                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .slick-list',
                        'declaration' => sprintf( 'margin-bottom: -%1$s!important;', $tab_spacing ),
                    ]
                );
            } else {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .slick-slide',
                        'declaration' => sprintf( 'padding-right: %1$s!important;', $tab_spacing ),
                    ]
                );

                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .slick-list',
                        'declaration' => sprintf( 'margin-right: -%1$s!important;', $tab_spacing ),
                    ]
                );
            }

// Texts.
            if ( !empty( $thumb_spacing ) ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item figure',
                        'declaration' => sprintf( 'margin-bottom: %1$s!important;', $thumb_spacing ),
                    ]
                );
            }

            if ( !empty( $title_spacing ) ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item h2',
                        'declaration' => sprintf( 'margin-bottom: %1$s!important;', $title_spacing ),
                    ]
                );
            }

            $tab_spacing_top                      = $this->props['tab_spacing_top'];
            $tab_spacing_top_tablet               = $this->props['tab_spacing_top_tablet'];
            $tab_spacing_top_phone                = $this->props['tab_spacing_top_phone'];
            $tab_spacing_top_last_edited          = $this->props['tab_spacing_top_last_edited'];
            $tab_spacing_top_responsive_status    = et_pb_get_responsive_status( $tab_spacing_top_last_edited );
            $tab_spacing_bottom                   = $this->props['tab_spacing_bottom'];
            $tab_spacing_bottom_tablet            = $this->props['tab_spacing_bottom_tablet'];
            $tab_spacing_bottom_phone             = $this->props['tab_spacing_bottom_phone'];
            $tab_spacing_bottom_last_edited       = $this->props['tab_spacing_bottom_last_edited'];
            $tab_spacing_bottom_responsive_status = et_pb_get_responsive_status( $tab_spacing_bottom_last_edited );

            if ( 'top' === $tab_placement || 'bottom' === $tab_placement ) {

                // Tab Spacing Top - Bottom.
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-carousel-nav .slick-track',
                        'declaration' => sprintf( 'padding-top: %1$s; padding-bottom: %2$s;', $tab_spacing_top, $tab_spacing_bottom ),
                    ]
                );

// Tab Spacing Top Tablet.
                if ( $tab_spacing_top_tablet && $tab_spacing_top_responsive_status ) {
                    ET_Builder_Element::set_style(
                        $render_slug,
                        [
                            'selector'    => '%%order_class%% .wdc-carousel-nav .slick-track',
                            'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                            'declaration' => sprintf( 'padding-top: %1$s;', $tab_spacing_top_tablet ),
                        ]
                    );
                }

// Tab Spacing Top Phone.
                if ( $tab_spacing_top_phone && $tab_spacing_top_responsive_status ) {
                    ET_Builder_Element::set_style(
                        $render_slug,
                        [
                            'selector'    => '%%order_class%% .wdc-carousel-nav .slick-track',
                            'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                            'declaration' => sprintf( 'padding-top: %1$s;', $tab_spacing_top_phone ),
                        ]
                    );
                }

// Tab Spacing Bottom Tablet.
                if ( $tab_spacing_bottom_tablet && $tab_spacing_bottom_responsive_status ) {
                    ET_Builder_Element::set_style(
                        $render_slug,
                        [
                            'selector'    => '%%order_class%% .wdc-carousel-nav .slick-track',
                            'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                            'declaration' => sprintf( 'padding-bottom: %1$s;', $tab_spacing_bottom_tablet ),
                        ]
                    );
                }

// Tab Spacing Bottom Phone.
                if ( $tab_spacing_bottom_phone && $tab_spacing_bottom_responsive_status ) {
                    ET_Builder_Element::set_style(
                        $render_slug,
                        [
                            'selector'    => '%%order_class%% .wdc-carousel-nav .slick-track',
                            'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                            'declaration' => sprintf( 'padding-bottom: %1$s;', $tab_spacing_bottom_phone ),
                        ]
                    );
                }

            }

        }

    }

    protected function get_custom_bg_style( $render_slug, $opt_slug, $selector, $hover_selector ) {

        $_bg = $this->processcustom_advanced_background_fields( $opt_slug, '' );

        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => $selector,
                'declaration' => $_bg,
            ]
        );

        // hover.
        $_bg_hover = $this->processcustom_advanced_background_fields( $opt_slug, '__hover' );

        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => $hover_selector,
                'declaration' => $_bg_hover,
            ]
        );

    }

    protected function get_overlay_option_fields( $opt_slug, $show_if ) {

        $fields = [

            'overlay_icon'         => [
                'label'           => esc_html__( 'Overlay Icon', 'wdc-wow-divi-carousel' ),
                'type'            => 'select_icon',
                'option_category' => 'basic_option',
                'toggle_slug'     => $opt_slug,
                'tab_slug'        => 'advanced',
                'show_if'         => $show_if,
                'hover'           => 'tabs',
            ],

            'overlay_icon_color'   => [
                'label'       => esc_html__( 'Overlay Icon Color', 'wdc-wow-divi-carousel' ),
                'type'        => 'color-alpha',
                'tab_slug'    => 'advanced',
                'default'     => '#2EA3F2',
                'toggle_slug' => $opt_slug,
                'show_if'     => $show_if,
                'hover'       => 'tabs',
            ],

            'overlay_icon_size'    => [
                'label'           => esc_html__( 'Overlay Icon Size', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '32px',
                'range_settings'  => [
                    'min'  => 0,
                    'max'  => 200,
                    'step' => 1,
                ],
                'toggle_slug'     => $opt_slug,
                'tab_slug'        => 'advanced',
                'show_if'         => $show_if,
            ],

            'overlay_icon_opacity' => [
                'label'           => esc_html__( 'Overlay Icon Opacity', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '1',
                'unitless'        => true,
                'range_settings'  => [
                    'min'  => 0,
                    'max'  => 1,
                    'step' => .02,
                ],
                'toggle_slug'     => $opt_slug,
                'tab_slug'        => 'advanced',
                'show_if'         => $show_if,
                'hover'           => 'tabs',
            ],

        ];

        $overlay = $this->custom_advanced_background_fields( 'overlay', 'Overlay', 'advanced', $opt_slug, ['color', 'gradient'], $show_if, '' );

        return array_merge( $overlay, $fields );

    }

    protected function get_overlay_style( $render_slug ) {

        $overlay_icon_color         = $this->props['overlay_icon_color'];
        $overlay_icon_color_hover   = $this->get_hover_value( 'overlay_icon_color' );
        $overlay_icon_size          = $this->props['overlay_icon_size'];
        $overlay_icon_size_hover    = $this->get_hover_value( 'overlay_icon_size' );
        $overlay_icon_opacity       = $this->props['overlay_icon_opacity'];
        $overlay_icon_opacity_hover = $this->get_hover_value( 'overlay_icon_opacity' );

        // Overlay background.
        $this->get_custom_bg_style( $render_slug, 'overlay', '%%order_class%% .wdc-overlay', '%%order_class%% .wdc-carousel-item:hover .wdc-overlay' );

        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-overlay .wdc-overlay-icon',
                'declaration' => sprintf( 'color: %1$s;', $overlay_icon_color ),
            ]
        );

        if ( !empty( $overlay_icon_color_hover ) ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%%:hover .wdc-overlay .wdc-overlay-icon',
                    'declaration' => sprintf( 'color: %1$s;', $overlay_icon_color_hover ),
                ]
            );
        }

        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-overlay .wdc-overlay-icon',
                'declaration' => "font-size:{$overlay_icon_size};",
            ]
        );

        if ( !empty( $overlay_icon_size_hover ) ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%%:hover .wdc-overlay .wdc-overlay-icon',
                    'declaration' => "font-size:{$overlay_icon_size_hover};",
                ]
            );
        }

        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-overlay .wdc-overlay-icon',
                'declaration' => "opacity:{$overlay_icon_opacity};",
            ]
        );

        if ( !empty( $overlay_icon_opacity_hover ) ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%%:hover .wdc-overlay .wdc-overlay-icon',
                    'declaration' => "opacity:{$overlay_icon_opacity_hover};",
                ]
            );
        }

    }

    protected function render_carousel_nav( $tab_data, $order_number, $id, $name ) {
        $nav_items = '';

        if ( 'on' === $this->props['use_tab'] ) {

            $tab_elements  = explode( '|', $this->props['tab_elements'] );
            $tab_placement = $this->props['tab_placement'];
            $tab_position  = $this->props['tab_position'];

            foreach ( $tab_data[$id - 1] as $data ) {
                $tab_title    = $data['tab_title'];
                $tab_subtitle = $data['tab_subtitle'];
                $tab_thumb    = $data['tab_thumb'];
                $title        = '';
                $subtitle     = '';
                $thumb        = '';

                if ( 'on' === $tab_elements[0] ) {

                    if ( !empty( $tab_title ) ) {
                        $title = '<h2>' . $tab_title . '</h2>';
                    } else {
                        $title = '<h2>Title</h2>';
                    }

                }

                if ( 'on' === $tab_elements[1] ) {

                    if ( !empty( $tab_subtitle ) ) {
                        $subtitle = '<p>' . $tab_subtitle . '</p>';
                    } else {
                        $subtitle = '<p>Subtitle</p>';
                    }

                }

                if ( 'on' === $tab_elements[2] ) {
                    $thumb = '<figure><img data-lazy="' . $tab_thumb . '"/></figure>';
                }

                $nav_items = $nav_items . sprintf(
                    '<div class="wdc-carousel-nav-item">
                        <div class="nav-item-inner">
                            %1$s %2$s %3$s
                        </div>
                    </div>',
                    $thumb,
                    $title,
                    $subtitle
                );
            }

            return sprintf(
                ' <div %1$s class="wdc-carousel-nav wdc-%6$s-carousel-nav-%5$s nav--%2$s nav--%3$s">
                    %4$s
                </div>
                ',
                $this->get_tab_carousel_options_data( $order_number, $name ),
                $tab_placement,
                $tab_position,
                $nav_items,
                $order_number,
                $name
            );
        }

    }

    protected function get_carousel_options_data( $order_number, $name ) {

        $sliding_dir            = $this->props['sliding_dir'];
        $wait_for_animate       = $this->props['wait_for_animate'];
        $is_autoplay            = $this->props['is_autoplay'];
        $css_transition         = $this->props['css_transition'];
        $is_lazyload            = $this->props['is_lazyload'];
        $lazyload_type          = $this->props['lazyload_type'];
        $is_auto_height         = $this->props['is_auto_height'];
        $autoplay_speed         = $this->props['autoplay_speed'];
        $animation_speed        = $this->props['animation_speed'];
        $slide_count            = $this->props['slide_count'];
        $is_center              = $this->props['is_center'];
        $center_mode_type       = $this->props['center_mode_type'];
        $center_padding         = $this->props['center_padding'];
        $center_padding_tablet  = $this->props['center_padding_tablet'];
        $center_padding_phone   = $this->props['center_padding_phone'];
        $is_vertical            = $this->props['is_vertical'];
        $is_infinite            = $this->props['is_infinite'];
        $slide_count            = $this->props['slide_count'];
        $is_fade                = $this->props['is_fade'];
        $fade                   = false;
        $slide_count_tablet     = $this->props['slide_count_tablet'] ? $this->props['slide_count_tablet'] : $slide_count;
        $slide_count_phone      = $this->props['slide_count_phone'] ? $this->props['slide_count_phone'] : $slide_count_tablet;
        $icon_left              = esc_html( et_pb_process_font_icon( $this->props['icon_left'] ) );
        $icon_left              = !empty( $icon_left ) ? $icon_left : '4';
        $icon_right             = esc_html( et_pb_process_font_icon( $this->props['icon_right'] ) );
        $icon_right             = !empty( $icon_right ) ? $icon_right : '5';
        $nav_pagi               = $this->props['nav_pagi'];
        $nav_pagi_tablet        = !empty( $this->props['nav_pagi_tablet'] ) ? $this->props['nav_pagi_tablet'] : $nav_pagi;
        $nav_pagi_phone         = !empty( $this->props['nav_pagi_phone'] ) ? $this->props['nav_pagi_phone'] : $nav_pagi_tablet;
        $is_pagi_active         = 'pagi' === $nav_pagi || 'nav_pagi' === $nav_pagi ? true : false;
        $is_pagi_active_tablet  = 'pagi' === $nav_pagi_tablet || 'nav_pagi' === $nav_pagi_tablet ? true : false;
        $is_pagi_active_phone   = 'pagi' === $nav_pagi_phone || 'nav_pagi' === $nav_pagi_phone ? true : false;
        $is_arrow_active        = 'nav' === $nav_pagi || 'nav_pagi' === $nav_pagi ? true : false;
        $is_arrow_active_tablet = 'nav' === $nav_pagi_tablet || 'nav_pagi' === $nav_pagi_tablet ? true : false;
        $is_arrow_active_phone  = 'nav' === $nav_pagi_phone || 'nav_pagi' === $nav_pagi_phone ? true : false;
        $is_variable_width      = $this->props['is_variable_width'];
        $slide_to_scroll        = $this->props['slide_to_scroll'];
        $slide_to_scroll_tablet = $this->props['slide_to_scroll_tablet'];
        $slide_to_scroll_phone  = $this->props['slide_to_scroll_phone'];
        $is_swipe               = $this->props['is_swipe'];
        $is_swipe_tablet        = $this->props['is_swipe_tablet'];
        $is_swipe_phone         = $this->props['is_swipe_phone'];
        $use_tab                = isset( $this->props['use_tab'] ) ? $this->props['use_tab'] : 'off';

        if ( 'off' === $is_variable_width && '1' === $slide_count && 'on' === $is_fade ) {
            $fade = true;
        }

        if ( 'on' === $is_variable_width || 'on' === $use_tab ) {
            $slide_count = 1;
        }

        $settings               = [];
        $settings['responsive'] = [];
        $tablet                 = [];
        $phone                  = [];

        $settings['fade']           = $fade;
        $settings['rtl']            = 'rtl' === $sliding_dir ? true : false;
        $settings['adaptiveHeight'] = 'on' === $is_auto_height ? true : false;
        $settings['swipe']          = 'on' === $is_swipe ? true : false;
        $settings['variableWidth']  = ( 'off' === $use_tab && 'on' === $is_variable_width ) ? true : false;
        $settings['dots']           = $is_pagi_active;
        $settings['cssEase']        = $css_transition;
        $settings['arrows']         = $is_arrow_active;
        $settings['infinite']       = 'on' === $is_infinite ? true : false;
        $settings['autoplay']       = 'on' === $is_autoplay ? true : false;
        $settings['autoplaySpeed']  = intval( $autoplay_speed );
        $settings['speed']          = intval( $animation_speed );
        $settings['slidesToShow']   = intval( $slide_count );
        $settings['slidesToScroll'] = intval( $slide_to_scroll );
        $settings['centerPadding']  = ( 'off' === $is_variable_width && 'classic' === $center_mode_type ) ? $center_padding : 0;
        $settings['centerMode']     = ( 'off' === $use_tab && 'on' === $is_center ) ? true : false;
        $settings['vertical']       = 'on' === $is_vertical ? true : false;
        $settings['prevArrow']      = '<button type="button" data-icon=" ' . $icon_left . '"class="slick-arrow slick-prev">Prev</button>';
        $settings['nextArrow']      = '<button type="button" data-icon=" ' . $icon_right . '"class="slick-arrow slick-next">Prev</button>';

        if ( 'on' === $use_tab ) {
            $settings['asNavFor'] = ".wdc-{$name}-carousel-nav-{$order_number}";
            $settings['fade']     = true;
        }

        if ( 'on' === $is_lazyload ) {
            $settings['lazyLoad'] = $lazyload_type;
        }

        if ( 'off' === $wait_for_animate ) {
            $settings['waitForAnimate'] = false;
        }

        // Responsive break point 980.
        $tablet['breakpoint'] = 980;

        if ( 'off' === $is_variable_width && !empty( $slide_count_tablet ) ) {
            $tablet['settings']['slidesToShow'] = 'off' === $use_tab ? intval( $slide_count_tablet ) : 1;
        }

        if ( !empty( $slide_to_scroll_tablet ) ) {
            $tablet['settings']['slidesToScroll'] = intval( $slide_to_scroll_tablet );
        }

        if ( !empty( $is_pagi_active_tablet ) ) {
            $tablet['settings']['dots'] = $is_pagi_active_tablet;
        }

        if ( !empty( $is_arrow_active_tablet ) ) {
            $tablet['settings']['arrows'] = $is_arrow_active_tablet;
        }

        if ( !empty( $is_swipe_tablet ) ) {
            $tablet['settings']['swipe'] = 'on' === $is_swipe_tablet ? true : false;
        }

        if ( 'off' === $is_variable_width && 'classic' === $center_mode_type && !empty( $center_padding_tablet ) ) {
            $tablet['settings']['centerPadding'] = $center_padding_tablet;
        }

        array_push( $settings['responsive'], $tablet );

        // Responsive break point 767.
        $phone['breakpoint'] = 767;

        if ( 'off' === $is_variable_width && !empty( $slide_count_phone ) ) {
            $phone['settings']['slidesToShow'] = 'off' === $use_tab ? intval( $slide_count_phone ) : 1;
        }

        if ( !empty( $slide_to_scroll_phone ) ) {
            $phone['settings']['slidesToScroll'] = intval( $slide_to_scroll_phone );
        }

        if ( !empty( $is_pagi_active_phone ) ) {
            $phone['settings']['dots'] = $is_pagi_active_phone;
        }

        if ( !empty( $is_arrow_active_phone ) ) {
            $phone['settings']['arrows'] = $is_arrow_active_phone;
        }

        if ( !empty( $is_swipe_phone ) ) {
            $phone['settings']['swipe'] = 'on' === $is_swipe_phone ? true : false;
        }

        if ( 'off' === $is_variable_width && 'classic' === $center_mode_type && !empty( $center_padding_phone ) ) {
            $phone['settings']['centerPadding'] = $center_padding_phone;
        }

        array_push( $settings['responsive'], $phone );

        $carousel_options = sprintf( 'data-settings="%1$s"', htmlspecialchars( wp_json_encode( $settings ), ENT_QUOTES, 'UTF-8' ) );

        return $carousel_options;
    }

    protected function get_tab_carousel_options_data( $order_number, $name ) {

        $is_infinite            = $this->props['is_infinite'];
        $tab_placement          = $this->props['tab_placement'];
        $is_autoplay            = $this->props['is_autoplay'];
        $autoplay_speed         = $this->props['autoplay_speed'];
        $animation_speed        = $this->props['animation_speed'];
        $tab_slide_count        = $this->props['tab_slide_count'];
        $tab_slide_count_tablet = $this->props['tab_slide_count_tablet'] ? $this->props['tab_slide_count_tablet'] : $tab_slide_count;
        $tab_slide_count_phone  = $this->props['tab_slide_count_phone'] ? $this->props['tab_slide_count_phone'] : $tab_slide_count_tablet;
        $use_tab                = isset( $this->props['use_tab'] ) ? $this->props['use_tab'] : 'off';
        $is_vertical            = false;

        if ( 'left' === $tab_placement || 'right' === $tab_placement ) {
            $is_vertical = true;
        }

        $settings               = [];
        $settings['responsive'] = [];
        $tablet                 = [];
        $phone                  = [];

        $settings['infinite']       = 'on' === $is_infinite ? true : false;
        $settings['autoplay']       = 'on' === $is_autoplay ? true : false;
        $settings['autoplaySpeed']  = intval( $autoplay_speed );
        $settings['speed']          = intval( $animation_speed );
        $settings['slidesToShow']   = intval( $tab_slide_count );
        $settings['dots']           = false;
        $settings['arrows']         = false;
        $settings['focusOnSelect']  = true;
        $settings['slidesToScroll'] = 1;
        $settings['swipeToSlide']   = true;
        $settings['lazyLoad']       = 'progressive';
        $settings['centerPadding']  = 0;
        $settings['centerMode']     = true;
        $settings['vertical']       = $is_vertical;
        $settings['asNavFor']       = ".wdc-{$name}-carousel-{$order_number}";

        // Responsive break point 980.
        $tablet['breakpoint'] = 980;

        if ( !empty( $tab_slide_count_tablet ) ) {
            $tablet['settings']['slidesToShow'] = intval( $tab_slide_count_tablet );
        }

        array_push( $settings['responsive'], $tablet );

        // Responsive break point 767.
        $phone['breakpoint'] = 767;

        if ( !empty( $tab_slide_count_phone ) ) {
            $phone['settings']['slidesToShow'] = $tab_slide_count_phone;
        }

        array_push( $settings['responsive'], $phone );

        if ( 'on' === $use_tab ) {
            return sprintf( 'data-tab-settings="%1$s"', htmlspecialchars( wp_json_encode( $settings ), ENT_QUOTES, 'UTF-8' ) );
        }

    }

    public static function process_margin_padding( $value = '0|0|0|0', $type = 'padding', $important = false ) {
        $_top    = '';
        $_right  = '';
        $_bottom = '';
        $_left   = '';
        $suffix  = '';
        $_value  = explode( '|', $value );

        if ( $important ) {
            $suffix = '!important';
        }

        if ( '' !== $_value[0] ) {
            $_top = "{$type}-top:" . $_value[0] . $suffix . ';';
        }

        if ( '' !== $_value[1] ) {
            $_right = "{$type}-right:" . $_value[1] . $suffix . ';';
        }

        if ( '' !== $_value[2] ) {
            $_bottom = "{$type}-bottom:" . $_value[2] . $suffix . ';';
        }

        if ( '' !== $_value[3] ) {
            $_left = "{$type}-left:" . $_value[3] . $suffix . ';';
        }

        return esc_html( "{$_top} {$_right} {$_bottom} {$_left}" );
    }

    public static function process_flex_style( $val, $type, $important ) {
        $flex_val = 'center';

        if ( 'left' === $val ) {
            $flex_val = 'flex-start';
        } elseif ( 'right' === $val ) {
            $flex_val = 'flex-end';
        }

        return sprintf(
            '%1$s:%2$s%3$s;',
            $type,
            $flex_val,
            $important ? '!important;' : ''
        );
    }

    public function get_conditional_responsive_styles( $styles, $data, $style ) {
        $important = isset( $styles['important'] ) ? $styles['important'] : false;

        if ( 'padding' === $style || 'margin' === $style ) {
            return $this->process_margin_padding( $data, $style, $important );
        } elseif ( 'align-self' === $style || 'align-items' === $style || 'justify-content' === $style ) {
            return $this->process_flex_style( $data, $style, $important );
        } elseif ( 'flex' === $style ) {
            return 'flex: 0 0 ' . $data . ';';
        } else {
            return sprintf(
                '%1$s:%2$s%3$s;',
                $style,
                $data,
                $important ? '!important;' : ''
            );
        }

    }

    protected function get_responsive_styles( $opt_name, $selector, $styles, $pre_values, $render_slug ) {

        $is_enabled = false;
        $style      = isset( $styles['primary'] ) ? $styles['primary'] : '';
        $_data      = $this->props["{$opt_name}"];

        if ( isset( $this->props["{$opt_name}_last_edited"] ) ) {
            $is_enabled = et_pb_get_responsive_status( $this->props["{$opt_name}_last_edited"] );
        }

        if ( empty( $_data ) && !empty( $pre_values ) ) {

            if ( !empty( $pre_values['conditional'] ) ) {
                $is_default = true;

                foreach ( $pre_values['conditional']['values'] as $value ) {
                    $property_val = $this->props["{$pre_values['conditional']['name']}"];

                    if ( $property_val === $value['a'] ) {
                        $_data      = $value['b'];
                        $is_default = false;
                    }

                }

                if ( $is_default ) {
                    $_data = $pre_values['default'];
                }

            }

        }

        if ( !empty( $_data ) ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => $selector,
                    'declaration' => $this->get_conditional_responsive_styles( $styles, $_data, $style ),
                ]
            );

            if ( !empty( $styles['secondary'] ) ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => $selector,
                        'declaration' => $styles['secondary'],
                    ]
                );
            }

        }

        if ( $is_enabled ) {

            $_data_tablet = $this->props["{$opt_name}_tablet"];
            $_data_phone  = $this->props["{$opt_name}_phone"];

            if ( !empty( $_data_tablet ) ) {

                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => $selector,
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                        'declaration' => $this->get_conditional_responsive_styles( $styles, $_data_tablet, $style ),
                    ]
                );

                if ( !empty( $styles['secondary'] ) ) {
                    ET_Builder_Element::set_style(
                        $render_slug,
                        [
                            'selector'    => $selector,
                            'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                            'declaration' => $styles['secondary'],
                        ]
                    );
                }

            }

            if ( !empty( $_data_phone ) ) {

                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => $selector,
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                        'declaration' => $this->get_conditional_responsive_styles( $styles, $_data_phone, $style ),
                    ]
                );

                if ( !empty( $styles['secondary'] ) ) {
                    ET_Builder_Element::set_style(
                        $render_slug,
                        [
                            'selector'    => $selector,
                            'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                            'declaration' => $styles['secondary'],
                        ]
                    );
                }

            }

        }

    }

    protected function get_buttons_styles( $prefix, $render_slug, $selector ) {

        $custom_padding                   = $this->props["{$prefix}_custom_padding"];
        $custom_padding_tablet            = $this->props["{$prefix}_custom_padding_tablet"];
        $custom_padding_phone             = $this->props["{$prefix}_custom_padding_phone"];
        $custom_padding_hover             = $this->get_hover_value( "{$prefix}_custom_padding" );
        $custom_padding_last_edited       = $this->props["{$prefix}_custom_padding_last_edited"];
        $custom_padding_responsive_status = et_pb_get_responsive_status( $custom_padding_last_edited );
        $icon_placement                   = $this->props["{$prefix}_icon_placement"];
        $use_icon                         = $this->props["{$prefix}_use_icon"];
        $is_custom                        = $this->props["custom_{$prefix}"];

        if ( 'on' === $is_custom ) {

            if ( !empty( $custom_padding ) ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => "body #page-container {$selector}, .et-db #et-boc {$selector}",
                        'declaration' => $this->process_margin_padding( $custom_padding, 'padding', true ),
                    ]
                );
            }

            if ( !empty( $custom_padding_hover ) ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => "body #page-container {$selector}:hover, .et-db #et-boc {$selector}:hover",
                        'declaration' => $this->process_margin_padding( $custom_padding_hover, 'padding', true ),
                    ]
                );
            } else {

                if ( !empty( $custom_padding ) ) {
                    ET_Builder_Element::set_style(
                        $render_slug,
                        [
                            'selector'    => "body #page-container {$selector}:hover, .et-db #et-boc {$selector}:hover",
                            'declaration' => $this->process_margin_padding( $custom_padding, 'padding', true ),
                        ]
                    );
                }

            }

            if ( !empty( $custom_padding_tablet ) && $custom_padding_responsive_status ):
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => "body #page-container {$selector}, .et-db #et-boc {$selector}",
                        'declaration' => $this->process_margin_padding( $custom_padding_tablet, 'padding', true ),
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    ]
                );
            endif;

            if ( !empty( $custom_padding_phone ) && $custom_padding_responsive_status ):
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => "body #page-container {$selector}, .et-db #et-boc {$selector}",
                        'declaration' => $this->process_margin_padding( $custom_padding_phone, 'padding', true ),
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                    ]
                );
            endif;

            if ( 'on' === $use_icon && 'right' === $icon_placement ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => "body #page-container {$selector}:after, .et-db #et-boc {$selector}:after",
                        'declaration' => '
                        display: inline-block;
                        content: attr(data-icon)!important;',
                    ]
                );
            }

        }

    }

}
