<?php

class WDC_VideoCarousel extends WDC_Builder_Module {

	protected $module_credits = array(
		'module_uri' => 'https://wowcarousel.com/modules/video-carousel/',
		'author'     => 'Wow Carousel',
		'author_uri' => 'https://divipeople.com/wow-divi-carousel/',
	);

	public function init() {

		$this->name       = esc_html__('Wow Video Carousel', 'wdc-wow-divi-carousel');
		$this->icon_path  = plugin_dir_path(__FILE__) . 'wdc-video-carousel.svg';
		$this->slug       = 'wdc_video_carousel';
		$this->vb_support = 'on';
		$this->child_slug = 'wdc_video_carousel_child';

		$this->settings_modal_toggles = array(
			'general'  => array(
				'toggles' => array(
					'settings' => array(
						'title'             => esc_html__('Carousel Settings', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'general'  => array(
								'name' => esc_html__('General', 'wdc-wow-divi-carousel'),
							),
							'advanced' => array(
								'name' => esc_html__('Advanced', 'wdc-wow-divi-carousel'),
							),
						),
					),
				),
			),

			'advanced' => array(
				'toggles' => array(
					'arrow'      => array(
						'title'             => esc_html__('Navigation', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'arrow_common' => array(
								'name' => esc_html__('Common', 'wdc-wow-divi-carousel'),
							),
							'arrow_left'   => array(
								'name' => esc_html__('Prev', 'wdc-wow-divi-carousel'),
							),
							'arrow_right'  => array(
								'name' => esc_html__('Next', 'wdc-wow-divi-carousel'),
							),
						),
					),
					'pagination' => array(
						'title'             => esc_html__('Pagination', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'pagi_common' => array(
								'name' => esc_html__('Common', 'wdc-wow-divi-carousel'),
							),
							'pagi_active' => array(
								'name' => esc_html__('Active', 'wdc-wow-divi-carousel'),
							),
						),
					),
				),
			),
		);
	}

	public function get_fields() {
		$carousel_options = WDC_Builder_Module::get_carousel_option_fields('carousel', array('lightbox'));
		return $carousel_options;
	}

	public function get_advanced_fields_config() {

		$advanced_fields                 = array();
		$advanced_fields['text']         = false;
		$advanced_fields['borders']      = false;
		$advanced_fields['text_shadow']  = false;
		$advanced_fields['link_options'] = false;
		$advanced_fields['fonts']        = false;
		return $advanced_fields;
	}

	public function render($attrs, $content, $render_slug) {

		$sliding_dir      = $this->props['sliding_dir'];
		$content          = $this->props['content'];
		$is_center        = $this->props['is_center'];
		$center_mode_type = $this->props['center_mode_type'];
		$custom_cursor    = $this->props['custom_cursor'];

		wp_enqueue_style('wdc-magnific');
		wp_enqueue_script('wdc-magnific');

		$this->apply_css($render_slug);
		$classes = array();

		if ('on' === $is_center) {
			array_push($classes, 'wdc-centered');
			array_push($classes, "wdc-centered--{$center_mode_type}");
		}

		if ('on' === $custom_cursor) {
			array_push($classes, 'wdc-cursor');
		}

		// Get Order Class.
		$order_class  = self::get_module_order_class($render_slug);
		$order_number = str_replace('_', '', str_replace($this->slug, '', $order_class));

		$output = sprintf(
			'<div class="wdc-carousel-parent" dir="%4$s" %5$s>
			    <div class="wdc-carousel wdc-video-carousel-%2$s wdc-video-carousel wdc-carousel-frontend %3$s">
                    %1$s
                </div>
            </div>',
			$content,
			$order_number,
			join(' ', $classes),
			$sliding_dir,
			$this->get_carousel_options_data($order_number, 'video')
		);

		return $output;
	}


	public function apply_css($render_slug) {
		$this->apply_carousel_css($render_slug);
	}
}

new WDC_VideoCarousel();
