<?php
class WDC_TestimonialCarouselChild extends WDC_Builder_Module {

	public $slug       = 'wdc_testimonial_carousel_child';
	public $vb_support = 'on';
	public $type       = 'child';

	public function init() {

		$this->name                     = esc_html__( 'Testimonial', 'wdc-wow-divi-carousel' );
		$this->child_title_var          = 'admin_title';
		$this->child_title_fallback_var = 'name';

		$this->settings_modal_toggles = array(
			'general'  => array(
				'toggles' => array(
					'content'     => esc_html__( 'Content', 'wdc-wow-divi-carousel' ),
					'elements'    => esc_html__( 'Elements', 'wdc-wow-divi-carousel' ),
					'tab_content' => esc_html__( 'Tab Content', 'wdc-wow-divi-carousel' ),
				),
			),

			'advanced' => array(
				'toggles' => array(
					'common'     => esc_html__( 'General', 'wdc-wow-divi-carousel' ),
					'quote_icon' => esc_html__( 'Quote Icon', 'wdc-wow-divi-carousel' ),
					'image'      => esc_html__( 'Image', 'wdc-wow-divi-carousel' ),
					'rating'     => esc_html__( 'Rating', 'wdc-wow-divi-carousel' ),
					'texts'      => array(
						'title'             => esc_html__( 'Texts', 'wdc-wow-divi-carousel' ),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'name'   => array(
								'name' => esc_html__( 'Name', 'wdc-wow-divi-carousel' ),
							),
							'title'  => array(
								'name' => esc_html__( 'Title', 'wdc-wow-divi-carousel' ),
							),
							'review' => array(
								'name' => esc_html__( 'Review', 'wdc-wow-divi-carousel' ),
							),
						),
					),
					'bubble'     => esc_html__( 'Bubble', 'wdc-wow-divi-carousel' ),
				),
			),
		);
	}

	public function get_fields() {

		$fields = array(
			'image'                  => array(
				'label'              => esc_html__( 'Image', 'wdc-wow-divi-carousel' ),
				'type'               => 'upload',
				'option_category'    => 'basic_option',
				'upload_button_text' => esc_attr__( 'Upload an image', 'wdc-wow-divi-carousel' ),
				'choose_text'        => esc_attr__( 'Choose an Image', 'wdc-wow-divi-carousel' ),
				'update_text'        => esc_attr__( 'Set As Image', 'wdc-wow-divi-carousel' ),
				'toggle_slug'        => 'content',
			),
			'image_alt'              => array(
				'label'       => esc_html__( 'Image Alt Text', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'content',
			),
			'name'                   => array(
				'label'       => esc_html__( 'Name', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'content',
			),

			'title'                  => array(
				'label'       => esc_html__( 'Title', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'content',
			),

			'use_rating'             => array(
				'label'           => esc_html__( 'Use Rating', 'wdc-wow-divi-carousel' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'         => 'off',
				'toggle_slug'     => 'content',
			),
			'rating'                 => array(
				'label'       => esc_html__( 'Rating', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'toggle_slug' => 'content',
				'default'     => '1',
				'options'     => array(
					'1' => esc_html__( '1', 'wdc-wow-divi-carousel' ),
					'2' => esc_html__( '2', 'wdc-wow-divi-carousel' ),
					'3' => esc_html__( '3', 'wdc-wow-divi-carousel' ),
					'4' => esc_html__( '4', 'wdc-wow-divi-carousel' ),
					'5' => esc_html__( '5', 'wdc-wow-divi-carousel' ),
				),
				'show_if'     => array(
					'use_rating' => 'on',
				),
			),
			'testimonial'            => array(
				'label'       => esc_html__( 'Testimonial', 'wdc-wow-divi-carousel' ),
				'type'        => 'textarea',
				'toggle_slug' => 'content',
			),
			'use_custom_icon'        => array(
				'label'           => esc_html__( 'Upload Custom Quote Icon', 'wdc-wow-divi-carousel' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'         => 'off',
				'toggle_slug'     => 'content',
			),
			'selected_icon'          => array(
				'label'       => esc_html__( 'Select Quote Icon', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'toggle_slug' => 'content',
				'default'     => '1',
				'options'     => array(
					'1' => esc_html__( 'Icon 1', 'wdc-wow-divi-carousel' ),
					'2' => esc_html__( 'Icon 2', 'wdc-wow-divi-carousel' ),
					'3' => esc_html__( 'Icon 3', 'wdc-wow-divi-carousel' ),
					'4' => esc_html__( 'Icon 4', 'wdc-wow-divi-carousel' ),
					'5' => esc_html__( 'Icon 5', 'wdc-wow-divi-carousel' ),
				),
				'show_if'     => array(
					'use_custom_icon' => 'off',
				),
			),
			'icon_img'               => array(
				'label'              => esc_html__( 'Upload Icon Image', 'wdc-wow-divi-carousel' ),
				'type'               => 'upload',
				'data_type'          => 'image',
				'option_category'    => 'basic_option',
				'upload_button_text' => esc_attr__( 'Upload an Image', 'wdc-wow-divi-carousel' ),
				'choose_text'        => esc_attr__( 'Choose an Image', 'wdc-wow-divi-carousel' ),
				'update_text'        => esc_attr__( 'Set As Image', 'wdc-wow-divi-carousel' ),
				'toggle_slug'        => 'content',
				'show_if'            => array(
					'use_custom_icon' => 'on',
				),
			),
			// elements.
			'hide_quote'             => array(
				'label'           => esc_html__( 'Hide Quote Icon', 'wdc-wow-divi-carousel' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'         => 'off',
				'toggle_slug'     => 'elements',
			),
			'reviewer_position'      => array(
				'label'       => esc_html__( 'Reviewer Position', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'toggle_slug' => 'elements',
				'default'     => 'bottom',
				'options'     => array(
					'top'    => esc_html__( 'Top', 'wdc-wow-divi-carousel' ),
					'bottom' => esc_html__( 'Bottom', 'wdc-wow-divi-carousel' ),
				),
			),
			'ratings_position'       => array(
				'label'       => esc_html__( 'Rating Position', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'toggle_slug' => 'elements',
				'default'     => 'default',
				'options'     => array(
					'default'  => esc_html__( 'Default', 'wdc-wow-divi-carousel' ),
					'bottom'   => esc_html__( 'Bottom', 'wdc-wow-divi-carousel' ),
					'reviewer' => esc_html__( 'Relative to Reviewer', 'wdc-wow-divi-carousel' ),
				),
				'show_if'     => array(
					'use_rating' => 'on',
				),
			),
			'review_design'          => array(
				'label'       => esc_html__( 'Review Design', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'toggle_slug' => 'elements',
				'default'     => 'default',
				'options'     => array(
					'normal' => esc_html__( 'Normal', 'wdc-wow-divi-carousel' ),
					'bubble' => esc_html__( 'Bubble', 'wdc-wow-divi-carousel' ),
				),
			),
			// links.
			'website_url'            => array(
				'label'       => esc_html__( 'Personal Website Url', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'link_options',
				'tab_slug'    => 'general',

			),
			'company_url'            => array(
				'label'       => esc_html__( 'Company Url', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'link_options',
				'tab_slug'    => 'general',

			),
			// common.
			'alignment'              => array(
				'label'          => __( 'Content Alignment', 'wdc-wow-divi-carousel' ),
				'type'           => 'text_align',
				'options'        => et_builder_get_text_orientation_options( array( 'justified' ) ),
				'options_icon'   => 'module_align',
				'default'        => 'center',
				'toggle_slug'    => 'common',
				'tab_slug'       => 'advanced',
				'mobile_options' => true,
			),
			'content_padding'        => array(
				'label'          => esc_html__( 'Content Padding', 'wdc-wow-divi-carousel' ),
				'type'           => 'custom_padding',
				'toggle_slug'    => 'common',
				'tab_slug'       => 'advanced',
				'mobile_options' => true,
			),
			// Quote Icon.
			'icon_placement'         => array(
				'label'       => esc_html__( 'Icon Placement', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'toggle_slug' => 'quote_icon',
				'tab_slug'    => 'advanced',
				'default'     => 'background',
				'options'     => array(
					'__default'  => esc_html__( 'Default', 'wdc-wow-divi-carousel' ),
					'absolute'   => esc_html__( 'Absolute', 'wdc-wow-divi-carousel' ),
					'background' => esc_html__( 'Background', 'wdc-wow-divi-carousel' ),
				),
			),
			'icon_pos_x'             => array(
				'label'          => esc_html__( 'Icon Position X', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '0px',
				'range_settings' => array(
					'min'  => -500,
					'step' => 1,
					'max'  => 500,
				),
				'toggle_slug'    => 'quote_icon',
				'tab_slug'       => 'advanced',
				'show_if'        => array(
					'icon_placement' => 'absolute',
				),
			),
			'icon_pos_y'             => array(
				'label'          => esc_html__( 'Icon Position Y', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '0px',
				'range_settings' => array(
					'min'  => -500,
					'step' => 1,
					'max'  => 500,
				),
				'toggle_slug'    => 'quote_icon',
				'tab_slug'       => 'advanced',
				'show_if'        => array(
					'icon_placement' => 'absolute',
				),
			),
			'icon_alignment'         => array(
				'label'           => esc_html__( 'Icon Alignment', 'wdc-wow-divi-carousel' ),
				'type'            => 'text_align',
				'option_category' => 'layout',
				'options'         => et_builder_get_text_orientation_options( array( 'justified' ) ),
				'options_icon'    => 'module_align',
				'default'         => 'center',
				'toggle_slug'     => 'quote_icon',
				'tab_slug'        => 'advanced',
				'show_if_not'     => array(
					'icon_placement' => 'absolute',
				),
			),
			'icon_color'             => array(
				'label'       => __( 'Icon Color', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'quote_icon',
				'default'     => '#333',
				'show_if'     => array(
					'use_custom_icon' => 'off',
				),
			),
			'icon_bg'                => array(
				'label'       => __( 'Icon Background', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'quote_icon',
				'default'     => 'transparent',
			),
			'icon_size'              => array(
				'label'           => esc_html__( 'Icon Size', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '70px',
				'option_category' => 'basic_option',
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 500,
				),
				'toggle_slug'     => 'quote_icon',
				'tab_slug'        => 'advanced',
			),
			'icon_opacity'           => array(
				'label'           => esc_html__( 'Icon Opacity', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '.2',
				'option_category' => 'basic_option',
				'unitless'        => true,
				'range_settings'  => array(
					'min'  => 0,
					'step' => .01,
					'max'  => 1,
				),
				'toggle_slug'     => 'quote_icon',
				'tab_slug'        => 'advanced',
			),
			'icon_padding'           => array(
				'label'       => esc_html__( 'Icon Padding', 'wdc-wow-divi-carousel' ),
				'type'        => 'custom_padding',
				'default'     => '0px|0px|0px|0px',
				'toggle_slug' => 'quote_icon',
				'tab_slug'    => 'advanced',
				'show_if'     => array(
					'use_custom_icon' => 'off',
				),
			),
			'icon_top_spacing'       => array(
				'label'           => esc_html__( 'Icon Spacing Top', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '40px',
				'option_category' => 'basic_option',
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'quote_icon',
				'tab_slug'        => 'advanced',
				'show_if_not'     => array(
					'icon_placement' => 'absolute',
				),
			),
			'icon_bottom_spacing'    => array(
				'label'           => esc_html__( 'Icon Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '5px',
				'option_category' => 'basic_option',
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'quote_icon',
				'tab_slug'        => 'advanced',
				'show_if_not'     => array(
					'icon_placement' => 'absolute',
				),
			),
			// image.
			'use_img_top'            => array(
				'label'           => esc_html__( 'Use Absolute Image Position', 'wdc-wow-divi-carousel' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'         => 'off',
				'toggle_slug'     => 'image',
				'tab_slug'        => 'advanced',
			),
			'image_placement'        => array(
				'label'       => esc_html__( 'Image Position', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'image',
				'default'     => 'left_top',
				'options'     => array(
					'left_top'     => esc_html__( 'Left Top', 'wdc-wow-divi-carousel' ),
					'left_bottom'  => esc_html__( 'Left Bottom', 'wdc-wow-divi-carousel' ),
					'right_top'    => esc_html__( 'Right Top', 'wdc-wow-divi-carousel' ),
					'right_bottom' => esc_html__( 'Right Bottom', 'wdc-wow-divi-carousel' ),
				),
				'show_if'     => array(
					'use_img_top' => 'on',
				),
			),
			'img_offset_x'           => array(
				'label'          => esc_html__( 'Image Offset X', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '50%',
				'range_settings' => array(
					'min'  => -600,
					'max'  => 600,
					'step' => 1,
				),
				'show_if'        => array(
					'use_img_top' => 'on',
				),
				'toggle_slug'    => 'image',
				'tab_slug'       => 'advanced',
			),
			'img_offset_y'           => array(
				'label'           => esc_html__( 'Image Offset Y', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'default'         => '0px',
				'range_settings'  => array(
					'min'  => -600,
					'max'  => 600,
					'step' => 1,
				),
				'show_if'         => array(
					'use_img_top' => 'on',
				),
				'toggle_slug'     => 'image',
				'tab_slug'        => 'advanced',
			),
			'image_position'         => array(
				'label'       => esc_html__( 'Image Position', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'toggle_slug' => 'image',
				'tab_slug'    => 'advanced',
				'default'     => 'top',
				'options'     => array(
					'top'   => esc_html__( 'Top', 'wdc-wow-divi-carousel' ),
					'left'  => esc_html__( 'Left', 'wdc-wow-divi-carousel' ),
					'right' => esc_html__( 'Right', 'wdc-wow-divi-carousel' ),
				),
				'show_if'     => array(
					'use_img_top' => 'off',
				),
			),
			'image_spacing'          => array(
				'label'           => esc_html__( 'Image Spacing Left/Right', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '15px',
				'option_category' => 'basic_option',
				'default_unit'    => 'px',
				'range_settings'  => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 100,
				),
				'toggle_slug'     => 'image',
				'tab_slug'        => 'advanced',
				'show_if'         => array(
					'use_img_top'    => 'off',
					'image_position' => array( 'left', 'right' ),
				),
			),
			'image_width'            => array(
				'label'           => esc_html__( 'Image Width', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '65px',
				'option_category' => 'basic_option',
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 1,
					'step' => 1,
					'max'  => 800,
				),
				'toggle_slug'     => 'image',
				'tab_slug'        => 'advanced',
				'mobile_options'  => true,
			),
			'image_height'           => array(
				'label'           => esc_html__( 'Image Height', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '65px',
				'option_category' => 'basic_option',
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 1,
					'step' => 1,
					'max'  => 800,
				),
				'toggle_slug'     => 'image',
				'tab_slug'        => 'advanced',
				'mobile_options'  => true,
			),
			'image_spacing_top'      => array(
				'label'           => esc_html__( 'Image Spacing Top', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '15px',
				'option_category' => 'basic_option',
				'default_unit'    => 'px',
				'range_settings'  => array(
					'step' => 1,
					'min'  => -300,
					'max'  => 300,
				),
				'toggle_slug'     => 'image',
				'tab_slug'        => 'advanced',
				'show_if'         => array(
					'use_img_top'    => 'off',
					'image_position' => 'top',
				),
			),
			'image_spacing_bottom'   => array(
				'label'           => esc_html__( 'Image Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '20px',
				'option_category' => 'basic_option',
				'default_unit'    => 'px',
				'range_settings'  => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 300,
				),
				'toggle_slug'     => 'image',
				'tab_slug'        => 'advanced',
				'show_if'         => array(
					'use_img_top'    => 'off',
					'image_position' => 'top',
				),
			),
			// rating.
			'ratings_spacing_top'    => array(
				'label'          => __( 'Rating Spacing Top', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '0px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 100,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'rating',
				'show_if'        => array(
					'use_rating' => 'on',
				),
			),
			'ratings_spacing_bottom' => array(
				'label'          => __( 'Rating Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '0px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 100,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'rating',
				'show_if'        => array(
					'use_rating' => 'on',
				),
			),
			'stars_size'             => array(
				'label'          => __( 'Stars Size', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '20px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 100,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'rating',
				'show_if'        => array(
					'use_rating' => 'on',
				),
			),
			'stars_color'            => array(
				'label'       => __( 'Stars Color', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'rating',
				'default'     => '#F3B325',
				'show_if'     => array(
					'use_rating' => 'on',
				),
			),
			'stars_spacing_between'  => array(
				'label'          => __( 'Stars Spacing Between', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '5px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 20,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'rating',
				'show_if'        => array(
					'use_rating' => 'on',
				),
			),
			// texts.
			'name_bottom_spacing'    => array(
				'label'           => esc_html__( 'Name Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '5px',
				'option_category' => 'basic_option',
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'texts',
				'tab_slug'        => 'advanced',
				'sub_toggle'      => 'name',
			),
			'title_bottom_spacing'   => array(
				'label'           => esc_html__( 'Title Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '5px',
				'option_category' => 'basic_option',
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'texts',
				'tab_slug'        => 'advanced',
				'sub_toggle'      => 'title',
			),
			'review_top_spacing'     => array(
				'label'          => esc_html__( 'Review Spacing Top', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '0px',
				'default_unit'   => 'px',
				'range_settings' => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'    => 'texts',
				'tab_slug'       => 'advanced',
				'sub_toggle'     => 'review',
			),
			'review_bottom_spacing'  => array(
				'label'          => esc_html__( 'Review Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '20px',
				'default_unit'   => 'px',
				'range_settings' => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'    => 'texts',
				'tab_slug'       => 'advanced',
				'sub_toggle'     => 'review',
			),
			// Bubble.
			'bubble_padding'         => array(
				'label'       => esc_html__( 'Bubble Padding', 'wdc-wow-divi-carousel' ),
				'type'        => 'custom_padding',
				'toggle_slug' => 'bubble',
				'tab_slug'    => 'advanced',
				'default'     => '15px|15px|15px|15px',
				'show_if'     => array(
					'review_design' => 'bubble',
				),
			),
			'bubble_radius'          => array(
				'label'       => esc_html__( 'Bubble Border Radius', 'wdc-wow-divi-carousel' ),
				'type'        => 'border-radius',
				'toggle_slug' => 'bubble',
				'tab_slug'    => 'advanced',
				'default'     => 'off|6px|6px|6px|6px',
				'show_if'     => array(
					'review_design' => 'bubble',
				),
			),
			'arrow_color'            => array(
				'label'       => esc_html__( 'Arrow Color', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'bubble',
				'default'     => '#efefef',
				'show_if'     => array(
					'review_design' => 'bubble',
				),
			),
			'arrow_placement'        => array(
				'label'            => esc_html__( 'Arrow Placement', 'wdc-wow-divi-carousel' ),
				'type'             => 'select',
				'options'          => array(
					'left'   => esc_html__( 'Left', 'wdc-wow-divi-carousel' ),
					'right'  => esc_html__( 'Right', 'wdc-wow-divi-carousel' ),
					'center' => esc_html__( 'Center', 'wdc-wow-divi-carousel' ),
				),
				'default_on_front' => 'center',
				'tab_slug'         => 'advanced',
				'toggle_slug'      => 'bubble',
				'show_if'          => array(
					'review_design' => 'bubble',
				),
			),
			'arrow_position_x'       => array(
				'label'          => esc_html__( 'Arrow Custom Position', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '15px',
				'default_unit'   => 'px',
				'range_settings' => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 1000,
				),
				'toggle_slug'    => 'bubble',
				'tab_slug'       => 'advanced',
				'show_if'        => array(
					'review_design'   => 'bubble',
					'arrow_placement' => array( 'left', 'right' ),
				),
			),

		);

		$bubble_bg  = $this->custom_advanced_background_fields( 'bubble', 'Bubble', 'advanced', 'bubble', array( 'color', 'gradient' ), array( 'review_design' => 'bubble' ), '#efefef' );
		$tab_fields = $this->get_tab_fields();

		$label = array(
			'admin_title' => array(
				'label'       => esc_html__( 'Admin Label', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'description' => esc_html__( 'This will change the label of the item', 'wdc-wow-divi-carousel' ),
				'toggle_slug' => 'admin_label',
			),
		);

		return array_merge( $label, $bubble_bg, $fields, $tab_fields );
	}

	public function get_advanced_fields_config() {

		$advanced_fields                = array();
		$advanced_fields['text']        = false;
		$advanced_fields['text_shadow'] = false;
		$advanced_fields['max_width']   = false;
		$advanced_fields['fonts']       = false;

		$advanced_fields['box_shadow']['item'] = array(
			'label'       => esc_html__( 'Item Box Shadow', 'wdc-wow-divi-carousel' ),
			'toggle_slug' => 'common',
			'css'         => array(
				'main'      => '%%order_class%%',
				'important' => 'all',
			),
		);

		$advanced_fields['borders']['image'] = array(
			'label_prefix' => esc_html__( 'Image', 'wdc-wow-divi-carousel' ),
			'toggle_slug'  => 'image',
			'css'          => array(
				'main'      => array(
					'border_radii'  => '%%order_class%% .wdc-testimonial-img',
					'border_styles' => '%%order_class%% .wdc-testimonial-img',
				),
				'important' => 'all',
			),
			'defaults'     => array(
				'border_radii'  => 'on|0px|0px|0px|0px',
				'border_styles' => array(
					'width' => '0px',
					'color' => '#333',
					'style' => 'solid',
				),
			),
		);

		$advanced_fields['borders']['icon'] = array(
			'label_prefix' => esc_html__( 'Icon', 'wdc-wow-divi-carousel' ),
			'toggle_slug'  => 'quote_icon',
			'css'          => array(
				'main'      => array(
					'border_radii'  => '%%order_class%% .wdc-testimonial-icon i',
					'border_styles' => '%%order_class%% .wdc-testimonial-icon i',
				),
				'important' => 'all',
			),
			'defaults'     => array(
				'border_radii'  => 'on|0px|0px|0px|0px',
				'border_styles' => array(
					'width' => '0px',
					'color' => '#333',
					'style' => 'solid',
				),
			),
		);

		$advanced_fields['borders']['item'] = array(
			'label_prefix' => esc_html__( 'Item', 'wdc-wow-divi-carousel' ),
			'toggle_slug'  => 'common',
			'css'          => array(
				'main'      => array(
					'border_radii'  => '%%order_class%% .wdc-testimonial-inner',
					'border_styles' => '%%order_class%% .wdc-testimonial-inner',
				),
				'important' => 'all',
			),
			'defaults'     => array(
				'border_radii'  => 'on|0px|0px|0px|0px',
				'border_styles' => array(
					'width' => '0px',
					'color' => '#333',
					'style' => 'solid',
				),
			),
		);

		$advanced_fields['background'] = array(
			'css' => array(
				'main'      => '%%order_class%% .wdc-testimonial-inner',
				'important' => 'all',
			),
		);

		$advanced_fields['margin_padding'] = array(
			'css' => array(
				'main'      => '%%order_class%%',
				'important' => 'all',
			),
		);

		$advanced_fields['fonts']['name'] = array(
			'label'       => esc_html__( 'Name', 'wdc-wow-divi-carousel' ),
			'css'         => array(
				'main'      => '%%order_class%% .wdc-testimonial-reviewer-text h3, .et-db #et-boc %%order_class%% .wdc-testimonial-reviewer-text h3',
				'important' => 'all',
			),
			'tab_slug'    => 'advanced',
			'toggle_slug' => 'texts',
			'sub_toggle'  => 'name',
			'line_height' => array(
				'range_settings' => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
			),
			'font_size'   => array(
				'default' => '22px',
			),
		);

		$advanced_fields['fonts']['title'] = array(
			'label'       => esc_html__( 'Title', 'wdc-wow-divi-carousel' ),
			'css'         => array(
				'main'      => '%%order_class%% .wdc-testimonial-reviewer-text p',
				'important' => 'all',
			),
			'tab_slug'    => 'advanced',
			'toggle_slug' => 'texts',
			'sub_toggle'  => 'title',
			'line_height' => array(
				'range_settings' => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
			),
			'font_size'   => array(
				'default' => '14px',
			),
		);

		$advanced_fields['fonts']['review'] = array(
			'label'       => esc_html__( 'Review', 'wdc-wow-divi-carousel' ),
			'css'         => array(
				'main'      => '%%order_class%% .wdc-testimonial-review p, .et-db #et-boc %%order_class%% .wdc-testimonial-review p',
				'important' => 'all',
			),
			'tab_slug'    => 'advanced',
			'toggle_slug' => 'texts',
			'sub_toggle'  => 'review',
			'line_height' => array(
				'range_settings' => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
			),
			'font_size'   => array(
				'default' => '14px',
			),
		);

		return $advanced_fields;
	}

	public function render_rating( $pos ) {

		$ratings_position = $this->props['ratings_position'];
		$use_rating       = $this->props['use_rating'];
		$rating           = intval( $this->props['rating'] );
		$html             = '';

		for ( $i = 0; $i < $rating; $i++ ) {
			$html = $html . '<span>★</span>';
		}

		if ( 'on' === $use_rating && $ratings_position === $pos ) {
			return sprintf(
				'<div class="wdc-testimonial-rating">
                    %1$s
                </div>',
				$html
			);
		}

	}

	public function render_quote_icon( $class ) {

		$selected_icon   = $this->props['selected_icon'];
		$hide_quote      = $this->props['hide_quote'];
		$use_custom_icon = $this->props['use_custom_icon'];
		$icon            = '<i class="wdc-ico-quote"></i>';

		if ( 'off' === $use_custom_icon ) {
			$icon = '<i class="wdc-ico-quote-' . $selected_icon . '"></i>';
		}

		if ( 'off' === $hide_quote ) {
			return sprintf(
				'<div class="wdc-testimonial-icon %1$s">
                %2$s
            </div> ',
				$class,
				$icon
			);
		}
	}

	public function render_review() {

		$testimonial      = $this->props['testimonial'];
		$testimonial_html = sprintf( '<p>%1$s</p>', $testimonial );
		$icon_placement   = $this->props['icon_placement'];

		return sprintf(
			'<div class="wdc-testimonial-review">%2$s %1$s</div>',
			! empty( $testimonial ) ? $testimonial_html : '',
			'__default' === $icon_placement ? $this->render_quote_icon( 'wdc-icon-default' ) : ''
		);

	}

	public function render_module_image() {

		$image         = $this->props['image'];
		$image_alt     = $this->props['image_alt'];
		$parent_module = self::get_parent_modules( 'page' )['wdc_testimonial_carousel'];
		$is_lazyload   = $parent_module->shortcode_atts['is_lazyload'];

		if ( ! empty( $image ) ) {
			return sprintf(
				'<figure class="wdc-testimonial-img"><img class="wdc-img-cover" %2$s="%1$s" alt="%3$s" /></figure>',
				$image,
				'on' === $is_lazyload ? 'data-lazy' : 'src',
				$image_alt
			);
		}

	}

	public function render_reviewer( $pos ) {

		$reviewer_position = $this->props['reviewer_position'];
		$use_img_top       = $this->props['use_img_top'];
		$name              = $this->props['name'];
		$title             = $this->props['title'];
		$link_target       = $this->props['link_option_url_new_window'];
		$company_url       = $this->props['company_url'];
		$website_url       = $this->props['website_url'];
		$name_html         = '';
		$title_html        = '';

		if ( ! empty( $name ) ) {
			if ( ! empty( $website_url ) ) {
				$name_html = sprintf( '<a href="%2$s" target="%3$s"><h3>%1$s</h3></a>', $name, $website_url, $link_target );
			} else {
				$name_html = sprintf( '<h3>%1$s</h3>', $name );
			}
		}

		if ( ! empty( $title ) ) {
			if ( ! empty( $company_url ) ) {
				$title_html = sprintf( '<a href="%2$s" target="%3$s"><p>%1$s</p></a>', $title, $company_url, $link_target );
			} else {
				$title_html = sprintf( '<p>%1$s</p>', $title );
			}
		}

		if ( $reviewer_position === $pos ) {
			return sprintf(
				'<div class="wdc-testimonial-reviewer">
                    %1$s
                    <div class="wdc-testimonial-reviewer-text">
                        %2$s %3$s %4$s
                    </div>
                </div>',
				'off' === $use_img_top ? $this->render_module_image() : '',
				$name_html,
				$title_html,
				$this->render_rating( 'reviewer' )
			);
		}

	}

	public function render( $attrs, $content, $render_slug ) {

		global $wdc_testimonial_child;
		global $wdc_uid_testimonial;

		if ( empty( $wdc_uid_testimonial ) && 0 !== $wdc_uid_testimonial ) {
			$wdc_uid_testimonial = 0;
		}

		$wdc_testimonial_child[ $wdc_uid_testimonial ][] = array(
			'tab_title'    => ! empty( $this->props['tab_title'] ) ? $this->props['tab_title'] : $this->props['name'],
			'tab_subtitle' => ! empty( $this->props['tab_subtitle'] ) ? $this->props['tab_subtitle'] : $this->props['title'],
			'tab_thumb'    => ! empty( $this->props['tab_thumb'] ) ? $this->props['tab_thumb'] : $this->props['image'],
		);

		$icon_placement = $this->props['icon_placement'];
		$image_position = $this->props['image_position'];
		$use_img_top    = $this->props['use_img_top'];

		$this->apply_css( $render_slug );
		$this->remove_classname( 'et_pb_module' );
		$this->add_classname( 'wdc_et_pb_module' );

		return sprintf(
			'<div class="wdc-carousel-item wdc-testimonial-item">
                %2$s %4$s
                <div class="wdc-testimonial-inner wdc-bg-support wdc-img-%1$s">
                     %3$s
                    <div class="wdc-testimonial-content">
                        %5$s %6$s %7$s
                        <div class="wdc-item-base">
                            %8$s %9$s
                        </div>
                    </div>
                </div>
			</div>',
			$image_position,
			'absolute' === $icon_placement ? $this->render_quote_icon( 'wdc-icon-absolute' ) : '',
			'background' === $icon_placement ? $this->render_quote_icon( 'wdc-icon-bg' ) : '',
			'on' === $use_img_top ? $this->render_module_image() : '',
			$this->render_reviewer( 'top' ),
			$this->render_rating( 'default' ),
			$this->render_review(),
			$this->render_reviewer( 'bottom' ),
			$this->render_rating( 'bottom' )
		);
	}


	public function apply_css( $render_slug ) {

		$image_width                       = $this->props['image_width'];
		$image_width_tablet                = $this->props['image_width_tablet'];
		$image_width_phone                 = $this->props['image_width_phone'];
		$image_width_last_edited           = $this->props['image_width_last_edited'];
		$image_width_responsive_status     = et_pb_get_responsive_status( $image_width_last_edited );
		$image_height                      = $this->props['image_height'];
		$image_height_tablet               = $this->props['image_height_tablet'];
		$image_height_phone                = $this->props['image_height_phone'];
		$image_height_last_edited          = $this->props['image_height_last_edited'];
		$image_height_responsive_status    = et_pb_get_responsive_status( $image_height_last_edited );
		$alignment                         = $this->props['alignment'];
		$image_spacing                     = $this->props['image_spacing'];
		$image_spacing_top                 = $this->props['image_spacing_top'];
		$image_spacing_bottom              = $this->props['image_spacing_bottom'];
		$ratings_spacing_top               = $this->props['ratings_spacing_top'];
		$ratings_spacing_bottom            = $this->props['ratings_spacing_bottom'];
		$title_bottom_spacing              = $this->props['title_bottom_spacing'];
		$stars_size                        = $this->props['stars_size'];
		$stars_color                       = $this->props['stars_color'];
		$stars_spacing_between             = $this->props['stars_spacing_between'];
		$name_bottom_spacing               = $this->props['name_bottom_spacing'];
		$review_bottom_spacing             = $this->props['review_bottom_spacing'];
		$review_top_spacing                = $this->props['review_top_spacing'];
		$content_padding                   = $this->props['content_padding'];
		$content_padding_tablet            = $this->props['content_padding_tablet'];
		$content_padding_phone             = $this->props['content_padding_phone'];
		$content_padding_last_edited       = $this->props['content_padding_last_edited'];
		$content_padding_responsive_status = et_pb_get_responsive_status( $content_padding_last_edited );
		$icon_alignment                    = $this->props['icon_alignment'];
		$use_custom_icon                   = $this->props['use_custom_icon'];
		$icon_img                          = $this->props['icon_img'];
		$icon_color                        = $this->props['icon_color'];
		$icon_size                         = $this->props['icon_size'];
		$icon_bg                           = $this->props['icon_bg'];
		$icon_top_spacing                  = $this->props['icon_top_spacing'];
		$icon_bottom_spacing               = $this->props['icon_bottom_spacing'];
		$icon_padding                      = $this->props['icon_padding'];
		$icon_opacity                      = $this->props['icon_opacity'];
		$icon_placement                    = $this->props['icon_placement'];
		$icon_pos_y                        = $this->props['icon_pos_y'];
		$icon_pos_x                        = $this->props['icon_pos_x'];
		$use_img_top                       = $this->props['use_img_top'];
		$custom_margin                     = $this->props['custom_margin'];
		$custom_padding                    = $this->props['custom_padding'];
		$image_position                    = $this->props['image_position'];
		$img_offset_x                      = $this->props['img_offset_x'];
		$img_offset_y                      = $this->props['img_offset_y'];
		$image_placement                   = $this->props['image_placement'];
		$image__placement                  = explode( '_', $image_placement );

		if ( 'on' === $use_img_top ) {
			$content_padding = ! empty( $content_padding ) ? $content_padding : '60px|20px|20px|20px';
		} else {
			$content_padding = ! empty( $content_padding ) ? $content_padding : '20px|20px|20px|20px';
		}

		$this->get_responsive_styles(
			'alignment',
			'%%order_class%% .wdc-testimonial-item *',
			array( 'primary' => 'text-align' ),
			array( 'default' => 'center' ),
			$render_slug
		);

		if ( 'on' === $use_img_top || 'absolute' === $icon_placement ) {
			if ( empty( $custom_margin ) && empty( $custom_padding ) ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%%',
						'declaration' => 'padding-top:60px!important;padding-bottom:60px!important;',
					)
				);
			}
		}

		// Content padding.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-testimonial-content',
				'declaration' => WDC_Builder_Module::wdc_process_padding( $content_padding, false ),
			)
		);

		// Content padding tablet.
		if ( $content_padding_tablet && $content_padding_responsive_status ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-testimonial-content',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					'declaration' => WDC_Builder_Module::wdc_process_padding( $content_padding_tablet, false ),
				)
			);
		}

		// Content padding phone.
		if ( $content_padding_phone && $content_padding_responsive_status ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-testimonial-content',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					'declaration' => WDC_Builder_Module::wdc_process_padding( $content_padding_phone, false ),
				)
			);
		}

		// Quote Icon.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-testimonial-inner .wdc-testimonial-icon',
				'declaration' => sprintf( 'text-align: %1$s!important;', $icon_alignment ),
			)
		);

		if ( 'right' === $icon_alignment ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-testimonial-inner .wdc-testimonial-icon',
					'declaration' => sprintf( 'justify-content: flex-end!important;' ),
				)
			);

		} elseif ( 'center' === $icon_alignment ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-testimonial-inner .wdc-testimonial-icon',
					'declaration' => sprintf( 'justify-content: center!important;' ),
				)
			);
		}

		if ( 'off' === $use_custom_icon ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-testimonial-icon i',
					'declaration' => sprintf(
						'
                    color: %1$s;
                    font-size: %2$s;
                    background: %3$s;
                    %4$s
                    opacity: %5$s;',
						$icon_color,
						$icon_size,
						$icon_bg,
						$this->wdc_process_padding( $icon_padding, false ),
						$icon_opacity
					),
				)
			);
		} else {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-testimonial-icon i',
					'declaration' => sprintf(
						'
                    width: %1$s;
                    height: %1$s;
                    background-color: %2$s;
                    opacity: %3$s;
                    background-image: url(%4$s);
                    background-position: center;
                    background-repeat: no-repeat;
                    background-size: contain;',
						$icon_size,
						$icon_bg,
						$icon_opacity,
						$icon_img
					),
				)
			);
		}

		if ( 'absolute' !== $icon_placement ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-testimonial-icon i',
					'declaration' => sprintf(
						'margin-top: %1$s;margin-bottom: %2$s;',
						$icon_top_spacing,
						$icon_bottom_spacing
					),
				)
			);
		} else {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-icon-absolute',
					'declaration' => sprintf( 'top: %1$s; left: %2$s;', $icon_pos_y, $icon_pos_x ),
				)
			);
		}

		// Image.
		if ( 'on' === $use_img_top ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-testimonial-img',
					'declaration' => 'position: absolute; z-index: 99;',
				)
			);

			// image offset X.
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-testimonial-img',
					'declaration' => sprintf( '%1$s: %2$s;', $image__placement[0], $img_offset_x ),
				)
			);

			// image offset Y.
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-testimonial-img',
					'declaration' => sprintf( '%1$s: %2$s;', $image__placement[1], $img_offset_y ),
				)
			);

			if ( 'right_top' === $image_placement ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-testimonial-img',
						'declaration' => 'transform : translateX(50%) translateY(-50%);',
					)
				);
			} elseif ( 'right_bottom' === $image_placement ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-testimonial-img',
						'declaration' => 'transform : translateX(50%) translateY(50%);',
					)
				);
			} elseif ( 'left_bottom' === $image_placement ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-testimonial-img',
						'declaration' => 'transform : translateX(-50%) translateY(50%);',
					)
				);
			} elseif ( 'left_top' === $image_placement ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-testimonial-img',
						'declaration' => 'transform : translateX(-50%) translateY(-50%);',
					)
				);
			}
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-testimonial-img',
				'declaration' => sprintf( 'height: %1$s;', $image_height ),
			)
		);

		// image height Tablet.
		if ( $image_height_tablet && $image_height_responsive_status ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-testimonial-img',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					'declaration' => sprintf( 'height: %1$s;', $image_height_tablet ),
				)
			);
		}

		// image height phone.
		if ( $image_height_phone && $image_height_responsive_status ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-testimonial-img',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					'declaration' => sprintf( 'height: %1$s;', $image_height_phone ),
				)
			);
		}

		// image width.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-testimonial-img',
				'declaration' => sprintf( 'width: %1$s; max-width: %1$s; flex: 0 0 %1$s;', $image_width ),
			)
		);

		// image width Tablet.
		if ( $image_width_tablet && $image_width_responsive_status ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-testimonial-img',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					'declaration' => sprintf( 'width: %1$s;max-width: %1$s; flex: 0 0 %1$s;', $image_width_tablet ),
				)
			);
		}

		// image width phone.
		if ( $image_width_phone && $image_width_responsive_status ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-testimonial-img',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					'declaration' => sprintf( 'width: %1$s;max-width: %1$s; flex: 0 0 %1$s;', $image_width_phone ),
				)
			);
		}

		// Image spacing.
		if ( 'on' !== $use_img_top ) {
			if ( 'top' === $image_position ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-testimonial-img',
						'declaration' => sprintf( 'margin-bottom: %1$s; margin-top: %2$s;', $image_spacing_bottom, $image_spacing_top ),
					)
				);
			} elseif ( 'left' === $image_position ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-testimonial-img',
						'declaration' => sprintf( 'margin-right: %1$s;', $image_spacing ),
					)
				);
			} elseif ( 'right' === $image_position ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-testimonial-img',
						'declaration' => sprintf( 'margin-left: %1$s;', $image_spacing ),
					)
				);
			}
		}

		// ratings.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-testimonial-rating',
				'declaration' => sprintf( 'padding-bottom: %1$s; padding-top: %2$s;', $ratings_spacing_bottom, $ratings_spacing_top ),
			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-testimonial-rating span',
				'declaration' => sprintf( 'color: %1$s; font-size: %2$s;', $stars_color, $stars_size ),
			)
		);

		if ( 'center' === $alignment ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-testimonial-rating span',
					'declaration' => sprintf( 'margin: 0 calc(%1$s / 2);', $stars_spacing_between ),
				)
			);
		} elseif ( 'right' === $alignment ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-testimonial-rating span',
					'declaration' => sprintf( 'margin-left: %1$s;', $stars_spacing_between ),
				)
			);
		} else {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-testimonial-rating span',
					'declaration' => sprintf( 'margin-right: %1$s;', $stars_spacing_between ),
				)
			);
		}

		// Text.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-testimonial-reviewer-text h3',
				'declaration' => sprintf( 'padding-bottom: %1$s;', $name_bottom_spacing ),
			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-testimonial-reviewer-text p',
				'declaration' => sprintf( 'padding-bottom: %1$s;', $title_bottom_spacing ),
			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-testimonial-review',
				'declaration' => sprintf( 'margin-bottom: %1$s; margin-top: %2$s;', $review_bottom_spacing, $review_top_spacing ),
			)
		);

				// Bubble.
				$review_design     = $this->props['review_design'];
				$bubble_padding    = $this->props['bubble_padding'];
				$arrow_color       = $this->props['arrow_color'];
				$arrow_placement   = $this->props['arrow_placement'];
				$arrow_position_x  = $this->props['arrow_position_x'];
				$reviewer_position = $this->props['reviewer_position'];
				$bubble_radius     = explode( '|', $this->props['bubble_radius'] );

		if ( 'bubble' === $review_design ) {
			$this->get_custom_bg_style( $render_slug, 'bubble', '%%order_class%% .wdc-testimonial-review', '%%order_class%%:hover .wdc-testimonial-review' );

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-testimonial-review',
					'declaration' => sprintf(
						'
                            position: relative;
                            border-radius: %1$s %2$s %3$s %4$s;
                            %5$s',
						$bubble_radius[1],
						$bubble_radius[2],
						$bubble_radius[3],
						$bubble_radius[4],
						$this->wdc_process_padding( $bubble_padding, false )
					),
				)
			);

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-testimonial-review:after',
					'declaration' => 'content: ""; width: 0;height: 0;position: absolute;border-style: solid;',
				)
			);

			if ( 'bottom' === $reviewer_position ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-testimonial-review:after',
						'declaration' => sprintf(
							'
                                border-width: 13px 13px 0 13px;
                                border-color: %1$s transparent transparent transparent;
                                top: 100%%;',
							$arrow_color
						),
					)
				);
			} elseif ( 'top' === $reviewer_position ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-testimonial-review:after',
						'declaration' => sprintf(
							'
                                border-width: 0 13px 13px 13px;
                                border-color: transparent transparent %1$s transparent;
                                bottom: 100%%;',
							$arrow_color
						),
					)
				);
			}

			if ( 'left' === $arrow_placement ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-testimonial-review:after',
						'declaration' => 'left:' . $arrow_position_x . ';',
					)
				);
			} elseif ( 'right' === $arrow_placement ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-testimonial-review:after',
						'declaration' => 'right:' . $arrow_position_x . ';',
					)
				);
			} elseif ( 'center' === $arrow_placement ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-testimonial-review:after',
						'declaration' => 'left: 50%; transform: translateX(-13px);',
					)
				);
			}
		}

	}
}

new WDC_TestimonialCarouselChild();
