<?php
class WDC_TeamCarouselChild extends WDC_Builder_Module {

	public $slug       = 'wdc_team_carousel_child';
	public $vb_support = 'on';
	public $type       = 'child';

	public function init() {
		$this->name                     = esc_html__( 'Team', 'wdc-wow-divi-carousel' );
		$this->child_title_var          = 'admin_title';
		$this->child_title_fallback_var = 'member_name';

		$this->settings_modal_toggles = array(
			'general'  => array(
				'toggles' => array(
					'content'     => array(
						'title' => esc_html__( 'Content', 'wdc-wow-divi-carousel' ),
					),
					'links'       => array(
						'title' => esc_html__( 'Social Links', 'wdc-wow-divi-carousel' ),
					),
					'tab_content' => array(
						'title' => esc_html__( 'Tab Content', 'wdc-wow-divi-carousel' ),
					),
				),
			),

			'advanced' => array(
				'toggles' => array(
					'common'  => array(
						'title' => esc_html__( 'Common', 'wdc-wow-divi-carousel' ),
					),
					'photo'   => array(
						'title' => esc_html__( 'Photo', 'wdc-wow-divi-carousel' ),
					),
					'overlay' => array(
						'title' => esc_html__( 'Overlay', 'wdc-wow-divi-carousel' ),
					),
					'text'    => array(
						'title'             => esc_html__( 'Texts', 'wdc-wow-divi-carousel' ),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'name'      => array(
								'name' => esc_html__( 'Name', 'wdc-wow-divi-carousel' ),
							),
							'job_title' => array(
								'name' => esc_html__( 'Job Title', 'wdc-wow-divi-carousel' ),
							),
							'short_bio' => array(
								'name' => esc_html__( 'Bio', 'wdc-wow-divi-carousel' ),
							),
						),
					),
					'links'   => array(
						'title' => esc_html__( 'Social Links', 'wdc-wow-divi-carousel' ),
					),
				),
			),
		);
	}

	public function get_fields() {

		$fields = array(

			'photo'                 => array(
				'label'              => esc_html__( 'Photo', 'wdc-wow-divi-carousel' ),
				'type'               => 'upload',
				'option_category'    => 'basic_option',
				'upload_button_text' => esc_attr__( 'Upload an image', 'wdc-wow-divi-carousel' ),
				'choose_text'        => esc_attr__( 'Choose an Image', 'wdc-wow-divi-carousel' ),
				'update_text'        => esc_attr__( 'Set As Image', 'wdc-wow-divi-carousel' ),
				'toggle_slug'        => 'content',
				'mobile_options'     => true,
				'hover'              => 'tabs',
				'dynamic_content'    => 'image',
			),

			'photo_alt'             => array(
				'label'       => esc_html__( 'Photo Alt Text', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'content',
			),

			'member_name'           => array(
				'label'       => esc_html__( 'Member Name', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'content',
			),

			'job_title'             => array(
				'label'       => esc_html__( 'Job Title', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'content',
			),

			'short_bio'             => array(
				'label'       => esc_html__( 'Member Bio', 'wdc-wow-divi-carousel' ),
				'type'        => 'textarea',
				'toggle_slug' => 'content',
			),

			// Social Links.
			'website'               => array(
				'label'       => esc_html__( 'Website URL', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'links',
			),

			'email'                 => array(
				'label'       => esc_html__( 'Email Address', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'links',
			),

			'facebook'              => array(
				'label'       => esc_html__( 'Facebook URL', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'links',
			),

			'twitter'               => array(
				'label'       => esc_html__( 'Twitter URL', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'links',
			),

			'instagram'             => array(
				'label'       => esc_html__( 'Instagram URL', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'links',
			),

			'linkedin'              => array(
				'label'       => esc_html__( 'Linkedin URL', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'links',
			),

			'github'                => array(
				'label'       => esc_html__( 'Github URL', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'links',
			),

			'behance'               => array(
				'label'       => esc_html__( 'Behance URL', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'links',
			),

			'dribbble'              => array(
				'label'       => esc_html__( 'Dribbble URL', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'links',
			),

			'phone'                 => array(
				'label'       => esc_html__( 'Phone', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'links',
			),

			// photo.
			'image_width'           => array(
				'label'          => esc_html__( 'Image Width', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => 'auto',
				'mobile_options' => true,
				'default_unit'   => 'px',
				'range_settings' => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 1000,
				),
				'toggle_slug'    => 'photo',
				'tab_slug'       => 'advanced',
			),

			'image_height'          => array(
				'label'          => esc_html__( 'Image Height', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => 'auto',
				'mobile_options' => true,
				'default_unit'   => 'px',
				'range_settings' => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 1000,
				),
				'toggle_slug'    => 'photo',
				'tab_slug'       => 'advanced',
			),

			'image_alignment'       => array(
				'label'            => esc_html__( 'Image Alignment', 'wdc-wow-divi-carousel' ),
				'type'             => 'text_align',
				'option_category'  => 'layout',
				'options'          => et_builder_get_text_orientation_options( array( 'justified' ) ),
				'options_icon'     => 'module_align',
				'default_on_front' => 'left',
				'toggle_slug'      => 'photo',
				'tab_slug'         => 'advanced',
			),

			'image_hover_animation' => array(
				'label'       => esc_html__( 'Hover Animation', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'photo',
				'default'     => 'none',
				'options'     => array(
					'none'         => esc_html__( 'None', 'wdc-wow-divi-carousel' ),
					'zoom-in'      => esc_html__( 'Zoom In', 'wdc-wow-divi-carousel' ),
					'zoom-out'     => esc_html__( 'Zoom Out', 'wdc-wow-divi-carousel' ),
					'pulse'        => esc_html__( 'Pulse', 'wdc-wow-divi-carousel' ),
					'bounce'       => esc_html__( 'Bounce', 'wdc-wow-divi-carousel' ),
					'flash'        => esc_html__( 'Flash', 'wdc-wow-divi-carousel' ),
					'rubberBand'   => esc_html__( 'Rubber Band', 'wdc-wow-divi-carousel' ),
					'shake'        => esc_html__( 'Shake', 'wdc-wow-divi-carousel' ),
					'swing'        => esc_html__( 'Swing', 'wdc-wow-divi-carousel' ),
					'tada'         => esc_html__( 'Tada', 'wdc-wow-divi-carousel' ),
					'wobble'       => esc_html__( 'Wobble', 'wdc-wow-divi-carousel' ),
					'jello'        => esc_html__( 'Jello', 'wdc-wow-divi-carousel' ),
					'heartBeat'    => esc_html__( 'Heart Beat', 'wdc-wow-divi-carousel' ),
					'bounceIn'     => esc_html__( 'Bounce In', 'wdc-wow-divi-carousel' ),
					'fadeIn'       => esc_html__( 'Fade In', 'wdc-wow-divi-carousel' ),
					'flip'         => esc_html__( 'Flip', 'wdc-wow-divi-carousel' ),
					'lightSpeedIn' => esc_html__( 'Light Speed In', 'wdc-wow-divi-carousel' ),
					'rotateIn'     => esc_html__( 'Rotate In', 'wdc-wow-divi-carousel' ),
					'slideInUp'    => esc_html__( 'Slide In Up', 'wdc-wow-divi-carousel' ),
					'slideInDown'  => esc_html__( 'Slide In Down', 'wdc-wow-divi-carousel' ),
				),
			),

			'image_spacing_bottom'  => array(
				'label'           => esc_html__( 'Image Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '15px',
				'option_category' => 'basic_option',
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'photo',
				'tab_slug'        => 'advanced',
			),

			// settings.
			'content_alignment'     => array(
				'label'            => esc_html__( 'Content Alignment', 'wdc-wow-divi-carousel' ),
				'type'             => 'text_align',
				'option_category'  => 'layout',
				'options'          => et_builder_get_text_orientation_options( array( 'justified' ) ),
				'options_icon'     => 'module_align',
				'default_on_front' => 'left',
				'toggle_slug'      => 'common',
				'tab_slug'         => 'advanced',
			),

			'content_padding'       => array(
				'label'          => esc_html__( 'Content Padding', 'wdc-wow-divi-carousel' ),
				'type'           => 'custom_padding',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'common',
				'default'        => '0px|0px|0px|0px',
				'mobile_options' => true,
			),

			// social links.
			'links_position'        => array(
				'label'       => esc_html__( 'Position', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'links',
				'default'     => 'bottom',
				'options'     => array(
					'top'    => esc_html__( 'Top', 'wdc-wow-divi-carousel' ),
					'center' => esc_html__( 'Center', 'wdc-wow-divi-carousel' ),
					'bottom' => esc_html__( 'Bottom', 'wdc-wow-divi-carousel' ),
				),
			),

			'social_icon_color'     => array(
				'label'       => esc_html__( 'Icon Color', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'links',
				'default'     => '#333',
				'hover'       => 'tabs',
			),

			'links_bg'              => array(
				'label'       => esc_html__( 'Background', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'links',
				'default'     => '#e5e5e5',
				'hover'       => 'tabs',
			),

			'links_margin_between'  => array(
				'label'           => esc_html__( 'Spacing Between', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'default'         => '5px',
				'range_settings'  => array(
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				),
				'toggle_slug'     => 'links',
				'tab_slug'        => 'advanced',
			),

			'links_margin_top'      => array(
				'label'           => esc_html__( 'Top Spacing', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'default'         => '15px',
				'range_settings'  => array(
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				),
				'toggle_slug'     => 'links',
				'tab_slug'        => 'advanced',
			),

			'links_margin_bottom'   => array(
				'label'           => esc_html__( 'Bottom Spacing', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'default'         => '15px',
				'range_settings'  => array(
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				),
				'toggle_slug'     => 'links',
				'tab_slug'        => 'advanced',
			),

			'links_height'          => array(
				'label'           => esc_html__( 'Height', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'default'         => '36px',
				'range_settings'  => array(
					'min'  => 10,
					'max'  => 100,
					'step' => 1,
				),
				'toggle_slug'     => 'links',
				'tab_slug'        => 'advanced',
			),

			'links_width'           => array(
				'label'           => esc_html__( 'Width', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'default'         => '36px',
				'range_settings'  => array(
					'min'  => 10,
					'max'  => 100,
					'step' => 1,
				),
				'toggle_slug'     => 'links',
				'tab_slug'        => 'advanced',
			),

			'links_icon_size'       => array(
				'label'           => esc_html__( 'Icon Size', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'default'         => '16px',
				'range_settings'  => array(
					'min'  => 10,
					'max'  => 100,
					'step' => 1,
				),
				'toggle_slug'     => 'links',
				'tab_slug'        => 'advanced',
			),

			'links_radius'          => array(
				'label'           => esc_html__( 'Border Radius', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'default'         => '4px',
				'validate_unit'   => true,
				'units'           => array( 'px', '%', 'em', 'rem' ),
				'range_settings'  => array(
					'min'  => 0,
					'max'  => 200,
					'step' => 1,
				),
				'toggle_slug'     => 'links',
				'tab_slug'        => 'advanced',
			),

			// Texts.
			'name_bottom_spacing'   => array(
				'label'           => esc_html__( 'Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '0px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'text',
				'tab_slug'        => 'advanced',
				'sub_toggle'      => 'name',
			),

			'job_bottom_spacing'    => array(
				'label'           => esc_html__( 'Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '0px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'text',
				'tab_slug'        => 'advanced',
				'sub_toggle'      => 'job_title',
			),
		);

		$tab_fields = $this->get_tab_fields();
		$overlay    = $this->get_overlay_option_fields( 'overlay', array() );

		$label = array(
			'admin_title' => array(
				'label'       => esc_html__( 'Admin Label', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'description' => esc_html__( 'This will change the label of the item', 'wdc-wow-divi-carousel' ),
				'toggle_slug' => 'admin_label',
			),
		);

		return array_merge( $label, $fields, $overlay, $tab_fields );

	}

	public function get_advanced_fields_config() {

		$advanced_fields                = array();
		$advanced_fields['text']        = false;
		$advanced_fields['borders']     = false;
		$advanced_fields['text_shadow'] = false;
		$advanced_fields['fonts']       = false;

		$advanced_fields['fonts']['name'] = array(
			'label'           => esc_html__( 'Name', 'wdc-wow-divi-carousel' ),
			'css'             => array(
				'main'      => '%%order_class%% .wdc-team-content h3, .et-db #et-boc %%order_class%% .wdc-team-content h3',
				'important' => 'all',
			),
			'important'       => 'all',
			'hide_text_align' => true,
			'tab_slug'        => 'advanced',
			'toggle_slug'     => 'text',
			'sub_toggle'      => 'name',
			'line_height'     => array(
				'range_settings' => array(
					'min'  => '1',
					'max'  => '3',
					'step' => '.1',
				),
			),
			'font_size'       => array(
				'default' => '22px',
			),
		);

		$advanced_fields['fonts']['job_title'] = array(
			'label'           => esc_html__( 'Job Title', 'wdc-wow-divi-carousel' ),
			'css'             => array(
				'main'      => '%%order_class%% .wdc-team-content .wdc-job-title, .et-db #et-boc %%order_class%% .wdc-team-content .wdc-job-title',
				'important' => 'all',
			),
			'important'       => 'all',
			'hide_text_align' => true,
			'tab_slug'        => 'advanced',
			'toggle_slug'     => 'text',
			'sub_toggle'      => 'job_title',
			'line_height'     => array(
				'range_settings' => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
			),
			'font_size'       => array(
				'default' => '14px',
			),
		);

		$advanced_fields['fonts']['short_bio'] = array(
			'label'           => esc_html__( 'Bio', 'wdc-wow-divi-carousel' ),
			'css'             => array(
				'main'      => '%%order_class%% .wdc-team-content p, .et-db #et-boc %%order_class%% .wdc-team-content p',
				'important' => 'all',
			),
			'important'       => 'all',
			'hide_text_align' => true,
			'tab_slug'        => 'advanced',
			'toggle_slug'     => 'text',
			'sub_toggle'      => 'short_bio',
			'line_height'     => array(
				'range_settings' => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
			),
			'font_size'       => array(
				'default' => '14px',
			),
		);

		$advanced_fields['margin_padding'] = array(
			'css' => array(
				'main'      => '%%order_class%% .wdc-team',
				'important' => 'all',
			),
		);

		$advanced_fields['background'] = array(
			'css' => array(
				'main'      => '%%order_class%% .wdc-team',
				'important' => 'all',
			),
		);

		$advanced_fields['borders']['item'] = array(
			'label_prefix' => esc_html__( 'Item', 'wdc-wow-divi-carousel' ),
			'toggle_slug'  => 'common',
			'css'          => array(
				'main'      => array(
					'border_radii'  => '%%order_class%% .wdc-team',
					'border_styles' => '%%order_class%% .wdc-team',
				),
				'important' => 'all',
			),
			'defaults'     => array(
				'border_radii'  => 'on|0px|0px|0px|0px',
				'border_styles' => array(
					'width' => '0px',
					'color' => '#333',
					'style' => 'solid',
				),
			),
		);

		$advanced_fields['borders']['photo'] = array(
			'label_prefix' => esc_html__( 'Photo', 'wdc-wow-divi-carousel' ),
			'toggle_slug'  => 'photo',
			'css'          => array(
				'main'      => array(
					'border_radii'  => '%%order_class%% .wdc-team figure',
					'border_styles' => '%%order_class%% .wdc-team figure',
				),
				'important' => 'all',
			),
			'defaults'     => array(
				'border_radii'  => 'on|0px|0px|0px|0px',
				'border_styles' => array(
					'width' => '0px',
					'color' => '#333',
					'style' => 'solid',
				),
			),
		);

		return $advanced_fields;
	}

	public function render_figure() {

		$photo         = $this->props['photo'];
		$photo_alt     = $this->props['photo_alt'];
		$data_schema   = $this->get_swapped_img_schema( 'photo' );
		$parent_module = self::get_parent_modules( 'page' )['wdc_team_carousel'];
		$is_lazyload   = $parent_module->shortcode_atts['is_lazyload'];

		return sprintf(
			'<img class="wdc-swapped-img" data-mfp-src="%1$s" %3$s="%1$s"  %2$s alt="%4$s"/>',
			$photo,
			$data_schema,
			'on' === $is_lazyload ? 'data-lazy' : 'src',
			$photo_alt
		);
	}

	public function render_name() {

		if ( ! empty( $this->props['member_name'] ) ) {
			return sprintf( '<h3>%1$s</h3>', $this->props['member_name'] );
		}

	}

	public function render_job_title() {

		if ( ! empty( $this->props['job_title'] ) ) {
			return sprintf( '<div class="wdc-job-title">%1$s</div>', $this->props['job_title'] );
		}
	}

	public function render_bio() {
		if ( ! empty( $this->props['short_bio'] ) ) {
			return sprintf( '<p>%1$s</p>', $this->props['short_bio'] );
		}
	}

	public function render_links( $position ) {

		$links = array(
			array(
				'type' => 'website',
				'name' => 'Website',
				'icon' => 'website',
			),
			array(
				'type' => 'email',
				'name' => 'Email',
				'icon' => 'email',
			),
			array(
				'type' => 'facebook',
				'name' => 'Facebook',
				'icon' => 'facebook',
			),
			array(
				'type' => 'twitter',
				'name' => 'Twitter',
				'icon' => 'twitter',
			),
			array(
				'type' => 'linkedin',
				'name' => 'Linkedin',
				'icon' => 'linkedin',
			),
			array(
				'type' => 'instagram',
				'name' => 'Instagram',
				'icon' => 'instagram',
			),
			array(
				'type' => 'github',
				'name' => 'Github',
				'icon' => 'github',
			),
			array(
				'type' => 'behance',
				'name' => 'Behance',
				'icon' => 'behance',
			),
			array(
				'type' => 'dribbble',
				'name' => 'Dribbble',
				'icon' => 'dribbble',
			),
			array(
				'type' => 'phone',
				'name' => 'Phone',
				'icon' => 'phone',
			),
		);

		$html           = '';
		$is_empty       = true;
		$links_position = $this->props['links_position'];

		foreach ( $links as $item ) {

			if ( ! empty( $this->props[ $item['type'] ] ) ) {

				$href_prefix = '';
				$is_empty    = false;

				if ( 'email' === $item['type'] ) {
					$href_prefix = 'mailto:';
				} elseif ( 'phone' === $item['type'] ) {
					$href_prefix = 'tel:';
				}

				$html = $html . sprintf(
					'<li><a class="wdc-icon wdc-ico-%1$s" href="%3$s%2$s"></a></li>',
					$item['icon'],
					$this->props[ $item['type'] ],
					$href_prefix
				);

			}
		}

		if ( ! $is_empty ) {
			if ( $position === $links_position ) {
				return sprintf( '<ul class="wdc-team-social item-%1$s">%2$s</ul>', $this->props['content_alignment'], $html );
			}
		}
	}

	public function render( $attrs, $content, $render_slug ) {

		global $wdc_team_child;
		global $wdc_uid_team;

		if ( empty( $wdc_uid_team ) && 0 !== $wdc_uid_team ) {
			$wdc_uid_team = 0;
		}

		$wdc_team_child[ $wdc_uid_team ][] = array(
			'tab_title'    => ! empty( $this->props['tab_title'] ) ? $this->props['tab_title'] : $this->props['member_name'],
			'tab_subtitle' => ! empty( $this->props['tab_subtitle'] ) ? $this->props['tab_subtitle'] : $this->props['job_title'],
			'tab_thumb'    => ! empty( $this->props['tab_thumb'] ) ? $this->props['tab_thumb'] : $this->props['photo'],
		);

		$this->remove_classname( 'et_pb_module' );
		$this->add_classname( 'wdc_et_pb_module' );
		$this->apply_css( $render_slug );

		$processed_overlay_icon = esc_attr( et_pb_process_font_icon( $this->props['overlay_icon'] ) );
		$overlay_icon           = ! empty( $processed_overlay_icon ) ? $processed_overlay_icon : '';
		wdc_inject_fa_icons( $this->props['overlay_icon'] );

		return sprintf(
			'<div class="wdc-carousel-item wdc-team wdc-bg-support wdc-swapped-img-selector wdc-hover--%7$s">
                %8$s
                <figure>
                    <div class="wdc-overlay"><span class="wdc-overlay-icon">%10$s</span></div>
                    <div class="figure-wrap wdc-lightbox-ctrl">%1$s</div>
                </figure>
                %9$s
                <div class="wdc-team-content content-%2$s">
                    <div class="flex-top">
                        %3$s %4$s %5$s
                    </div>
                    %6$s
                </div>
            </div>',
			$this->render_figure(),
			$this->props['content_alignment'],
			$this->render_name(),
			$this->render_job_title(),
			$this->render_bio(),
			$this->render_links( 'bottom' ),
			$this->props['image_hover_animation'],
			$this->render_links( 'top' ),
			$this->render_links( 'center' ),
			$overlay_icon
		);
	}

	public function apply_css( $render_slug ) {

		$content_padding                   = $this->props['content_padding'];
		$content_padding_tablet            = $this->props['content_padding_tablet'];
		$content_padding_phone             = $this->props['content_padding_phone'];
		$content_padding_last_edited       = $this->props['content_padding_last_edited'];
		$content_padding_responsive_status = et_pb_get_responsive_status( $content_padding_last_edited );
		$image_alignment                   = $this->props['image_alignment'];
		$image_width                       = $this->props['image_width'];
		$image_width_tablet                = $this->props['image_width_tablet'];
		$image_width_phone                 = $this->props['image_width_phone'];
		$image_width_last_edited           = $this->props['image_width_last_edited'];
		$image_width_responsive_status     = et_pb_get_responsive_status( $image_width_last_edited );
		$image_height                      = $this->props['image_height'];
		$image_height_tablet               = $this->props['image_height_tablet'];
		$image_height_phone                = $this->props['image_height_phone'];
		$image_height_last_edited          = $this->props['image_height_last_edited'];
		$image_height_responsive_status    = et_pb_get_responsive_status( $image_height_last_edited );
		$links_margin_top                  = $this->props['links_margin_top'];
		$links_margin_bottom               = $this->props['links_margin_bottom'];
		$link_color_hover                  = $this->get_hover_value( 'social_icon_color' );
		$link_bg_hover                     = $this->get_hover_value( 'links_bg' );
		$name_bottom_spacing               = $this->props['name_bottom_spacing'];
		$job_bottom_spacing                = $this->props['job_bottom_spacing'];
		$image_spacing_bottom              = $this->props['image_spacing_bottom'];
		$content_alignment                 = $this->props['content_alignment'];

		if ( class_exists( 'ET_Builder_Module_Helper_Style_Processor' ) ) {
			$this->generate_styles(
				array(
					'utility_arg'    => 'icon_font_family',
					'render_slug'    => $render_slug,
					'base_attr_name' => 'overlay_icon',
					'important'      => true,
					'selector'       => '%%order_class%% .wdc-overlay .wdc-overlay-icon',
					'processor'      => array(
						'ET_Builder_Module_Helper_Style_Processor',
						'process_extended_icon',
					),
				)
			);
		}

		// Text Spacing.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-team-content h3, .et-db #et-boc %%order_class%% .wdc-team-content h3',
				'declaration' => sprintf( 'padding-bottom: %1$s!important;', $name_bottom_spacing ),
			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-job-title',
				'declaration' => sprintf( 'padding-bottom: %1$s!important;', $job_bottom_spacing ),
			)
		);

		// Content Padding.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-team-content',
				'declaration' => $this->wdc_process_padding( $content_padding, false ),
			)
		);

		// Content Padding tablet.
		if ( ! empty( $content_padding_tablet ) && $content_padding_responsive_status ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-team-content',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					'declaration' => $this->wdc_process_padding( $content_padding_tablet, false ),
				)
			);
		}

		// Content Padding phone.
		if ( ! empty( $content_padding_phone ) && $content_padding_responsive_status ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-team-content',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					'declaration' => $this->wdc_process_padding( $content_padding_phone, false ),
				)
			);
		}

		// photo width & height.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-team figure',
				'declaration' => sprintf( 'width: %1$s;', $image_width ),
			)
		);
		if ( ! empty( $image_width_tablet ) && $image_width_responsive_status ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-team figure',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					'declaration' => sprintf( 'width: %1$s;', $image_width_tablet ),
				)
			);
		}

		if ( ! empty( $image_width_phone ) && $image_width_responsive_status ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-team figure',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					'declaration' => sprintf( 'width: %1$s;', $image_width_phone ),
				)
			);
		}

		if ( 'auto' !== $image_height ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-team figure',
					'declaration' => sprintf( 'height: %1$s;', $image_height ),
				)
			);
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-team figure img',
					'declaration' => 'height: 100%; object-fit: cover;width:100%;',
				)
			);

			if ( ! empty( $image_height_tablet ) && $image_height_responsive_status ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-team figure',
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
						'declaration' => sprintf( 'height: %1$s;', $image_height_tablet ),
					)
				);
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-team figure img',
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
						'declaration' => 'height: 100%; object-fit: cover;width:100%;',
					)
				);
			}

			if ( ! empty( $image_height_phone ) && $image_height_responsive_status ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-team figure',
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
						'declaration' => sprintf( 'height: %1$s;', $image_height_phone ),
					)
				);
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-team figure img',
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
						'declaration' => 'height: 100%; object-fit: cover;width:100%;',
					)
				);
			}
		}

		// photo alignment.
		if ( 'center' === $image_alignment ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-team figure',
					'declaration' => 'margin-left: auto; margin-right: auto;',
				)
			);

		} elseif ( 'right' === $image_alignment ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-team figure',
					'declaration' => 'margin-left: auto;',
				)
			);
		}

		// Photo Spacing.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-team figure',
				'declaration' => sprintf( 'margin-bottom: %1$s;', $image_spacing_bottom ),
			)
		);

		// Social Icons.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-team-social',
				'declaration' => sprintf( 'padding-top: %1$s!important; padding-bottom: %2$s!important;', $links_margin_top, $links_margin_bottom ),
			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-icon',
				'declaration' => sprintf(
					'
                background-color: %1$s;
                color: %2$s!important;
                border-radius: %3$s;
                font-size: %4$s!important;
                height: %5$s;
                width: %6$s;',
					$this->props['links_bg'],
					$this->props['social_icon_color'],
					$this->props['links_radius'],
					$this->props['links_icon_size'],
					$this->props['links_height'],
					$this->props['links_width']
				),
			)
		);

		if ( 'left' === $content_alignment ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-team-social .wdc-icon',
					'declaration' => sprintf( 'margin-right: %1$s;', $this->props['links_margin_between'] ),
				)
			);

		} elseif ( 'right' === $content_alignment ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-team-social .wdc-icon',
					'declaration' => sprintf( 'margin-left: %1$s;', $this->props['links_margin_between'] ),
				)
			);

		} else {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-team-social .wdc-icon',
					'declaration' => sprintf( 'margin-left: %1$s; margin-right: %1$s;', $this->props['links_margin_between'] ),
				)
			);
		}

		// Social Icons hover.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-team-social .wdc-icon:hover',
				'declaration' => sprintf( 'background-color: %1$s; color: %2$s!important;', $link_bg_hover, $link_color_hover ),
			)
		);

		$this->get_overlay_style( $render_slug );

	}
}

new WDC_TeamCarouselChild();
