<?php
class WowProductHelper {

    public static function render_product_label( $label_text ) {
        global $product;
        $inner_text = '';

        if ( 'sale' === $label_text ) {

            if ( $product->is_on_sale() ) {
                $inner_text = esc_html__( 'Sale', 'wdc-wow-divi-carousel' );
                return sprintf( '<div class="wdc-woo-label label-%1$s">%2$s</div>', $label_text, $inner_text );
            }

        } elseif ( 'featured' === $label_text ) {

            if ( $product->is_featured() ) {
                $inner_text = esc_html__( 'Featured', 'wdc-wow-divi-carousel' );
                return sprintf( '<div class="wdc-woo-label label-%1$s">%2$s</div>', $label_text, $inner_text );
            }

        } elseif ( 'new' === $label_text ) {

            $postdate      = get_the_time( 'Y-m-d' );
            $postdatestamp = strtotime( $postdate );
            $newness       = 30;

            if (  ( time() - ( 60 * 60 * 24 * $newness ) ) < $postdatestamp ) {
                $inner_text = esc_html__( 'New', 'wdc-wow-divi-carousel' );
                return sprintf( '<div class="wdc-woo-label label-%1$s">%2$s</div>', $label_text, $inner_text );
            }

        }

    }

    public static function render_stock_out( $class ) {
        return sprintf( '<div class="wdc-woo-not-aval %1$s">%2$s</div>', $class, __( 'Out Of Stock', 'wdc-wow-divi-carousel' ) );
    }

    public static function render_product_thumb( $args, $woo_post_id ) {

        $thumb_id               = get_post_thumbnail_id( get_the_ID() );
        $alt                    = get_post_meta( $thumb_id, '_wp_attachment_image_alt', true );
        $overlay_icon           = $args['overlay_icon'];
        $actions                = '';
        $processed_overlay_icon = esc_attr( et_pb_process_font_icon( $overlay_icon ) );
        $overlay_icon           = !empty( $processed_overlay_icon ) ? $processed_overlay_icon : '';
        $layout                 = $args['layout'];
        $is_lazyload            = $args['is_lazyload'];

        if ( 'v3' === $layout ) {
            $actions = self::render_product_actions( $args, $woo_post_id );
        }

        return sprintf(
            '<figure class="wdc-woo-figure">
				%1$s
				<a href="%2$s">
					<div class="wdc-overlay"><span class="wdc-overlay-icon">%3$s</span></div>
					<img class="wdc-img-cover" %4$s="%5$s" alt="%6$s">
				</a>
			</figure>',
            $actions,
            esc_url( get_the_permalink() ),
            $overlay_icon,
            'on' === $is_lazyload ? 'data-lazy' : 'src',
            esc_url( get_the_post_thumbnail_url() ? get_the_post_thumbnail_url() : wc_placeholder_img_src() ),
            esc_attr( $alt )
        );

    }

    public static function render_product_category( $has_label, $show_parent_category ) {
        global $product;
        $category           = '';
        $product_categories = function_exists( 'wc_get_product_category_list' ) ? wc_get_product_category_list( get_the_ID(), ', ', '', '' ) : $product->get_categories( ', ', '', '' );

        if ( 'off' === $show_parent_category ) {

            if ( $has_label ) {
                $category = 'Categories: ' . $product_categories;
            } else {
                $category = $product_categories;
            }

        } else {
            list( $parent_cat ) = explode( ',', $product_categories );

            if ( $has_label ) {
                $category = '<span>Category:</span> ' . $parent_cat;
            } else {
                $category = $parent_cat;
            }

        }

        return sprintf(
            '<div class="wdc-woo-categories">
				%1$s
			</div>',
            $category
        );
    }

    public static function render_title( $tag ) {
        return sprintf(
            '<%1$s class="wdc-woo-title">
                <a href="%2$s">%3$s</a>
            </%1$s>',
            $tag,
            esc_url( get_the_permalink() ),
            et_core_intentionally_unescaped( get_the_title(), 'html' ) // phpcs:ignore
        );
    }

    public static function render_price( $class ) {
        global $product;
        return sprintf(
            '<div class="wdc-price-html %1$s">
				%2$s
			</div>',
            $class,
            $product->get_price_html()
        );
    }

    public static function render_review( $woo_rating ) {
        ob_start();
        echo '<div class="wdc-woo-review">';

        if ( $woo_rating > 0 ) {
            woocommerce_template_loop_rating();
        } else {
            echo '<div class="star-rating" role="img"></div>';
        }

        echo '</div>';
        $output = ob_get_clean();

        return $output;
    }

    public static function render_product_actions( $args, $post_id ) {

        $quick_view_type  = $args['quick_view_type'];
        $show_quick_view  = $args['show_quick_view'];
        $show_cart_btn    = $args['show_cart_btn'];
        $qv_cart_btn_text = $args['qv_cart_btn_text'];

        $data_qv_elements = [
            'show_qv_gallery'      => $args['show_qv_gallery'],
            'show_qv_cart_btn'     => $args['show_qv_cart_btn'],
            'show_qv_categories'   => $args['show_qv_categories'],
            'show_qv_ratings'      => $args['show_qv_ratings'],
            'show_qv_price'        => $args['show_qv_price'],
            'show_qv_desc'         => $args['show_qv_desc'],
            'only_sale_price'      => $args['only_sale_price'],
            'show_parent_category' => $args['show_parent_category'],
        ];

        if ( 'on' === $show_quick_view || 'on' === $show_cart_btn ) {

            global $product;
            $qv_btn   = '';
            $cart_btn = '';

            if ( 'on' === $show_quick_view ) {

                if ( 'normal' === $quick_view_type ) {
                    $qv_btn = sprintf(
                        '<a href="#" data-mfp-src="#wdc-modal-%1$s" class="wdc-product-act-btn wdc-woo-quick-veiw-btn wdc-btn-modal">
							<i class="wdc-ico-eye"></i>
						</a>',
                        $post_id
                    );

                } elseif ( 'ajax' === $quick_view_type ) {
                    $qv_btn = sprintf(
                        '<div data-elements="%1$s" class="wdc-product-act-btn wdc-woo-quick-veiw-btn wdc-woo-ajax-veiw" data-product-id="%2$s">
							<i class="wdc-ico-eye"></i>
						</div>',
                        wp_json_encode( $data_qv_elements ),
                        $post_id
                    );
                }

            }

            if ( 'on' === $show_cart_btn ) {
                $cart_btn = sprintf(
                    '<a
						href="%1$s"
						class="wdc-product-act-btn wdc-add-to-cart-btn add_to_cart_button ajax_add_to_cart"
                        data-product_id="%2$s"
					>
						<i class="wdc-ico-cart"></i>
					</a>',
                    esc_url( $product->add_to_cart_url() ),
                    esc_attr( $post_id )
                );
            }

            return sprintf(
                '<div class="wdc-product-actions">
					%1$s
					%2$s
				</div>',
                $qv_btn,
                $cart_btn
            );
        }

    }

    public static function render_woo_gallery() {

        global $post, $product, $woocommerce;
        $version        = '3.0';
        $gallery_parent = '';
        $gallery_child  = '';

        if ( version_compare( $woocommerce->version, $version, '>=' ) ) {
            $attachment_ids = $product->get_gallery_image_ids();
        } else {
            $attachment_ids = $product->get_gallery_attachment_ids();
        }

        if ( has_post_thumbnail() ) {

            $thumbanil_id   = [get_post_thumbnail_id()];
            $attachment_ids = array_merge( $thumbanil_id, $attachment_ids );
        }

        if ( $attachment_ids ) {
            $css_class = '';

            if ( count( $attachment_ids ) > 1 ) {
                $css_class = 'gallery-on';
            }

            // gallery parent.
            ob_start();

            foreach ( $attachment_ids as $attachment_id ) {

                $attachment_props  = wc_get_product_attachment_props( $attachment_id, $post );
                $thumbnails_catlog = '';

                if ( !$attachment_props['url'] ) {
                    continue;
                }

                // phpcs:ignore
                echo apply_filters(
                    'woocommerce_single_product_image_thumbnail_html',
                    sprintf(
                        '<div class="wdc-protuct-gallery-item">%s</div>',
                        wp_get_attachment_image( $attachment_id, apply_filters( 'single_product_large_thumbnail_size', 'full' ), 0, $thumbnails_catlog )
                    ),
                    $attachment_id,
                    $post->ID
                );
            }

            $gallery_parent = ob_get_clean();

            if ( count( $attachment_ids ) > 1 ) {
                // gallery child.
                ob_start();
                echo '<div class="wdc-products-nav">';

                foreach ( $attachment_ids as $attachment_id ) {

                    $attachment_props  = wc_get_product_attachment_props( $attachment_id, $post );
                    $thumbnails_catlog = '';

                    if ( !$attachment_props['url'] ) {
                        continue;
                    }

                    // phpcs:ignore
                    echo apply_filters(
                        'woocommerce_single_product_image_thumbnail_html',
                        sprintf(
                            '<div class="wdc-protuct-nav-item">%s</div>',
                            wp_get_attachment_image( $attachment_id, apply_filters( 'single_product_large_thumbnail_size', 'full' ), 0, $thumbnails_catlog )
                        ),
                        $attachment_id,
                        $post->ID
                    );
                }

                echo '</div>';
                $gallery_child = ob_get_clean();
            }

            return sprintf(
                '<div id="wdc-product-gallery" class="wdc-product-gallery wdc-product-gallery--slider wdc-product-gallery--has-nav">
					<div  class="wdc-products-parent wdc-product-gallery-wrap %1$s">
						%2$s
					</div>
					%3$s
				</div>',
                $css_class,
                $gallery_parent,
                $gallery_child
            );
        }

    }

    public static function render_cart_added_msg( $args ) {

        return sprintf(
            '<div class="wdc-cart-added-flash">
				<div class="wdc-added-msg">%2$s</div>
				<a href="%1$s" class="wdc-after-cart-btn">%3$s</a>
			</div>',
            wc_get_cart_url(),
            $args['added_msg'],
            $args['added_btn_text']
        );
    }

}
