<?php

class WDC_ProductCarousel extends Wow_Builder_Module_Type_PostBased {

	protected $module_credits = array(
		'module_uri' => 'https://demo.wowcarousel.com/post-carousel',
		'author'     => 'Wow Carousel',
		'author_uri' => 'https://divipeople.com/wow-divi-carousel/',
	);

	public function init() {

		$this->vb_support = 'on';
		$this->name       = esc_html__('Wow Product Carousel', 'wdc-wow-divi-carousel');
		$this->plural     = esc_html__('Wow Product Carousels', 'wdc-wow-divi-carousel');
		$this->icon_path  = plugin_dir_path(__FILE__) . 'wdc-product.svg';
		$this->slug       = 'wdc_product_carousel';

		$this->settings_modal_toggles = array(
			'general'  => array(
				'toggles' => array(
					'content'     => array(
						'title' => esc_html__('Content', 'wdc-wow-divi-carousel'),
					),
					'elements'    => array(
						'title' => esc_html__('Elements', 'wdc-wow-divi-carousel'),
					),
					'qv_elements' => array(
						'title' => esc_html__('Modal Elements', 'wdc-wow-divi-carousel'),
					),
					'settings'    => array(
						'title'             => esc_html__('Carousel Settings', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'general'  => array(
								'name' => esc_html__('General', 'wdc-wow-divi-carousel'),
							),
							'advanced' => array(
								'name' => esc_html__('Advanced', 'wdc-wow-divi-carousel'),
							),
						),
					),
				),
			),

			'advanced' => array(
				'toggles' => array(
					'common'           => esc_html__('General', 'wdc-wow-divi-carousel'),
					'image'            => esc_html__('Image', 'wdc-wow-divi-carousel'),
					'overlay'          => esc_html__('Overlay', 'wdc-wow-divi-carousel'),
					'label'            => esc_html__('Label', 'wdc-wow-divi-carousel'),
					'texts'            => array(
						'title'             => esc_html__('Texts', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'common'   => array(
								'name' => esc_html__('Common', 'wdc-wow-divi-carousel'),
							),
							'title'    => array(
								'name' => esc_html__('Title', 'wdc-wow-divi-carousel'),
							),
							'category' => array(
								'name' => esc_html__('Category', 'wdc-wow-divi-carousel'),
							),
						),
					),

					'buttons'          => array(
						'title'             => esc_html__('Buttons', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'common'     => array(
								'name' => esc_html__('Common', 'wdc-wow-divi-carousel'),
							),
							'quick_view' => array(
								'name' => esc_html__('Quick View', 'wdc-wow-divi-carousel'),
							),
							'cart'       => array(
								'name' => esc_html__('Add Cart', 'wdc-wow-divi-carousel'),
							),
						),
					),

					'footer'           => array(
						'title'             => esc_html__('Footer', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'footer'     => array(
								'name' => esc_html__('Footer', 'wdc-wow-divi-carousel'),
							),
							'price'      => array(
								'name' => esc_html__('Price', 'wdc-wow-divi-carousel'),
							),
							'sale_price' => array(
								'name' => esc_html__('Sale Price', 'wdc-wow-divi-carousel'),
							),
						),
					),
					'quick_view'       => esc_html__('Modal', 'wdc-wow-divi-carousel'),
					'quick_view_btn'   => esc_html__('Modal Button', 'wdc-wow-divi-carousel'),
					'quick_view_texts' => array(
						'title'             => esc_html__('Modal Texts', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'title'    => array(
								'name' => esc_html__('Title', 'wdc-wow-divi-carousel'),
							),
							'desc'     => array(
								'name' => esc_html__('Desc', 'wdc-wow-divi-carousel'),
							),
							'price'    => array(
								'name' => esc_html__('Price', 'wdc-wow-divi-carousel'),
							),
							'category' => array(
								'name' => esc_html__('Cat', 'wdc-wow-divi-carousel'),
							),
						),
					),
					'arrow'            => array(
						'title'             => esc_html__('Carousel Navigation', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'arrow_common' => array(
								'name' => esc_html__('Common', 'wdc-wow-divi-carousel'),
							),
							'arrow_left'   => array(
								'name' => esc_html__('Prev', 'wdc-wow-divi-carousel'),
							),
							'arrow_right'  => array(
								'name' => esc_html__('Next', 'wdc-wow-divi-carousel'),
							),
						),
					),

					'pagination'       => array(
						'title'             => esc_html__('Carousel Pagination', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'pagi_common' => array(
								'name' => esc_html__('Common', 'wdc-wow-divi-carousel'),
							),
							'pagi_active' => array(
								'name' => esc_html__('Active', 'wdc-wow-divi-carousel'),
							),
						),
					),

				),
			),
		);
	}

	public function get_fields() {

		$fields = array(
			'layout'                  => array(
				'label'       => esc_html__('Select Layout', 'wdc-wow-divi-carousel'),
				'type'        => 'select',
				'default'     => 'v1',
				'toggle_slug' => 'content',
				'options'     => array(
					'v1' => esc_html__('Layout 1', 'wdc-wow-divi-carousel'),
					'v2' => esc_html__('Layout 2', 'wdc-wow-divi-carousel'),
					'v3' => esc_html__('Layout 3', 'wdc-wow-divi-carousel'),
				),
			),
			'type'                    => array(
				'label'            => esc_html__('Product View Type', 'wdc-wow-divi-carousel'),
				'type'             => 'select',
				'options'          => array(
					'recent'       => esc_html__('Recent Products', 'wdc-wow-divi-carousel'),
					'featured'     => esc_html__('Featured Products', 'wdc-wow-divi-carousel'),
					'sale'         => esc_html__('Sale Products', 'wdc-wow-divi-carousel'),
					'best_selling' => esc_html__('Best Selling Products', 'wdc-wow-divi-carousel'),
					'top_rated'    => esc_html__('Top Rated Products', 'wdc-wow-divi-carousel'),
				),
				'default_on_front' => 'recent',
				'description'      => esc_html__('Choose which type of product view you would like to display.', 'wdc-wow-divi-carousel'),
				'toggle_slug'      => 'content',
				'computed_affects' => array(
					'__product',
				),
			),

			'include_categories'      => array(
				'label'            => esc_html__('Included Categories', 'wdc-wow-divi-carousel'),
				'type'             => 'categories',
				'renderer_options' => array(
					'use_terms' => false,
				),
				'taxonomy_name'    => 'product_cat',
				'option_category'  => 'basic_option',
				'toggle_slug'      => 'content',
				'computed_affects' => array('__product'),
			),

			'order_by'                => array(
				'label'            => esc_html__('Order By', 'wdc-wow-divi-carousel'),
				'description'      => esc_html__('Choose how your products should be ordered.', 'wdc-wow-divi-carousel'),
				'type'             => 'select',
				'option_category'  => 'configuration',
				'options'          => array(
					'menu_order' => esc_html__('Default Sorting', 'wdc-wow-divi-carousel'),
					'popularity' => esc_html__('Sort By Popularity', 'wdc-wow-divi-carousel'),
					'date'       => esc_html__('Sort By Date: Oldest To Newest', 'wdc-wow-divi-carousel'),
					'date-desc'  => esc_html__('Sort By Date: Newest To Oldest', 'wdc-wow-divi-carousel'),
					'price'      => esc_html__('Sort By Price: Low To High', 'wdc-wow-divi-carousel'),
					'price-desc' => esc_html__('Sort By Price: High To Low', 'wdc-wow-divi-carousel'),
				),

				'default_on_front' => 'menu_order',
				'computed_affects' => array('__product'),
				'toggle_slug'      => 'content',
			),

			'product_count'           => array(
				'label'            => esc_html__('Show Product Item', 'wdc-wow-divi-carousel'),
				'type'             => 'text',
				'default'          => '5',
				'toggle_slug'      => 'content',
				'computed_affects' => array('__product'),
			),
			'exclude_posts'           => array(
				'label'            => esc_html__('Exclude Products by IDs', 'wdc-wow-divi-carousel'),
				'description'      => esc_html__('eg. 10, 22, 19 etc. If this is used by IDs, Selected Products will be ignored.', 'wdc-wow-divi-carousel'),
				'type'             => 'text',
				'toggle_slug'      => 'content',
				'computed_affects' => array('__product'),
			),
			'post_offset'             => array(
				'label'            => esc_html__('Product Offset', 'wdc-wow-divi-carousel'),
				'type'             => 'range',
				'default'          => '0',
				'unitless'         => true,
				'range_settings'   => array(
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				),
				'toggle_slug'      => 'content',
				'computed_affects' => array('__product'),
			),
			// elements.
			'show_title'              => array(
				'label'            => esc_html__('Show Title', 'wdc-wow-divi-carousel'),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__('Yes', 'wdc-wow-divi-carousel'),
					'off' => esc_html__('No', 'wdc-wow-divi-carousel'),
				),
				'default'          => 'on',
				'toggle_slug'      => 'elements',
				'computed_affects' => array('__product'),
			),

			'show_thumb'              => array(
				'label'            => esc_html__('Show Featured Image', 'wdc-wow-divi-carousel'),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__('Yes', 'wdc-wow-divi-carousel'),
					'off' => esc_html__('No', 'wdc-wow-divi-carousel'),
				),
				'default'          => 'on',
				'toggle_slug'      => 'elements',
				'computed_affects' => array('__product'),
			),

			'show_label'              => array(
				'label'            => esc_html__('Show Label', 'wdc-wow-divi-carousel'),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__('Yes', 'wdc-wow-divi-carousel'),
					'off' => esc_html__('No', 'wdc-wow-divi-carousel'),
				),
				'default'          => 'off',
				'toggle_slug'      => 'elements',
				'computed_affects' => array('__product'),
			),

			'label_text'              => array(
				'label'            => esc_html__('Display Label on', 'wdc-wow-divi-carousel'),
				'type'             => 'select',
				'option_category'  => 'layout',
				'default'          => 'sale',
				'options'          => array(
					'sale'     => esc_html__('Sale', 'wdc-wow-divi-carousel'),
					'featured' => esc_html__('Featured', 'wdc-wow-divi-carousel'),
					'new'      => esc_html__('New', 'wdc-wow-divi-carousel'),
				),

				'description'      => esc_html__('Choose which Label you would like to display.', 'wdc-wow-divi-carousel'),
				'computed_affects' => array('__product'),
				'toggle_slug'      => 'elements',
				'show_if'          => array(
					'show_label' => 'on',
				),
			),

			'show_categories'         => array(
				'label'            => esc_html__('Show Categories', 'wdc-wow-divi-carousel'),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__('Yes', 'wdc-wow-divi-carousel'),
					'off' => esc_html__('No', 'wdc-wow-divi-carousel'),
				),
				'default'          => 'on',
				'toggle_slug'      => 'elements',
				'computed_affects' => array('__product'),
			),

			'show_parent_category'    => array(
				'label'            => esc_html__('Show Single Category only', 'wdc-wow-divi-carousel'),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__('Yes', 'wdc-wow-divi-carousel'),
					'off' => esc_html__('No', 'wdc-wow-divi-carousel'),
				),
				'default'          => 'on',
				'toggle_slug'      => 'elements',
				'computed_affects' => array('__product'),
				'show_if'          => array(
					'show_categories' => 'on',
				),
			),

			'show_price'              => array(
				'label'            => esc_html__('Show Price', 'wdc-wow-divi-carousel'),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__('Yes', 'wdc-wow-divi-carousel'),
					'off' => esc_html__('No', 'wdc-wow-divi-carousel'),
				),
				'default'          => 'on',
				'toggle_slug'      => 'elements',
				'computed_affects' => array('__product'),
			),

			'only_sale_price'         => array(
				'label'            => esc_html__('Show Sale Price only', 'wdc-wow-divi-carousel'),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__('Yes', 'wdc-wow-divi-carousel'),
					'off' => esc_html__('No', 'wdc-wow-divi-carousel'),
				),
				'default'          => 'on',
				'toggle_slug'      => 'elements',
				'computed_affects' => array('__product'),
				'show_if'          => array(
					'show_price' => 'on',
				),
			),

			'show_review'             => array(
				'label'            => esc_html__('Show Rating', 'wdc-wow-divi-carousel'),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__('Yes', 'wdc-wow-divi-carousel'),
					'off' => esc_html__('No', 'wdc-wow-divi-carousel'),
				),
				'default'          => 'on',
				'toggle_slug'      => 'elements',
				'computed_affects' => array('__product'),
			),

			'show_cart_btn'           => array(
				'label'            => esc_html__('Show Cart Button', 'wdc-wow-divi-carousel'),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__('Yes', 'wdc-wow-divi-carousel'),
					'off' => esc_html__('No', 'wdc-wow-divi-carousel'),
				),
				'default'          => 'on',
				'toggle_slug'      => 'elements',
				'computed_affects' => array('__product'),
			),

			'show_quick_view'         => array(
				'label'            => esc_html__('Show Quick View Modal', 'wdc-wow-divi-carousel'),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__('Yes', 'wdc-wow-divi-carousel'),
					'off' => esc_html__('No', 'wdc-wow-divi-carousel'),
				),
				'default'          => 'on',
				'toggle_slug'      => 'elements',
				'computed_affects' => array('__product'),
			),

			'quick_view_type'         => array(
				'label'            => esc_html__('Quick View Type', 'wdc-wow-divi-carousel'),
				'type'             => 'select',
				'default'          => 'normal',
				'toggle_slug'      => 'elements',
				'computed_affects' => array('__product'),
				'options'          => array(
					'normal' => esc_html__('Normal', 'wdc-wow-divi-carousel'),
				),
				'show_if'          => array(
					'show_quick_view' => 'on',
				),
			),

			'show_cart_msg'           => array(
				'label'            => esc_html__('Show Added Cart Massage', 'wdc-wow-divi-carousel'),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__('Yes', 'wdc-wow-divi-carousel'),
					'off' => esc_html__('No', 'wdc-wow-divi-carousel'),
				),
				'default'          => 'on',
				'toggle_slug'      => 'elements',
				'computed_affects' => array('__product'),
			),

			'added_msg'               => array(
				'label'            => esc_html__('Cart Successful Text', 'wdc-wow-divi-carousel'),
				'type'             => 'text',
				'default'          => 'Successfully Added To Cart',
				'toggle_slug'      => 'elements',
				'computed_affects' => array('__product'),
				'show_if'          => array(
					'show_cart_msg' => 'on',
				),
			),

			'added_btn_text'          => array(
				'label'            => esc_html__('View Cart Button Text', 'wdc-wow-divi-carousel'),
				'type'             => 'text',
				'default'          => 'View Cart',
				'toggle_slug'      => 'elements',
				'computed_affects' => array('__product'),
				'show_if'          => array(
					'show_cart_msg' => 'on',
				),
			),

			// Quick View Elements.
			'show_qv_gallery'         => array(
				'label'            => esc_html__('Show Gallery', 'wdc-wow-divi-carousel'),
				'type'             => 'yes_no_button',
				'description'      => esc_html__('Enable this to show product gallery on quick view modal. Gallery will only work on frontend view.'),
				'options'          => array(
					'on'  => esc_html__('Yes', 'wdc-wow-divi-carousel'),
					'off' => esc_html__('No', 'wdc-wow-divi-carousel'),
				),
				'default'          => 'on',
				'toggle_slug'      => 'qv_elements',
				'computed_affects' => array('__product'),
				'show_if'          => array(
					'show_quick_view' => 'on',
				),
			),

			'show_qv_cart_btn'        => array(
				'label'           => esc_html__('Show Cart Button', 'wdc-wow-divi-carousel'),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__('Yes', 'wdc-wow-divi-carousel'),
					'off' => esc_html__('No', 'wdc-wow-divi-carousel'),
				),
				'default'         => 'on',
				'toggle_slug'     => 'qv_elements',
				'show_if'         => array(
					'show_quick_view' => 'on',
				),
			),

			'qv_cart_btn_text'        => array(
				'label'            => esc_html__('Cart Button Text', 'wdc-wow-divi-carousel'),
				'type'             => 'text',
				'default'          => esc_html__('Add to cart', 'wdc-wow-divi-carousel'),
				'toggle_slug'      => 'qv_elements',
				'show_if'          => array(
					'show_qv_cart_btn' => 'on',
				),
				'computed_affects' => array('__product'),
				'show_if'          => array(
					'show_quick_view' => 'on',
				),
			),

			'show_qv_categories'      => array(
				'label'           => esc_html__('Show Categories', 'wdc-wow-divi-carousel'),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__('Yes', 'wdc-wow-divi-carousel'),
					'off' => esc_html__('No', 'wdc-wow-divi-carousel'),
				),
				'default'         => 'on',
				'toggle_slug'     => 'qv_elements',
				'show_if'         => array(
					'show_quick_view' => 'on',
				),
			),

			'show_qv_category_prefix' => array(
				'label'           => esc_html__('Show Category Label', 'wdc-wow-divi-carousel'),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'description'     => esc_html__('Enable this to display \'Category\' label before categories.'),
				'options'         => array(
					'on'  => esc_html__('Yes', 'wdc-wow-divi-carousel'),
					'off' => esc_html__('No', 'wdc-wow-divi-carousel'),
				),
				'default'         => 'on',
				'toggle_slug'     => 'qv_elements',
				'show_if'         => array(
					'show_qv_categories' => 'on',
					'show_quick_view'    => 'on',
				),
			),

			'show_qv_ratings'         => array(
				'label'           => esc_html__('Show Rating', 'wdc-wow-divi-carousel'),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__('Yes', 'wdc-wow-divi-carousel'),
					'off' => esc_html__('No', 'wdc-wow-divi-carousel'),
				),
				'default'         => 'off',
				'toggle_slug'     => 'qv_elements',
				'show_if'         => array(
					'show_quick_view' => 'on',
				),
			),

			'show_qv_price'           => array(
				'label'           => esc_html__('Show Price', 'wdc-wow-divi-carousel'),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__('Yes', 'wdc-wow-divi-carousel'),
					'off' => esc_html__('No', 'wdc-wow-divi-carousel'),
				),
				'default'         => 'on',
				'toggle_slug'     => 'qv_elements',
				'show_if'         => array(
					'show_quick_view' => 'on',
				),
			),

			'show_qv_desc'            => array(
				'label'           => esc_html__('Show Short Description', 'wdc-wow-divi-carousel'),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__('Yes', 'wdc-wow-divi-carousel'),
					'off' => esc_html__('No', 'wdc-wow-divi-carousel'),
				),
				'default'         => 'on',
				'toggle_slug'     => 'qv_elements',
				'show_if'         => array(
					'show_quick_view' => 'on',
				),
			),

			// common.
			'post_padding'            => array(
				'label'          => __('Item Padding', 'wdc-wow-divi-carousel'),
				'type'           => 'custom_padding',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'common',
				'default'        => '0px|0px|0px|0px',
				'mobile_options' => true,
			),

			'alignment'               => array(
				'label'          => __('Text Alignment', 'wdc-wow-divi-carousel'),
				'type'           => 'text_align',
				'options'        => et_builder_get_text_orientation_options(array('justified')),
				'options_icon'   => 'module_align',
				'toggle_slug'    => 'texts',
				'sub_toggle'     => 'common',
				'tab_slug'       => 'advanced',
				'mobile_options' => true,
			),

			'content_padding'         => array(
				'label'          => esc_html__('Text Padding', 'wdc-wow-divi-carousel'),
				'type'           => 'custom_padding',
				'toggle_slug'    => 'texts',
				'sub_toggle'     => 'common',
				'tab_slug'       => 'advanced',
				'default'        => '0px|0px|0px|0px',
				'mobile_options' => true,
			),

			// Buttons.
			'btns_height'             => array(
				'label'           => esc_html__('Height', 'wdc-wow-divi-carousel'),
				'type'            => 'range',
				'default'         => '40px',
				'option_category' => 'basic_option',
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 1,
					'step' => 1,
					'max'  => 300,
				),
				'toggle_slug'     => 'buttons',
				'tab_slug'        => 'advanced',
				'sub_toggle'      => 'common',
			),

			'btns_width'              => array(
				'label'           => esc_html__('Width', 'wdc-wow-divi-carousel'),
				'type'            => 'range',
				'default'         => '40px',
				'option_category' => 'basic_option',
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 1,
					'step' => 1,
					'max'  => 300,
				),
				'toggle_slug'     => 'buttons',
				'tab_slug'        => 'advanced',
				'sub_toggle'      => 'common',
				'show_if'         => array(
					'layout' => array('v1', 'v2'),
				),
			),

			'btns_separetor_color'    => array(
				'label'       => __('Separetor Color', 'wdc-wow-divi-carousel'),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'buttons',
				'default'     => '#999999',
				'sub_toggle'  => 'common',
				'show_if'     => array(
					'layout'          => 'v3',
					'show_cart_btn'   => 'on',
					'show_quick_view' => 'on',
				),
			),

			'qv_btn_icon_size'        => array(
				'label'           => esc_html__('Icon Size', 'wdc-wow-divi-carousel'),
				'type'            => 'range',
				'default'         => '16px',
				'option_category' => 'basic_option',
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 1,
					'step' => 1,
					'max'  => 300,
				),
				'toggle_slug'     => 'buttons',
				'tab_slug'        => 'advanced',
				'sub_toggle'      => 'quick_view',
			),

			'cart_btn_icon_size'      => array(
				'label'           => esc_html__('Icon Size', 'wdc-wow-divi-carousel'),
				'type'            => 'range',
				'default'         => '16px',
				'option_category' => 'basic_option',
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 1,
					'step' => 1,
					'max'  => 300,
				),
				'toggle_slug'     => 'buttons',
				'tab_slug'        => 'advanced',
				'sub_toggle'      => 'cart',
			),

			'qv_btn_icon_color'       => array(
				'label'       => __('Icon Color', 'wdc-wow-divi-carousel'),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'buttons',
				'default'     => '#333',
				'sub_toggle'  => 'quick_view',
				'hover'       => 'tabs',
			),

			'cart_btn_icon_color'     => array(
				'label'       => __('Icon Color', 'wdc-wow-divi-carousel'),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'buttons',
				'default'     => '#333',
				'sub_toggle'  => 'cart',
				'hover'       => 'tabs',
			),

			'qv_btn_bg'               => array(
				'label'       => __('Background', 'wdc-wow-divi-carousel'),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'buttons',
				'default'     => '#F3B325',
				'sub_toggle'  => 'quick_view',
				'hover'       => 'tabs',
			),

			'cart_btn_bg'             => array(
				'label'       => __('Background', 'wdc-wow-divi-carousel'),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'buttons',
				'default'     => '#F3B325',
				'sub_toggle'  => 'cart',
				'hover'       => 'tabs',
			),

			'qv_btn_radius'           => array(
				'label'       => esc_html__('Borders Radius', 'wdc-wow-divi-carousel'),
				'type'        => 'border-radius',
				'default'     => 'off|0|0|0|0',
				'toggle_slug' => 'buttons',
				'tab_slug'    => 'advanced',
				'sub_toggle'  => 'quick_view',
			),

			'cart_btn_radius'         => array(
				'label'       => esc_html__('Borders Radius', 'wdc-wow-divi-carousel'),
				'type'        => 'border-radius',
				'default'     => 'off|0|0|0|0',
				'toggle_slug' => 'buttons',
				'tab_slug'    => 'advanced',
				'sub_toggle'  => 'cart',
			),

			// image.
			'image_height'            => array(
				'label'          => esc_html__('Image Height', 'wdc-wow-divi-carousel'),
				'type'           => 'range',
				'default'        => 'auto',
				'default_unit'   => 'px',
				'range_settings' => array(
					'min'  => 1,
					'step' => 1,
					'max'  => 500,
				),
				'toggle_slug'    => 'image',
				'tab_slug'       => 'advanced',
				'mobile_options' => true,
			),

			'image_hover_animation'   => array(
				'label'            => esc_html__('Hover Animation', 'wdc-wow-divi-carousel'),
				'type'             => 'select',
				'tab_slug'         => 'advanced',
				'toggle_slug'      => 'image',
				'computed_affects' => array('__posts'),
				'default'          => 'none',
				'options'          => array(
					'none'         => esc_html__('None', 'wdc-wow-divi-carousel'),
					'zoom-in'      => esc_html__('Zoom In', 'wdc-wow-divi-carousel'),
					'zoom-out'     => esc_html__('Zoom Out', 'wdc-wow-divi-carousel'),
					'pulse'        => esc_html__('Pulse', 'wdc-wow-divi-carousel'),
					'bounce'       => esc_html__('Bounce', 'wdc-wow-divi-carousel'),
					'flash'        => esc_html__('Flash', 'wdc-wow-divi-carousel'),
					'rubberBand'   => esc_html__('Rubber Band', 'wdc-wow-divi-carousel'),
					'shake'        => esc_html__('Shake', 'wdc-wow-divi-carousel'),
					'swing'        => esc_html__('Swing', 'wdc-wow-divi-carousel'),
					'tada'         => esc_html__('Tada', 'wdc-wow-divi-carousel'),
					'wobble'       => esc_html__('Wobble', 'wdc-wow-divi-carousel'),
					'jello'        => esc_html__('Jello', 'wdc-wow-divi-carousel'),
					'heartBeat'    => esc_html__('Heart Beat', 'wdc-wow-divi-carousel'),
					'bounceIn'     => esc_html__('Bounce In', 'wdc-wow-divi-carousel'),
					'fadeIn'       => esc_html__('Fade In', 'wdc-wow-divi-carousel'),
					'flip'         => esc_html__('Flip', 'wdc-wow-divi-carousel'),
					'lightSpeedIn' => esc_html__('Light Speed In', 'wdc-wow-divi-carousel'),
					'rotateIn'     => esc_html__('Rotate In', 'wdc-wow-divi-carousel'),
					'slideInUp'    => esc_html__('Slide In Up', 'wdc-wow-divi-carousel'),
					'slideInDown'  => esc_html__('Slide In Down', 'wdc-wow-divi-carousel'),
				),
			),

			'image_spacing'           => array(
				'label'          => esc_html__('Image Spacing', 'wdc-wow-divi-carousel'),
				'type'           => 'range',
				'default'        => '10px',
				'default_unit'   => 'px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 100,
				),
				'toggle_slug'    => 'image',
				'tab_slug'       => 'advanced',
			),

			// label.
			'label_position'          => array(
				'label'       => esc_html__('Label Position', 'wdc-wow-divi-carousel'),
				'type'        => 'select',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'label',
				'default'     => 'left_top',
				'options'     => array(
					'left_top'     => esc_html__('Left Top', 'wdc-wow-divi-carousel'),
					'left_bottom'  => esc_html__('Left Bottom', 'wdc-wow-divi-carousel'),
					'right_top'    => esc_html__('Right Top', 'wdc-wow-divi-carousel'),
					'right_bottom' => esc_html__('Right Bottom', 'wdc-wow-divi-carousel'),
				),
			),

			'label_offset_x'          => array(
				'label'           => esc_html__('Label Offset X', 'wdc-wow-divi-carousel'),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'default'         => '10px',
				'range_settings'  => array(
					'min'  => -600,
					'max'  => 600,
					'step' => 1,
				),
				'toggle_slug'     => 'label',
				'tab_slug'        => 'advanced',
			),

			'label_offset_y'          => array(
				'label'           => esc_html__('Label Offset Y', 'wdc-wow-divi-carousel'),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'default'         => '10px',
				'range_settings'  => array(
					'min'  => -600,
					'max'  => 600,
					'step' => 1,
				),
				'toggle_slug'     => 'label',
				'tab_slug'        => 'advanced',
			),

			'label_padding'           => array(
				'label'       => esc_html__('Label Padding', 'wdc-wow-divi-carousel'),
				'type'        => 'custom_padding',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'label',
				'default'     => '5px|15px|5px|15px',
			),

			'label_bg'                => array(
				'label'       => esc_html__('Label Background', 'wdc-wow-divi-carousel'),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'label',
				'default'     => '#F3B325',
			),

			// title.
			'use_single_title'        => array(
				'label'           => esc_html__('Use Single Line Title', 'wdc-wow-divi-carousel'),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__('Yes', 'wdc-wow-divi-carousel'),
					'off' => esc_html__('No', 'wdc-wow-divi-carousel'),
				),
				'default'         => 'off',
				'toggle_slug'     => 'texts',
				'sub_toggle'      => 'title',
				'tab_slug'        => 'advanced',
			),

			'title_spacing_bottom'    => array(
				'label'           => esc_html__('Title Spacing Bottom', 'wdc-wow-divi-carousel'),
				'type'            => 'range',
				'default'         => '25px',
				'option_category' => 'basic_option',
				'allowed_units'   => array('px'),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'texts',
				'sub_toggle'      => 'title',
				'tab_slug'        => 'advanced',
			),

			'title_spacing_top'       => array(
				'label'           => esc_html__('Title Spacing Top', 'wdc-wow-divi-carousel'),
				'type'            => 'range',
				'default'         => '10px',
				'option_category' => 'basic_option',
				'allowed_units'   => array('px'),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'texts',
				'sub_toggle'      => 'title',
				'tab_slug'        => 'advanced',
			),
			// Footer.
			'footer_alignment'        => array(
				'label'       => esc_html__('Footer Alignment', 'wdc-wow-divi-carousel'),
				'type'        => 'select',
				'default'     => 'space-between',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'footer',
				'sub_toggle'  => 'footer',
				'options'     => array(
					'flex-start'    => esc_html__('Left', 'wdc-wow-divi-carousel'),
					'flex-end'      => esc_html__('Right', 'wdc-wow-divi-carousel'),
					'row_center'    => esc_html__('Row - Center', 'wdc-wow-divi-carousel'),
					'center'        => esc_html__('Column - Center', 'wdc-wow-divi-carousel'),
					'space-around'  => esc_html__('Space Around', 'wdc-wow-divi-carousel'),
					'space-between' => esc_html__('Space Between', 'wdc-wow-divi-carousel'),
				),
				'show_if'     => array(
					'layout' => array('v1', 'v3'),
				),
			),

			'footer_padding'          => array(
				'label'          => esc_html__('Footer Padding', 'wdc-wow-divi-carousel'),
				'type'           => 'custom_padding',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'footer',
				'sub_toggle'     => 'footer',
				'default'        => '0px|0px|0px|0px',
				'mobile_options' => true,
			),

			'review_spacing_top'      => array(
				'label'          => __('Rating Spacing Top', 'wdc-wow-divi-carousel'),
				'type'           => 'range',
				'default'        => '0px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 100,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'footer',
				'sub_toggle'     => 'footer',
			),

			'review_spacing_bottom'   => array(
				'label'          => __('Rating Spacing Bottom', 'wdc-wow-divi-carousel'),
				'type'           => 'range',
				'default'        => '0px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 100,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'footer',
				'sub_toggle'     => 'footer',
			),

			'stars_size'              => array(
				'label'          => __('Rating Star Size', 'wdc-wow-divi-carousel'),
				'type'           => 'range',
				'default'        => '14px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 100,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'footer',
				'sub_toggle'     => 'footer',
			),

			'stars_color'             => array(
				'label'       => __('Rating Star Color', 'wdc-wow-divi-carousel'),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'arrow',
				'default'     => '#F3B325',
				'toggle_slug' => 'footer',
				'sub_toggle'  => 'footer',
			),

			// computed fields.
			'__product'               => array(
				'type'                => 'computed',
				'computed_callback'   => array('WDC_ProductCarousel', 'get_products'),
				'computed_depends_on' => array(
					'title_level',
					'type',
					'order_by',
					'include_categories',
					'product_count',
					'exclude_posts',
					'post_offset',
					'show_title',
					'show_thumb',
					'show_label',
					'label_text',
					'show_categories',
					'show_price',
					'show_review',
					'show_cart_btn',
					'show_quick_view',
					'qv_cart_btn_text',
					'quick_view_type',
					'image_hover_animation',
					'layout',
					'show_parent_category',
					'show_qv_gallery',
					'show_qv_cart_btn',
					'show_qv_categories',
					'show_qv_ratings',
					'show_qv_price',
					'show_qv_desc',
					'overlay_icon',
					'only_sale_price',
					'show_cart_msg',
					'added_btn_text',
					'added_msg',
				),
				'computed_minimum'    => array(
					'product_count',
				),
			),
		);

		$qv_modal = array(
			'qv_rating_color'   => array(
				'label'       => __('Rating Color', 'wdc-wow-divi-carousel'),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'quick_view',
			),
			'qv_stars_size'     => array(
				'label'          => __('Rating Star Size', 'wdc-wow-divi-carousel'),
				'type'           => 'range',
				'default_unit'   => 'px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 100,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'quick_view',
				'mobile_options' => true,
			),
			'qv_rating_spacing' => array(
				'label'          => __('Rating Spacing Top', 'wdc-wow-divi-carousel'),
				'type'           => 'range',
				'default_unit'   => 'px',
				'default'        => '15px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 100,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'quick_view',
				'mobile_options' => true,
			),
			'qv_price_spacing'  => array(
				'label'          => __('Price Spacing Top', 'wdc-wow-divi-carousel'),
				'type'           => 'range',
				'default_unit'   => 'px',
				'default'        => '10px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 100,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'quick_view_texts',
				'sub_toggle'     => 'price',
				'mobile_options' => true,
			),
			'qv_desc_spacing'   => array(
				'label'          => __('Description Spacing Top', 'wdc-wow-divi-carousel'),
				'type'           => 'range',
				'default_unit'   => 'px',
				'default'        => '15px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 100,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'quick_view_texts',
				'sub_toggle'     => 'desc',
				'mobile_options' => true,
			),
			'qv_cat_spacing'    => array(
				'label'          => __('Category Spacing Top', 'wdc-wow-divi-carousel'),
				'type'           => 'range',
				'default_unit'   => 'px',
				'default'        => '25px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 100,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'quick_view_texts',
				'sub_toggle'     => 'category',
				'mobile_options' => true,
			),
		);

		$carousel_options = WDC_Builder_Module::get_carousel_option_fields('common', array('equal_height'));
		$overlay          = $this->get_overlay_option_fields('overlay', array());
		$quick_view_bg    = $this->custom_advanced_background_fields('quick_view', 'Modal', 'advanced', 'quick_view', array('color', 'gradient'), array('show_quick_view' => 'on'), '');
		$item_bg          = $this->custom_advanced_background_fields('item', 'Item', 'advanced', 'common', array('color', 'gradient'), array(), '');

		return array_merge($carousel_options, $fields, $overlay, $quick_view_bg, $qv_modal, $item_bg);
	}

	public function get_advanced_fields_config() {

		$advanced_fields = array();

		$advanced_fields['text']         = false;
		$advanced_fields['text_shadow']  = false;
		$advanced_fields['link_options'] = false;
		$advanced_fields['fonts']        = false;

		$advanced_fields['box_shadow']['item'] = array(
			'label'       => esc_html__('Item Box Shadow', 'wdc-wow-divi-carousel'),
			'css'         => array(
				'main'      => '%%order_class%% .wdc-woo-product-inner',
				'important' => 'all',
			),
			'tab_slug'    => 'advanced',
			'toggle_slug' => 'common',
		);

		$advanced_fields['borders']['image'] = array(
			'label_prefix' => esc_html__('Image', 'wdc-wow-divi-carousel'),
			'toggle_slug'  => 'image',
			'css'          => array(
				'main'      => array(
					'border_radii'  => '%%order_class%% .wdc-woo-figure',
					'border_styles' => '%%order_class%% .wdc-woo-figure',
				),
				'important' => 'all',
			),
			'defaults'     => array(
				'border_radii'  => 'on|0px|0px|0px|0px',
				'border_styles' => array(
					'width' => '0px',
					'color' => '#333',
					'style' => 'solid',
				),
			),
		);

		$advanced_fields['borders']['item'] = array(
			'label_prefix' => esc_html__('Item', 'wdc-wow-divi-carousel'),
			'toggle_slug'  => 'common',
			'css'          => array(
				'main'      => array(
					'border_radii'  => '%%order_class%% .wdc-woo-product-inner',
					'border_styles' => '%%order_class%% .wdc-woo-product-inner',
				),
				'important' => 'all',
			),
			'defaults'     => array(
				'border_radii'  => 'on|0px|0px|0px|0px',
				'border_styles' => array(
					'width' => '0px',
					'color' => '#333',
					'style' => 'solid',
				),
			),
		);

		$advanced_fields['borders']['label'] = array(
			'label_prefix' => esc_html__('Label', 'wdc-wow-divi-carousel'),
			'toggle_slug'  => 'label',
			'css'          => array(
				'main'      => array(
					'border_radii'  => '%%order_class%% .wdc-woo-label',
					'border_styles' => '%%order_class%% .wdc-woo-label',
				),
				'important' => 'all',
			),
			'defaults'     => array(
				'border_radii'  => 'on|0px|0px|0px|0px',
				'border_styles' => array(
					'width' => '0px',
					'color' => '#333',
					'style' => 'solid',
				),
			),
		);

		$advanced_fields['fonts']['modal_title'] = array(
			'label'           => esc_html__('Title', 'wdc-wow-divi-carousel'),
			'css'             => array(
				'main'      => '%%order_class%%__ .wdc-woo-quickview-content h3',
				'important' => 'all',
			),
			'hide_text_align' => true,
			'toggle_slug'     => 'quick_view_texts',
			'sub_toggle'      => 'title',
		);

		$advanced_fields['fonts']['modal_desc'] = array(
			'label'           => esc_html__('Description', 'wdc-wow-divi-carousel'),
			'css'             => array(
				'main'      => '%%order_class%%__ .wdc-woo-quickview-content .wdc-quickview-desc',
				'important' => 'all',
			),
			'hide_text_align' => true,
			'toggle_slug'     => 'quick_view_texts',
			'sub_toggle'      => 'desc',
		);

		$advanced_fields['fonts']['modal_price'] = array(
			'label'           => esc_html__('Price', 'wdc-wow-divi-carousel'),
			'css'             => array(
				'main'      => '%%order_class%%__ .wdc-woo-quickview-content .wdc-woo-price',
				'important' => 'all',
			),
			'hide_text_align' => true,
			'toggle_slug'     => 'quick_view_texts',
			'sub_toggle'      => 'price',
		);

		$advanced_fields['fonts']['modal_cat'] = array(
			'label'           => esc_html__('Category', 'wdc-wow-divi-carousel'),
			'css'             => array(
				'main'      => '%%order_class%%__ .wdc-woo-quickview-content .wdc-woo-categories, %%order_class%%__ .wdc-woo-quickview-content .wdc-woo-categories a',
				'important' => 'all',
			),
			'hide_text_align' => true,
			'toggle_slug'     => 'quick_view_texts',
			'sub_toggle'      => 'category',
		);

		$advanced_fields['fonts']['title'] = array(
			'label'           => esc_html__('Title', 'wdc-wow-divi-carousel'),
			'css'             => array(
				'main'      => '%%order_class%% .wdc-woo-title a',
				'important' => 'all',
			),
			'hide_text_align' => true,
			'header_level'    => array(
				'default'          => 'h4',
				'computed_affects' => array(
					'__product',
				),
			),
			'toggle_slug'     => 'texts',
			'sub_toggle'      => 'title',
		);

		$advanced_fields['fonts']['label'] = array(
			'label'           => esc_html__('Label', 'wdc-wow-divi-carousel'),
			'css'             => array(
				'main'      => '%%order_class%% .wdc-woo-label',
				'important' => 'all',
			),
			'toggle_slug'     => 'label',
			'hide_text_align' => true,
			'font_size'       => array(
				'default' => '14px',
			),
		);

		$advanced_fields['fonts']['old_price'] = array(
			'label'           => esc_html__('Price', 'wdc-wow-divi-carousel'),
			'css'             => array(
				'main'      => '%%order_class%% .wdc-price-html del',
				'important' => 'all',
			),
			'toggle_slug'     => 'footer',
			'sub_toggle'      => 'price',
			'hide_text_align' => true,
		);

		$advanced_fields['fonts']['sale_price'] = array(
			'label'           => esc_html__('Sale Price', 'wdc-wow-divi-carousel'),
			'css'             => array(
				'main'      => '%%order_class%% .wdc-price-html>.woocommerce-Price-amount>bdi, %%order_class%% .wdc-price-html ins,%%order_class%% .wdc-grouped.wdc-price-html',
				'important' => 'all',
			),
			'toggle_slug'     => 'footer',
			'sub_toggle'      => 'sale_price',
			'hide_text_align' => true,
		);

		$advanced_fields['fonts']['category'] = array(
			'label'           => esc_html__('Category', 'wdc-wow-divi-carousel'),
			'css'             => array(
				'main'       => '%%order_class%% .wdc-woo-categories a, %%order_class%% .wdc-woo-categories',
				'text_align' => '%%order_class%% .wdc-woo-categories',
				'important'  => 'all',
			),
			'hide_text_align' => true,
			'tab_slug'        => 'advanced',
			'toggle_slug'     => 'texts',
			'sub_toggle'      => 'category',
			'line_height'     => array(
				'range_settings' => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
			),
			'font_size'       => array(
				'default' => '14px',
			),
		);

		$advanced_fields['button']['modal_btn'] = array(
			'label'          => esc_html__('Button', 'wdc-wow-divi-carousel'),
			'css'            => array(
				'main'      => '%%order_class%%__ .wdc-woo-quickview-content .add_to_cart_button',
				'important' => 'all',
			),
			'box_shadow'     => array(
				'css' => array(
					'main' => '%%order_class%%__ .wdc-woo-quickview-content .add_to_cart_button',
				),
			),
			'borders'        => array(
				'css' => array(
					'important' => 'all',
				),
			),
			'margin_padding' => array(
				'css' => array(
					'important' => 'all',
				),
			),
			'text_size'      => array(
				'default' => '14px',
			),

			'border_width'   => array(
				'default' => '1px',
			),
			'use_alignment'  => false,
			'hide_icon'      => true,
			'tab_slug'       => 'advanced',
			'toggle_slug'    => 'quick_view_btn',
		);

		return $advanced_fields;
	}


	public static function get_products($args = array(), $conditional_tags = array(), $current_page = array()) {

		$defaults = array(
			'title_level'           => '',
			'type'                  => '',
			'order_by'              => '',
			'include_categories'    => '',
			'product_count'         => '',
			'post_offset'           => '',
			'exclude_posts'         => '',
			'show_title'            => '',
			'show_thumb'            => '',
			'show_categories'       => '',
			'show_price'            => '',
			'show_review'           => '',
			'show_cart_btn'         => '',
			'show_quick_view'       => '',
			'quick_view_type'       => '',
			'show_cart_msg'         => '',
			'added_btn_text'        => '',
			'added_msg'             => '',
			'image_hover_animation' => '',
			'layout'                => '',
			'show_parent_category'  => '',
			'show_qv_gallery'       => '',
			'show_qv_cart_btn'      => '',
			'show_qv_categories'    => '',
			'show_qv_ratings'       => '',
			'show_qv_price'         => '',
			'show_qv_desc'          => '',
			'overlay_icon'          => '',
			'only_sale_price'       => '',
			'is_lazyload'           => '',
		);

		$args = wp_parse_args($args, $defaults);

		$type                  = $args['type'];
		$order_by              = $args['order_by'];
		$title_level           = $args['title_level'];
		$include_categories    = explode(',', $args['include_categories']);
		$product_count         = $args['product_count'];
		$exclude_posts         = $args['exclude_posts'];
		$post_offset           = $args['post_offset'];
		$show_title            = $args['show_title'];
		$show_thumb            = $args['show_thumb'];
		$show_categories       = $args['show_categories'];
		$show_price            = $args['show_price'];
		$show_review           = $args['show_review'];
		$show_cart_btn         = $args['show_cart_btn'];
		$show_quick_view       = $args['show_quick_view'];
		$qv_cart_btn_text      = $args['qv_cart_btn_text'];
		$quick_view_type       = $args['quick_view_type'];
		$show_cart_msg         = $args['show_cart_msg'];
		$image_hover_animation = $args['image_hover_animation'];
		$show_parent_category  = $args['show_parent_category'];
		$show_qv_gallery       = $args['show_qv_gallery'];
		$show_qv_cart_btn      = $args['show_qv_cart_btn'];
		$show_qv_categories    = $args['show_qv_categories'];
		$show_qv_ratings       = $args['show_qv_ratings'];
		$show_qv_price         = $args['show_qv_price'];
		$show_qv_desc          = $args['show_qv_desc'];
		$overlay_icon          = $args['overlay_icon'];
		$show_cart_btn         = $args['show_cart_btn'];
		$show_label            = $args['show_label'];
		$label_text            = $args['label_text'];
		$layout                = $args['layout'];
		$processed_title_level = et_pb_process_header_level($title_level, 'h4');
		$processed_title_level = esc_html($processed_title_level);
		$title_element         = et_core_esc_previously($processed_title_level);

		$query_args = array(
			'posts_per_page' => intval($product_count),
			'post_type'      => 'product',
			'post_status'    => 'publish',
			'offset'         => intval($post_offset),
		);

		if (!empty($exclude_posts)) {
			$exclude_posts              = str_replace(' ', '', $exclude_posts);
			$exclude_posts              = explode(',', $exclude_posts);
			$query_args['post__not_in'] = $exclude_posts;
		}

		if ('featured' === $type) {
			$query_args['tax_query'][] = array(

				'taxonomy' => 'product_visibility',
				'field'    => 'name',
				'terms'    => 'featured',
				'operator' => 'IN',
			);
		} elseif ('sale' === $type) {

			$query_args['post__in'] = array_merge(array(0), wc_get_product_ids_on_sale());
		} elseif ('best_selling' === $type) {

			$query_args['meta_key'] = 'total_sales'; // phpcs:ignore
			$query_args['orderby']  = 'meta_value_num';
		} elseif ('top_rated' === $type) {

			$query_args['meta_key']   = '_wc_average_rating'; // phpcs:ignore
			$query_args['orderby']    = 'meta_value_num';
			$query_args['order']      = 'DESC';
			$query_args['meta_query'] = WC()->query->get_meta_query(); // phpcs:ignore
			$query_args['tax_query']  = WC()->query->get_tax_query(); // phpcs:ignore

		}

		// Category Filter.
		$product_categories = array();

		$all_shop_categories = et_builder_get_shop_categories();
		if (is_array($all_shop_categories) && !empty($all_shop_categories)) {

			foreach ($all_shop_categories as $category) {
				if (is_object($category) && is_a($category, 'WP_Term')) {
					if (in_array($category->term_id, $include_categories, false)) {
						$product_categories[] = $category->slug;
					}
				}
			}
		}

		if (!empty($product_categories)) {

			$query_args['tax_query'][] = array(
				'taxonomy' => 'product_cat',
				'field'    => 'slug',
				'terms'    => $product_categories,
				'operator' => 'IN',
			);
		}

		// Orderby.
		if ('popularity' === $order_by) {

			$query_args['meta_key'] = 'total_sales'; // phpcs:ignore
			$query_args['orderby']  = 'meta_value_num';
		} elseif ('date' === $order_by) {

			$query_args['orderby'] = 'date';
			$query_args['order']   = 'ASC';
		} elseif ('date-desc' === $order_by) {

			$query_args['orderby'] = 'date';
			$query_args['order']   = 'DESC';
		} elseif ('price' === $order_by) {

			$query_args['orderby']  = 'meta_value_num';
			$query_args['order']    = 'ASC';
			$query_args['meta_key'] = '_price'; // phpcs:ignore

		} elseif ('price-desc' === $order_by) {

			$query_args['orderby']  = 'meta_value_num';
			$query_args['order']    = 'DESC';
			$query_args['meta_key'] = '_price'; // phpcs:ignore
		}

		$query = new WP_Query($query_args);

		ob_start();
		if ($query->have_posts()) :
			while ($query->have_posts()) :
				$query->the_post();

				$thumb_id = get_post_thumbnail_id(get_the_ID());
				$alt      = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);
				global $product;

				$class = '';
				if ($product->is_type('grouped') || $product->is_type('variable')) {
					$class = 'wdc-grouped';
				}

				$cart_class  = $product->is_purchasable() && $product->is_in_stock() ? 'wdc-add-to-cart-btn' : '';
				$woo_post_id = $product->get_id();
				$woo_rating  = $product->get_rating_count();

				include WOW_DIVI_CAROUSEL_PLUGIN_DIR . 'templates/product/layout-1.php';

			endwhile;
			wp_reset_postdata();
		endif;

		$output = ob_get_clean();

		if (!$output) {
			$output = self::get_no_results_template(et_core_esc_previously($processed_title_level));
		}

		return $output;
	}

	public function render($attrs, $content, $render_slug) {

		$this->apply_css($render_slug);
		$this->apply_modal_css($render_slug);

		$is_center              = $this->props['is_center'];
		$sliding_dir            = $this->props['sliding_dir'];
		$center_mode_type       = $this->props['center_mode_type'];
		$custom_cursor          = $this->props['custom_cursor'];
		$overlay_icon           = $this->props['overlay_icon'];
		$is_equal_height        = $this->props['is_equal_height'];
		$show_quick_view        = $this->props['show_quick_view'];
		$alignment              = $this->props['alignment'];
		$processed_overlay_icon = esc_attr(et_pb_process_font_icon($overlay_icon));
		$overlay_icon           = !empty($processed_overlay_icon) ? $processed_overlay_icon : '';
		$order_class            = self::get_module_order_class($render_slug);
		$order_number           = str_replace('_', '', str_replace($this->slug, '', $order_class));
		$classes                = array();

		if ('on' === $show_quick_view) {
			wp_enqueue_style('wdc-magnific');
			wp_enqueue_script('wdc-magnific');
		}

		if ('on' === $is_center) {
			array_push($classes, 'wdc-centered');
			array_push($classes, "wdc-centered--{$center_mode_type}");
		}

		if ('on' === $custom_cursor) {
			array_push($classes, 'wdc-cursor');
		}

		array_push($classes, "wdc-text-{$alignment}");
		array_push($classes, "equal-height-{$is_equal_height}");
		wdc_inject_fa_icons($this->props['overlay_icon']);

		$output = sprintf(
			'<div class="wdc-carousel-parent" %2$s dir="%5$s">
                <div class="wdc-carousel wdc-product-carousel-%4$s wdc-carousel-jq wdc-product-carousel wdc-carousel-frontend %3$s" data-modal-parent="%4$s__">
                    %1$s
                </div>
            </div>',
			self::get_products($this->props),
			$this->get_carousel_options_data($order_number, 'product'),
			join(' ', $classes),
			$order_class,
			$sliding_dir
		);

		return $output;
	}

	public function apply_css($render_slug) {

		$this->apply_carousel_css($render_slug);
		$this->render_products_css($render_slug);
		$this->get_overlay_style($render_slug);
		$this->get_custom_bg_style($render_slug, 'item', '%%order_class%% .wdc-woo-product-inner', '%%order_class%% .wdc-woo-product-inner:hover');
	}

	public function apply_modal_css($render_slug) {

		$this->get_custom_bg_style($render_slug, 'quick_view', '%%order_class%%__.wdc-modal', '%%order_class%%__.wdc-modal:hover');

		$show_qv_category_prefix = $this->props['show_qv_category_prefix'];
		$qv_rating_color         = $this->props['qv_rating_color'];

		if ('off' === $show_qv_category_prefix) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%%__ .wdc-woo-categories span',
					'declaration' => 'display: none!important;',
				)
			);
		}

		if (!empty($qv_rating_color)) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%%__.wdc-woo-product .star-rating',
					'declaration' => sprintf(
						'color: %1$s;',
						$qv_rating_color
					),
				)
			);
		}

		$this->get_responsive_styles(
			'qv_stars_size',
			'%%order_class%%__.wdc-woo-product .star-rating',
			array(
				'primary'   => 'font-size',
				'important' => true,
			),
			array('default' => '14px'),
			$render_slug
		);

		$this->get_responsive_styles(
			'qv_rating_spacing',
			'%%order_class%%__.wdc-woo-product .wdc-woo-review',
			array(
				'primary'   => 'margin-top',
				'important' => true,
			),
			array('default' => '15px'),
			$render_slug
		);

		$this->get_responsive_styles(
			'qv_price_spacing',
			'%%order_class%%__.wdc-woo-product .wdc-sale-price',
			array(
				'primary'   => 'margin-top',
				'important' => true,
			),
			array('default' => '10px'),
			$render_slug
		);

		$this->get_responsive_styles(
			'qv_desc_spacing',
			'%%order_class%%__.wdc-woo-quickview .wdc-quickview-desc',
			array(
				'primary'   => 'margin-top',
				'important' => true,
			),
			array('default' => '15px'),
			$render_slug
		);

		$this->get_responsive_styles(
			'qv_cat_spacing',
			'%%order_class%%__.wdc-woo-quickview .wdc-woo-categories',
			array(
				'primary'   => 'margin-top',
				'important' => true,
			),
			array('default' => '25px'),
			$render_slug
		);
	}

	public function render_products_css($render_slug) {

		$use_single_title                  = $this->props['use_single_title'];
		$content_padding                   = $this->props['content_padding'];
		$content_padding_tablet            = $this->props['content_padding_tablet'];
		$content_padding_phone             = $this->props['content_padding_phone'];
		$content_padding_last_edited       = $this->props['content_padding_last_edited'];
		$content_padding_responsive_status = et_pb_get_responsive_status($content_padding_last_edited);
		$image_spacing                     = $this->props['image_spacing'];
		$image_height                      = $this->props['image_height'];
		$label_position                    = explode('_', $this->props['label_position']);
		$label_offset_x                    = $this->props['label_offset_x'];
		$label_offset_y                    = $this->props['label_offset_y'];
		$label_bg                          = $this->props['label_bg'];
		$only_sale_price                   = $this->props['only_sale_price'];
		$show_review                       = $this->props['show_review'];
		$layout                            = $this->props['layout'];
		$label_padding                     = $this->props['label_padding'];
		$review_spacing_top                = $this->props['review_spacing_top'];
		$review_spacing_bottom             = $this->props['review_spacing_bottom'];
		$stars_size                        = $this->props['stars_size'];
		$stars_color                       = $this->props['stars_color'];
		$title_spacing_top                 = $this->props['title_spacing_top'];
		$title_spacing_bottom              = $this->props['title_spacing_bottom'];
		$btns_height                       = $this->props['btns_height'];
		$btns_width                        = $this->props['btns_width'];
		$btns_separetor_color              = $this->props['btns_separetor_color'];
		$cart_btn_icon_size                = $this->props['cart_btn_icon_size'];
		$qv_btn_icon_color                 = $this->props['qv_btn_icon_color'];
		$qv_btn_icon_color_hover           = $this->get_hover_value('qv_btn_icon_color');
		$cart_btn_icon_color               = $this->props['cart_btn_icon_color'];
		$cart_btn_icon_color_hover         = $this->get_hover_value('cart_btn_icon_color');
		$qv_btn_bg                         = $this->props['qv_btn_bg'];
		$qv_btn_bg_hover                   = $this->get_hover_value('qv_btn_bg');
		$cart_btn_bg                       = $this->props['cart_btn_bg'];
		$cart_btn_bg_hover                 = $this->get_hover_value('cart_btn_bg');
		$qv_btn_radius                     = explode('|', $this->props['qv_btn_radius']);
		$cart_btn_radius                   = explode('|', $this->props['cart_btn_radius']);
		$qv_btn_icon_size                  = $this->props['qv_btn_icon_size'];
		$qv_btn_icon_size                  = $this->props['qv_btn_icon_size'];
		$footer_alignment                  = $this->props['footer_alignment'];
		$footer_padding                    = $this->props['footer_padding'];
		$footer_padding_tablet             = $this->props['footer_padding_tablet'];
		$footer_padding_phone              = $this->props['footer_padding_phone'];
		$footer_padding_last_edited        = $this->props['footer_padding_last_edited'];
		$footer_padding_responsive_status  = et_pb_get_responsive_status($footer_padding_last_edited);
		$post_padding                      = $this->props['post_padding'];
		$post_padding_tablet               = $this->props['post_padding_tablet'];
		$post_padding_phone                = $this->props['post_padding_phone'];
		$post_padding_last_edited          = $this->props['post_padding_last_edited'];
		$post_padding_responsive_status    = et_pb_get_responsive_status($post_padding_last_edited);

		if (class_exists('ET_Builder_Module_Helper_Style_Processor')) {
			$this->generate_styles(
				array(
					'utility_arg'    => 'icon_font_family',
					'render_slug'    => $render_slug,
					'base_attr_name' => 'overlay_icon',
					'important'      => true,
					'selector'       => '%%order_class%% .wdc-overlay .wdc-overlay-icon',
					'processor'      => array(
						'ET_Builder_Module_Helper_Style_Processor',
						'process_extended_icon',
					),
				)
			);
		}

		// Item Padding.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-woo-product-inner',
				'declaration' => WDC_Builder_Module::wdc_process_padding($post_padding, false),
			)
		);

		if ($post_padding_tablet && $post_padding_responsive_status) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-woo-product-inner',
					'media_query' => ET_Builder_Element::get_media_query('max_width_980'),
					'declaration' => WDC_Builder_Module::wdc_process_padding($post_padding_tablet, false),
				)
			);
		}

		if ($post_padding_phone && $post_padding_responsive_status) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-woo-product-inner',
					'media_query' => ET_Builder_Element::get_media_query('max_width_767'),
					'declaration' => WDC_Builder_Module::wdc_process_padding($post_padding_phone, false),
				)
			);
		}

		// Title.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-woo-title',
				'declaration' => sprintf(
					'padding-bottom: %1$s; padding-top: %2$s;',
					$title_spacing_bottom,
					$title_spacing_top
				),
			)
		);

		if ('on' === $use_single_title) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-woo-title a',
					'declaration' => 'text-overflow: ellipsis; overflow: hidden; white-space: nowrap; width: 100%;',
				)
			);
		}

		// Texts Padding.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-woo-content',
				'declaration' => WDC_Builder_Module::wdc_process_padding($content_padding, false),
			)
		);

		// Texts Padding Tablet.
		if ($content_padding_tablet && $content_padding_responsive_status) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-woo-content',
					'media_query' => ET_Builder_Element::get_media_query('max_width_980'),
					'declaration' => WDC_Builder_Module::wdc_process_padding($content_padding_tablet, false),
				)
			);
		}

		// Texts Padding Phone.
		if ($content_padding_phone && $content_padding_responsive_status) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-woo-content',
					'media_query' => ET_Builder_Element::get_media_query('max_width_767'),
					'declaration' => WDC_Builder_Module::wdc_process_padding($content_padding_phone, false),
				)
			);
		}

		// Image.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-woo-figure',
				'declaration' => sprintf('height: %1$s; margin-bottom: %2$s;', $image_height, $image_spacing),
			)
		);

		// Label.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-woo-label',
				'declaration' => sprintf(
					'
                background: %1$s; %2$s;',
					$label_bg,
					WDC_Builder_Module::wdc_process_padding($label_padding, false)
				),
			)
		);

		// Label Offset x.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-woo-label',
				'declaration' => sprintf('%1$s: %2$s;', $label_position[0], $label_offset_x),
			)
		);

		// Label Offset y.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-woo-label',
				'declaration' => sprintf('%1$s: %2$s;', $label_position[1], $label_offset_y),
			)
		);

		// Old Price.
		if ('on' === $only_sale_price) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-woo-price-review del',
					'declaration' => 'display: none;',
				)
			);
		}

		// content.
		if (!empty($this->props['alignment'])) {
			$this->get_responsive_styles(
				'alignment',
				'%%order_class%% .wdc-woo-content',
				array('primary' => 'text-align'),
				array('default' => 'initial'),
				$render_slug
			);
		}

		// Footer.
		if ('v2' !== $layout) {
			if ('row_center' !== $footer_alignment) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-woo-price-review',
						'declaration' => sprintf(
							'
                        display: flex; align-items: center; justify-content:%1$s;',
							$footer_alignment
						),
					)
				);

				if ('center' === $footer_alignment) {
					ET_Builder_Element::set_style(
						$render_slug,
						array(
							'selector'    => '%%order_class%% .wdc-woo-price-review>div',
							'declaration' => 'margin: 0 5px;',
						)
					);
				} elseif ('flex-start' === $footer_alignment || 'flex-end' === $footer_alignment) {
					ET_Builder_Element::set_style(
						$render_slug,
						array(
							'selector'    => '%%order_class%% .wdc-price-html',
							'declaration' => 'margin-right: 10px;',
						)
					);
				}
			} else {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-woo-price-review>div',
						'declaration' => 'justify-content: center;text-align: center;',
					)
				);
			}
		}

		// Footer Padding.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-woo-bottom',
				'declaration' => WDC_Builder_Module::wdc_process_padding($footer_padding, false),
			)
		);

		// Footer Padding Tablet.
		if ($footer_padding_tablet && $footer_padding_responsive_status) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-woo-bottom',
					'media_query' => ET_Builder_Element::get_media_query('max_width_980'),
					'declaration' => WDC_Builder_Module::wdc_process_padding($footer_padding_tablet, false),
				)
			);
		}

		// Footer Padding Phone.
		if ($footer_padding_phone && $footer_padding_responsive_status) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-woo-bottom',
					'media_query' => ET_Builder_Element::get_media_query('max_width_767'),
					'declaration' => WDC_Builder_Module::wdc_process_padding($footer_padding_phone, false),
				)
			);
		}

		// review.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-woo-review',
				'declaration' => sprintf('padding-top: %1$s;padding-bottom:%2$s;', $review_spacing_top, $review_spacing_bottom),
			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-woo-product .star-rating',
				'declaration' => sprintf('color: %1$s!important;font-size:%2$s!important;', $stars_color, $stars_size),
			)
		);

		// Buttons Common.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-woo-product .wdc-product-act-btn',
				'declaration' => sprintf('height: %1$s!important;', $btns_height),
			)
		);

		if ('v3' !== $layout) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-woo-product .wdc-product-act-btn',
					'declaration' => sprintf('width: %1$s;', $btns_width),
				)
			);
		}

		if ('v3' === $layout && !empty($btns_separetor_color)) {

			if ('on' === $this->props['show_cart_btn'] && 'on' === $this->props['show_quick_view']) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-woo-product .wdc-product-act-btn',
						'declaration' => sprintf('border-right: 1px solid %1$s;', $btns_separetor_color),
					)
				);
			}
		}

		// button Quick View.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-woo-product .wdc-woo-quick-veiw-btn',
				'declaration' => sprintf(
					'
                font-size: %1$s!important;
                background: %2$s!important;
                border-radius: %3$s %4$s %5$s %6$s!important;
                color: %7$s!important;',
					$qv_btn_icon_size,
					$qv_btn_bg,
					$qv_btn_radius[1],
					$qv_btn_radius[2],
					$qv_btn_radius[3],
					$qv_btn_radius[4],
					$qv_btn_icon_color
				),
			)
		);

		if (!empty($qv_btn_icon_color_hover)) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-woo-product .wdc-woo-quick-veiw-btn:hover',
					'declaration' => sprintf('color: %1$s!important;', $qv_btn_icon_color_hover),
				)
			);
		}

		if (!empty($qv_btn_bg_hover)) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-woo-product .wdc-woo-quick-veiw-btn:hover',
					'declaration' => sprintf('background: %1$s!important;', $qv_btn_bg_hover),
				)
			);
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-woo-product .wdc-add-to-cart-btn',
				'declaration' => sprintf(
					'font-size: %1$s!important;
                	background: %2$s!important;
                	border-radius: %3$s %4$s %5$s %6$s!important;
                	color: %7$s!important;',
					$cart_btn_icon_size,
					$cart_btn_bg,
					$cart_btn_radius[1],
					$cart_btn_radius[2],
					$cart_btn_radius[3],
					$cart_btn_radius[4],
					$cart_btn_icon_color
				),
			)
		);

		if (!empty($cart_btn_icon_color_hover)) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-woo-product .wdc-add-to-cart-btn:hover',
					'declaration' => sprintf('color: %1$s!important;', $cart_btn_icon_color_hover),
				)
			);
		}

		if (!empty($cart_btn_bg_hover)) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-woo-product .wdc-add-to-cart-btn:hover',
					'declaration' => sprintf('background: %1$s!important;', $cart_btn_bg_hover),
				)
			);
		}
	}
}

new WDC_ProductCarousel();
