<?php
class WowPostHelper {

	public static function render_date_content( $content ) {
		$output = '';
		switch ( $content ) {
			case 'D':
				$output = sprintf(
					'<div class="wdc-post-date-box wdc-day">
						<span class="__day">%1$s</span>
					</div>',
					get_the_time( 'D' )
				);
				break;

			case 'M':
				$output = sprintf(
					'<div class="wdc-post-date-box wdc-month">
					<span class="__month">%1$s</span>
					</div>',
					get_the_time( 'M' )
				);
				break;

			case 'D|M':
				$output = sprintf(
					'<div class="wdc-post-date-box wdc-day-month">
						<span class="__day">%1$s</span>
						<span class="__month">%2$s</span>
					</div>',
					get_the_time( 'd' ),
					get_the_time( 'M' )
				);
				break;

			case 'D|M|Y':
				$output = sprintf(
					'<div class="wdc-post-date-box wdc-date">
						<span class="__day">%1$s</span>
						<span class="__month">%2$s</span>
						<span class="__year">%3$s</span>
					</div>',
					get_the_time( 'd' ),
					get_the_time( 'M' ),
					get_the_time( 'Y' )
				);
				break;
		}
		return $output;
	}

	public static function render_post_thumb( $overlay_icon, $is_lazyload ) {
		$thumb_id = get_post_thumbnail_id( get_the_ID() );
		$alt      = get_post_meta( $thumb_id, '_wp_attachment_image_alt', true );

		return sprintf(
			'<figure class="wdc-post-thumb">
				<a href="%1$s">
					<div class="wdc-overlay"><span class="wdc-overlay-icon">%4$s</span></div>
					<img %5$s="%2$s" alt="%3$s">
				</a>
            </figure>',
			esc_url( get_the_permalink() ),
			esc_url( get_the_post_thumbnail_url() ),
			$alt,
			$overlay_icon,
			'on' === $is_lazyload ? 'data-lazy' : 'src'
		);
	}

	public static function render_post_categories( $separator, $show_first_category, $include_categories, $css_classes = '' ) {

		if ( 'off' === $show_first_category ) {
			return sprintf(
				'<div class="wdc-post-categories %2$s">%1$s</div>',
				et_builder_get_the_term_list( $separator . ' ' ),
				$css_classes
			);
		} else {
			if ( ! empty( $include_categories ) ) {
				$categories_ids = explode( ',', $include_categories );
			} else {
				$categories_ids = get_terms(
					array( 'category' ),
					array( 'fields' => 'ids' )
				);
			}

			return sprintf(
				'<div class="wdc-post-categories %3$s"><a rel="tag" href="%2$s">%1$s</a></div>',
				get_the_category_by_ID( $categories_ids[0] ),
				get_category_link( $categories_ids[0] ),
				$css_classes
			);
		}
	}

	public static function render_post_title( $tag ) {
		return sprintf(
			'<%1$s class="wdc-post-title">
                <a href="%2$s">%3$s</a>
            </%1$s>',
			$tag,
			esc_url( get_the_permalink() ),
			get_the_title()
		);
	}

	public static function render_post_button( $button_text, $icon_name ) {
		return sprintf(
			'<div class="wdc-post-btn-wrap">
                <a href="%1$s" target="_self" class="et_pb_button wdc-post-btn" data-icon="%2$s">
                    %3$s
                </a>
            </div>',
			esc_url( get_the_permalink() ),
			$icon_name,
			$button_text
		);
	}

	public static function get_post_content( $length = '-1' ) {
		global $post;
		$content = '';

		if ( ! has_excerpt() ) {

			$content = $post->post_content;
			$content = preg_replace( '@\[caption[^\]]*?\].*?\[\/caption]@si', '', $content );
			$content = preg_replace( '@\[et_pb_post_nav[^\]]*?\].*?\[\/et_pb_post_nav]@si', '', $content );
			$content = preg_replace( '@\[audio[^\]]*?\].*?\[\/audio]@si', '', $content );
			$content = preg_replace( '@\[embed[^\]]*?\].*?\[\/embed]@si', '', $content );
			$content = wp_strip_all_tags( $content );
			$content = et_strip_shortcodes( $content );
			$content = et_builder_strip_dynamic_content( $content );
			$content = apply_filters( 'et_truncate_post', $content, get_the_ID() );
		} else {

			$content = apply_filters( 'the_excerpt', $post->post_excerpt );
		}

		if ( $length > 0 ) {

			if ( strlen( $content ) <= $length ) {

				$str_end = '';
			} else {

				$str_end = '...';
			}

			$content = rtrim( et_wp_trim_words( $content, $length, '' ) );

			if ( ! empty( $str_end ) ) {

				$new_words_array = (array) explode( ' ', $content );
				array_pop( $new_words_array );
				$content  = implode( ' ', $new_words_array );
				$content .= $str_end;
			}

			return et_core_intentionally_unescaped( $content, 'html' );
		} else {

			return et_core_intentionally_unescaped( $content, 'html' );
		}
	}

	public static function render_post_content( $length = '-1' ) {
		return sprintf( '<div class="wdc-post-text">%1$s</div>', self::get_post_content( $length ) );
	}

	public static function render_post_author( $use_author_photo ) {

		global $authordata;
		$author = '';

		if ( 'on' === $use_author_photo ) {
			$author = sprintf( '<img data-lazy="%1$s">', esc_url( get_avatar_url( $authordata->ID ) ) );
		} else {
			$author = '<i class="wdc-ico-user"></i>';
		}

		return sprintf(
			'<div class="wdc-post-author wdc-post-meta-item">
				%1$s
				%2$s
			</div>',
			$author,
			et_pb_get_the_author_posts_link()
		);
	}

	public static function render_post_date( $date_format ) {
		return sprintf(
			'<div class="wdc-post-date wdc-post-meta-item">
                <i class="wdc-ico-calendar"></i> <span>%1$s</span>
            </div>',
			get_the_time( $date_format )
		);
	}

	public static function render_post_comments_number() {
		return sprintf(
			'<div class="wdc-post-comment wdc-post-meta-item">
                <i class="wdc-ico-comment"></i> <span>%1$s</span>
            </div>',
			get_comments_number()
		);
	}

}
