<?php

class WDC_PostCarousel extends Wow_Builder_Module_Type_PostBased {

	protected $module_credits = array(
		'module_uri' => 'https://wowcarousel.com/modules/post-carousel/',
		'author'     => 'Wow Carousel',
		'author_uri' => 'https://divipeople.com/wow-divi-carousel/',
	);

	public function init() {

		$this->vb_support = 'on';
		$this->name       = esc_html__( 'Wow Post Carousel', 'wdc-wow-divi-carousel' );
		$this->plural     = esc_html__( 'Wow Post Carousels', 'wdc-wow-divi-carousel' );
		$this->icon_path  = plugin_dir_path( __FILE__ ) . 'wdc-post.svg';
		$this->slug       = 'wdc_post_carousel';

		$this->settings_modal_toggles = array(
			'general'  => array(
				'toggles' => array(
					'content'  => esc_html__( 'Content', 'wdc-wow-divi-carousel' ),
					'elements' => esc_html__( 'Elements', 'wdc-wow-divi-carousel' ),
					'settings' => array(
						'title'             => esc_html__( 'Carousel Settings', 'wdc-wow-divi-carousel' ),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'general'  => array(
								'name' => esc_html__( 'General', 'wdc-wow-divi-carousel' ),
							),
							'advanced' => array(
								'name' => esc_html__( 'Advanced', 'wdc-wow-divi-carousel' ),
							),
						),
					),
				),
			),

			'advanced' => array(
				'toggles' => array(
					'common'     => esc_html__( 'General', 'wdc-wow-divi-carousel' ),
					'image'      => esc_html__( 'Image', 'wdc-wow-divi-carousel' ),
					'overlay'    => esc_html__( 'Overlay', 'wdc-wow-divi-carousel' ),
					'content'    => esc_html__( 'Content', 'wdc-wow-divi-carousel' ),
					'date_box'   => esc_html__( 'Date', 'wdc-wow-divi-carousel' ),
					'texts'      => array(
						'title'             => esc_html__( 'Texts', 'wdc-wow-divi-carousel' ),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'title'    => array(
								'name' => esc_html__( 'Title', 'wdc-wow-divi-carousel' ),
							),
							'content'  => array(
								'name' => esc_html__( 'Content', 'wdc-wow-divi-carousel' ),
							),
							'category' => array(
								'name' => esc_html__( 'Category', 'wdc-wow-divi-carousel' ),
							),
						),
					),
					'meta'       => array(
						'title'             => esc_html__( 'Meta', 'wdc-wow-divi-carousel' ),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'common' => array(
								'name' => esc_html__( 'Common', 'wdc-wow-divi-carousel' ),
							),
							'text'   => array(
								'name' => esc_html__( 'Text', 'wdc-wow-divi-carousel' ),
							),
						),
					),
					'author'     => esc_html__( 'Author', 'wdc-wow-divi-carousel' ),
					'button'     => esc_html__( 'Button', 'wdc-wow-divi-carousel' ),
					'footer'     => esc_html__( 'Footer', 'wdc-wow-divi-carousel' ),
					'arrow'      => array(
						'title'             => esc_html__( 'Navigation', 'wdc-wow-divi-carousel' ),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'arrow_common' => array(
								'name' => esc_html__( 'Common', 'wdc-wow-divi-carousel' ),
							),
							'arrow_left'   => array(
								'name' => esc_html__( 'Prev', 'wdc-wow-divi-carousel' ),
							),
							'arrow_right'  => array(
								'name' => esc_html__( 'Next', 'wdc-wow-divi-carousel' ),
							),
						),
					),
					'pagination' => array(
						'title'             => esc_html__( 'Pagination', 'wdc-wow-divi-carousel' ),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'pagi_common' => array(
								'name' => esc_html__( 'Common', 'wdc-wow-divi-carousel' ),
							),
							'pagi_active' => array(
								'name' => esc_html__( 'Active', 'wdc-wow-divi-carousel' ),
							),
						),
					),
				),
			),
		);
	}

	public function get_fields() {

		$post_options = array(

			// Content.
			'layout'                  => array(
				'label'            => esc_html__( 'Post Carousel Style', 'wdc-wow-divi-carousel' ),
				'type'             => 'select',
				'toggle_slug'      => 'content',
				'default'          => 'layout1',
				'computed_affects' => array( '__posts' ),
				'options'          => array(
					'layout1' => esc_html__( 'Layout 1', 'wdc-wow-divi-carousel' ),
					'layout2' => esc_html__( 'Layout 2', 'wdc-wow-divi-carousel' ),
					'layout3' => esc_html__( 'Layout 3', 'wdc-wow-divi-carousel' ),
					'layout4' => esc_html__( 'Layout 4', 'wdc-wow-divi-carousel' ),
					'layout5' => esc_html__( 'Layout 5', 'wdc-wow-divi-carousel' ),
				),
			),
			'post_type'               => array(
				'label'            => esc_html__( 'Post Type', 'wdc-wow-divi-carousel' ),
				'type'             => 'select',
				'option_category'  => 'configuration',
				'options'          => et_get_registered_post_type_options( false, false ),
				'description'      => esc_html__( 'Choose posts of which post type you would like to display.', 'wdc-wow-divi-carousel' ),
				'computed_affects' => array(
					'__posts',
				),
				'toggle_slug'      => 'content',
				'default'          => 'post',
			),
			'include_categories'      => array(
				'label'            => esc_html__( 'Included Categories', 'wdc-wow-divi-carousel' ),
				'type'             => 'categories',
				'renderer_options' => array(
					'use_terms' => false,
				),
				'meta_categories'  => array(
					'current' => esc_html__( 'Current Category', 'wdc-wow-divi-carousel' ),
				),
				'option_category'  => 'basic_option',
				'toggle_slug'      => 'content',
				'computed_affects' => array( '__posts' ),
				'show_if'          => array(
					'post_type' => 'post',
				),
			),

			'order_by'                => array(
				'label'            => esc_html__( 'Order By', 'wdc-wow-divi-carousel' ),
				'description'      => esc_html__( 'Choose how your Posts should be ordered.', 'wdc-wow-divi-carousel' ),
				'type'             => 'select',
				'option_category'  => 'configuration',
				'toggle_slug'      => 'content',
				'default'          => 'date',
				'options'          => array(
					'author' => esc_html__( 'Author', 'wdc-wow-divi-carousel' ),
					'date'   => esc_html__( 'Date', 'wdc-wow-divi-carousel' ),
					'ID'     => esc_html__( 'ID', 'wdc-wow-divi-carousel' ),
					'parent' => esc_html__( 'Parent', 'wdc-wow-divi-carousel' ),
					'rand'   => esc_html__( 'Random', 'wdc-wow-divi-carousel' ),
					'title'  => esc_html__( 'Title', 'wdc-wow-divi-carousel' ),
				),
				'default_on_front' => 'date',
				'computed_affects' => array( '__posts' ),
			),

			'order'                   => array(
				'label'            => esc_html__( 'Sorted By', 'wdc-wow-divi-carousel' ),
				'description'      => esc_html__( 'Choose how your Posts should be sorted.', 'wdc-wow-divi-carousel' ),
				'type'             => 'select',
				'option_category'  => 'configuration',
				'toggle_slug'      => 'content',
				'default'          => 'ASC',
				'options'          => array(
					'ASC'  => esc_html__( 'Ascending', 'wdc-wow-divi-carousel' ),
					'DESC' => esc_html__( 'Descending', 'wdc-wow-divi-carousel' ),
				),

				'default_on_front' => 'ASC',
				'computed_affects' => array( '__posts' ),
			),

			'post_count'              => array(
				'label'            => esc_html__( 'Post Limit', 'wdc-wow-divi-carousel' ),
				'type'             => 'text',
				'default'          => '5',
				'toggle_slug'      => 'content',
				'computed_affects' => array( '__posts' ),
			),
			'exclude_posts'           => array(
				'label'            => esc_html__( 'Exclude posts by IDs', 'wdc-wow-divi-carousel' ),
				'description'      => esc_html__( 'eg. 10, 22, 19 etc. If this is used by IDs, Selected Posts will be ignored.', 'wdc-wow-divi-carousel' ),
				'type'             => 'text',
				'toggle_slug'      => 'content',
				'computed_affects' => array( '__posts' ),
			),
			'post_offset'             => array(
				'label'            => esc_html__( 'Post Offset', 'wdc-wow-divi-carousel' ),
				'type'             => 'range',
				'default'          => '0',
				'unitless'         => true,
				'range_settings'   => array(
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				),
				'toggle_slug'      => 'content',
				'computed_affects' => array( '__posts' ),
			),

			'use_content_length'      => array(
				'label'            => esc_html__( 'Use Content Length', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'on',
				'toggle_slug'      => 'content',
				'computed_affects' => array( '__posts' ),
			),

			'content_length'          => array(
				'label'            => esc_html__( 'Content Length', 'wdc-wow-divi-carousel' ),
				'type'             => 'text',
				'default'          => '150',
				'toggle_slug'      => 'content',
				'computed_affects' => array( '__posts' ),
				'show_if'          => array(
					'use_content_length' => 'on',
				),
			),

			'date_format'             => array(
				'label'            => esc_html__( 'Date Format', 'wdc-wow-divi-carousel' ),
				'type'             => 'text',
				'default'          => 'M d, Y',
				'toggle_slug'      => 'content',
				'show_if'          => array(
					'show_date'            => 'on',
					'show_date_over_image' => 'off',
				),
				'computed_affects' => array( '__posts' ),
			),

			'button_text'             => array(
				'label'            => __( 'Button Text', 'wdc-wow-divi-carousel' ),
				'type'             => 'text',
				'default'          => 'Read More',
				'toggle_slug'      => 'content',
				'computed_affects' => array( '__posts' ),
				'show_if'          => array(
					'show_btn' => 'on',
				),
			),

			// elements.
			'show_thumb'              => array(
				'label'            => esc_html__( 'Show Featured Image', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'on',
				'toggle_slug'      => 'elements',
				'computed_affects' => array( '__posts' ),
			),

			'show_title'              => array(
				'label'            => esc_html__( 'Show Title', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'on',
				'toggle_slug'      => 'elements',
				'computed_affects' => array( '__posts' ),
			),

			'show_content'            => array(
				'label'            => esc_html__( 'Show Content', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'on',
				'toggle_slug'      => 'elements',
				'computed_affects' => array( '__posts' ),
			),

			'show_categories'         => array(
				'label'            => esc_html__( 'Show Categories', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'on',
				'toggle_slug'      => 'elements',
				'computed_affects' => array( '__posts' ),
			),
			'show_first_category'     => array(
				'label'            => esc_html__( 'Show Single Category', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'off',
				'toggle_slug'      => 'elements',
				'computed_affects' => array( '__posts' ),
				'show_if'          => array(
					'show_categories' => 'on',
				),
			),
			'show_category_separator' => array(
				'label'            => esc_html__( 'Show Categories Separator Comma', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'on',
				'toggle_slug'      => 'elements',
				'computed_affects' => array( '__posts' ),
				'show_if'          => array(
					'show_categories'     => 'on',
					'show_first_category' => 'off',
				),
			),

			'show_author'             => array(
				'label'            => esc_html__( 'Show Author', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'on',
				'toggle_slug'      => 'elements',
				'computed_affects' => array( '__posts' ),
			),

			'show_date'               => array(
				'label'            => esc_html__( 'Show Date', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'on',
				'toggle_slug'      => 'elements',
				'computed_affects' => array( '__posts' ),
			),

			'show_date_over_image'    => array(
				'label'            => esc_html__( 'Show Date Over Image', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'off',
				'toggle_slug'      => 'elements',
				'computed_affects' => array( '__posts' ),
				'show_if'          => array(
					'show_date' => 'on',
				),
			),

			'date_format_over_image'  => array(
				'label'            => esc_html__( 'Date Format', 'wdc-wow-divi-carousel' ),
				'type'             => 'select',
				'default'          => 'D|M|Y',
				'toggle_slug'      => 'elements',
				'computed_affects' => array( '__posts' ),
				'options'          => array(
					'D|M|Y' => esc_html__( 'Day Month & Year', 'wdc-wow-divi-carousel' ),
					'D|M'   => esc_html__( 'Day & Month', 'wdc-wow-divi-carousel' ),
					'D'     => esc_html__( 'Day', 'wdc-wow-divi-carousel' ),
					'M'     => esc_html__( 'Month', 'wdc-wow-divi-carousel' ),
				),
				'show_if'          => array(
					'show_date_over_image' => 'on',
				),
			),

			'show_comment_count'      => array(
				'label'            => esc_html__( 'Show Comments Count', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'on',
				'toggle_slug'      => 'elements',
				'computed_affects' => array( '__posts' ),
			),

			'show_btn'                => array(
				'label'            => esc_html__( 'Show Readmore', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'off',
				'toggle_slug'      => 'elements',
				'computed_affects' => array( '__posts' ),
			),

			// common.
			'post_padding'            => array(
				'label'          => __( 'Post Padding', 'wdc-wow-divi-carousel' ),
				'type'           => 'custom_padding',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'common',
				'default'        => '20px|20px|20px|20px',
				'mobile_options' => true,
				'show_if'        => array(
					'layout' => 'layout2',
				),
			),

			'post_bg'                 => array(
				'label'       => esc_html__( 'Post Background', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'toggle_slug' => 'common',
				'tab_slug'    => 'advanced',
			),

			// Content.
			'alignment'               => array(
				'label'          => __( 'Text Alignment', 'wdc-wow-divi-carousel' ),
				'type'           => 'text_align',
				'options'        => et_builder_get_text_orientation_options( array( 'justified' ) ),
				'options_icon'   => 'module_align',
				'default'        => 'left',
				'toggle_slug'    => 'content',
				'tab_slug'       => 'advanced',
				'mobile_options' => true,
			),

			'content_padding'         => array(
				'label'          => esc_html__( 'Content Padding', 'wdc-wow-divi-carousel' ),
				'type'           => 'custom_padding',
				'toggle_slug'    => 'content',
				'tab_slug'       => 'advanced',
				'mobile_options' => true,
			),

			'content_width'           => array(
				'label'           => esc_html__( 'Content Width', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '90%',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px', '%' ),
				'default_unit'    => '%',
				'range_settings'  => array(
					'min'  => 1,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'content',
				'tab_slug'        => 'advanced',
				'mobile_options'  => true,
				'show_if'         => array(
					'layout' => 'layout4',
				),
			),

			'content_position'        => array(
				'label'        => __( 'Conetnt Position', 'wdc-wow-divi-carousel' ),
				'type'         => 'text_align',
				'options'      => et_builder_get_text_orientation_options( array( 'justified' ) ),
				'options_icon' => 'module_align',
				'default'      => 'center',
				'toggle_slug'  => 'content',
				'tab_slug'     => 'advanced',
				'show_if'      => array(
					'layout' => 'layout4',
				),
			),

			'content_offset_top'      => array(
				'label'           => esc_html__( 'Content Offset Top', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px', 'em', 'rem' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => -200,
					'step' => 1,
					'max'  => 200,
				),
				'toggle_slug'     => 'content',
				'tab_slug'        => 'advanced',
				'show_if'         => array(
					'layout' => array( 'layout4', 'layout5' ),
				),
			),

			'content_offset_left'     => array(
				'label'          => esc_html__( 'Content Offset Left', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '0px',
				'fixed_unit'     => 'px',
				'range_settings' => array(
					'min'  => -500,
					'step' => 1,
					'max'  => 500,
				),
				'toggle_slug'    => 'content',
				'tab_slug'       => 'advanced',
				'show_if'        => array(
					'layout' => 'layout5',
				),
			),

			'content_bg'              => array(
				'label'       => esc_html__( 'Content Background', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'toggle_slug' => 'content',
				'tab_slug'    => 'advanced',
				'show_if'     => array(
					'layout' => array( 'layout4', 'layout5' ),
				),
			),

			// image.
			'img_position'            => array(
				'label'            => esc_html__( 'Image Position', 'wdc-wow-divi-carousel' ),
				'type'             => 'select',
				'default'          => 'left',
				'toggle_slug'      => 'image',
				'tab_slug'         => 'advanced',
				'options'          => array(
					'left'  => esc_html__( 'Left', 'wdc-wow-divi-carousel' ),
					'right' => esc_html__( 'Right', 'wdc-wow-divi-carousel' ),
				),
				'computed_affects' => array( '__posts' ),
				'show_if'          => array(
					'layout' => 'layout5',
				),
			),

			'image_width'             => array(
				'label'           => esc_html__( 'Image Width', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '30%',
				'option_category' => 'basic_option',
				'fixed_unit'      => '%',
				'range_settings'  => array(
					'min'  => 1,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'image',
				'tab_slug'        => 'advanced',
				'mobile_options'  => true,
				'show_if'         => array(
					'layout' => 'layout5',
				),
			),

			'image_height'            => array(
				'label'           => esc_html__( 'Image Height', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => 'auto',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 1,
					'step' => 1,
					'max'  => 1000,
				),
				'toggle_slug'     => 'image',
				'tab_slug'        => 'advanced',
				'mobile_options'  => true,
			),

			'image_size'              => array(
				'label'       => esc_html__( 'Image Size', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'image',
				'default'     => 'cover',
				'options'     => array(
					'actual'  => esc_html__( 'Actual Size', 'wdc-wow-divi-carousel' ),
					'contain' => esc_html__( 'Contain', 'wdc-wow-divi-carousel' ),
					'cover'   => esc_html__( 'Fit', 'wdc-wow-divi-carousel' ),
				),
				'show_if_not' => array(
					'image_height' => 'auto',
				),
			),

			'image_hover_animation'   => array(
				'label'            => esc_html__( 'Hover Animation', 'wdc-wow-divi-carousel' ),
				'type'             => 'select',
				'tab_slug'         => 'advanced',
				'toggle_slug'      => 'image',
				'computed_affects' => array( '__posts' ),
				'default'          => 'none',
				'options'          => array(
					'none'         => esc_html__( 'None', 'wdc-wow-divi-carousel' ),
					'zoom-in'      => esc_html__( 'Zoom In', 'wdc-wow-divi-carousel' ),
					'zoom-out'     => esc_html__( 'Zoom Out', 'wdc-wow-divi-carousel' ),
					'pulse'        => esc_html__( 'Pulse', 'wdc-wow-divi-carousel' ),
					'bounce'       => esc_html__( 'Bounce', 'wdc-wow-divi-carousel' ),
					'flash'        => esc_html__( 'Flash', 'wdc-wow-divi-carousel' ),
					'rubberBand'   => esc_html__( 'Rubber Band', 'wdc-wow-divi-carousel' ),
					'shake'        => esc_html__( 'Shake', 'wdc-wow-divi-carousel' ),
					'swing'        => esc_html__( 'Swing', 'wdc-wow-divi-carousel' ),
					'tada'         => esc_html__( 'Tada', 'wdc-wow-divi-carousel' ),
					'wobble'       => esc_html__( 'Wobble', 'wdc-wow-divi-carousel' ),
					'jello'        => esc_html__( 'Jello', 'wdc-wow-divi-carousel' ),
					'heartBeat'    => esc_html__( 'Heart Beat', 'wdc-wow-divi-carousel' ),
					'bounceIn'     => esc_html__( 'Bounce In', 'wdc-wow-divi-carousel' ),
					'fadeIn'       => esc_html__( 'Fade In', 'wdc-wow-divi-carousel' ),
					'flip'         => esc_html__( 'Flip', 'wdc-wow-divi-carousel' ),
					'lightSpeedIn' => esc_html__( 'Light Speed In', 'wdc-wow-divi-carousel' ),
					'rotateIn'     => esc_html__( 'Rotate In', 'wdc-wow-divi-carousel' ),
					'slideInUp'    => esc_html__( 'Slide In Up', 'wdc-wow-divi-carousel' ),
					'slideInDown'  => esc_html__( 'Slide In Down', 'wdc-wow-divi-carousel' ),
				),
			),

			// Date Box.
			'dbox_position'           => array(
				'label'       => esc_html__( 'Box Position', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'date_box',
				'default'     => 'right_top',
				'show_if'     => array(
					'show_date_over_image' => 'on',
				),
				'options'     => array(
					'left_top'     => esc_html__( 'Left Top', 'wdc-wow-divi-carousel' ),
					'left_bottom'  => esc_html__( 'Left Bottom', 'wdc-wow-divi-carousel' ),
					'right_top'    => esc_html__( 'Right Top', 'wdc-wow-divi-carousel' ),
					'right_bottom' => esc_html__( 'Right Bottom', 'wdc-wow-divi-carousel' ),
				),
			),

			'dbox_offset_x'           => array(
				'label'           => esc_html__( 'Offset X', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'default'         => '15px',
				'range_settings'  => array(
					'min'  => -600,
					'max'  => 600,
					'step' => 1,
				),
				'show_if'         => array(
					'show_date_over_image' => 'on',
				),
				'toggle_slug'     => 'date_box',
				'tab_slug'        => 'advanced',
			),

			'dbox_offset_y'           => array(
				'label'           => esc_html__( 'Offset Y', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'default'         => '15px',
				'range_settings'  => array(
					'min'  => -600,
					'max'  => 600,
					'step' => 1,
				),
				'show_if'         => array(
					'show_date_over_image' => 'on',
				),
				'toggle_slug'     => 'date_box',
				'tab_slug'        => 'advanced',
			),

			'dbox_height'             => array(
				'label'           => esc_html__( 'Box Height', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'default'         => '66px',
				'range_settings'  => array(
					'min'  => 0,
					'max'  => 200,
					'step' => 1,
				),
				'show_if'         => array(
					'show_date_over_image' => 'on',
				),
				'toggle_slug'     => 'date_box',
				'tab_slug'        => 'advanced',
			),

			'dbox_width'              => array(
				'label'           => esc_html__( 'Box Width', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'default'         => '76px',
				'range_settings'  => array(
					'min'  => 0,
					'max'  => 200,
					'step' => 1,
				),
				'show_if'         => array(
					'show_date_over_image' => 'on',
				),
				'toggle_slug'     => 'date_box',
				'tab_slug'        => 'advanced',
			),

			'dbox_radius'             => array(
				'label'       => esc_html__( 'Box Border Radius', 'wdc-wow-divi-carousel' ),
				'type'        => 'border-radius',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'date_box',
				'default'     => 'on|0|0|0|0',
				'show_if'     => array(
					'show_date_over_image' => 'on',
				),
			),

			'dbox_bg'                 => array(
				'label'       => esc_html__( 'Background', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'default'     => '#f9f9f9',
				'show_if'     => array(
					'show_date_over_image' => 'on',
				),
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'date_box',
			),

			'dbox_year_bg'            => array(
				'label'       => esc_html__( 'Year Background', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'default'     => '#e2e2e2',
				'show_if'     => array(
					'show_date_over_image'   => 'on',
					'date_format_over_image' => 'D|M|Y',
				),
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'date_box',
			),

			'dbox_text_color'         => array(
				'label'       => esc_html__( 'Text Color', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'default'     => '#555',
				'show_if'     => array(
					'show_date_over_image' => 'on',
				),
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'date_box',
			),

			'font_size_day'           => array(
				'label'          => esc_html__( 'Day Font Size', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '23px',
				'range_settings' => array(
					'min'  => 0,
					'max'  => 50,
					'step' => 1,
				),
				'show_if'        => array(
					'show_date_over_image' => 'on',
				),
				'toggle_slug'    => 'date_box',
				'tab_slug'       => 'advanced',
			),

			'font_size_month'         => array(
				'label'          => esc_html__( 'Month Font Size', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '15px',
				'range_settings' => array(
					'min'  => 0,
					'max'  => 50,
					'step' => 1,
				),
				'toggle_slug'    => 'date_box',
				'tab_slug'       => 'advanced',
				'show_if'        => array(
					'show_date_over_image'   => 'on',
					'date_format_over_image' => array( 'D|M|Y', 'M', 'D|M' ),
				),
			),

			'month_spacing_top'       => array(
				'label'          => esc_html__( 'Month Spacing Top', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '0px',
				'range_settings' => array(
					'min'  => 0,
					'max'  => 50,
					'step' => 1,
				),
				'toggle_slug'    => 'date_box',
				'tab_slug'       => 'advanced',
				'show_if'        => array(
					'show_date_over_image'   => 'on',
					'date_format_over_image' => array( 'D|M|Y', 'D|M' ),
				),
			),

			'font_size_year'          => array(
				'label'          => esc_html__( 'Year Font Size', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '16px',
				'range_settings' => array(
					'min'  => 0,
					'max'  => 50,
					'step' => 1,
				),
				'show_if'        => array(
					'show_date_over_image'   => 'on',
					'date_format_over_image' => 'D|M|Y',
				),
				'toggle_slug'    => 'date_box',
				'tab_slug'       => 'advanced',
			),

			// category.
			'category_border_color'   => array(
				'label'       => esc_html__( 'Left Border Color', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'texts',
				'sub_toggle'  => 'category',
			),

			'category_border_pos'     => array(
				'label'           => esc_html__( 'Left Border Position', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '-20px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => -100,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'texts',
				'sub_toggle'      => 'category',
				'tab_slug'        => 'advanced',
			),

			'category_bg'             => array(
				'label'       => esc_html__( 'Category Background', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'texts',
				'sub_toggle'  => 'category',
				'default'     => 'transparent',
				'hover'       => 'tabs',
			),

			'category_padding'        => array(
				'label'       => esc_html__( 'Category Padding', 'wdc-wow-divi-carousel' ),
				'type'        => 'custom_padding',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'texts',
				'sub_toggle'  => 'category',
				'default'     => '0|0|0|0',
			),

			'category_sp_color'       => array(
				'label'       => esc_html__( 'Category Separator Color', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'texts',
				'sub_toggle'  => 'category',
				'default'     => '#333',
				'hover'       => 'tabs',
			),

			'category_spacing'        => array(
				'label'           => esc_html__( 'Spacing Between', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '0px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'texts',
				'sub_toggle'      => 'category',
				'tab_slug'        => 'advanced',
			),

			'category_spacing_bottom' => array(
				'label'           => esc_html__( 'Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'texts',
				'sub_toggle'      => 'category',
				'tab_slug'        => 'advanced',
			),

			'category_radius'         => array(
				'label'       => esc_html__( 'Category Border Radius', 'wdc-wow-divi-carousel' ),
				'type'        => 'border-radius',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'texts',
				'sub_toggle'  => 'category',
				'default'     => 'on|0|0|0|0',
			),

			// title.
			'title_spacing_bottom'    => array(
				'label'           => esc_html__( 'Title Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '15px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'texts',
				'sub_toggle'      => 'title',
				'tab_slug'        => 'advanced',
			),

			'content_spacing_bottom'  => array(
				'label'           => esc_html__( 'Content Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '20px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'texts',
				'sub_toggle'      => 'content',
				'tab_slug'        => 'advanced',
			),

			// button.
			'btn_spacing_top'         => array(
				'label'           => esc_html__( 'Button Spacing Top', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '0px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'button',
				'tab_slug'        => 'advanced',
			),

			'btn_spacing_bottom'      => array(
				'label'           => esc_html__( 'Button Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '0px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'button',
				'tab_slug'        => 'advanced',
			),

			// meta.
			'meta_height'             => array(
				'label'           => esc_html__( 'Meta Section Height', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '30px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'meta',
				'sub_toggle'      => 'common',
				'tab_slug'        => 'advanced',
			),

			'meta_spacing_top'        => array(
				'label'           => esc_html__( 'Meta Spacing Top', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '20px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'meta',
				'sub_toggle'      => 'common',
				'tab_slug'        => 'advanced',
				'show_if'         => array(
					'layout' => array( 'layout2', 'layout4' ),
				),
			),

			'meta_spacing_top_alt'    => array(
				'label'           => esc_html__( 'Meta Spacing Top', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '0px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'meta',
				'sub_toggle'      => 'common',
				'tab_slug'        => 'advanced',
				'show_if'         => array(
					'layout' => array( 'layout1', 'layout3', 'layout5' ),
				),
			),

			'meta_spacing_bottom'     => array(
				'label'           => esc_html__( 'Meta Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '10px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'meta',
				'sub_toggle'      => 'common',
				'tab_slug'        => 'advanced',
				'show_if'         => array(
					'layout' => array( 'layout1', 'layout3', 'layout5' ),
				),
			),

			'meta_spacing_bottom_alt' => array(
				'label'           => esc_html__( 'Meta Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '0px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'meta',
				'sub_toggle'      => 'common',
				'tab_slug'        => 'advanced',
				'show_if'         => array(
					'layout' => array( 'layout2', 'layout4' ),
				),
			),

			'meta_post_spacing'       => array(
				'label'           => esc_html__( 'Meta Item Spacing', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '18px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'meta',
				'sub_toggle'      => 'common',
				'tab_slug'        => 'advanced',
			),

			'meta_icon_size'          => array(
				'label'           => esc_html__( 'Meta Icon Size', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '14px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'meta',
				'sub_toggle'      => 'common',
				'tab_slug'        => 'advanced',
			),

			'meta_icon_color'         => array(
				'label'       => esc_html__( 'Meta Icon Color', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'meta',
				'sub_toggle'  => 'common',
				'default'     => '#555',
			),

			'meta_icon_spacing'       => array(
				'label'           => esc_html__( 'Meta Icon Spacing', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '5px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'meta',
				'sub_toggle'      => 'common',
				'tab_slug'        => 'advanced',
			),

			'meta_border'             => array(
				'label'       => esc_html__( 'Use Meta Border', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'default'     => 'none',
				'options'     => array(
					'none'       => esc_html__( 'None', 'wdc-wow-divi-carousel' ),
					'top'        => esc_html__( 'Top', 'wdc-wow-divi-carousel' ),
					'bottom'     => esc_html__( 'Bottom', 'wdc-wow-divi-carousel' ),
					'top_bottom' => esc_html__( 'Top & Bottom', 'wdc-wow-divi-carousel' ),
				),
				'toggle_slug' => 'meta',
				'sub_toggle'  => 'common',
				'tab_slug'    => 'advanced',
			),

			'meta_border_color'       => array(
				'label'       => esc_html__( 'Meta Border Color', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'meta',
				'sub_toggle'  => 'common',
				'default'     => '#2ecc71',
				'show_if_not' => array(
					'meta_border' => 'none',
				),
			),

			// author.
			'use_author_photo'        => array(
				'label'            => esc_html__( 'Use Author Photo', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'on',
				'tab_slug'         => 'advanced',
				'toggle_slug'      => 'author',
				'computed_affects' => array( '__posts' ),
			),

			'author_img_size'         => array(
				'label'           => esc_html__( 'Author Photo Size', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '26px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'author',
				'tab_slug'        => 'advanced',
				'show_if'         => array(
					'use_author_photo' => 'on',
				),
			),

			'author_spacing'          => array(
				'label'           => esc_html__( 'Author Photo/Icon Spacing', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '5px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'author',
				'tab_slug'        => 'advanced',
			),

			'author_img_radius'       => array(
				'label'           => esc_html__( 'Author Photo Radius', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '30px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px', '%' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'author',
				'tab_slug'        => 'advanced',
				'show_if'         => array(
					'use_author_photo' => 'on',
				),
			),

			'author_icon_size'        => array(
				'label'           => esc_html__( 'Meta Icon Size', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '14px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'author',
				'tab_slug'        => 'advanced',
				'show_if'         => array(
					'use_author_photo' => 'off',
				),
			),

			'author_icon_color'       => array(
				'label'       => esc_html__( 'Meta Icon Color', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'author',
				'default'     => '#555',
				'show_if'     => array(
					'use_author_photo' => 'off',
				),
			),

			// footer.
			'footer_alignment'        => array(
				'label'       => esc_html__( 'Footer Alignment', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'footer',
				'default'     => 'space-between',
				'options'     => array(
					'flex-start'    => esc_html__( 'Left', 'wdc-wow-divi-carousel' ),
					'flex-end'      => esc_html__( 'Right', 'wdc-wow-divi-carousel' ),
					'space-between' => esc_html__( 'Space Between', 'wdc-wow-divi-carousel' ),
					'space-around'  => esc_html__( 'Space Around', 'wdc-wow-divi-carousel' ),
				),
				'show_if'     => array(
					'layout' => array( 'layout3', 'layout5' ),
				),
			),

			'footer_post_spacing'     => array(
				'label'           => esc_html__( 'Footer Item Spacing', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '30px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'footer',
				'tab_slug'        => 'advanced',
				'show_if'         => array(
					'layout'           => array( 'layout3', 'layout5' ),
					'footer_alignment' => array( 'flex-start', 'flex-end' ),
				),
			),

			'footer_spacing_top'      => array(
				'label'           => esc_html__( 'Footer Spacing Top', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '15px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'footer',
				'tab_slug'        => 'advanced',
				'show_if'         => array(
					'layout' => 'layout4',
				),
			),

			'footer_spacing_bottom'   => array(
				'label'           => esc_html__( 'Footer Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '0px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'footer',
				'tab_slug'        => 'advanced',
				'show_if'         => array(
					'layout' => 'layout4',
				),
			),

			'__posts'                 => array(
				'type'                => 'computed',
				'computed_callback'   => array( 'WDC_PostCarousel', 'get_posts' ),
				'computed_depends_on' => array(
					'layout',
					'post_type',
					'include_categories',
					'order_by',
					'order',
					'post_count',
					'exclude_posts',
					'post_offset',
					'use_content_length',
					'content_length',
					'date_format',
					'show_thumb',
					'show_date_over_image',
					'date_format_over_image',
					'show_title',
					'show_content',
					'show_btn',
					'button_icon',
					'button_text',
					'show_author',
					'show_date',
					'show_categories',
					'show_comment_count',
					'title_level',
					'img_position',
					'show_category_separator',
					'image_hover_animation',
					'use_author_photo',
					'overlay_icon',
					'show_first_category',
				),
			),
		);

		$carousel_options = WDC_Builder_Module::get_carousel_option_fields( 'common', array( 'equal_height' ) );
		$overlay          = $this->get_overlay_option_fields( 'overlay', array() );

		return array_merge( $carousel_options, $post_options, $overlay );
	}

	public function get_advanced_fields_config() {

		$advanced_fields = array();

		$advanced_fields['text']         = false;
		$advanced_fields['text_shadow']  = false;
		$advanced_fields['link_options'] = false;
		$advanced_fields['fonts']        = false;

		$advanced_fields['box_shadow']['content'] = array(
			'label'       => esc_html__( 'Content Box Shadow', 'wdc-wow-divi-carousel' ),
			'css'         => array(
				'main'      => '%%order_class%% .wdc-post-content',
				'important' => 'all',

			),
			'toggle_slug' => 'content',
		);

		$advanced_fields['box_shadow']['item'] = array(
			'label'       => esc_html__( 'Item Box Shadow', 'wdc-wow-divi-carousel' ),
			'css'         => array(
				'main'      => '%%order_class%% .wdc-post-inner',
				'important' => 'all',
			),
			'tab_slug'    => 'advanced',
			'toggle_slug' => 'common',
		);

		$advanced_fields['borders']['image'] = array(
			'label_prefix' => esc_html__( 'Image', 'wdc-wow-divi-carousel' ),
			'toggle_slug'  => 'image',
			'css'          => array(
				'main'      => array(
					'border_radii'  => '%%order_class%% .wdc-post figure',
					'border_styles' => '%%order_class%% .wdc-post figure',
				),
				'important' => 'all',
			),
			'defaults'     => array(
				'border_radii'  => 'on|0px|0px|0px|0px',
				'border_styles' => array(
					'width' => '0px',
					'color' => '#333',
					'style' => 'solid',
				),
			),
		);

		$advanced_fields['borders']['content'] = array(
			'label_prefix' => esc_html__( 'Content', 'wdc-wow-divi-carousel' ),
			'toggle_slug'  => 'content',
			'css'          => array(
				'main'      => array(
					'border_radii'  => '%%order_class%% .wdc-post-content',
					'border_styles' => '%%order_class%% .wdc-post-content',
				),
				'important' => 'all',
			),
			'defaults'     => array(
				'border_radii'  => 'on|0px|0px|0px|0px',
				'border_styles' => array(
					'width' => '0px',
					'color' => '#333',
					'style' => 'solid',
				),
			),
		);

		$advanced_fields['borders']['item'] = array(
			'label_prefix' => esc_html__( 'Item', 'wdc-wow-divi-carousel' ),
			'toggle_slug'  => 'common',
			'css'          => array(
				'main'      => array(
					'border_radii'  => '%%order_class%% .wdc-post-inner',
					'border_styles' => '%%order_class%% .wdc-post-inner',
				),
				'important' => 'all',
			),
			'defaults'     => array(
				'border_radii'  => 'on|0px|0px|0px|0px',
				'border_styles' => array(
					'width' => '0px',
					'color' => '#333',
					'style' => 'solid',
				),
			),
		);

		$advanced_fields['fonts']['title'] = array(
			'label'        => esc_html__( 'Title', 'wdc-wow-divi-carousel' ),
			'css'          => array(
				'main'      => '%%order_class%% .wdc-post-title a',
				'important' => 'all',
			),
			'font_size'    => array(
				'default' => '20px',
			),
			'header_level' => array(
				'default'          => 'h2',
				'computed_affects' => array(
					'__posts',
				),
			),
			'toggle_slug'  => 'texts',
			'sub_toggle'   => 'title',
		);

		$advanced_fields['fonts']['content'] = array(
			'label'       => esc_html__( 'Content', 'wdc-wow-divi-carousel' ),
			'css'         => array(
				'main'      => '%%order_class%% .wdc-post-text, %%order_class%% .wdc-post-text p',
				'important' => 'all',
			),
			'tab_slug'    => 'advanced',
			'toggle_slug' => 'texts',
			'sub_toggle'  => 'content',
			'line_height' => array(
				'range_settings' => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
			),
			'font_size'   => array(
				'default' => '14px',
			),
		);

		$advanced_fields['fonts']['category'] = array(
			'label'           => esc_html__( 'Category', 'wdc-wow-divi-carousel' ),
			'css'             => array(
				'main'      => '%%order_class%% .wdc-post-categories a',
				'important' => 'all',
			),
			'hide_text_align' => true,
			'tab_slug'        => 'advanced',
			'toggle_slug'     => 'texts',
			'sub_toggle'      => 'category',
			'line_height'     => array(
				'range_settings' => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
			),
			'font_size'       => array(
				'default' => '14px',
			),
		);

		$advanced_fields['fonts']['meta'] = array(
			'label'           => esc_html__( 'Meta', 'wdc-wow-divi-carousel' ),
			'css'             => array(
				'main'      => '%%order_class%% .wdc-post-meta-item span, %%order_class%% .wdc-post-author a',
				'important' => 'all',
			),
			'hide_text_align' => true,
			'toggle_slug'     => 'meta',
			'sub_toggle'      => 'text',
			'tab_slug'        => 'advanced',
			'line_height'     => array(
				'range_settings' => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
			),
			'font_size'       => array(
				'default' => '14px',
			),
		);

		$advanced_fields['fonts']['author'] = array(
			'label'           => esc_html__( 'Author', 'wdc-wow-divi-carousel' ),
			'css'             => array(
				'main'      => '%%order_class%% .wdc-post-meta .wdc-post-author a',
				'important' => 'all',
			),
			'hide_text_align' => true,
			'toggle_slug'     => 'author',
			'tab_slug'        => 'advanced',
			'line_height'     => array(
				'range_settings' => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
			),
			'font_size'       => array(
				'default' => '14px',
			),
		);

		$advanced_fields['button']['button'] = array(
			'label' => esc_html__( 'Button', 'wdc-wow-divi-carousel' ),
			'css'   => array(
				'main'      => '%%order_class%% .wdc-post-btn-wrap .wdc-post-btn',
				'important' => 'all',
			),
		);

		return $advanced_fields;
	}

	public static function get_posts( $args = array(), $conditional_tags = array(), $current_page = array() ) {

		$defaults = array(
			'layout'                  => '',
			'post_type'               => '',
			'include_categories'      => '',
			'order_by'                => '',
			'order'                   => '',
			'post_count'              => '',
			'exclude_posts'           => '',
			'post_offset'             => 0,
			'content_length'          => '',
			'use_content_length'      => '',
			'date_format'             => '',
			'show_thumb'              => '',
			'show_date_over_image'    => '',
			'date_format_over_image'  => '',
			'show_title'              => '',
			'show_content'            => '',
			'show_btn'                => '',
			'button_text'             => '',
			'show_author'             => '',
			'show_date'               => '',
			'show_categories'         => '',
			'show_comment_count'      => '',
			'button_icon'             => '',
			'show_category_separator' => '',
			'image_hover_animation'   => '',
			'use_author_photo'        => '',
			'overlay_icon'            => '',
			'title_level'             => '',
			'img_position'            => '',
			'is_lazyload'             => '',
			'show_first_category'     => '',
		);

		$args                    = wp_parse_args( $args, $defaults );
		$layout                  = $args['layout'];
		$post_type               = $args['post_type'];
		$include_categories      = $args['include_categories'];
		$order_by                = $args['order_by'];
		$order                   = $args['order'];
		$post_count              = $args['post_count'];
		$exclude_posts           = $args['exclude_posts'];
		$post_offset             = $args['post_offset'];
		$use_content_length      = $args['use_content_length'];
		$content_length          = 'off' === $use_content_length ? '-1' : $args['content_length'];
		$date_format             = $args['date_format'];
		$button_text             = $args['button_text'];
		$button_icon             = $args['button_icon'];
		$title_level             = $args['title_level'];
		$image_hover_animation   = $args['image_hover_animation'];
		$show_thumb              = $args['show_thumb'];
		$show_date_over_image    = $args['show_date_over_image'];
		$date_format_over_image  = $args['date_format_over_image'];
		$show_title              = $args['show_title'];
		$show_content            = $args['show_content'];
		$show_categories         = $args['show_categories'];
		$show_author             = $args['show_author'];
		$show_date               = $args['show_date'];
		$show_comment_count      = $args['show_comment_count'];
		$show_btn                = $args['show_btn'];
		$show_category_separator = $args['show_category_separator'];
		$use_author_photo        = $args['use_author_photo'];
		$overlay_icon            = $args['overlay_icon'];
		$icon_name               = esc_attr( et_pb_process_font_icon( $button_icon ) );
		$processed_overlay_icon  = esc_attr( et_pb_process_font_icon( $overlay_icon ) );
		$overlay_icon            = ! empty( $processed_overlay_icon ) ? $processed_overlay_icon : '';
		$processed_title_level   = et_pb_process_header_level( $title_level, 'h3' );
		$processed_title_level   = esc_html( $processed_title_level );
		$title_element           = et_core_esc_previously( $processed_title_level );
		$category_separator      = 'on' === $show_category_separator ? ',' : ' ';
		$layout                  = $args['layout'];
		$img_position            = $args['img_position'];
		$is_lazyload             = $args['is_lazyload'];
		$show_first_category     = $args['show_first_category'];

		$query_args = array(
			'posts_per_page' => intval( $post_count ),
			'post_type'      => $post_type,
			'post_status'    => 'publish',
			'orderby'        => $order_by,
			'order'          => $order,
			'offset'         => intval( $post_offset ),
		);

		if ( ! empty( $exclude_posts ) ) {
			$exclude_posts              = str_replace( ' ', '', $exclude_posts );
			$exclude_posts              = explode( ',', $exclude_posts );
			$query_args['post__not_in'] = $exclude_posts;
		}

		$post_id = isset( $current_page['id'] ) ? (int) $current_page['id'] : 0;

		if ( 'post' === $post_type ) {
			$query_args['cat'] = implode( ',', self::filter_include_categories( $include_categories, $post_id ) );
		}
		$query = new WP_Query( $query_args );

		ob_start();

		if ( $query->have_posts() ) :
			while ( $query->have_posts() ) :
				$query->the_post();
				if ( 'layout1' === $layout ) {

					include WOW_DIVI_CAROUSEL_PLUGIN_DIR . 'templates/post/blog-layout-1.php';
				} elseif ( 'layout2' === $layout ) {

					include WOW_DIVI_CAROUSEL_PLUGIN_DIR . 'templates/post/blog-layout-2.php';
				} elseif ( 'layout3' === $layout ) {

					include WOW_DIVI_CAROUSEL_PLUGIN_DIR . 'templates/post/blog-layout-3.php';
				} elseif ( 'layout4' === $layout ) {

					include WOW_DIVI_CAROUSEL_PLUGIN_DIR . 'templates/post/blog-layout-4.php';
				} elseif ( 'layout5' === $layout ) {

					include WOW_DIVI_CAROUSEL_PLUGIN_DIR . 'templates/post/blog-layout-5.php';
				}
			endwhile;
		endif;

		$output = ob_get_clean();

		if ( ! $output ) {
			$output = self::get_no_results_template( et_core_esc_previously( $processed_title_level ) );
		}

		return $output;
	}

	public function render( $attrs, $content, $render_slug ) {

		$this->apply_css( $render_slug );
		wdc_inject_fa_icons( $this->props['overlay_icon'] );

		$sliding_dir      = $this->props['sliding_dir'];
		$is_center        = $this->props['is_center'];
		$center_mode_type = $this->props['center_mode_type'];
		$custom_cursor    = $this->props['custom_cursor'];
		$is_equal_height  = $this->props['is_equal_height'];
		$alignment        = $this->props['alignment'];
		$classes          = array();
		$order_class      = self::get_module_order_class( $render_slug );
		$order_number     = str_replace( '_', '', str_replace( $this->slug, '', $order_class ) );

		if ( 'on' === $is_center ) {
			array_push( $classes, 'wdc-centered' );
			array_push( $classes, "wdc-centered--{$center_mode_type}" );
		}

		if ( 'on' === $custom_cursor ) {
			array_push( $classes, 'wdc-cursor' );
		}

		array_push( $classes, "wdc-text-{$alignment}" );
		array_push( $classes, "equal-height-{$is_equal_height}" );

		$output = sprintf(
			'<div class="wdc-carousel-parent" %2$s dir="%5$s">
                <div class="wdc-carousel wdc-carousel-%4$s wdc-carousel-jq wdc-post-carousel wdc-carousel-frontend %3$s">
                    %1$s
                </div>
            </div>',
			self::get_posts( $this->props ),
			$this->get_carousel_options_data( $order_number, 'post' ),
			join( ' ', $classes ),
			$order_number,
			$sliding_dir
		);

		return $output;
	}


	public function apply_css( $render_slug ) {
		$this->apply_carousel_css( $render_slug );
		$this->render_post_css( $render_slug );
	}

	public function render_post_css( $render_slug ) {

		$layout                            = $this->props['layout'];
		$title_spacing_bottom              = $this->props['title_spacing_bottom'];
		$content_spacing_bottom            = $this->props['content_spacing_bottom'];
		$category_bg                       = $this->props['category_bg'];
		$category_bg_hover                 = $this->get_hover_value( 'category_bg' );
		$category_spacing                  = $this->props['category_spacing'];
		$category_spacing_bottom           = $this->props['category_spacing_bottom'];
		$category_padding                  = $this->props['category_padding'];
		$category_radius                   = explode( '|', $this->props['category_radius'] );
		$meta_height                       = $this->props['meta_height'];
		$meta_spacing_top                  = $this->props['meta_spacing_top'];
		$meta_spacing_top_alt              = $this->props['meta_spacing_top_alt'];
		$meta_spacing_bottom               = $this->props['meta_spacing_bottom'];
		$meta_spacing_bottom_alt           = $this->props['meta_spacing_bottom_alt'];
		$meta_post_spacing                 = $this->props['meta_post_spacing'];
		$meta_icon_size                    = $this->props['meta_icon_size'];
		$meta_icon_color                   = $this->props['meta_icon_color'];
		$meta_icon_spacing                 = $this->props['meta_icon_spacing'];
		$meta_border_color                 = $this->props['meta_border_color'];
		$meta_border                       = $this->props['meta_border'];
		$use_author_photo                  = $this->props['use_author_photo'];
		$author_img_size                   = $this->props['author_img_size'];
		$author_spacing                    = $this->props['author_spacing'];
		$author_img_radius                 = $this->props['author_img_radius'];
		$author_icon_color                 = $this->props['author_icon_color'];
		$author_icon_size                  = $this->props['author_icon_size'];
		$content_padding                   = $this->props['content_padding'];
		$content_padding_tablet            = $this->props['content_padding_tablet'];
		$content_padding_phone             = $this->props['content_padding_phone'];
		$content_padding_last_edited       = $this->props['content_padding_last_edited'];
		$content_padding_responsive_status = et_pb_get_responsive_status( $content_padding_last_edited );
		$content_bg                        = $this->props['content_bg'];
		$content_position                  = $this->props['content_position'];
		$content_offset_top                = $this->props['content_offset_top'];
		$content_width                     = $this->props['content_width'];
		$content_width_last_edited         = $this->props['content_width_last_edited'];
		$content_width_responsive_status   = et_pb_get_responsive_status( $content_width_last_edited );
		$content_width_tablet              = $this->props['content_width_tablet'];
		$content_width_phone               = $this->props['content_width_phone'];
		$post_padding                      = $this->props['post_padding'];
		$post_padding_tablet               = $this->props['post_padding_tablet'];
		$post_padding_phone                = $this->props['post_padding_phone'];
		$post_padding_last_edited          = $this->props['post_padding_last_edited'];
		$post_padding_responsive_status    = et_pb_get_responsive_status( $post_padding_last_edited );
		$footer_alignment                  = $this->props['footer_alignment'];
		$footer_post_spacing               = $this->props['footer_post_spacing'];
		$footer_spacing_bottom             = $this->props['footer_spacing_bottom'];
		$footer_spacing_top                = $this->props['footer_spacing_top'];
		$image_width                       = $this->props['image_width'];
		$image_width_last_edited           = $this->props['image_width_last_edited'];
		$image_width_responsive_status     = et_pb_get_responsive_status( $image_width_last_edited );
		$image_width_tablet                = $this->props['image_width_tablet'];
		$image_width_phone                 = $this->props['image_width_phone'];
		$image_height                      = $this->props['image_height'];
		$image_height_last_edited          = $this->props['image_height_last_edited'];
		$image_height_responsive_status    = et_pb_get_responsive_status( $image_height_last_edited );
		$image_height_tablet               = $this->props['image_height_tablet'];
		$image_height_phone                = $this->props['image_height_phone'];
		$button_custom_padding             = $this->props['button_custom_padding'];
		$btn_spacing_top                   = $this->props['btn_spacing_top'];
		$btn_spacing_bottom                = $this->props['btn_spacing_bottom'];
		$post_bg                           = $this->props['post_bg'];
		$dbox_pos                          = explode( '_', $this->props['dbox_position'] );
		$dbox_offset_x                     = $this->props['dbox_offset_x'];
		$dbox_offset_y                     = $this->props['dbox_offset_y'];
		$dbox_radius                       = explode( '|', $this->props['dbox_radius'] );
		$dbox_bg                           = $this->props['dbox_bg'];
		$dbox_text_color                   = $this->props['dbox_text_color'];
		$font_size_day                     = $this->props['font_size_day'];
		$font_size_month                   = $this->props['font_size_month'];
		$dbox_year_bg                      = $this->props['dbox_year_bg'];
		$font_size_year                    = $this->props['font_size_year'];
		$dbox_height                       = $this->props['dbox_height'];
		$dbox_width                        = $this->props['dbox_width'];
		$date_format_over_image            = $this->props['date_format_over_image'];
		$month_spacing_top                 = $this->props['month_spacing_top'];
		$category_border_color             = $this->props['category_border_color'];
		$category_border_pos               = $this->props['category_border_pos'];
		$content_offset_left               = $this->props['content_offset_left'];
		$image_size                        = $this->props['image_size'];

		if ( class_exists( 'ET_Builder_Module_Helper_Style_Processor' ) ) {
			$this->generate_styles(
				array(
					'utility_arg'    => 'icon_font_family',
					'render_slug'    => $render_slug,
					'base_attr_name' => 'overlay_icon',
					'important'      => true,
					'selector'       => '%%order_class%% .wdc-overlay .wdc-overlay-icon',
					'processor'      => array(
						'ET_Builder_Module_Helper_Style_Processor',
						'process_extended_icon',
					),
				)
			);
		}

		if ( 'layout1' === $layout ) {

			$content_bg              = ! empty( $content_bg ) ? $content_bg : 'transparent';
			$post_bg                 = ! empty( $post_bg ) ? $post_bg : 'rgb(242, 242, 242)';
			$content_padding         = ! empty( $content_padding ) ? $content_padding : '20px|20px|20px|20px';
			$category_spacing_bottom = ! empty( $category_spacing_bottom ) ? $category_spacing_bottom : '15px';

		} elseif ( 'layout2' === $layout ) {

			$content_bg              = ! empty( $content_bg ) ? $content_bg : 'transparent';
			$post_bg                 = ! empty( $post_bg ) ? $post_bg : 'rgb(242, 242, 242)';
			$content_padding         = ! empty( $content_padding ) ? $content_padding : '20px|0px|0px|0px';
			$category_spacing_bottom = ! empty( $category_spacing_bottom ) ? $category_spacing_bottom : '15px';

		} elseif ( 'layout3' === $layout ) {

			$content_bg              = ! empty( $content_bg ) ? $content_bg : 'transparent';
			$post_bg                 = ! empty( $post_bg ) ? $post_bg : 'rgb(242, 242, 242)';
			$content_padding         = ! empty( $content_padding ) ? $content_padding : '20px|20px|20px|20px';
			$category_spacing_bottom = ! empty( $category_spacing_bottom ) ? $category_spacing_bottom : '0px';

		} elseif ( 'layout4' === $layout ) {

			$content_bg              = ! empty( $content_bg ) ? $content_bg : '#f7f7f7';
			$post_bg                 = ! empty( $post_bg ) ? $post_bg : 'transparent';
			$content_padding         = ! empty( $content_padding ) ? $content_padding : '20px|20px|20px|20px';
			$category_spacing_bottom = ! empty( $category_spacing_bottom ) ? $category_spacing_bottom : '15px';
			$content_offset_top      = ! empty( $content_offset_top ) ? $content_offset_top : '-60px';

		} elseif ( 'layout5' === $layout ) {

			$content_bg              = ! empty( $content_bg ) ? $content_bg : 'rgb(242, 242, 242)';
			$post_bg                 = ! empty( $post_bg ) ? $post_bg : 'transparent';
			$content_padding         = ! empty( $content_padding ) ? $content_padding : '20px|20px|20px|20px';
			$category_spacing_bottom = ! empty( $category_spacing_bottom ) ? $category_spacing_bottom : '15px';
		}

		$this->get_responsive_styles(
			'alignment',
			'%%order_class%% .wdc-post',
			array( 'primary' => 'text-align' ),
			array( 'default' => 'left' ),
			$render_slug
		);

		$this->get_responsive_styles(
			'alignment',
			'%%order_class%% .wdc-post .wdc-post-meta',
			array( 'primary' => 'justify-content' ),
			array( 'default' => 'left' ),
			$render_slug
		);

		if ( 'auto' !== $image_height ) {
			if ( 'contain' === $image_size ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-post figure img',
						'declaration' => 'height: 100%;object-fit: contain;',
					)
				);
			} elseif ( 'cover' === $image_size ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-post figure img',
						'declaration' => 'height: 100%;object-fit: cover;',
					)
				);
			}
		}

		if ( ! empty( $category_border_color ) ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-categories:before',
					'declaration' => sprintf( 'background: %1$s;left:%2$s;', $category_border_color, $category_border_pos ),
				)
			);
		}

		// Date Box Offset x.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-post-date-box',
				'declaration' => sprintf( '%1$s: %2$s;', $dbox_pos[0], $dbox_offset_x ),
			)
		);

		// Date Box Offset x.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-post-date-box',
				'declaration' => sprintf( '%1$s: %2$s;', $dbox_pos[1], $dbox_offset_y ),
			)
		);

		// Date Box.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-post-date-box',
				'declaration' => sprintf(
					'
                height: %1$s;
                width: %2$s;
                border-radius: %3$s %4$s %5$s %6$s;
                background: %7$s;
                color: %8$s;',
					$dbox_height,
					$dbox_width,
					$dbox_radius[1],
					$dbox_radius[2],
					$dbox_radius[3],
					$dbox_radius[4],
					$dbox_bg,
					$dbox_text_color
				),
			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-post-date-box .__day',
				'declaration' => sprintf( 'font-size: %1$s;', $font_size_day ),
			)
		);

		if ( ! empty( $font_size_month ) ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-date-box .__month',
					'declaration' => sprintf( 'font-size: %1$s;', $font_size_month ),
				)
			);
		}

		if ( 'D|M|Y' === $date_format_over_image || 'D|M' === $date_format_over_image ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-date-box .__month',
					'declaration' => sprintf( 'margin-top: %1$s;', $month_spacing_top ),
				)
			);
		}

		if ( 'D|M|Y' === $date_format_over_image ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-date-box .__year',
					'declaration' => sprintf(
						'
                    background: %1$s;
                    width: %2$s;
                    font-size: %3$s;',
						$dbox_year_bg,
						$dbox_height,
						$font_size_year
					),
				)
			);
		}

		// Item Background.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-post-inner',
				'declaration' => sprintf( 'background: %1$s;', $post_bg ),
			)
		);

		// Content Bg.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-post-content',
				'declaration' => sprintf( 'background: %1$s;', $content_bg ),
			)
		);

		// Footer.
		if ( 'layout4' === $layout ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-footer',
					'declaration' => sprintf(
						'
                    margin-top: %1$s;
                    margin-bottom: %2$s;',
						$footer_spacing_top,
						$footer_spacing_bottom
					),
				)
			);
		}

		if ( 'layout3' === $layout || 'layout5' === $layout ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-footer',
					'declaration' => sprintf(
						'
                    justify-content: %1$s!important;',
						$footer_alignment
					),
				)
			);

			if ( 'flex-start' === $footer_alignment ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-post-footer .wdc-post-btn-wrap',
						'declaration' => sprintf( 'margin-right: %1$s;', $footer_post_spacing ),
					)
				);
			} elseif ( 'flex-end' === $footer_alignment ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-post-footer .wdc-post-author',
						'declaration' => sprintf( 'margin-left: %1$s;', $footer_post_spacing ),
					)
				);
			}
		}

		// Content Padding.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-post-content',
				'declaration' => WDC_Builder_Module::wdc_process_padding( $content_padding, false ),
			)
		);

		// Content Padding Tablet.
		if ( $content_padding_tablet && $content_padding_responsive_status ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-content',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					'declaration' => WDC_Builder_Module::wdc_process_padding( $content_padding_tablet, false ),
				)
			);
		}

		// Content Padding Phone.
		if ( $content_padding_phone && $content_padding_responsive_status ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-content',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					'declaration' => WDC_Builder_Module::wdc_process_padding( $content_padding_phone, false ),
				)
			);
		}

		// layout 2.
		if ( 'layout2' === $layout ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-inner',
					'declaration' => WDC_Builder_Module::wdc_process_padding( $post_padding, false ),
				)
			);

			if ( $post_padding_tablet && $post_padding_responsive_status ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-post-inner',
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
						'declaration' => WDC_Builder_Module::wdc_process_padding( $post_padding_tablet, false ),
					)
				);
			}

			if ( $post_padding_phone && $post_padding_responsive_status ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-post-inner',
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
						'declaration' => WDC_Builder_Module::wdc_process_padding( $post_padding_phone, false ),
					)
				);
			}
		}

		// Content offset top.
		if ( 'layout4' === $layout || 'layout5' === $layout ) {
			if ( ! empty( $content_offset_top ) ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-post-content',
						'declaration' => sprintf( 'margin-top: %1$s;', $content_offset_top ),
					)
				);
			}
		}

		// layout 4.
		if ( 'layout4' === $layout ) {

			// Content Position.
			if ( 'center' === $content_position ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-post-content',
						'declaration' => sprintf( 'margin-left: auto; margin-right: auto;' ),
					)
				);

			} elseif ( 'left' === $content_position ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-post-content',
						'declaration' => sprintf( 'margin-right: auto;' ),
					)
				);

			} elseif ( 'right' === $content_position ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-post-content',
						'declaration' => sprintf( 'margin-left: auto;' ),
					)
				);

			}

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-content',
					'declaration' => sprintf( 'width: %1$s;', $content_width ),
				)
			);

			if ( $content_width_tablet && $content_width_responsive_status ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-post-content',
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
						'declaration' => sprintf( 'width: %1$s;', $content_width_tablet ),
					)
				);
			}

			if ( $content_width_phone && $content_width_responsive_status ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-post-content',
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
						'declaration' => sprintf( 'width: %1$s;', $content_width_phone ),
					)
				);
			}
		}

		// layout 5.
		if ( 'layout5' === $layout ) {
			$operator = '-';
			if ( intval( $content_offset_left ) > 0 ) {
				$operator = '+';
			}
			// Image Width.
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-thumb-wrap',
					'declaration' => sprintf( 'flex: 0 0 %1$s; max-width: %1$s;', $image_width ),
				)
			);

			// Content Width.
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-content',
					'declaration' => sprintf(
						'
                    margin-left: %4$s;
                    flex: 0 0 calc(100%% - calc(%1$s %2$s %3$spx));
                    max-width: calc(100%% - calc(%1$s %2$s %3$spx));',
						$image_width,
						$operator,
						abs( intval( $content_offset_left ) ),
						$content_offset_left
					),
				)
			);

			if ( $image_width_tablet && $image_width_responsive_status ) {
				// Image Width Tablet.
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-post-thumb-wrap',
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
						'declaration' => sprintf( 'flex: 0 0 %1$s; max-width: %1$s;', $image_width_tablet ),
					)
				);

				// Content Width Tablet.
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-post-content',
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
						'declaration' => sprintf( 'flex: 0 0 calc(100%% - %1$s); max-width: calc(100%% - %1$s);', $image_width_tablet ),
					)
				);

			}

			if ( $image_width_phone && $image_width_responsive_status ) {

				// Image Width Phone.
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-post-thumb-wrap',
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
						'declaration' => sprintf( 'flex: 0 0 %1$s; max-width: %1$s;', $image_width_phone ),
					)
				);

				// Content Width Phone.
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-post-content',
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
						'declaration' => sprintf( 'flex: 0 0 calc(100%% - %1$s); max-width: calc(100%% - %1$s);', $image_width_phone ),
					)
				);
			}
		}

		// Image Height.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-post-thumb-wrap',
				'declaration' => sprintf( 'height: %1$s;', $image_height ),
			)
		);

		// Image Height Tablet.
		if ( $image_height_tablet && $image_height_responsive_status ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-thumb-wrap',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					'declaration' => sprintf( 'height: %1$s;', $image_height_tablet ),
				)
			);

		}

		// Image Height Phone.
		if ( $image_height_phone && $image_height_responsive_status ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-thumb-wrap',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					'declaration' => sprintf( 'height: %1$s;', $image_height_phone ),
				)
			);

		}

		// Texts.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-post-title',
				'declaration' => sprintf( 'padding-bottom: %1$s;', $title_spacing_bottom ),
			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-post-text',
				'declaration' => sprintf( 'margin-bottom: %1$s;', $content_spacing_bottom ),
			)
		);

		// Button.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-post-btn-wrap',
				'declaration' => sprintf( 'padding-bottom: %1$s; padding-top: %2$s;', $btn_spacing_bottom, $btn_spacing_top ),
			)
		);

		if ( ! empty( $button_custom_padding ) ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => 'body #page-container %%order_class%% .wdc-post-btn, .et-db #et-boc %%order_class%% .wdc-post-btn-wrap .wdc-post-btn',
					'declaration' => WDC_Builder_Module::wdc_process_padding( $button_custom_padding, true ),
				)
			);
		}

		// Meta.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-post-meta',
				'declaration' => sprintf( 'height: %1$s;', $meta_height ),
			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-post-meta .wdc-post-meta-item',
				'declaration' => sprintf( 'padding-right: %1$s; padding-left: %1$s;', $meta_post_spacing ),
			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-post-meta',
				'declaration' => sprintf( 'margin-right: -%1$s; margin-left: -%1$s;', $meta_post_spacing ),
			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-post-meta-item i',
				'declaration' => sprintf(
					'
                font-size: %1$s;
                color: %2$s;
                margin-right: %3$s;',
					$meta_icon_size,
					$meta_icon_color,
					$meta_icon_spacing
				),
			)
		);

		if ( 'layout2' === $layout || 'layout4' === $layout ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-meta',
					'declaration' => sprintf( 'margin-top: %1$s;', $meta_spacing_top ),
				)
			);
		} else {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-meta',
					'declaration' => sprintf( 'margin-top: %1$s;', $meta_spacing_top_alt ),
				)
			);
		}

		if ( 'layout2' === $layout || 'layout4' === $layout ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-meta',
					'declaration' => sprintf( 'margin-bottom: %1$s;', $meta_spacing_bottom_alt ),
				)
			);
		} else {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-meta',
					'declaration' => sprintf( 'margin-bottom: %1$s;', $meta_spacing_bottom ),
				)
			);
		}

		// Meta borders.
		if ( 'top' === $meta_border ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-meta',
					'declaration' => sprintf( 'border-top: 1px solid %1$s!important;', $meta_border_color ),
				)
			);

		} elseif ( 'bottom' === $meta_border ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-meta',
					'declaration' => sprintf( 'border-bottom: 1px solid %1$s!important;', $meta_border_color ),
				)
			);

		} elseif ( 'top_bottom' === $meta_border ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-meta',
					'declaration' => sprintf( 'border-top: 1px solid %1$s!important; border-bottom: 1px solid %1$s!important;', $meta_border_color ),
				)
			);

		}

		// Author Photo.
		if ( 'on' === $use_author_photo ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-author img',
					'declaration' => sprintf( 'width: %1$s; height: %1$s;', $author_img_size ),
				)
			);

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-author img',
					'declaration' => sprintf( 'margin-right: %1$s;', $author_spacing ),
				)
			);

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-author img',
					'declaration' => sprintf( 'border-radius: %1$s;', $author_img_radius ),
				)
			);
		} else {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-post-author .wdc-ico-user',
					'declaration' => sprintf(
						'
                    margin-right: %1$s;
                    font-size: %2$s;
                    color: %3$s;',
						$author_spacing,
						$author_icon_size,
						$author_icon_color
					),
				)
			);
		}

		// Category.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-post-categories',
				'declaration' => sprintf( 'margin-bottom: %1$s;', $category_spacing_bottom ),
			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-post-categories a',
				'declaration' => sprintf(
					'
                background: %1$s;
                margin-right: %2$s;
                %3$s
                border-radius: %4$s;',
					$category_bg,
					$category_spacing,
					WDC_Builder_Module::wdc_process_padding( $category_padding, false ),
					$category_radius[1],
					$category_radius[2],
					$category_radius[3],
					$category_radius[4]
				),
			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-post-categories a:hover',
				'declaration' => sprintf( 'background: %1$s;', $category_bg_hover ),
			)
		);

		// Overlay Styles.
		$this->get_overlay_style( $render_slug );

	}
}

new WDC_PostCarousel();
