<?php

class WDC_LogoCarousel extends WDC_Builder_Module {

	protected $module_credits = array(
		'module_uri' => 'https://wowcarousel.com/modules/logo-carousel/',
		'author'     => 'Wow Carousel',
		'author_uri' => 'https://divipeople.com/wow-divi-carousel/',
	);

	public function init() {

		$this->name       = esc_html__('Wow Logo Carousel', 'wdc-wow-divi-carousel');
		$this->icon_path  = plugin_dir_path(__FILE__) . 'wdc-logo-carousel.svg';
		$this->slug       = 'wdcl_logo_carousel';
		$this->vb_support = 'on';
		$this->child_slug = 'wdcl_logo_carousel_child';

		$this->settings_modal_toggles = array(
			'general'  => array(
				'toggles' => array(
					'logo_settings' => array(
						'title' => esc_html__('Logo Settings', 'wdc-wow-divi-carousel'),
					),
					'settings'      => array(
						'title'             => esc_html__('Carousel Settings', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'general'  => array(
								'name' => esc_html__('General', 'wdc-wow-divi-carousel'),
							),
							'advanced' => array(
								'name' => esc_html__('Advanced', 'wdc-wow-divi-carousel'),
							),
						),
					),
					'tab_settings'  => array(
						'title' => esc_html__('Tab Settings', 'wdc-wow-divi-carousel'),
					),
				),
			),

			'advanced' => array(
				'toggles' => array(
					'arrow'        => array(
						'title'             => esc_html__('Navigation', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'arrow_common' => array(
								'name' => esc_html__('Common', 'wdc-wow-divi-carousel'),
							),
							'arrow_left'   => array(
								'name' => esc_html__('Prev', 'wdc-wow-divi-carousel'),
							),
							'arrow_right'  => array(
								'name' => esc_html__('Next', 'wdc-wow-divi-carousel'),
							),
						),
					),
					'pagination'   => array(
						'title'             => esc_html__('Pagination', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'pagi_common' => array(
								'name' => esc_html__('Common', 'wdc-wow-divi-carousel'),
							),
							'pagi_active' => array(
								'name' => esc_html__('Active', 'wdc-wow-divi-carousel'),
							),
						),
					),
					'tab'          => array(
						'title'             => esc_html__('Tab Style', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'common' => array(
								'name' => esc_html__('Common', 'wdc-wow-divi-carousel'),
							),
							'active' => array(
								'name' => esc_html__('Active', 'wdc-wow-divi-carousel'),
							),
						),
					),

					'tab_elements' => array(
						'title'             => esc_html__('Tab Elements', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'title'    => array(
								'name' => esc_html__('Title', 'wdc-wow-divi-carousel'),
							),
							'subtitle' => array(
								'name' => esc_html__('Subtitle', 'wdc-wow-divi-carousel'),
							),
							'thumb'    => array(
								'name' => esc_html__('Thumbnail', 'wdc-wow-divi-carousel'),
							),
						),
					),
				),
			),
		);
	}

	public function get_fields() {

		$carousel_options = WDC_Builder_Module::get_carousel_option_fields('carousel', array('tab', 'lightbox'));

		$logo_options = array(

			'logo_hover'  => array(
				'label'       => esc_html__('Image Hover Animation', 'wdc-wow-divi-carousel'),
				'type'        => 'select',
				'toggle_slug' => 'logo_settings',
				'default'     => 'zoom_in',
				'options'     => array(
					'no_hover'      => esc_html__('None', 'wdc-wow-divi-carousel'),
					'zoom_in'       => esc_html__('Zoom In', 'wdc-wow-divi-carousel'),
					'zoom_out'      => esc_html__('Zoom Out', 'wdc-wow-divi-carousel'),
					'fade'          => esc_html__('Fade', 'wdc-wow-divi-carousel'),
					'black_n_white' => esc_html__('Black and White', 'wdc-wow-divi-carousel'),
				),
			),

			'logo_height' => array(
				'label'           => esc_html__('Height', 'wdc-wow-divi-carousel'),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'default'         => 'auto',
				'default_unit'    => 'px',
				'range_settings'  => array(
					'step' => 1,
					'min'  => 1,
					'max'  => 1000,
				),
				'toggle_slug'     => 'logo_settings',
				'mobile_options'  => true,
			),

			'logo_width'  => array(
				'label'           => esc_html__('Width', 'wdc-wow-divi-carousel'),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'default'         => 'auto',
				'default_unit'    => 'px',
				'range_settings'  => array(
					'step' => 1,
					'min'  => 1,
					'max'  => 1000,
				),
				'toggle_slug'     => 'logo_settings',
				'mobile_options'  => true,
			),
		);

		return array_merge($carousel_options, $logo_options);
	}

	public function get_advanced_fields_config() {

		$advanced_fields                 = array();
		$advanced_fields['text']         = false;
		$advanced_fields['borders']      = false;
		$advanced_fields['text_shadow']  = false;
		$advanced_fields['link_options'] = false;
		$advanced_fields['fonts']        = false;

		$advanced_fields['fonts']['title'] = array(
			'label'           => esc_html__('Title', 'wdc-wow-divi-carousel'),
			'css'             => array(
				'main'      => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item h2',
				'important' => 'all',
			),
			'tab_slug'        => 'advanced',
			'toggle_slug'     => 'tab_elements',
			'hide_text_align' => true,
			'sub_toggle'      => 'title',
		);

		$advanced_fields['fonts']['subtitle'] = array(
			'label'           => esc_html__('Title', 'wdc-wow-divi-carousel'),
			'css'             => array(
				'main'      => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item p',
				'important' => 'all',
			),
			'tab_slug'        => 'advanced',
			'hide_text_align' => true,
			'toggle_slug'     => 'tab_elements',
			'sub_toggle'      => 'subtitle',
		);

		return $advanced_fields;
	}

	public function render($attrs, $content, $render_slug) {

		$sliding_dir      = $this->props['sliding_dir'];
		$content          = $this->props['content'];
		$logo_hover       = $this->props['logo_hover'];
		$is_center        = $this->props['is_center'];
		$center_mode_type = $this->props['center_mode_type'];
		$use_lightbox     = $this->props['use_lightbox'];
		$custom_cursor    = $this->props['custom_cursor'];

		global $wdc_logo_child;
		global $wdc_uid_logo;

		if (empty($wdc_uid_logo) && 0 !== $wdc_uid_logo) {
			$wdc_uid_logo = 0;
		} else {
			++$wdc_uid_logo;
		}

		$this->apply_css($render_slug);
		$classes = array();
		array_push($classes, "wdc-lightbox-{$use_lightbox}");
		array_push($classes, $logo_hover);

		if ('on' === $use_lightbox) {
			wp_enqueue_style('wdc-magnific');
			wp_enqueue_script('wdc-magnific');
		}

		if ('on' === $is_center) {
			array_push($classes, 'wdc-centered');
			array_push($classes, "wdc-centered--{$center_mode_type}");
		}

		if ('on' === $custom_cursor) {
			array_push($classes, 'wdc-cursor');
		}

		$parent_classes = 'top' === $this->props['tab_placement'] && 'normal' === $this->props['tab_position'] ? 'nav--top' : '';

		// Get Order Class.
		$order_class  = self::get_module_order_class($render_slug);
		$order_number = str_replace('_', '', str_replace($this->slug, '', $order_class));

		$output = sprintf(
			'<div class="wdc-carousel-parent %6$s" %2$s dir="%7$s">
			    <div class="wdc-carousel wdc-logo-carousel-%3$s wdc-logo-carousel wdc-carousel-frontend %4$s">
                    %1$s
                </div>
                %5$s
            </div>',
			$content,
			$this->get_carousel_options_data($order_number, 'logo'),
			$order_number,
			join(' ', $classes),
			$this->render_carousel_nav($wdc_logo_child, $order_number, $wdc_uid_logo, 'logo'),
			$parent_classes,
			$sliding_dir
		);

		return $output;
	}

	public function render_logo_css($render_slug) {

		$logo_height                   = $this->props['logo_height'];
		$logo_height_tablet            = $this->props['logo_height_tablet'];
		$logo_height_phone             = $this->props['logo_height_phone'];
		$logo_height_last_edited       = $this->props['logo_height_last_edited'];
		$logo_height_responsive_status = et_pb_get_responsive_status($logo_height_last_edited);

		$logo_width                   = $this->props['logo_width'];
		$logo_width_tablet            = $this->props['logo_width_tablet'];
		$logo_width_phone             = $this->props['logo_width_phone'];
		$logo_width_last_edited       = $this->props['logo_width_last_edited'];
		$logo_width_responsive_status = et_pb_get_responsive_status($logo_width_last_edited);

		if ('auto' !== $logo_height) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-logo-carousel-item',
					'declaration' => sprintf('height: %1$s;display: flex; justify-content: center; align-items: center;', $logo_height),
				)
			);

			if ($logo_height_tablet && $logo_height_responsive_status) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-logo-carousel-item',
						'declaration' => sprintf('height: %1$s;display: flex; justify-content: center; align-items: center; ', $logo_height_tablet),
						'media_query' => ET_Builder_Element::get_media_query('max_width_980'),
					)
				);
			}

			if ($logo_height_phone && $logo_height_responsive_status) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-logo-carousel-item',
						'declaration' => sprintf('height: %1$s; display: flex; justify-content: center; align-items: center;`', $logo_height_phone),
						'media_query' => ET_Builder_Element::get_media_query('max_width_767'),
					)
				);
			}
		}

		if ('auto' !== $logo_width) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-logo-carousel-item img',
					'declaration' => sprintf('width: %1$s;', $logo_width),
				)
			);

			if ($logo_width_tablet && $logo_width_responsive_status) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-logo-carousel-item img',
						'declaration' => sprintf('width: %1$s;', $logo_width_tablet),
						'media_query' => ET_Builder_Element::get_media_query('max_width_980'),
					)
				);
			}

			if ($logo_width_phone && $logo_width_responsive_status) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-logo-carousel-item img',
						'declaration' => sprintf('width: %1$s;`', $logo_width_phone),
						'media_query' => ET_Builder_Element::get_media_query('max_width_767'),
					)
				);
			}
		}
	}

	public function apply_css($render_slug) {
		$this->apply_carousel_css($render_slug);
		$this->render_logo_css($render_slug);
		$this->apply_tab_css($render_slug);
	}
}

new WDC_LogoCarousel();
