<?php
class WDC_ImageCarouselChild extends WDC_Builder_Module {

	public $slug       = 'wdc_image_carousel_child';
	public $vb_support = 'on';
	public $type       = 'child';

	public function init() {

		$this->name                     = esc_html__( 'Item', 'wdc-wow-divi-carousel' );
		$this->child_title_var          = 'admin_title';
		$this->child_title_fallback_var = 'title';

		$this->settings_modal_toggles = array(
			'general'  => array(
				'toggles' => array(
					'carousel_content' => esc_html__( 'Content', 'wdc-wow-divi-carousel' ),
					'tab_content'      => esc_html__( 'Tab Content', 'wdc-wow-divi-carousel' ),
				),
			),

			'advanced' => array(
				'toggles' => array(
					'image'   => esc_html__( 'Image', 'wdc-wow-divi-carousel' ),
					'overlay' => esc_html__( 'Overlay', 'wdc-wow-divi-carousel' ),
					'content' => esc_html__( 'Content', 'wdc-wow-divi-carousel' ),
					'texts'   => array(
						'title'             => esc_html__( 'Texts', 'wdc-wow-divi-carousel' ),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'title_tab'    => array(
								'name' => esc_html__( 'Title', 'wdc-wow-divi-carousel' ),
							),
							'subtitle_tab' => array(
								'name' => esc_html__( 'Subtitle', 'wdc-wow-divi-carousel' ),
							),
						),
					),
					'borders' => esc_html__( 'Border', 'wdc-wow-divi-carousel' ),
				),
			),
		);
	}

	public function get_fields() {

		$fields = array(

			'photo'                 => array(
				'label'              => esc_html__( 'Upload Image', 'wdc-wow-divi-carousel' ),
				'type'               => 'upload',
				'option_category'    => 'basic_option',
				'toggle_slug'        => 'carousel_content',
				'upload_button_text' => esc_attr__( 'Upload an image', 'wdc-wow-divi-carousel' ),
				'choose_text'        => esc_attr__( 'Choose an Image', 'wdc-wow-divi-carousel' ),
				'update_text'        => esc_attr__( 'Set As Image', 'wdc-wow-divi-carousel' ),
				'hover'              => 'tabs',
				'mobile_options'     => true,
				'dynamic_content'    => 'image',
			),

			'photo_alt'             => array(
				'label'       => esc_html__( 'Image Alt Text', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'carousel_content',
			),

			'title'                 => array(
				'label'           => esc_html__( 'Title', 'wdc-wow-divi-carousel' ),
				'type'            => 'text',
				'toggle_slug'     => 'carousel_content',
				'dynamic_content' => 'text',
			),

			'sub_title'             => array(
				'label'           => esc_html__( 'Subtitle', 'wdc-wow-divi-carousel' ),
				'type'            => 'text',
				'toggle_slug'     => 'carousel_content',
				'dynamic_content' => 'text',
			),

			'content_width'         => array(
				'label'          => esc_html__( 'Content Width', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '100%',
				'default_unit'   => '%',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 100,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'content',
			),

			'content_type'          => array(
				'label'       => esc_html__( 'Content Type', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'toggle_slug' => 'content',
				'tab_slug'    => 'advanced',
				'default'     => 'absolute',
				'options'     => array(
					'normal'   => esc_html__( 'Normal', 'wdc-wow-divi-carousel' ),
					'absolute' => esc_html__( 'Absolute', 'wdc-wow-divi-carousel' ),
				),
			),

			'content_pos_x'         => array(
				'label'       => esc_html__( 'Content Horizontal Position', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'toggle_slug' => 'content',
				'tab_slug'    => 'advanced',
				'default'     => 'center',
				'options'     => array(
					'center'     => esc_html__( 'Center', 'wdc-wow-divi-carousel' ),
					'flex-start' => esc_html__( 'Left', 'wdc-wow-divi-carousel' ),
					'flex-end'   => esc_html__( 'Right', 'wdc-wow-divi-carousel' ),
				),
				'show_if'     => array(
					'content_type' => 'absolute',
				),
			),

			'content_pos_y'         => array(
				'label'       => esc_html__( 'Content Vertical Position', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'toggle_slug' => 'content',
				'tab_slug'    => 'advanced',
				'default'     => 'center',
				'options'     => array(
					'center'     => esc_html__( 'Center', 'wdc-wow-divi-carousel' ),
					'flex-start' => esc_html__( 'Top', 'wdc-wow-divi-carousel' ),
					'flex-end'   => esc_html__( 'Bottom', 'wdc-wow-divi-carousel' ),
				),
				'show_if'     => array(
					'content_type' => 'absolute',
				),
			),

			'content_padding'       => array(
				'label'          => esc_html__( 'Content Padding', 'wdc-wow-divi-carousel' ),
				'type'           => 'custom_padding',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'content',
				'mobile_options' => true,
			),

			// image.
			'image_height'          => array(
				'label'           => esc_html__( 'Image Height', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'em', 'rem', 'px', 'cm', '%', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw' ),
				'default_unit'    => 'px',
				'default'         => 'auto',
				'mobile_options'  => true,
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 1000,
				),
				'toggle_slug'     => 'image',
				'tab_slug'        => 'advanced',
			),

			'image_hover_animation' => array(
				'label'       => esc_html__( 'Image Hover Animation', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'image',
				'default'     => 'none',
				'options'     => array(
					'none'         => esc_html__( 'None', 'wdc-wow-divi-carousel' ),
					'zoom-in'      => esc_html__( 'Zoom In', 'wdc-wow-divi-carousel' ),
					'zoom-out'     => esc_html__( 'Zoom Out', 'wdc-wow-divi-carousel' ),
					'pulse'        => esc_html__( 'Pulse', 'wdc-wow-divi-carousel' ),
					'bounce'       => esc_html__( 'Bounce', 'wdc-wow-divi-carousel' ),
					'flash'        => esc_html__( 'Flash', 'wdc-wow-divi-carousel' ),
					'rubberBand'   => esc_html__( 'Rubber Band', 'wdc-wow-divi-carousel' ),
					'shake'        => esc_html__( 'Shake', 'wdc-wow-divi-carousel' ),
					'swing'        => esc_html__( 'Swing', 'wdc-wow-divi-carousel' ),
					'tada'         => esc_html__( 'Tada', 'wdc-wow-divi-carousel' ),
					'wobble'       => esc_html__( 'Wobble', 'wdc-wow-divi-carousel' ),
					'jello'        => esc_html__( 'Jello', 'wdc-wow-divi-carousel' ),
					'heartBeat'    => esc_html__( 'Heart Beat', 'wdc-wow-divi-carousel' ),
					'bounceIn'     => esc_html__( 'Bounce In', 'wdc-wow-divi-carousel' ),
					'fadeIn'       => esc_html__( 'Fade In', 'wdc-wow-divi-carousel' ),
					'flip'         => esc_html__( 'Flip', 'wdc-wow-divi-carousel' ),
					'lightSpeedIn' => esc_html__( 'Light Speed In', 'wdc-wow-divi-carousel' ),
					'rotateIn'     => esc_html__( 'Rotate In', 'wdc-wow-divi-carousel' ),
					'slideInUp'    => esc_html__( 'Slide In Up', 'wdc-wow-divi-carousel' ),
					'slideInDown'  => esc_html__( 'Slide In Down', 'wdc-wow-divi-carousel' ),
				),
			),

			// Text.
			'title_bottom_spacing'  => array(
				'label'           => esc_html__( 'Title Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '5px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'texts',
				'tab_slug'        => 'advanced',
				'sub_toggle'      => 'title_tab',
			),

		);

		$tab_fields = $this->get_tab_fields();

		$content = $this->custom_advanced_background_fields(
			'content',
			esc_html__( 'Content', 'wdc-wow-divi-carousel' ),
			'advanced',
			'content',
			array( 'color', 'gradient' ),
			array(),
			''
		);

		$overlay = $this->get_overlay_option_fields( 'overlay', array() );

		$label = array(
			'admin_title' => array(
				'label'       => esc_html__( 'Admin Label', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'description' => esc_html__( 'This will change the label of the item', 'wdc-wow-divi-carousel' ),
				'toggle_slug' => 'admin_label',
			),
		);

		return array_merge( $label, $fields, $content, $overlay, $tab_fields );
	}

	public function get_advanced_fields_config() {

		$advanced_fields                = array();
		$advanced_fields['text']        = false;
		$advanced_fields['text_shadow'] = false;
		$advanced_fields['max_width']   = false;
		$advanced_fields['fonts']       = false;
		$advanced_fields['borders']     = false;

		$advanced_fields['fonts']['title'] = array(
			'label'        => esc_html__( 'Title', 'wdc-wow-divi-carousel' ),
			'css'          => array(
				'main'      => '%%order_class%% .wdc-image-carousel-item .wdc-image-title',
				'important' => 'all',
			),
			'tab_slug'     => 'advanced',
			'toggle_slug'  => 'texts',
			'sub_toggle'   => 'title_tab',
			'line_height'  => array(
				'range_settings' => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
			),
			'header_level' => array(
				'default' => 'h3',
			),
		);

		$advanced_fields['fonts']['subtitle'] = array(
			'label'        => esc_html__( 'Subtitle', 'wdc-wow-divi-carousel' ),
			'css'          => array(
				'main'      => '%%order_class%% .wdc-image-subtitle, .et-db #et-boc %%order_class%% .wdc-image-subtitle',
				'important' => 'all',
			),
			'tab_slug'     => 'advanced',
			'toggle_slug'  => 'texts',
			'sub_toggle'   => 'subtitle_tab',
			'line_height'  => array(
				'range_settings' => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
			),
			'header_level' => array(
				'default' => 'h5',
			),
		);

		$advanced_fields['borders']['item'] = array(
			'label_prefix' => esc_html__( 'Item', 'wdc-wow-divi-carousel' ),
			'css'          => array(
				'main'      => '%%order_class%%',
				'important' => 'all',
			),
			'tab_slug'     => 'advanced',
			'toggle_slug'  => 'borders',
		);

		return $advanced_fields;
	}

	public function render_figure() {

		$photo                  = $this->props['photo'];
		$photo_alt              = $this->props['photo_alt'];
		$processed_overlay_icon = esc_attr( et_pb_process_font_icon( $this->props['overlay_icon'] ) );
		$overlay_icon           = ! empty( $processed_overlay_icon ) ? $processed_overlay_icon : '';
		$data_schema            = $this->get_swapped_img_schema( 'photo' );
		$parent_module          = self::get_parent_modules( 'page' )['wdc_image_carousel'];
		$is_lazyload            = $parent_module->shortcode_atts['is_lazyload'];
		wdc_inject_fa_icons( $this->props['overlay_icon'] );
		if ( ! empty( $photo ) ) {
			return sprintf(
				'<figure class="wdc-lightbox-ctrl">
                    <div class="wdc-overlay"><span class="wdc-overlay-icon">%3$s</span></div>
                    <img class="wdc-swapped-img" data-mfp-src="%1$s" %4$s="%1$s" %2$s alt="%5$s"/>
                </figure>',
				$photo,
				$data_schema,
				$overlay_icon,
				'on' === $is_lazyload ? 'data-lazy' : 'src',
				$photo_alt
			);
		}

	}

	public function render_title() {

		$title_text            = $this->props['title'];
		$title_level           = $this->props['title_level'];
		$processed_title_level = et_pb_process_header_level( $title_level, 'h3' );
		$processed_title_level = esc_html( $processed_title_level );

		if ( ! empty( $title_text ) ) {
			return sprintf( '<%2$s class="wdc-image-title">%1$s</%2$s>', $title_text, $processed_title_level );
		}
	}

	public function render_subTitle() {

		$sub_title                = $this->props['sub_title'];
		$subtitle_level           = $this->props['subtitle_level'];
		$processed_subtitle_level = et_pb_process_header_level( $subtitle_level, 'h5' );
		$processed_subtitle_level = esc_html( $processed_subtitle_level );

		if ( ! empty( $sub_title ) ) {
			return sprintf( '<%2$s class="wdc-image-subtitle">%1$s</%2$s>', $sub_title, $processed_subtitle_level );
		}
	}

	public function render_content() {

		if ( empty( $this->props['title'] ) && empty( $this->props['sub_title'] ) ) {
			return;
		}

		$content_type = $this->props['content_type'];

		return sprintf(
			'<div class="content content--%3$s"><div class="content-inner"> %1$s %2$s </div></div>',
			$this->render_title(),
			$this->render_subTitle(),
			$content_type
		);
	}

	public function render( $attrs, $content, $render_slug ) {

		global $wdc_image_child;
		global $wdc_uid_image;

		if ( empty( $wdc_uid_image ) && 0 !== $wdc_uid_image ) {
			$wdc_uid_image = 0;
		}

		$wdc_image_child[ $wdc_uid_image ][] = array(
			'tab_title'    => ! empty( $this->props['tab_title'] ) ? $this->props['tab_title'] : $this->props['title'],
			'tab_subtitle' => ! empty( $this->props['tab_subtitle'] ) ? $this->props['tab_subtitle'] : $this->props['sub_title'],
			'tab_thumb'    => ! empty( $this->props['tab_thumb'] ) ? $this->props['tab_thumb'] : $this->props['photo'],
		);

		$content_pos_x                     = $this->props['content_pos_x'];
		$content_pos_y                     = $this->props['content_pos_y'];
		$content_type                      = $this->props['content_type'];
		$content_width                     = $this->props['content_width'];
		$title_bottom_spacing              = $this->props['title_bottom_spacing'];
		$image_hover_animation             = $this->props['image_hover_animation'];
		$image_height                      = $this->props['image_height'];
		$image_height_tablet               = $this->props['image_height_tablet'];
		$image_height_phone                = $this->props['image_height_phone'];
		$image_height_last_edited          = $this->props['image_height_last_edited'];
		$image_height_responsive_status    = et_pb_get_responsive_status( $image_height_last_edited );
		$content_padding                   = $this->props['content_padding'];
		$content_padding_tablet            = $this->props['content_padding_tablet'];
		$content_padding_phone             = $this->props['content_padding_phone'];
		$content_padding_last_edited       = $this->props['content_padding_last_edited'];
		$content_padding_responsive_status = et_pb_get_responsive_status( $content_padding_last_edited );

		if ( 'absolute' === $content_type ) {

			if ( empty( $content_padding ) ) {
				$content_padding = '10px|20px|10px|20px';
			}
		} else {

			if ( empty( $content_padding ) ) {
				$content_padding = '20px|0|0|0';
			}
		}
		if ( class_exists( 'ET_Builder_Module_Helper_Style_Processor' ) ) {
			$this->generate_styles(
				array(
					'utility_arg'    => 'icon_font_family',
					'render_slug'    => $render_slug,
					'base_attr_name' => 'overlay_icon',
					'important'      => true,
					'selector'       => '%%order_class%% .wdc-overlay .wdc-overlay-icon',
					'processor'      => array(
						'ET_Builder_Module_Helper_Style_Processor',
						'process_extended_icon',
					),
				)
			);
		}
		// image Height.
		if ( 'auto' !== $image_height ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-image-carousel-item figure',
					'declaration' => sprintf( 'height: %1$s;', $image_height ),
				)
			);
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-image-carousel-item figure img',
					'declaration' => 'height: 100%; object-fit: cover;width:100%;',
				)
			);

			if ( $image_height_tablet && $image_height_responsive_status ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-image-carousel-item figure',
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
						'declaration' => sprintf( 'height: %1$s;', $image_height_tablet ),
					)
				);
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-image-carousel-item figure img',
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
						'declaration' => 'height: 100%; object-fit: cover;width:100%;',
					)
				);
			}

			if ( $image_height_phone && $image_height_responsive_status ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-image-carousel-item figure',
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
						'declaration' => sprintf( 'height: %1$s;', $image_height_phone ),
					)
				);
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-image-carousel-item figure img',
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
						'declaration' => 'height: 100%; object-fit: cover;width:100%;',
					)
				);
			}
		}

		// Texts.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-image-carousel-item h3, .et-db #et-boc %%order_class%% .wdc-image-carousel-item h3',
				'declaration' => sprintf( 'padding-bottom: %1$s;', $title_bottom_spacing ),
			)
		);

		// Content.
		if ( 'absolute' === $content_type ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .content--absolute',
					'declaration' => sprintf(
						'align-items: %1$s; justify-content: %2$s;',
						$content_pos_x,
						$content_pos_y
					),
				)
			);
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-image-carousel-item .content .content-inner',
				'declaration' => sprintf(
					'width: %1$s; %2$s',
					$content_width,
					WDC_Builder_Module::wdc_process_padding( $content_padding, false )
				),
			)
		);

		if ( $content_padding_tablet && $content_padding_responsive_status ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-image-carousel-item .content .content-inner',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					'declaration' => WDC_Builder_Module::wdc_process_padding( $content_padding_tablet, false ),
				)
			);
		}

		if ( $content_padding_phone && $content_padding_responsive_status ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-image-carousel-item .content .content-inner',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					'declaration' => WDC_Builder_Module::wdc_process_padding( $content_padding_phone, false ),
				)
			);
		}

		// Content background.
		$this->get_custom_bg_style( $render_slug, 'content', '%%order_class%% .wdc-image-carousel-item .content .content-inner', '%%order_class%% .wdc-image-carousel-item .content .content-inner:hover' );

		// Overlay Styles.
		$this->get_overlay_style( $render_slug );

		// Module classnames.
		$this->remove_classname( 'et_pb_module' );
		$this->add_classname( 'wdc_et_pb_module' );

		return sprintf(
			'<div class="wdc-carousel-item wdc-image-carousel-item wdc-swapped-img-selector wdc-hover--%3$s">
				%1$s %2$s
			</div>',
			$this->render_figure(),
			$this->render_content(),
			$image_hover_animation
		);
	}
}

new WDC_ImageCarouselChild();
