<?php
class WDC_GoogleReview extends WDC_Builder_Module {

	protected $module_credits = array(
		'module_uri' => 'https://wowcarousel.com/modules/google-review/',
		'author'     => 'Wow Carousel',
		'author_uri' => 'https://divipeople.com/wow-divi-carousel/',
	);

	public function init() {

		$this->vb_support = 'on';
		$this->icon_path  = plugin_dir_path( __FILE__ ) . 'wdc-google-review.svg';
		$this->name       = esc_html__( 'Wow Google Review', 'wdc-wow-divi-carousel' );
		$this->plural     = esc_html__( 'Wow Google Review', 'wdc-wow-divi-carousel' );
		$this->slug       = 'wdc_google_reviews';

		$this->settings_modal_toggles = array(

			'general'  => array(
				'toggles' => array(
					'google_review'    => esc_html__( 'Google Review', 'wdc-wow-divi-carousel' ),
					'review_elements'  => esc_html__( 'Review Elements', 'wdc-wow-divi-carousel' ),
					'general_settings' => esc_html__( 'Genarel Settings', 'wdc-wow-divi-carousel' ),
					'settings'         => array(
						'title'             => esc_html__( 'Carousel Settings', 'wdc-wow-divi-carousel' ),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'general'  => array(
								'name' => esc_html__( 'General', 'wdc-wow-divi-carousel' ),
							),
							'advanced' => array(
								'name' => esc_html__( 'Advanced', 'wdc-wow-divi-carousel' ),
							),
						),
					),
				),
			),

			'advanced' => array(
				'toggles' => array(
					'common'     => esc_html__( 'Common', 'wdc-wow-divi-carousel' ),
					'elements'   => array(
						'title'             => esc_html__( 'Elements', 'wdc-wow-divi-carousel' ),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'icon'   => array(
								'name' => esc_html__( 'Google Icon', 'wdc-wow-divi-carousel' ),
							),
							'image'  => array(
								'name' => esc_html__( 'Image', 'wdc-wow-divi-carousel' ),
							),
							'rating' => array(
								'name' => esc_html__( 'Rating', 'wdc-wow-divi-carousel' ),
							),
						),
					),
					'texts'      => array(
						'title'             => esc_html__( 'Text', 'wdc-wow-divi-carousel' ),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'name'   => array(
								'name' => esc_html__( 'Name', 'wdc-wow-divi-carousel' ),
							),
							'review' => array(
								'name' => esc_html__( 'Review', 'wdc-wow-divi-carousel' ),
							),
							'date'   => array(
								'name' => esc_html__( 'Date', 'wdc-wow-divi-carousel' ),
							),
							'more'   => array(
								'name' => esc_html__( 'More', 'wdc-wow-divi-carousel' ),
							),
						),
					),

					'arrow'      => array(
						'title'             => esc_html__( 'Navigation', 'wdc-wow-divi-carousel' ),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'arrow_common' => array(
								'name' => esc_html__( 'Common', 'wdc-wow-divi-carousel' ),
							),
							'arrow_left'   => array(
								'name' => esc_html__( 'Prev', 'wdc-wow-divi-carousel' ),
							),
							'arrow_right'  => array(
								'name' => esc_html__( 'Next', 'wdc-wow-divi-carousel' ),
							),
						),
					),

					'pagination' => array(
						'title'             => esc_html__( 'Pagination', 'wdc-wow-divi-carousel' ),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'pagi_common' => array(
								'name' => esc_html__( 'Common', 'wdc-wow-divi-carousel' ),
							),
							'pagi_active' => array(
								'name' => esc_html__( 'Active', 'wdc-wow-divi-carousel' ),
							),
						),
					),
				),
			),
		);
	}

	protected static function get_locations_fields() {

		$fields   = array();
		$lists    = wdc_gmb_locations_list();
		$no_lists = array();

		$no_lists['none'] = esc_html__( 'No Location Found', 'wdc-wow-divi-carousel' );
		$options          = $lists && is_array( $lists ) ? $lists : $no_lists;

		$fields['location_name'] = array(
			'label'            => esc_html__( 'Location', 'wdc-wow-divi-carousel' ),
			'type'             => 'select',
			'options'          => $options,
			'toggle_slug'      => 'google_review',
			'show_if'          => array(
				'review_type' => 'gmb',
			),
			'computed_affects' => array(
				'__reviews',
			),
		);

		return $fields;
	}

	public function get_fields() {

		$switch_review_type = array(
			'review_type' => array(
				'label'            => esc_html__( 'Review Type', 'wdc-wow-divi-carousel' ),
				'type'             => 'select',
				'default'          => 'gpr',
				'options'          => array(
					'gpr' => __( 'Google Places Reviews', 'wdc-wow-divi-carousel' ),
					// 'gmb' => __( 'Google My Business', 'wdc-wow-divi-carousel' ),
				),
				'toggle_slug'      => 'google_review',
				'computed_affects' => array(
					'__reviews',
				),
			),

			'placeid'     => array(
				'label'            => __( 'Place ID', 'wdc-wow-divi-carousel' ),
				'type'             => 'text',
				'description'      => esc_html__( 'A place ID is a textual identifier that uniquely identifies a place. The length of the identifier may vary. Examples: ChIJgUbEo8cfqokR5lP9_Wh_DaM.', 'wdc-wow-divi-carousel' ),
				'toggle_slug'      => 'google_review',
				'default'          => 'ChIJj61dQgK6j4AR4GeTYWZsKWw',
				'show_if'          => array(
					'review_type' => 'gpr',
				),
				'computed_affects' => array( '__reviews' ),
			),

		);

		$fields = array(
			'reviews_number'            => array(
				'label'            => __( 'Review Count', 'wdc-wow-divi-carousel' ),
				'type'             => 'text',
				'default'          => 10,
				'show_if'          => array(
					'review_type' => 'gmb',
				),
				'toggle_slug'      => 'google_review',
				'description'      => esc_html__( 'Choose how much reviews you would like to display in crousel.', 'wdc-wow-divi-carousel' ),
				'computed_affects' => array( '__reviews' ),
			),

			'reviews_number'            => array(
				'label'            => __( 'Review Count', 'wdc-wow-divi-carousel' ),
				'type'             => 'range',
				'default'          => '5',
				'unitless'         => true,
				'range_settings'   => array(
					'step' => 1,
					'min'  => 1,
					'max'  => 5,
				),
				'show_if'          => array(
					'review_type' => 'gpr',
				),
				'toggle_slug'      => 'google_review',
				'description'      => esc_html__( 'Choose how much reviews you would like to display in crousel.', 'wdc-wow-divi-carousel' ),
				'computed_affects' => array( '__reviews' ),
			),

			'show_five_star_only'       => array(
				'label'            => __( 'Show 5 Star Only', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'options'          => array(
					'on'  => __( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => __( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'on',
				'toggle_slug'      => 'google_review',
				'computed_affects' => array( '__reviews' ),
			),

			'hide_empty_comment_review' => array(
				'label'            => __( 'Hide Empty Comment Reviews', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'options'          => array(
					'on'  => __( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => __( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'off',
				'show_if'          => array(
					'show_review_comment' => 'on',
				),
				'toggle_slug'      => 'google_review',
				'computed_affects' => array( '__reviews' ),
			),

			// Review Settings.
			'show_google_icon'          => array(
				'label'            => __( 'Show google Logo', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'options'          => array(
					'on'  => __( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => __( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'on',
				'toggle_slug'      => 'review_elements',
				'computed_affects' => array( '__reviews' ),
			),

			'show_reviewer_image'       => array(
				'label'            => __( 'Show Reviewer Image', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'options'          => array(
					'on'  => __( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => __( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'on',
				'toggle_slug'      => 'review_elements',
				'computed_affects' => array( '__reviews' ),
			),

			'show_name'                 => array(
				'label'            => __( 'Show Reviewer Name', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'options'          => array(
					'on'  => __( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => __( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'on',
				'toggle_slug'      => 'review_elements',
				'computed_affects' => array( '__reviews' ),
			),

			'show_review_comment'       => array(
				'label'            => __( 'Show Review Comment', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'options'          => array(
					'on'  => __( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => __( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'on',
				'toggle_slug'      => 'review_elements',
				'computed_affects' => array( '__reviews' ),
			),

			'show_time'                 => array(
				'label'            => __( 'Show Review Date', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'options'          => array(
					'on'  => __( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => __( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'on',
				'toggle_slug'      => 'review_elements',
				'computed_affects' => array( '__reviews' ),
			),

			'show_ratings'              => array(
				'label'            => __( 'Show Ratings', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'options'          => array(
					'on'  => __( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => __( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'on',
				'toggle_slug'      => 'review_elements',
				'computed_affects' => array( '__reviews' ),
			),

			'show_read_more'            => array(
				'label'            => __( ' Show Read More Text', 'wdc-wow-divi-carousel' ),
				'type'             => 'yes_no_button',
				'options'          => array(
					'on'  => __( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => __( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'          => 'on',
				'show_if'          => array(
					'show_review_comment' => 'on',
				),
				'toggle_slug'      => 'review_elements',
				'computed_affects' => array( '__reviews' ),
			),

			'text_lenght'               => array(
				'label'            => __( 'Text Lenght', 'wdc-wow-divi-carousel' ),
				'type'             => 'range',
				'default'          => '150',
				'unitless'         => true,
				'range_settings'   => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 1000,
				),
				'show_if'          => array(
					'show_review_comment' => 'on',
					'show_read_more'      => 'on',
				),
				'toggle_slug'      => 'review_elements',
				'computed_affects' => array( '__reviews' ),
			),

			'read_more_text'            => array(
				'label'            => __( 'Read More Text', 'wdc-wow-divi-carousel' ),
				'type'             => 'text',
				'default'          => 'Read More',
				'show_if'          => array(
					'show_review_comment' => 'on',
					'show_read_more'      => 'on',
				),
				'toggle_slug'      => 'review_elements',
				'computed_affects' => array( '__reviews' ),
			),

			// Genegal Settings.
			'alignment'                 => array(
				'label'        => __( 'Alignment', 'wdc-wow-divi-carousel' ),
				'type'         => 'text_align',
				'options'      => et_builder_get_text_orientation_options( array( 'justified' ) ),
				'options_icon' => 'module_align',
				'default'      => 'center',
				'toggle_slug'  => 'general_settings',
			),

			'reviewer_position'         => array(
				'label'            => esc_html__( 'Reviewer Info Position', 'wdc-wow-divi-carousel' ),
				'type'             => 'select',
				'default'          => 'top',
				'options'          => array(
					'top'    => esc_html__( 'Top', 'wdc-wow-divi-carousel' ),
					'bottom' => esc_html__( 'Bottom', 'wdc-wow-divi-carousel' ),
				),
				'toggle_slug'      => 'general_settings',
				'computed_affects' => array( '__reviews' ),
			),

			'date_position'             => array(
				'label'            => esc_html__( 'Display Date', 'wdc-wow-divi-carousel' ),
				'type'             => 'select',
				'default'          => 'default',
				'options'          => array(
					'default' => esc_html__( 'Default', 'wdc-wow-divi-carousel' ),
					'footer'  => esc_html__( 'On Footer', 'wdc-wow-divi-carousel' ),
				),
				'toggle_slug'      => 'general_settings',
				'computed_affects' => array( '__reviews' ),
			),

			// review text spacing top.
			'text_spacing_top'          => array(
				'label'          => __( 'Review text Spacing Top', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '18px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 100,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'texts',
				'sub_toggle'     => 'review',
			),

			'text_spacing_bottom'       => array(
				'label'          => __( 'Review text Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '25px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 100,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'texts',
				'sub_toggle'     => 'review',
			),

			// Ratings.
			'ratings_spacing_top'       => array(
				'label'          => __( 'Stars Spacing Top', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '20px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 100,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'elements',
				'sub_toggle'     => 'rating',
			),

			'ratings_spacing_bottom'    => array(
				'label'          => __( 'Stars Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '0px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 100,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'elements',
				'sub_toggle'     => 'rating',
			),

			'stars_size'                => array(
				'label'          => __( 'Stars Size', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '17px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 100,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'elements',
				'sub_toggle'     => 'rating',
			),

			'stars_color'               => array(
				'label'       => __( 'Stars Color', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'arrow',
				'default'     => '#F3B325',
				'sub_toggle'  => 'elements',
				'sub_toggle'  => 'rating',
			),

			'stars_spacing_between'     => array(
				'label'          => __( 'Stars Spacing Between', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '5px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 20,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'elements',
				'sub_toggle'     => 'rating',
			),

			// common.
			'content_padding'           => array(
				'label'          => __( 'Item Padding', 'wdc-wow-divi-carousel' ),
				'type'           => 'custom_padding',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'common',
				'default'        => '25px|25px|15px|25px',
				'mobile_options' => true,
			),

			// Google icon.
			'logo_position'             => array(
				'label'       => esc_html__( 'Google Icon Position', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'default'     => 'left',
				'options'     => array(
					'auto'  => esc_html__( 'Auto', 'wdc-wow-divi-carousel' ),
					'left'  => esc_html__( 'Left', 'wdc-wow-divi-carousel' ),
					'right' => esc_html__( 'Right', 'wdc-wow-divi-carousel' ),
				),
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'elements',
				'sub_toggle'  => 'icon',
			),

			'google_icon_size'          => array(
				'label'          => __( 'Google Icon Size', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '20px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 200,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'elements',
				'sub_toggle'     => 'icon',
			),

			'icon_pos_y'                => array(
				'label'          => __( 'Google Icon Offset Top', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '10px',
				'range_settings' => array(
					'step' => 1,
					'min'  => -100,
					'max'  => 100,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'elements',
				'sub_toggle'     => 'icon',
			),

			'icon_pos_x'                => array(
				'label'          => __( 'Google Icon Offset Left/Right', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '10px',
				'range_settings' => array(
					'step' => 1,
					'min'  => -100,
					'max'  => 100,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'elements',
				'sub_toggle'     => 'icon',
			),

			// reviewer image (elements).
			'reviewer_image_size'       => array(
				'label'          => __( 'Reviewer Image Size', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '50px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 80,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'elements',
				'sub_toggle'     => 'image',
			),

			'image_spacing'             => array(
				'label'          => __( 'Image Spacing', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '10px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 200,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'elements',
				'sub_toggle'     => 'image',
			),

			'image_border_width'        => array(
				'label'          => __( 'Image Border Width', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '0px',
				'range_settings' => array(
					'step' => 1,
					'min'  => 0,
					'max'  => 50,
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'elements',
				'sub_toggle'     => 'image',
			),

			'image_border_color'        => array(
				'label'       => esc_html__( 'Image Border Color', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'default'     => '#333',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'elements',
				'sub_toggle'  => 'image',
			),

			'__reviews'                 => array(
				'type'                => 'computed',
				'computed_callback'   => array( 'WDC_GoogleReview', 'google_review_render' ),
				'computed_depends_on' => array(
					'review_type',
					'placeid',
					'location_name',
					'reviews_number',
					'show_google_icon',
					'show_reviewer_image',
					'show_name',
					'show_time',
					'show_review_comment',
					'show_ratings',
					'show_read_more',
					'text_lenght',
					'read_more_text',
					'meta_alignment',
					'reviewer_position',
					'date_position',
					'show_five_star_only',
					'hide_empty_comment_review',
				),

				'computed_minimum'    => array(
					'review_type',
					'placeid',
					'location_name',
					'reviews_number',
				),
			),
		);

		$additional_options = $this->custom_advanced_background_fields(
			'review_item',
			'Reviews',
			'advanced',
			'common',
			array( 'color', 'gradient' ),
			array(),
			''
		);
		$carousel_options   = WDC_Builder_Module::get_carousel_option_fields( 'common', array( 'equal_height' ) );

		return array_merge( $switch_review_type, self::get_locations_fields(), $carousel_options, $fields, $additional_options );
	}

	public function get_advanced_fields_config() {

		$advanced_fields                 = array();
		$advanced_fields['text']         = false;
		$advanced_fields['text_shadow']  = false;
		$advanced_fields['link_options'] = false;
		$advanced_fields['fonts']        = false;

		$advanced_fields['borders']['item'] = array(
			'label'       => esc_html__( 'Item', 'wdc-wow-divi-carousel' ),
			'toggle_slug' => 'common',
			'tab_slug'    => 'advanced',
			'css'         => array(
				'main'      => array(
					'border_radii'  => '%%order_class%% .wdc-review-item-inner',
					'border_styles' => '%%order_class%% .wdc-review-item-inner',
				),
				'important' => true,
			),
			'defaults'    => array(
				'border_radii'  => 'on|0px|0px|0px|0px',
				'border_styles' => array(
					'width' => '0px',
					'color' => '#333',
					'style' => 'solid',
				),
			),
		);

		$advanced_fields['fonts']['name'] = array(
			'label'           => esc_html__( 'Reviewer', 'wdc-wow-divi-carousel' ),
			'css'             => array(
				'main' => '%%order_class%% .wdc-review-author h4',
			),
			'important'       => 'all',
			'hide_text_align' => true,
			'tab_slug'        => 'advanced',
			'toggle_slug'     => 'texts',
			'sub_toggle'      => 'name',
			'line_height'     => array(
				'range_settings' => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'default'        => floatval( et_get_option( 'body_font_height', '1.7' ) ) . 'em',
			),
			'font_size'       => array(
				'default' => absint( et_get_option( 'body_font_size', '18' ) ) . 'px',
			),
		);

		$advanced_fields['box_shadow'] = array(
			'default' => array(),
			'image'   => array(
				'label'             => esc_html__( 'Item Box Shadow', 'wdc-wow-divi-carousel' ),
				'option_category'   => 'layout',
				'tab_slug'          => 'advanced',
				'toggle_slug'       => 'common',
				'css'               => array(
					'main'    => '%%order_class%% .wdc-review-item-inner',
					'overlay' => 'inset',
				),
				'default_on_fronts' => array(
					'color'    => '',
					'position' => '',
				),
			),
		);

		$advanced_fields['fonts']['review'] = array(
			'label'       => esc_html__( 'Review', 'wdc-wow-divi-carousel' ),
			'css'         => array(
				'main' => '%%order_class%% .wdc-review-text',
			),
			'important'   => 'all',
			'tab_slug'    => 'advanced',
			'toggle_slug' => 'texts',
			'sub_toggle'  => 'review',
			'line_height' => array(
				'range_settings' => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'default'        => floatval( et_get_option( 'body_font_height', '1.7' ) ) . 'em',
			),
			'font_size'   => array(
				'default' => absint( et_get_option( 'body_font_size', '14' ) ) . 'px',
			),
		);

		$advanced_fields['fonts']['date'] = array(
			'label'           => esc_html__( 'Review', 'wdc-wow-divi-carousel' ),
			'css'             => array(
				'main' => '%%order_class%% .wdc-review-date',
			),
			'hide_text_align' => true,
			'important'       => 'all',
			'tab_slug'        => 'advanced',
			'toggle_slug'     => 'texts',
			'sub_toggle'      => 'date',
			'line_height'     => array(
				'range_settings' => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'default'        => floatval( et_get_option( 'body_font_height', '1.7' ) ) . 'em',
			),
			'font_size'       => array(
				'default' => absint( et_get_option( 'body_font_size', '13' ) ) . 'px',
			),
		);

		$advanced_fields['fonts']['more'] = array(
			'label'           => esc_html__( 'Read More', 'wdc-wow-divi-carousel' ),
			'css'             => array(
				'main' => '%%order_class%% .wdc-more-toggle',
			),
			'hide_text_align' => true,
			'important'       => 'all',
			'tab_slug'        => 'advanced',
			'toggle_slug'     => 'texts',
			'sub_toggle'      => 'more',
			'line_height'     => array(
				'range_settings' => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'default'        => floatval( et_get_option( 'body_font_height', '1.7' ) ) . 'em',
			),
			'font_size'       => array(
				'default' => absint( et_get_option( 'body_font_size', '14' ) ) . 'px',
			),
		);

		return $advanced_fields;
	}

	public static function google_review_render( $args = array(), $conditional_tags = array(), $current_page = array() ) {

		$defaults = array(
			'review_type'               => '',
			'placeid'                   => '',
			'location_name'             => '',
			'reviews_number'            => '',
			'show_google_icon'          => '',
			'show_reviewer_name'        => '',
			'show_reviewer_image'       => '',
			'show_review_comment'       => '',
			'show_name'                 => '',
			'show_time'                 => '',
			'show_ratings'              => '',
			'show_read_more'            => '',
			'text_lenght'               => '',
			'read_more_text'            => '',
			'meta_alignment'            => '',
			'reviewer_position'         => '',
			'date_position'             => '',
			'show_five_star_only'       => '',
			'hide_empty_comment_review' => '',
		);

		$args = wp_parse_args( $args, $defaults );

		$review_type   = $args['review_type'];
		$placeid       = $args['placeid'];
		$location_name = $args['location_name'];

		$reviews_number      = $args['reviews_number'];
		$reviewer_position   = $args['reviewer_position'];
		$date_position       = $args['date_position'];
		$show_time           = $args['show_time'];
		$show_review_comment = $args['show_review_comment'];
		$show_read_more      = $args['show_read_more'];
		$text_lenght         = intval( $args['text_lenght'] );
		$read_more_text      = $args['read_more_text'];
		$reviews             = new stdClass();

		$google_reviews_cache = 'wdc_google_reviews_cache_';

		if ( 'gpr' === $review_type ) {

			$transient_key = $google_reviews_cache . $placeid;

			$ch_reviews = get_transient( $transient_key );

			$messages = array();

			if ( empty( $placeid ) ) {
				$messages['no_place_id'] = esc_html__( 'Please enter your place id.', 'wdc-wow-divi-carousel' );
			}

			$gpr = new WowDiviCarousel\Api\Google_Places_Reviews();

			if ( $ch_reviews ) {
				if ( empty( $ch_reviews ) ) {
					$messages['wrong_api_key'] = esc_html__( 'Wrong Api Key or Place ID added. Due to recent changes by Google you must now add the Maps API to your existing API key in order to use the Location Lookup feature of the Google Reviews Module.', 'wdc-wow-divi-carousel' );
				}

				if ( ! empty( $ch_reviews ) && count( $ch_reviews ) < 1 ) {
					$messages['not_found'] = esc_html__( 'No review found!', 'wdc-wow-divi-carousel' );
				}
				$reviews = $ch_reviews;

			} else {
				if ( '' !== $placeid ) {
					$gpr = new WowDiviCarousel\Api\Google_Places_Reviews();
					$gpr->set_place_id( $placeid );

					$res = $gpr->get_reviews();

					if ( 'OK' === $res->status ) {
						if ( isset( $res->result->reviews ) ) {
							set_transient( $transient_key, $res->result->reviews, DAY_IN_SECONDS );
							$reviews = $res->result->reviews;
						} else {
							$messages['not_found'] = esc_html__( 'No review found!', 'wdc-wow-divi-carousel' );
						}
					} else {
						delete_transient( $transient_key );
						$messages['wrong_api_key'] = esc_html__( 'Wrong Api Key or Place ID added. Due to recent changes by Google you must now add the Maps API to your existing API key in order to use the Location Lookup feature of the Google Reviews Module.', 'wdc-wow-divi-carousel' );
					}
				}
			}

			if ( ! empty( $messages ) ) {
				foreach ( $messages as $key => $message ) {
					$output = sprintf( '<div class="wdc-%2$s wdc-google-review-error">%1$s</div>', esc_html( $message ), esc_html( $key ) );
				}

				return $output;
			}
		} elseif ( 'gmb' === $review_type ) {

			$transient_key = $google_reviews_cache . str_replace( '/', '_', $location_name );
			$reviews       = get_transient( $transient_key );

			if ( false === $reviews && 'none' === $location_name ) {
				$gmb = new WowDiviCarousel\Api\Google_My_Business();
				$gmb->init();
				$response = $gmb->get_reviews( $location_name );
				set_transient( $transient_key, $response->reviews->reviews, DAY_IN_SECONDS );
			}

			$messages = array();

			if ( ! $location_name || 'none' === $location_name ) {
				$messages['no_locations'] = esc_html__( 'No businesses found. Did you log in to the correct Google account?', 'wdc-wow-divi-carousel' );
			}

			if ( ! is_object( $reviews ) ) {
				$messages['no_account'] = esc_html__( 'No user account or location groups found', 'wdc-wow-divi-carousel' );
			}

			if ( ! empty( $messages ) ) {
				foreach ( $messages as $key => $message ) {
					$output = sprintf( '<div class="wdc-%2$s wdc-google-review-error">%1$s</div>', esc_html( $message ), esc_html( $key ) );
				}

				return $output;
			}
		}

		$google_icon = '';
		if ( 'on' === $args['show_google_icon'] ) {
			$google_icon = sprintf(
				'<div class="wdc-review-icon">
            		%1$s
                </div>',
				wdc_google_svg_icon()
			);
		}

		$index_number = 1;

		ob_start();

		foreach ( $reviews as $review ) {

			if ( 'on' === $args['hide_empty_comment_review'] ) {
				if ( empty( $review->comment ) && 'gmb' === $review_type ) {
					continue;
				}
				if ( empty( $review->text ) && 'gpr' === $review_type ) {
					continue;
				}
			}

			if ( 'on' === $args['show_five_star_only'] && 'gmb' === $review_type ) {
				if ( 'FIVE' !== $review->star_rating ) {
					continue;
				}
			}

			if ( 'on' === $args['show_five_star_only'] && 'gpr' === $review_type ) {
				if ( $review->rating < 5 ) {
					continue;
				}
			}

			if ( 'gpr' === $review_type ) {
				include WOW_DIVI_CAROUSEL_PLUGIN_DIR . 'templates/google-reviews/gpr.php';
			} elseif ( 'gmb' === $review_type ) {
				include WOW_DIVI_CAROUSEL_PLUGIN_DIR . 'templates/google-reviews/gmb.php';
			}

			if ( ++$index_number === $reviews_number ) {
				break;
			}
		}

		$output = ob_get_clean();

		if ( ! $output ) {
			$output = 'Something is wrong';
		}

		return $output;
	}

	public function render( $attrs, $content, $render_slug ) {

		$this->apply_css( $render_slug );

		$sliding_dir      = $this->props['sliding_dir'];
		$is_center        = $this->props['is_center'];
		$is_equal_height  = $this->props['is_equal_height'];
		$center_mode_type = $this->props['center_mode_type'];
		$alignment        = $this->props['alignment'];
		$custom_cursor    = $this->props['custom_cursor'];
		$show_read_more   = $this->props['show_read_more'];
		$location_name    = isset( $this->props['location_name'] ) ? $this->props['location_name'] : '';
		$placeid          = isset( $this->props['placeid'] ) ? $this->props['placeid'] : '';

		$review_items = self::google_review_render(
			array(
				'review_type'               => $this->props['review_type'],
				'location_name'             => $location_name,
				'placeid'                   => $placeid,
				'reviews_number'            => $this->props['reviews_number'],
				'show_google_icon'          => $this->props['show_google_icon'],
				'show_reviewer_image'       => $this->props['show_reviewer_image'],
				'show_name'                 => $this->props['show_name'],
				'show_time'                 => $this->props['show_time'],
				'show_review_comment'       => $this->props['show_review_comment'],
				'show_ratings'              => $this->props['show_ratings'],
				'show_read_more'            => $this->props['show_read_more'],
				'text_lenght'               => $this->props['text_lenght'],
				'read_more_text'            => $this->props['read_more_text'],
				'reviewer_position'         => $this->props['reviewer_position'],
				'date_position'             => $this->props['date_position'],
				'show_five_star_only'       => $this->props['show_five_star_only'],
				'hide_empty_comment_review' => $this->props['hide_empty_comment_review'],
			)
		);

		// CSS Classes.
		$classes = array();

		if ( 'on' === $is_center ) {
			array_push( $classes, 'wdc-centered' );
			array_push( $classes, "wdc-centered--{$center_mode_type}" );
		}

		if ( 'on' === $custom_cursor ) {
			array_push( $classes, 'wdc-cursor' );
		}

		array_push( $classes, "wdc-text-{$alignment}" );
		array_push( $classes, "equal-height-{$is_equal_height}" );

		// Get Order Class.
		$order_class  = self::get_module_order_class( $render_slug );
		$order_number = str_replace( '_', '', str_replace( $this->slug, '', $order_class ) );

		$js_remore = sprintf(
			'<script type="text/javascript">
			var read_more = document.querySelectorAll(".wdc-more-toggle");
		    for (var i = 0; i < read_more.length; i++) {
		        (function(rm) {
		        rm.onclick = function() {
		            rm.parentNode.removeChild(rm.previousSibling.previousSibling);
		            rm.previousSibling.className = "";
		            rm.textContent = "";
		        };
		        })(read_more[i]);
		    }
		    </script>
		 '
		);

		$output = sprintf(
			'<div class="wdc-carousel-parent" %3$s dir="%5$s">
                <div class="wdc-carousel wdc-carousel-jq wdc-review-carousel wdc-carousel-frontend %2$s" %3$s>
                    %1$s
                </div>
                %4$s
            </div>
            ',
			$review_items,
			join( ' ', $classes ),
			$this->get_carousel_options_data( $order_number, 'google-review' ),
			'on' === $show_read_more ? $js_remore : '',
			$sliding_dir
		);

		return $output;
	}

	public function render_review_css( $render_slug ) {

		$content_padding                   = explode( '|', $this->props['content_padding'] );
		$content_padding_last_edited       = $this->props['content_padding_last_edited'];
		$content_padding_responsive_status = et_pb_get_responsive_status( $content_padding_last_edited );
		$content_padding_phone             = $this->props['content_padding_phone'];
		$content_padding_tablet            = $this->props['content_padding_tablet'];

		$ratings_spacing_top    = $this->props['ratings_spacing_top'];
		$ratings_spacing_bottom = $this->props['ratings_spacing_bottom'];
		$stars_color            = $this->props['stars_color'];
		$stars_size             = $this->props['stars_size'];
		$alignment              = $this->props['alignment'];
		$stars_spacing_between  = $this->props['stars_spacing_between'];
		$image_border_color     = $this->props['image_border_color'];
		$image_border_width     = $this->props['image_border_width'];
		$reviewer_image_size    = $this->props['reviewer_image_size'];
		$image_spacing          = $this->props['image_spacing'];
		$icon_pos_y             = $this->props['icon_pos_y'];
		$google_icon_size       = $this->props['google_icon_size'];
		$icon_pos_x             = $this->props['icon_pos_x'];

		$logo_position       = $this->props['logo_position'];
		$text_spacing_top    = $this->props['text_spacing_top'];
		$text_spacing_bottom = $this->props['text_spacing_bottom'];

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-review-item-inner',
				'declaration' => sprintf(
					'
				padding: %1$s %2$s %3$s %4$s !important;',
					$content_padding[0],
					$content_padding[1],
					$content_padding[2],
					$content_padding[3]
				),
			)
		);

		if ( $content_padding_tablet && $content_padding_responsive_status ) {
			$_content_padding_tablet = explode( '|', $this->props['content_padding_tablet'] );
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-review-item-inner',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					'declaration' => sprintf(
						'
					padding: %1$s %2$s %3$s %4$s !important;',
						$_content_padding_tablet[0],
						$_content_padding_tablet[1],
						$_content_padding_tablet[2],
						$_content_padding_tablet[3]
					),
				)
			);
		}

		if ( $content_padding_phone && $content_padding_responsive_status ) {

			$_content_padding_phone = explode( '|', $content_padding_phone );

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-review-item-inner',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					'declaration' => sprintf(
						'
					padding: %1$s %2$s %3$s %4$s !important;',
						$_content_padding_phone[0],
						$_content_padding_phone[1],
						$_content_padding_phone[2],
						$_content_padding_phone[3]
					),
				)
			);
		}

		// Review text Spacing.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-review-text',
				'declaration' => sprintf( 'padding-top: %1$s; padding-bottom: %2$s;', $text_spacing_top, $text_spacing_bottom ),
			)
		);

		// Ratings.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-review-stars',
				'declaration' => sprintf(
					'
                padding-top: %1$s !important;
                padding-bottom: %2$s !important;',
					$ratings_spacing_top,
					$ratings_spacing_bottom
				),
			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-review-stars i',
				'declaration' => sprintf( 'color: %1$s !important; font-size: %2$s !important;', $stars_color, $stars_size ),
			)
		);

		if ( 'center' === $alignment ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-review-stars i',
					'declaration' => sprintf( 'margin: 0 calc(%1$s / 2);', $stars_spacing_between ),
				)
			);
		} elseif ( 'right' === $alignment ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-review-stars i',
					'declaration' => sprintf( 'margin-left: %1$s;', $stars_spacing_between ),
				)
			);
		} else {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-review-stars i',
					'declaration' => sprintf( 'margin-right: %1$s;', $stars_spacing_between ),
				)
			);
		}

		// reviewer image.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-review-author figure',
				'declaration' => sprintf( 'width: %1$s; height: %1$s;', $reviewer_image_size ),
			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-review-author figure',
				'declaration' => sprintf( 'border: %1$s solid %2$s;', $image_border_width, $image_border_color ),
			)
		);

		if ( 'left' === $alignment ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-review-author figure',
					'declaration' => sprintf( 'margin-right: %1$s;', $image_spacing ),
				)
			);
		} elseif ( 'right' === $alignment ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-review-author figure',
					'declaration' => sprintf( 'margin-left: %1$s;', $image_spacing ),
				)
			);
		} else {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-review-author figure',
					'declaration' => sprintf( 'margin-bottom: %1$s;', $image_spacing ),
				)
			);
		}

		// Google Icon.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-review-icon',
				'declaration' => sprintf( 'top: %1$s; width: %2$s;', $icon_pos_y, $google_icon_size ),
			)
		);

		if ( 'left' === $logo_position ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-review-icon',
					'declaration' => sprintf( 'right: %1$s;', $icon_pos_x ),
				)
			);

		} elseif ( 'right' === $logo_position ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-review-icon',
					'declaration' => sprintf( 'left: %1$s;', $icon_pos_x ),
				)
			);

		} else {
			if ( 'right' === $alignment ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-review-icon',
						'declaration' => sprintf( 'left: %1$s;', $icon_pos_x ),
					)
				);
			} else {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .wdc-review-icon',
						'declaration' => sprintf( 'right: %1$s;', $icon_pos_x ),
					)
				);
			}
		}
	}

	public function apply_css( $render_slug ) {

		$this->apply_carousel_css( $render_slug );
		$this->render_review_css( $render_slug );
		$review_item_background = $this->processcustom_advanced_background_fields( 'review_item', '' );

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-review-item-inner',
				'declaration' => $review_item_background,
			)
		);

	}

}

new WDC_GoogleReview();
