<?php

class WDC_DiviLibraryChild extends WDC_Builder_Module {

	public function init() {
		$this->name            = esc_html__( 'Wow Smart Slide', 'wdc-wow-divi-carousel' );
		$this->slug            = 'wdc_divi_library_child';
		$this->vb_support      = 'on';
		$this->type            = 'child';
		$this->child_title_var = 'title';

		$this->settings_modal_toggles = array(
			'general' => array(
				'toggles' => array(
					'content' => esc_attr__( 'Divi Library', 'wdc-wow-divi-carousel' ),
				),
			),
		);
	}

	public function get_advanced_fields_config() {

		$advanced_fields                = array();
		$advanced_fields['text']        = false;
		$advanced_fields['text_shadow'] = false;
		$advanced_fields['fonts']       = false;

		return $advanced_fields;
	}

	public function get_fields() {

		$fields = array();

		$fields['title'] = array(
			'label'       => __( 'Admin Label', 'wdc-wow-divi-carousel' ),
			'type'        => 'text',
			'toggle_slug' => 'content',
		);

		$fields['library_id'] = array(
			'label'            => __( 'Divi Library', 'wdc-wow-divi-carousel' ),
			'type'             => 'select',
			'default'          => '-1',
			'options'          => wdc_divi_library(),
			'toggle_slug'      => 'content',
			'computed_affects' => array(
				'__divi_layout',
			),
		);

		$fields['__divi_layout'] = array(
			'type'                => 'computed',
			'computed_callback'   => array( 'WDC_DiviLibraryChild', 'divi_layout_callback' ),
			'computed_depends_on' => array(
				'library_id',
			),
		);

		return $fields;
	}

	public static function divi_layout_callback( $args = array() ) {

		$defaults = array();
		$args     = wp_parse_args( $args, $defaults );

		ob_start();
		if ( ! empty( $args['library_id'] ) && '-1' !== $args['library_id'] ) {

			ET_Builder_Element::clean_internal_modules_styles();

			echo do_shortcode( sprintf( '[et_pb_section global_module="%1$s"][/et_pb_section]', $args['library_id'] ) );

			$internal_style = ET_Builder_Element::get_style();
			ET_Builder_Element::clean_internal_modules_styles( false );

			if ( $internal_style ) {
				$modules_style = sprintf(
					'<style type="text/css" class="wdc_divi_library_styles-%2$s">
						%1$s
					</style>',
					et_core_esc_previously( $internal_style ),
					$args['library_id']
				);
			}

			echo et_core_intentionally_unescaped( $modules_style, 'html' ); // phpcs:ignore
		} else {
			echo '<p>No Content available</p>';
		}

		$render_shortcode = ob_get_clean();

		return $render_shortcode;
	}

	public function render( $attrs, $content, $render_slug ) {

		$library_id = $this->props['library_id'];
		$shortcode  = do_shortcode( '[et_pb_section global_module="' . $library_id . '"][/et_pb_section]' );

		$this->remove_classname( 'et_pb_module' );
		$this->add_classname( 'wdc_et_pb_module' );

		return sprintf(
			'<div class="wdc-library-slide wdc-child-content-%2$s">
				%1$s
			</div>',
			$shortcode,
			$library_id
		);
	}

}

new WDC_DiviLibraryChild();
