<?php
class WDC_DiviLibrary extends WDC_Builder_Module {

	protected $module_credits = array(
		'module_uri' => 'https://wowcarousel.com/modules/divi-library/',
		'author'     => 'Wow Carousel',
		'author_uri' => 'https://divipeople.com/wow-divi-carousel/',
	);

	public function init() {

		$this->vb_support = 'on';
		$this->slug       = 'wdc_divi_library';
		$this->child_slug = 'wdc_divi_library_child';
		$this->name       = esc_html__( 'Wow Smart Slider', 'wdc-wow-divi-carousel' );
		$this->icon_path  = plugin_dir_path( __FILE__ ) . 'wdc-divi-library.svg';

		$this->settings_modal_toggles = array(
			'general'  => array(
				'toggles' => array(
					'settings' => array(
						'title'             => esc_html__( 'Carousel Settings', 'wdc-wow-divi-carousel' ),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'general'  => array(
								'name' => esc_html__( 'General', 'wdc-wow-divi-carousel' ),
							),
							'advanced' => array(
								'name' => esc_html__( 'Advanced', 'wdc-wow-divi-carousel' ),
							),
						),
					),
				),
			),

			'advanced' => array(
				'toggles' => array(
					'arrow'      => array(
						'title'             => esc_html__( 'Navigation', 'wdc-wow-divi-carousel' ),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'arrow_common' => array(
								'name' => esc_html__( 'Common', 'wdc-wow-divi-carousel' ),
							),
							'arrow_left'   => array(
								'name' => esc_html__( 'Prev', 'wdc-wow-divi-carousel' ),
							),
							'arrow_right'  => array(
								'name' => esc_html__( 'Next', 'wdc-wow-divi-carousel' ),
							),
						),
					),

					'pagination' => array(
						'title'             => esc_html__( 'Pagination', 'wdc-wow-divi-carousel' ),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'pagi_common' => array(
								'name' => esc_html__( 'Common', 'wdc-wow-divi-carousel' ),
							),
							'pagi_active' => array(
								'name' => esc_html__( 'Active', 'wdc-wow-divi-carousel' ),
							),
						),
					),
				),
			),
		);
	}

	public function get_fields() {

		return WDC_Builder_Module::get_carousel_option_fields( 'carousel', array() );
	}

	public function get_advanced_fields_config() {

		$advanced_fields = array();

		$advanced_fields['text']         = false;
		$advanced_fields['borders']      = false;
		$advanced_fields['text_shadow']  = false;
		$advanced_fields['link_options'] = false;
		$advanced_fields['fonts']        = false;

		$advanced_fields['fonts']['title'] = array(
			'label'           => esc_html__( 'Title', 'wdc-wow-divi-carousel' ),
			'css'             => array(
				'main'      => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item h2',
				'important' => 'all',
			),
			'tab_slug'        => 'advanced',
			'toggle_slug'     => 'tab_elements',
			'hide_text_align' => true,
			'sub_toggle'      => 'title',
		);

		$advanced_fields['fonts']['subtitle'] = array(
			'label'           => esc_html__( 'Title', 'wdc-wow-divi-carousel' ),
			'css'             => array(
				'main'      => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item p',
				'important' => 'all',
			),
			'tab_slug'        => 'advanced',
			'hide_text_align' => true,
			'toggle_slug'     => 'tab_elements',
			'sub_toggle'      => 'subtitle',
		);

		return $advanced_fields;
	}

	public function render( $attrs, $content, $render_slug ) {

		$sliding_dir      = $this->props['sliding_dir'];
		$content          = $this->props['content'];
		$is_center        = $this->props['is_center'];
		$center_mode_type = $this->props['center_mode_type'];
		$center_mode_type = $this->props['center_mode_type'];
		$custom_cursor    = $this->props['custom_cursor'];
		$order_class      = self::get_module_order_class( $render_slug );
		$order_number     = str_replace( '_', '', str_replace( $this->slug, '', $order_class ) );

		$this->apply_css( $render_slug );
		$classes = array();

		if ( 'on' === $is_center ) {
			array_push( $classes, 'wdc-centered' );
			array_push( $classes, "wdc-centered--{$center_mode_type}" );
		}

		if ( 'on' === $custom_cursor ) {
			array_push( $classes, 'wdc-cursor' );
		}

		$output = sprintf(
			'<div class="wdc-carousel-parent" %2$s dir="%5$s">
			    <div class="wdc-carousel wdc-smart-carousel-%3$s wdc-divi-library wdc-carousel-frontend %4$s">
                    %1$s
                </div>
			</div>',
			$content,
			$this->get_carousel_options_data( $order_number, 'smart' ),
			$order_number,
			join( ' ', $classes ),
			$sliding_dir
		);

		return $output;
	}

	public function apply_css( $render_slug ) {
		$this->apply_carousel_css( $render_slug );
	}

}

new WDC_DiviLibrary();
