<?php
class WDC_ContentCarouselChild extends WDC_Builder_Module {

	public function init() {

		$this->name                     = esc_html__( 'Content Slide', 'wdc-wow-divi-carousel' );
		$this->plural                   = esc_html__( 'Content Slides', 'wdc-wow-divi-carousel' );
		$this->slug                     = 'wdc_content_carousel_child';
		$this->vb_support               = 'on';
		$this->type                     = 'child';
		$this->child_title_var          = 'admin_title';
		$this->child_title_fallback_var = 'title';
		$this->main_css_element         = '%%order_class%%.wdc_content_carousel_child';

		$this->settings_modal_toggles = array(

			'general'  => array(
				'toggles' => array(
					'content'     => esc_html__( 'Content', 'wdc-wow-divi-carousel' ),
					'tab_content' => esc_html__( 'Tab Content', 'wdc-wow-divi-carousel' ),
				),
			),

			'advanced' => array(
				'toggles' => array(
					'common'       => esc_html__( 'General', 'wdc-wow-divi-carousel' ),
					'main_element' => esc_html__( 'Main Element', 'wdc-wow-divi-carousel' ),
					'overlay'      => esc_html__( 'Overlay', 'wdc-wow-divi-carousel' ),
					'texts'        => array(
						'title'             => esc_html__( 'Title & Subtitle', 'wdc-wow-divi-carousel' ),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'title'    => array(
								'name' => esc_html__( 'Title', 'wdc-wow-divi-carousel' ),
							),
							'subtitle' => array(
								'name' => esc_html__( 'Subtitle', 'wdc-wow-divi-carousel' ),
							),
						),
					),
					'body'         => esc_html__( 'Body Text', 'wdc-wow-divi-carousel' ),
					'header'       => array(
						'title'             => esc_html__( 'Heading Text', 'wdc-wow-divi-carousel' ),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'h1' => array(
								'name' => 'H1',
								'icon' => 'text-h1',
							),
							'h2' => array(
								'name' => 'H2',
								'icon' => 'text-h2',
							),
							'h3' => array(
								'name' => 'H3',
								'icon' => 'text-h3',
							),
							'h4' => array(
								'name' => 'H4',
								'icon' => 'text-h4',
							),
							'h5' => array(
								'name' => 'H5',
								'icon' => 'text-h5',
							),
							'h6' => array(
								'name' => 'H6',
								'icon' => 'text-h6',
							),
						),
					),
					'body'         => array(
						'title' => esc_html__( 'Body Text', 'wdc-wow-divi-carousel' ),
					),
					'button'       => esc_html__( 'Button', 'wdc-wow-divi-carousel' ),
				),
			),

		);
	}

	public function get_fields() {

		$fields = array(

			'figure_el'               => array(
				'label'       => esc_html__( 'Choose an Element', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'toggle_slug' => 'content',
				'default'     => 'image',
				'options'     => array(
					'image' => esc_html__( 'Image', 'wdc-wow-divi-carousel' ),
					'video' => esc_html__( 'Video', 'wdc-wow-divi-carousel' ),
					'icon'  => esc_html__( 'Icon', 'wdc-wow-divi-carousel' ),
				),
			),

			'photo'                   => array(
				'label'              => esc_html__( 'Upload Image', 'wdc-wow-divi-carousel' ),
				'type'               => 'upload',
				'data_type'          => 'image',
				'option_category'    => 'basic_option',
				'upload_button_text' => esc_attr__( 'Upload an image', 'wdc-wow-divi-carousel' ),
				'choose_text'        => esc_attr__( 'Choose an Image', 'wdc-wow-divi-carousel' ),
				'update_text'        => esc_attr__( 'Set As Image', 'wdc-wow-divi-carousel' ),
				'toggle_slug'        => 'content',
				'mobile_options'     => true,
				'dynamic_content'    => 'image',
				'hover'              => 'tabs',
				'show_if'            => array(
					'figure_el' => 'image',
				),
			),

			'photo_alt'               => array(
				'label'       => esc_html__( 'Image Alt Text', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'toggle_slug' => 'content',
				'show_if'     => array(
					'figure_el' => 'image',
				),
			),

			'video'                   => array(
				'label'              => esc_html__( 'Video MP4 File Or Youtube URL', 'wdc-wow-divi-carousel' ),
				'type'               => 'upload',
				'option_category'    => 'basic_option',
				'data_type'          => 'video',
				'upload_button_text' => esc_attr__( 'Upload a video', 'wdc-wow-divi-carousel' ),
				'choose_text'        => esc_attr__( 'Choose a Video MP4 File', 'wdc-wow-divi-carousel' ),
				'update_text'        => esc_attr__( 'Set As Video', 'wdc-wow-divi-carousel' ),
				'description'        => esc_html__( 'Upload your desired video in .MP4 format, or type in the URL to the video you would like to display', 'wdc-wow-divi-carousel' ),
				'toggle_slug'        => 'content',
				'show_if'            => array(
					'figure_el' => 'video',
				),
			),

			'icon'                    => array(
				'label'       => esc_html__( 'Select Icon', 'wdc-wow-divi-carousel' ),
				'type'        => 'select_icon',
				'toggle_slug' => 'content',
				'tab_slug'    => 'general',
				'show_if'     => array(
					'figure_el' => 'icon',
				),
			),

			'title'                   => array(
				'label'           => esc_html__( 'Title Text', 'wdc-wow-divi-carousel' ),
				'type'            => 'text',
				'toggle_slug'     => 'content',
				'dynamic_content' => 'text',
			),

			'subtitle'                => array(
				'label'           => esc_html__( 'Subtitle Text', 'wdc-wow-divi-carousel' ),
				'type'            => 'text',
				'toggle_slug'     => 'content',
				'dynamic_content' => 'text',
			),

			'body_content'            => array(
				'label'           => esc_html__( 'Tiny MCE', 'wdc-wow-divi-carousel' ),
				'type'            => 'tiny_mce',
				'option_category' => 'basic_option',
				'toggle_slug'     => 'content',
				'dynamic_content' => 'text',
			),

			'use_button'              => array(
				'label'       => esc_html__( 'Use Button', 'wdc-wow-divi-carousel' ),
				'type'        => 'yes_no_button',
				'options'     => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'     => 'off',
				'toggle_slug' => 'content',
			),

			'button_text'             => array(
				'label'           => esc_html__( 'Button Text', 'wdc-wow-divi-carousel' ),
				'type'            => 'text',
				'default'         => 'Click Here',
				'toggle_slug'     => 'content',
				'dynamic_content' => 'text',
				'show_if'         => array(
					'use_button' => 'on',
				),
			),

			'button_link'             => array(
				'label'       => esc_html__( 'Button Link', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'default'     => '',
				'toggle_slug' => 'content',
				'show_if'     => array(
					'use_button' => 'on',
				),
			),

			'is_new_wndow'            => array(
				'label'           => esc_html__( 'Open Button link in new window', 'wdc-wow-divi-carousel' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'         => 'on',
				'toggle_slug'     => 'content',
				'show_if'         => array(
					'use_button' => 'on',
				),
			),

			// video overlay.
			'use_overlay'             => array(
				'label'           => esc_html__( 'Use Overlay Image', 'wdc-wow-divi-carousel' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
					'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
				),
				'default'         => 'off',
				'toggle_slug'     => 'overlay',
				'show_if'         => array(
					'figure_el' => 'video',
				),
			),

			'vo_src'                  => array(
				'label'              => esc_html__( 'Overlay Image', 'wdc-wow-divi-carousel' ),
				'type'               => 'upload',
				'data_type'          => 'image',
				'option_category'    => 'basic_option',
				'upload_button_text' => esc_attr__( 'Upload an image', 'wdc-wow-divi-carousel' ),
				'choose_text'        => esc_attr__( 'Choose an Image', 'wdc-wow-divi-carousel' ),
				'update_text'        => esc_attr__( 'Set As Image', 'wdc-wow-divi-carousel' ),
				'toggle_slug'        => 'overlay',
				'show_if'            => array(
					'figure_el'   => 'video',
					'use_overlay' => 'on',
				),
			),

			'vo_icon_color'           => array(
				'label'       => esc_html__( 'Overlay Icon Color', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'overlay',
				'show_if'     => array(
					'figure_el'   => 'video',
					'use_overlay' => 'on',
				),
			),

			'vo_icon_size'            => array(
				'label'           => esc_html__( 'Overlay Icon Size', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'default_unit'    => 'px',
				'default '        => '6rem',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 200,
				),
				'toggle_slug'     => 'overlay',
				'tab_slug'        => 'advanced',
				'show_if'         => array(
					'figure_el'   => 'video',
					'use_overlay' => 'on',
				),
			),

			'vo_bg'                   => array(
				'label'       => esc_html__( 'Overlay background', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'overlay',
				'show_if'     => array(
					'figure_el'   => 'video',
					'use_overlay' => 'on',
				),
			),

			// common.
			'text_alignment'          => array(
				'label'            => esc_html__( 'Text Alignment', 'wdc-wow-divi-carousel' ),
				'type'             => 'text_align',
				'option_category'  => 'layout',
				'options'          => et_builder_get_text_orientation_options( array( 'justified' ) ),
				'options_icon'     => 'text_align',
				'default_on_front' => 'left',
				'toggle_slug'      => 'common',
				'tab_slug'         => 'advanced',
				'mobile_options'   => true,
			),
			'content_padding'         => array(
				'label'          => esc_html__( 'Content Padding', 'wdc-wow-divi-carousel' ),
				'type'           => 'custom_padding',
				'toggle_slug'    => 'common',
				'tab_slug'       => 'advanced',
				'default'        => '0px|0px|0px|0px',
				'mobile_options' => true,
			),

			// figure.
			'icon_alignment'          => array(
				'label'            => esc_html__( 'Icon Alignment', 'wdc-wow-divi-carousel' ),
				'type'             => 'text_align',
				'option_category'  => 'layout',
				'options'          => et_builder_get_text_orientation_options( array( 'justified' ) ),
				'options_icon'     => 'module_align',
				'default_on_front' => 'left',
				'toggle_slug'      => 'main_element',
				'tab_slug'         => 'advanced',
				'show_if'          => array(
					'figure_el' => 'icon',
				),
			),

			'icon_color'              => array(
				'label'       => esc_html__( 'Icon Color', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'main_element',
				'default'     => '#333',
				'hover'       => 'tabs',
				'show_if'     => array(
					'figure_el' => 'icon',
				),
			),

			'icon_bg'                 => array(
				'label'       => esc_html__( 'Icon Background', 'wdc-wow-divi-carousel' ),
				'type'        => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'main_element',
				'default'     => 'transparent',
				'hover'       => 'tabs',
				'show_if'     => array(
					'figure_el' => 'icon',
				),
			),

			'icon_size'               => array(
				'label'           => esc_html__( 'Icon Size', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'em', 'rem', 'px', 'cm', '%', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw' ),
				'default_unit'    => 'px',
				'default'         => '45px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 400,
				),
				'toggle_slug'     => 'main_element',
				'tab_slug'        => 'advanced',
				'mobile_options'  => true,
				'show_if'         => array(
					'figure_el' => 'icon',
				),
			),

			'image_width'             => array(
				'label'          => esc_html__( 'Image Width', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '100%',
				'default_unit'   => '%',
				'range_settings' => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'show_if'        => array(
					'figure_el' => 'image',
				),
				'toggle_slug'    => 'main_element',
				'tab_slug'       => 'advanced',
				'show_if'        => array(
					'figure_el' => 'image',
				),
			),

			'image_height'            => array(
				'label'           => esc_html__( 'Image Height', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'em', 'rem', 'px', 'cm', '%', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw' ),
				'default_unit'    => 'px',
				'default'         => 'auto',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 1000,
				),
				'toggle_slug'     => 'main_element',
				'tab_slug'        => 'advanced',
				'show_if'         => array(
					'figure_el' => 'image',
				),
			),

			'image_alignment'         => array(
				'label'            => esc_html__( 'Image Alignment', 'wdc-wow-divi-carousel' ),
				'type'             => 'text_align',
				'options'          => et_builder_get_text_orientation_options( array( 'justified' ) ),
				'options_icon'     => 'module_align',
				'default_on_front' => 'left',
				'show_if'          => array(
					'figure_el' => 'image',
				),
				'toggle_slug'      => 'main_element',
				'tab_slug'         => 'advanced',
			),

			'image_hover_animation'   => array(
				'label'       => esc_html__( 'Hover Animation', 'wdc-wow-divi-carousel' ),
				'type'        => 'select',
				'default'     => 'none',
				'options'     => array(
					'none'         => esc_html__( 'None', 'wdc-wow-divi-carousel' ),
					'zoom-in'      => esc_html__( 'Zoom In', 'wdc-wow-divi-carousel' ),
					'zoom-out'     => esc_html__( 'Zoom Out', 'wdc-wow-divi-carousel' ),
					'pulse'        => esc_html__( 'Pulse', 'wdc-wow-divi-carousel' ),
					'bounce'       => esc_html__( 'Bounce', 'wdc-wow-divi-carousel' ),
					'flash'        => esc_html__( 'Flash', 'wdc-wow-divi-carousel' ),
					'rubberBand'   => esc_html__( 'Rubber Band', 'wdc-wow-divi-carousel' ),
					'shake'        => esc_html__( 'Shake', 'wdc-wow-divi-carousel' ),
					'swing'        => esc_html__( 'Swing', 'wdc-wow-divi-carousel' ),
					'tada'         => esc_html__( 'Tada', 'wdc-wow-divi-carousel' ),
					'wobble'       => esc_html__( 'Wobble', 'wdc-wow-divi-carousel' ),
					'jello'        => esc_html__( 'Jello', 'wdc-wow-divi-carousel' ),
					'heartBeat'    => esc_html__( 'Heart Beat', 'wdc-wow-divi-carousel' ),
					'bounceIn'     => esc_html__( 'Bounce In', 'wdc-wow-divi-carousel' ),
					'fadeIn'       => esc_html__( 'Fade In', 'wdc-wow-divi-carousel' ),
					'flip'         => esc_html__( 'Flip', 'wdc-wow-divi-carousel' ),
					'lightSpeedIn' => esc_html__( 'Light Speed In', 'wdc-wow-divi-carousel' ),
					'rotateIn'     => esc_html__( 'Rotate In', 'wdc-wow-divi-carousel' ),
					'slideInUp'    => esc_html__( 'Slide In Up', 'wdc-wow-divi-carousel' ),
					'slideInDown'  => esc_html__( 'Slide In Down', 'wdc-wow-divi-carousel' ),
				),
				'show_if'     => array(
					'figure_el' => 'image',
				),
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'main_element',
			),

			'icon_padding'            => array(
				'label'          => esc_html__( 'Icon Padding', 'wdc-wow-divi-carousel' ),
				'type'           => 'custom_padding',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'main_element',
				'default'        => '0px|0px|0px|0px',
				'mobile_options' => true,
				'show_if'        => array(
					'figure_el' => 'icon',
				),
			),

			'figure_spacing_bottom'   => array(
				'label'           => esc_html__( 'Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '10px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'main_element',
				'tab_slug'        => 'advanced',
			),

			// Button.
			'btn_spacing_top'         => array(
				'label'           => esc_html__( 'Button Spacing Top', 'wdc-wow-divi-carousel' ),
				'type'            => 'range',
				'default'         => '15px',
				'option_category' => 'basic_option',
				'allowed_units'   => array( 'px' ),
				'default_unit'    => 'px',
				'range_settings'  => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'     => 'button',
				'tab_slug'        => 'advanced',
			),

			'title_bottom_spacing'    => array(
				'label'          => esc_html__( 'Title Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '10px',
				'allowed_units'  => array( 'px' ),
				'default_unit'   => 'px',
				'range_settings' => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'    => 'texts',
				'tab_slug'       => 'advanced',
				'sub_toggle'     => 'title',
			),

			'subtitle_bottom_spacing' => array(
				'label'          => esc_html__( 'Subtitle Spacing Bottom', 'wdc-wow-divi-carousel' ),
				'type'           => 'range',
				'default'        => '10px',
				'allowed_units'  => array( 'px' ),
				'default_unit'   => 'px',
				'range_settings' => array(
					'min'  => 0,
					'step' => 1,
					'max'  => 100,
				),
				'toggle_slug'    => 'texts',
				'tab_slug'       => 'advanced',
				'sub_toggle'     => 'subtitle',
			),

		);
		$tab_fields = $this->get_tab_fields();
		$overlay    = $this->get_overlay_option_fields( 'overlay', array( 'figure_el' => 'image' ) );

		$label = array(
			'admin_title' => array(
				'label'       => esc_html__( 'Admin Label', 'wdc-wow-divi-carousel' ),
				'type'        => 'text',
				'description' => esc_html__( 'This will change the label of the item', 'wdc-wow-divi-carousel' ),
				'toggle_slug' => 'admin_label',
			),
		);

		return array_merge( $label, $fields, $overlay, $tab_fields );
	}

	public function get_advanced_fields_config() {

		$advanced_fields                = array();
		$advanced_fields['text']        = false;
		$advanced_fields['text_shadow'] = false;
		$advanced_fields['fonts']       = false;

		$advanced_fields['fonts'] = array(
			'title'    => array(
				'label'           => esc_html__( 'Title', 'wdc-wow-divi-carousel' ),
				'css'             => array(
					'main'      => '%%order_class%% .wdc-content-slide .wdc-content-slide-title',
					'important' => 'all',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'texts',
				'sub_toggle'      => 'title',
				'hide_text_align' => true,
				'header_level'    => array(
					'default' => 'h2',
				),
				'line_height'     => array(
					'range_settings' => array(
						'min'  => '1',
						'max'  => '100',
						'step' => '1',
					),
				),
			),
			'subtitle' => array(
				'label'           => esc_html__( 'Description', 'wdc-wow-divi-carousel' ),
				'css'             => array(
					'main'      => '%%order_class%% .wdc-content-slide .wdc-content-slide-subtitle',
					'important' => 'all',
				),
				'hide_text_align' => true,
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'texts',
				'sub_toggle'      => 'subtitle',
				'line_height'     => array(
					'range_settings' => array(
						'min'  => '1',
						'max'  => '100',
						'step' => '1',
					),
				),
				'header_level'    => array(
					'default' => 'h4',
				),
			),
			'body'     => array(
				'label'           => esc_html__( 'Body', 'wdc-wow-divi-carousel' ),
				'css'             => array(
					'main'        => '%%order_class%% .wdc-mce-content',
					'line_height' => '%%order_class%% .wdc-mce-content p',
					'text_align'  => '%%order_class%% .wdc-mce-content',
					'text_shadow' => '%%order_class%% .wdc-mce-content',
					'important'   => 'all',
				),
				'hide_text_align' => true,
				'block_elements'  => array(
					'tabbed_subtoggles' => true,
					'bb_icons_support'  => true,
					'css'               => array(
						'main'      => '%%order_class%% .wdc-mce-content',
						'important' => 'all',
					),
				),
			),
			'header'   => array(
				'label'       => esc_html__( 'Heading', 'wdc-wow-divi-carousel' ),
				'css'         => array(
					'main'      => '%%order_class%% .wdc-mce-content h1',
					'important' => 'all',
				),
				'font_size'   => array(
					'default' => absint( et_get_option( 'body_header_size', '30' ) ) . 'px',
				),
				'toggle_slug' => 'header',
				'sub_toggle'  => 'h1',
			),
			'header_2' => array(
				'label'       => esc_html__( 'Heading 2', 'wdc-wow-divi-carousel' ),
				'css'         => array(
					'main'      => '%%order_class%% .wdc-mce-content h2',
					'important' => 'all',
				),
				'font_size'   => array(
					'default' => '26px',
				),
				'line_height' => array(
					'default' => '1em',
				),
				'toggle_slug' => 'header',
				'sub_toggle'  => 'h2',
			),
			'header_3' => array(
				'label'       => esc_html__( 'Heading 3', 'wdc-wow-divi-carousel' ),
				'css'         => array(
					'main'      => '%%order_class%% .wdc-mce-content h3',
					'important' => 'all',
				),
				'font_size'   => array(
					'default' => '22px',
				),
				'line_height' => array(
					'default' => '1em',
				),
				'toggle_slug' => 'header',
				'sub_toggle'  => 'h3',
			),
			'header_4' => array(
				'label'       => esc_html__( 'Heading 4', 'wdc-wow-divi-carousel' ),
				'css'         => array(
					'main'      => '%%order_class%% .wdc-mce-content h4',
					'important' => 'all',
				),
				'font_size'   => array(
					'default' => '18px',
				),
				'line_height' => array(
					'default' => '1em',
				),
				'toggle_slug' => 'header',
				'sub_toggle'  => 'h4',
			),
			'header_5' => array(
				'label'       => esc_html__( 'Heading 5', 'wdc-wow-divi-carousel' ),
				'css'         => array(
					'main'      => '%%order_class%% .wdc-mce-content h5',
					'important' => 'all',
				),
				'font_size'   => array(
					'default' => '16px',
				),
				'line_height' => array(
					'default' => '1em',
				),
				'toggle_slug' => 'header',
				'sub_toggle'  => 'h5',
			),
			'header_6' => array(
				'label'       => esc_html__( 'Heading 6', 'wdc-wow-divi-carousel' ),
				'css'         => array(
					'main'      => '%%order_class%% .wdc-mce-content h6',
					'important' => 'all',
				),
				'font_size'   => array(
					'default' => '14px',
				),
				'line_height' => array(
					'default' => '1em',
				),
				'toggle_slug' => 'header',
				'sub_toggle'  => 'h6',
			),
		);

		$advanced_fields['borders']['item'] = array(
			'label_prefix' => esc_html__( 'Item', 'wdc-wow-divi-carousel' ),
			'css'          => array(
				'main'      => array(
					'border_radii'  => '%%order_class%%',
					'border_styles' => '%%order_class%%',
				),
				'important' => 'all',
			),
			'defaults'     => array(
				'border_radii'  => 'on|0px|0px|0px|0px',
				'border_styles' => array(
					'width' => '0px',
					'color' => '#333',
					'style' => 'solid',
				),
			),
			'toggle_slug'  => 'common',
		);

		$advanced_fields['borders']['figure'] = array(
			'toggle_slug' => 'main_element',
			'tab_slug'    => 'advanced',
			'css'         => array(
				'main'      => array(
					'border_radii'  => '%%order_class%% .figure, %%order_class%% .wdc-content-slide-icon, %%order_class%% .wdc-content-video',
					'border_styles' => '%%order_class%% .figure, %%order_class%% .wdc-content-slide-icon, %%order_class%% .wdc-content-video',
				),
				'important' => 'all',
			),
			'defaults'    => array(
				'border_radii'  => 'on|0px|0px|0px|0px',
				'border_styles' => array(
					'width' => '0px',
					'color' => '#e5e5e5',
					'style' => 'solid',
				),
			),
		);

		$advanced_fields['margin_padding'] = array(
			'css' => array(
				'main'      => '%%order_class%%',
				'important' => 'all',
			),
		);

		$advanced_fields['button']['button'] = array(
			'label'         => esc_html__( 'Button', 'wdc-wow-divi-carousel' ),
			'css'           => array(
				'main'      => '%%order_class%% .wdc-btn-content',
				'alignment' => '%%order_class%% .wdc-content-slide-btn',
				'important' => 'all',
			),
			'use_alignment' => true,
		);

		return $advanced_fields;
	}

	public function render_figure() {

		if ( 'image' === $this->props['figure_el'] ) {

			$processed_overlay_icon = esc_attr( et_pb_process_font_icon( $this->props['overlay_icon'] ) );
			$overlay_icon           = ! empty( $processed_overlay_icon ) ? $processed_overlay_icon : '';
			$photo                  = $this->props['photo'];
			$photo_alt              = $this->props['photo_alt'];
			$data_schema            = $this->get_swapped_img_schema( 'photo' );
			$image_alignment        = isset( $this->props['image_alignment'] ) && 'undefined' !== $this->props['image_alignment'] ? $this->props['image_alignment'] : 'left';
			$parent_module          = self::get_parent_modules( 'page' )['wdc_content_carousel'];
			$is_lazyload            = $parent_module->shortcode_atts['is_lazyload'];
			wdc_inject_fa_icons( $this->props['overlay_icon'] );
			return sprintf(
				'<div class="figure border-el wdc-image-alignment-%2$s wdc-lightbox-ctrl">
                    <div class="wdc-overlay"><span class="wdc-overlay-icon">%4$s</span></div>
					<img class="wdc-content-slide-figure-img wdc-swapped-img" data-mfp-src="%1$s" %5$s="%1$s" %3$s alt="%6$s"/>
				</div>',
				$photo,
				$image_alignment,
				$data_schema,
				$overlay_icon,
				'on' === $is_lazyload ? 'data-lazy' : 'src',
				$photo_alt
			);
		} elseif ( 'icon' === $this->props['figure_el'] ) {

			$icon_name = esc_attr( et_pb_process_font_icon( $this->props['icon'] ) );
			wdc_inject_fa_icons( $this->props['icon'] );
			return sprintf(
				'<span class="wdc-content-slide-icon border-el">
					<i class="wdc-et-icon">%1$s</i>
				</span>',
				$icon_name
			);

		} else {

			$video_src    = '';
			$overlay_html = '';
			$overlay_src  = $this->props['vo_src'];

			if ( false !== et_pb_check_oembed_provider( esc_url( $this->props['video'] ) ) ) {

					$video_src = wp_oembed_get( esc_url( $this->props['video'] ) );
			} else {

				$video     = $this->props['video'];
				$video_src = sprintf( '<video controls><source type="video/mp4" src="%1$s"></video>', $video );
			}

			if ( ! empty( $overlay_src ) ) {
				$overlay_html = sprintf(
					'
					<div style="background-image:url(%1$s)" class="et_pb_video_overlay">
						<div class="et_pb_video_overlay_hover">
							<a href="#" class="et_pb_video_play"></a>
						</div>
					</div>',
					$overlay_src
				);
			}

			return sprintf(
				'<div class="wdc-content-video et_pb_video">
					<div class="et_pb_video_box wdc-content-video-wrap">
						%1$s
					</div>
					%2$s
				</div>',
				$video_src,
				$overlay_html
			);

		}
	}

	public function render_title() {

		$title_text            = $this->props['title'];
		$title_level           = $this->props['title_level'];
		$processed_title_level = et_pb_process_header_level( $title_level, 'h2' );
		$processed_title_level = esc_html( $processed_title_level );

		if ( ! empty( $title_text ) ) {
			return sprintf( '<%2$s class="wdc-content-slide-title">%1$s</%2$s>', $title_text, $processed_title_level );
		}
	}

	public function render_subtitle() {

		$subtitle_text            = $this->props['subtitle'];
		$subtitle_level           = $this->props['subtitle_level'];
		$processed_subtitle_level = et_pb_process_header_level( $subtitle_level, 'h4' );
		$processed_subtitle_level = esc_html( $processed_subtitle_level );

		if ( ! empty( $subtitle_text ) ) {
			return sprintf( '<%2$s class="wdc-content-slide-subtitle">%1$s</%2$s>', $subtitle_text, $processed_subtitle_level );
		}
	}


	public function render_custom_button() {

		if ( 'on' === $this->props['use_button'] ) {

			$button_custom = $this->props['custom_button'];
			$button_text   = isset( $this->props['button_text'] ) ? $this->props['button_text'] : 'Click Here';
			$button_link   = isset( $this->props['button_link'] ) ? $this->props['button_link'] : '#';
			$button_url    = trim( $button_link );
			$button_rel    = isset( $this->props['button_rel'] ) ? $this->props['button_rel'] : '';
			$new_tab       = $this->props['is_new_wndow'];

			$custom_icon_values = et_pb_responsive_options()->get_property_values( $this->props, 'button_icon' );
			$custom_icon        = isset( $custom_icon_values['desktop'] ) ? $custom_icon_values['desktop'] : '';
			$custom_icon_tablet = isset( $custom_icon_values['tablet'] ) ? $custom_icon_values['tablet'] : '';
			$custom_icon_phone  = isset( $custom_icon_values['phone'] ) ? $custom_icon_values['phone'] : '';
			$multi_view         = et_pb_multi_view_options( $this );

			wdc_inject_fa_icons( $this->props['button_icon'] );

			$button = $this->render_button(
				array(
					'button_classname'    => array( 'wdc-btn-default', 'wdc-btn-content' ),
					'button_custom'       => $button_custom,
					'button_text'         => $button_text,
					'button_rel'          => $button_rel,
					'button_text_escaped' => true,
					'button_url'          => $button_url,
					'custom_icon'         => $custom_icon,
					'custom_icon_tablet'  => $custom_icon_tablet,
					'custom_icon_phone'   => $custom_icon_phone,
					'url_new_window'      => $new_tab,
					'has_wrapper'         => false,
					'multi_view_data'     => $multi_view->render_attrs(
						array(
							'content'        => '{{button_text}}',
							'hover_selector' => '%%order_class%% .dtq-btn-card',
							'visibility'     => array(
								'button_text' => '__not_empty',
							),
						)
					),
				)
			);

			return sprintf(
				'<div class="wdc-content-slide-btn">
                    %1$s
                </div>',
				$button
			);
		}
	}

	public function render_MCE() {

		$body_content = $this->props['body_content'];
		$content      = force_balance_tags( $body_content );
		$content      = preg_replace( '~\s?<p></p>\s?~', '', $content );

		if ( ! empty( $content ) ) {
			return sprintf( '<div class="wdc-mce-content">%1$s</div>', $content );
		}
	}

	public function render_main_element() {
		$photo = $this->props['photo'];
		$icon  = $this->props['icon'];
		$video = $this->props['video'];

		if ( ! empty( $photo ) || ! empty( $icon ) || ! empty( $video ) ) {
			return sprintf( '<div class="wdc-content-slide-figure"> %1$s</div>', $this->render_figure() );
		}
	}

	public function render( $attrs, $content, $render_slug ) {

		global $wdc_content_child;
		global $wdc_uid_content;

		if ( empty( $wdc_uid_content ) && 0 !== $wdc_uid_content ) {
			$wdc_uid_content = 0;
		}

		$wdc_content_child[ $wdc_uid_content ][] = array(
			'tab_title'    => ! empty( $this->props['tab_title'] ) ? $this->props['tab_title'] : $this->props['title'],
			'tab_subtitle' => ! empty( $this->props['tab_subtitle'] ) ? $this->props['tab_subtitle'] : $this->props['subtitle'],
			'tab_thumb'    => ! empty( $this->props['tab_thumb'] ) ? $this->props['tab_thumb'] : $this->props['photo'],
		);

		$this->apply_css( $render_slug );

		// Module classnames.
		$this->remove_classname( 'et_pb_module' );
		$this->add_classname( 'wdc_et_pb_module' );

		return sprintf(
			'<div class="wdc-carousel-item wdc-content-slide use-icon-%1$s wdc-icon--%8$s wdc-swapped-img-selector wdc-hover--%2$s">
			    %3$s
                <div class="wdc-content-slide-content">
                    %4$s %5$s %6$s %7$s
                </div>
		    </div>',
			$this->props['image_hover_animation'],
			$this->props['image_hover_animation'],
			$this->render_main_element(),
			$this->render_title(),
			$this->render_subtitle(),
			$this->render_MCE(),
			$this->render_custom_button(),
			$this->props['icon_alignment']
		);

	}

	public function apply_css( $render_slug ) {

		$icon_padding                      = $this->props['icon_padding'];
		$icon_padding_tablet               = $this->props['icon_padding_tablet'];
		$icon_padding_phone                = $this->props['icon_padding_phone'];
		$icon_padding_last_edited          = $this->props['icon_padding_last_edited'];
		$icon_padding_responsive_status    = et_pb_get_responsive_status( $icon_padding_last_edited );
		$figure_spacing_bottom             = $this->props['figure_spacing_bottom'];
		$image_width                       = $this->props['image_width'];
		$image_height                      = $this->props['image_height'];
		$content_padding                   = $this->props['content_padding'];
		$content_padding_tablet            = $this->props['content_padding_tablet'];
		$content_padding_phone             = $this->props['content_padding_phone'];
		$content_padding_last_edited       = $this->props['content_padding_last_edited'];
		$content_padding_responsive_status = et_pb_get_responsive_status( $content_padding_last_edited );
		$icon_bg_hover                     = $this->get_hover_value( 'icon_bg' );
		$icon_color_hover                  = $this->get_hover_value( 'icon_color' );
		$btn_spacing_top                   = $this->props['btn_spacing_top'];
		$title_bottom_spacing              = $this->props['title_bottom_spacing'];
		$subtitle_bottom_spacing           = $this->props['subtitle_bottom_spacing'];
		$button_custom_padding             = $this->props['button_custom_padding'];
		$vo_icon_color                     = $this->props['vo_icon_color'];
		$vo_icon_size                      = $this->props['vo_icon_size'];
		$vo_bg                             = $this->props['vo_bg'];

		if ( class_exists( 'ET_Builder_Module_Helper_Style_Processor' ) ) {
			$this->generate_styles(
				array(
					'utility_arg'    => 'icon_font_family',
					'render_slug'    => $render_slug,
					'base_attr_name' => 'icon',
					'important'      => true,
					'selector'       => '%%order_class%% .wdc-content-slide-icon .wdc-et-icon',
					'processor'      => array(
						'ET_Builder_Module_Helper_Style_Processor',
						'process_extended_icon',
					),
				)
			);
			$this->generate_styles(
				array(
					'utility_arg'    => 'icon_font_family',
					'render_slug'    => $render_slug,
					'base_attr_name' => 'overlay_icon',
					'important'      => true,
					'selector'       => '%%order_class%% .wdc-overlay .wdc-overlay-icon',
					'processor'      => array(
						'ET_Builder_Module_Helper_Style_Processor',
						'process_extended_icon',
					),
				)
			);
		}

		// Figure Image.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-content-slide .figure',
				'declaration' => sprintf( 'width: %1$s !important;', $image_width ),
			)
		);

		if ( 'auto' !== $image_height ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-content-slide .figure',
					'declaration' => sprintf( 'height: %1$s !important;', $image_height ),
				)
			);

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-content-slide .figure img',
					'declaration' => 'height: 100%; object-fit: cover;width:100%;',
				)
			);
		}

		// Button.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-content-slide-btn',
				'declaration' => sprintf( 'padding-top: %1$s;', $btn_spacing_top ),
			)
		);

		if ( ! empty( $button_custom_padding ) ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => 'body #page-container %%order_class%% .wdc-btn-content, .et-db #et-boc %%order_class%% .wdc-btn-content',
					'declaration' => $this->wdc_process_padding( $button_custom_padding, true ),
				)
			);
		}

		// Texts.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-content-slide-title',
				'declaration' => sprintf( 'padding-bottom: %1$s!important;', $title_bottom_spacing ),
			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-content-slide-subtitle, .et-db #et-boc %%order_class%% .wdc-content-slide-subtitle',
				'declaration' => sprintf( 'padding-bottom: %1$s!important;', $subtitle_bottom_spacing ),
			)
		);

		$this->get_responsive_styles(
			'text_alignment',
			'%%order_class%% *',
			array( 'primary' => 'text-align' ),
			array( 'default' => 'left' ),
			$render_slug
		);

		// Figure Spacing.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-content-slide-figure',
				'declaration' => sprintf( 'margin-bottom: %1$s;', $figure_spacing_bottom ),
			)
		);

		// Content Padding.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-content-slide-content',
				'declaration' => $this->wdc_process_padding( $content_padding, false ),
			)
		);

		// Content Padding Tablet.
		if ( $content_padding_tablet && $content_padding_responsive_status ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-content-slide-content',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					'declaration' => $this->wdc_process_padding( $content_padding_tablet, false ),
				)
			);
		}

		// Content Padding Phone.
		if ( $content_padding_phone && $content_padding_responsive_status ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-content-slide-content',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					'declaration' => $this->wdc_process_padding( $content_padding_phone, false ),
				)
			);
		}

		// Icon.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-content-slide-icon',
				'declaration' => sprintf( 'background: %1$s;', $this->props['icon_bg'] ),
			)
		);

		if ( ! empty( $icon_bg_hover ) ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-content-slide-icon:hover',
					'declaration' => sprintf( 'background: %1$s', $icon_bg_hover ),
				)
			);
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-content-slide-icon i',
				'declaration' => sprintf( 'color: %1$s; font-size: %2$s;', $this->props['icon_color'], $this->props['icon_size'] ),
			)
		);

		if ( ! empty( $icon_color_hover ) ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-content-slide-icon:hover i',
					'declaration' => sprintf( 'color: %1$s;', $icon_color_hover ),
				)
			);
		}

		// Icon Padding.
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .wdc-content-slide-icon',
				'declaration' => $this->wdc_process_padding( $icon_padding, false ),
			)
		);

		// Icon Padding tablet.
		if ( $icon_padding_tablet && $icon_padding_responsive_status ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-content-slide-icon',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					'declaration' => $this->wdc_process_padding( $icon_padding_tablet, false ),
				)
			);
		}

		// Icon Padding phone.
		if ( $icon_padding_phone && $icon_padding_responsive_status ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .wdc-content-slide-icon',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					'declaration' => $this->wdc_process_padding( $icon_padding_phone, false ),
				)
			);
		}

		// Overlay Styles.
		$this->get_overlay_style( $render_slug );

		// video overlay.
		if ( ! empty( $vo_icon_color ) ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .et_pb_video_overlay .et_pb_video_play',
					'declaration' => sprintf( 'color: %1$s;', $vo_icon_color ),
				)
			);
		}
		if ( ! empty( $vo_icon_size ) ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .et_pb_video_overlay .et_pb_video_play',
					'declaration' => sprintf( 'font-size: %1$s;', $vo_icon_size ),
				)
			);
		}

		if ( ! empty( $vo_bg ) ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .et_pb_video_overlay_hover:hover',
					'declaration' => sprintf( 'background: %1$s;', $vo_bg ),
				)
			);
		}
	}
}

new WDC_ContentCarouselChild();
