<?php
class WDC_CardCarouselChild extends WDC_Builder_Module {

    public function init() {

        $this->name                     = esc_html__( 'Card', 'wdc-wow-divi-carousel' );
        $this->plural                   = esc_html__( 'Cards', 'wdc-wow-divi-carousel' );
        $this->slug                     = 'wdc_card_carousel_child';
        $this->vb_support               = 'on';
        $this->type                     = 'child';
        $this->child_title_var          = 'admin_title';
        $this->child_title_fallback_var = 'title';
        $this->main_css_element         = '%%order_class%%.wdc_card_carousel_child';

        $this->settings_modal_toggles = [
            'general'  => [
                'toggles' => [
                    'content'           => esc_html__( 'Content', 'wdc-wow-divi-carousel' ),
                    'title_description' => esc_html__( 'Title & Description', 'wdc-wow-divi-carousel' ),
                    'button'            => esc_html__( 'Button', 'wdc-wow-divi-carousel' ),
                    'tab_content'       => esc_html__( 'Tab Content', 'wdc-wow-divi-carousel' ),
                ],
            ],

            'advanced' => [
                'toggles' => [
                    'card'       => esc_html__( 'General', 'wdc-wow-divi-carousel' ),
                    'image_icon' => esc_html__( 'Image/Icon', 'wdc-wow-divi-carousel' ),
                    'overlay'    => esc_html__( 'Overlay', 'wdc-wow-divi-carousel' ),
                    'badge'      => esc_html__( 'Badge', 'wdc-wow-divi-carousel' ),
                    'texts'      => [
                        'title'             => esc_html__( 'Texts', 'wdc-wow-divi-carousel' ),
                        'tabbed_subtoggles' => true,
                        'sub_toggles'       => [
                            'badge'           => [
                                'name' => esc_html__( 'Badge', 'wdc-wow-divi-carousel' ),
                            ],
                            'title_tab'       => [
                                'name' => esc_html__( 'Title', 'wdc-wow-divi-carousel' ),
                            ],
                            'description_tab' => [
                                'name' => esc_html__( 'Description', 'wdc-wow-divi-carousel' ),
                            ],
                        ],
                    ],
                    'button'     => esc_html__( 'Button', 'wdc-wow-divi-carousel' ),
                ],
            ],

        ];
    }

    public function get_fields() {

        $content = [
            'use_icon'      => [
                'label'           => esc_html__( 'Use Icon', 'wdc-wow-divi-carousel' ),
                'type'            => 'yes_no_button',
                'option_category' => 'configuration',
                'default'         => 'off',
                'toggle_slug'     => 'content',
                'options'         => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
            ],

            'icon'          => [
                'label'           => esc_html__( 'Left Icon', 'wdc-wow-divi-carousel' ),
                'type'            => 'select_icon',
                'option_category' => 'basic_option',
                'toggle_slug'     => 'content',
                'tab_slug'        => 'general',
                'show_if'         => [
                    'use_icon' => 'on',
                ],
            ],

            'photo'         => [
                'label'              => esc_html__( 'Upload Card Image', 'wdc-wow-divi-carousel' ),
                'type'               => 'upload',
                'option_category'    => 'basic_option',
                'upload_button_text' => esc_attr__( 'Upload an image', 'wdc-wow-divi-carousel' ),
                'choose_text'        => esc_attr__( 'Choose an Image', 'wdc-wow-divi-carousel' ),
                'update_text'        => esc_attr__( 'Set As Image', 'wdc-wow-divi-carousel' ),
                'toggle_slug'        => 'content',
                'mobile_options'     => true,
                'hover'              => 'tabs',
                'dynamic_content'    => 'image',
                'show_if'            => [
                    'use_icon' => 'off',
                ],
            ],

            'photo_alt'     => [
                'label'       => esc_html__( 'Image Alt Text', 'wdc-wow-divi-carousel' ),
                'type'        => 'text',
                'toggle_slug' => 'content',
                'show_if'     => [
                    'use_icon' => 'off',
                ],
            ],

            'is_hide_badge' => [
                'label'           => esc_html__( 'Hide Badge', 'wdc-wow-divi-carousel' ),
                'type'            => 'yes_no_button',
                'option_category' => 'configuration',
                'default'         => 'on',
                'toggle_slug'     => 'content',
                'options'         => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
            ],

            'badge_text'    => [
                'label'           => esc_html__( 'Badge Text', 'wdc-wow-divi-carousel' ),
                'type'            => 'text',
                'toggle_slug'     => 'content',
                'dynamic_content' => 'text',
                'show_if'         => [
                    'is_hide_badge' => 'off',
                ],
            ],

            // Title & description.
            'title'         => [
                'label'           => esc_html__( 'Title Text', 'wdc-wow-divi-carousel' ),
                'type'            => 'text',
                'toggle_slug'     => 'content',
                'dynamic_content' => 'text',
            ],

            'description'   => [
                'label'           => esc_html__( 'Description', 'wdc-wow-divi-carousel' ),
                'type'            => 'textarea',
                'toggle_slug'     => 'content',
                'dynamic_content' => 'text',
            ],

            // Button.
            'use_button'    => [
                'label'           => esc_html__( 'Use Button', 'wdc-wow-divi-carousel' ),
                'type'            => 'yes_no_button',
                'option_category' => 'configuration',
                'options'         => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
                'default'         => 'off',
                'toggle_slug'     => 'content',

            ],

            'button_text'   => [
                'label'           => esc_html__( 'Button Text', 'wdc-wow-divi-carousel' ),
                'type'            => 'text',
                'default'         => 'Click Here',
                'toggle_slug'     => 'content',
                'dynamic_content' => 'text',
                'show_if'         => [
                    'use_button' => 'on',
                ],
            ],

            'button_link'   => [
                'label'           => esc_html__( 'Button Link', 'wdc-wow-divi-carousel' ),
                'type'            => 'text',
                'toggle_slug'     => 'content',
                'dynamic_content' => 'url',
                'show_if'         => [
                    'use_button' => 'on',
                ],
            ],

            'is_new_wndow'  => [
                'label'           => esc_html__( 'Open Button link in new window', 'wdc-wow-divi-carousel' ),
                'type'            => 'yes_no_button',
                'option_category' => 'configuration',
                'options'         => [
                    'on'  => esc_html__( 'Yes', 'wdc-wow-divi-carousel' ),
                    'off' => esc_html__( 'No', 'wdc-wow-divi-carousel' ),
                ],
                'default'         => 'on',
                'toggle_slug'     => 'content',
                'show_if'         => [
                    'use_button' => 'on',
                ],
            ],
        ];

        $fields = [
            // Badge style.
            'badge_position'        => [
                'label'       => esc_html__( 'Badge Position', 'wdc-wow-divi-carousel' ),
                'type'        => 'select',
                'tab_slug'    => 'advanced',
                'toggle_slug' => 'badge',
                'default'     => 'right_bottom',
                'options'     => [
                    'left_top'     => esc_html__( 'Left Top', 'wdc-wow-divi-carousel' ),
                    'left_bottom'  => esc_html__( 'Left Bottom', 'wdc-wow-divi-carousel' ),
                    'right_top'    => esc_html__( 'Right Top', 'wdc-wow-divi-carousel' ),
                    'right_bottom' => esc_html__( 'Right Bottom', 'wdc-wow-divi-carousel' ),
                ],
            ],

            'badge_padding'         => [
                'label'       => esc_html__( 'Badge Padding', 'wdc-wow-divi-carousel' ),
                'type'        => 'custom_padding',
                'tab_slug'    => 'advanced',
                'toggle_slug' => 'badge',
                'default'     => '5px|15px|5px|15px',
            ],

            'badge_offset_x'        => [
                'label'           => esc_html__( 'Badge Offset X', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '15px',
                'range_settings'  => [
                    'min'  => -600,
                    'max'  => 600,
                    'step' => 1,
                ],
                'toggle_slug'     => 'badge',
                'tab_slug'        => 'advanced',
                'mobile_options'  => true,
            ],

            'badge_offset_y'        => [
                'label'           => esc_html__( 'Badge Offset Y', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'default'         => '15px',
                'range_settings'  => [
                    'min'  => -600,
                    'max'  => 600,
                    'step' => 1,
                ],
                'toggle_slug'     => 'badge',
                'tab_slug'        => 'advanced',
                'mobile_options'  => true,
            ],

            'badge_color'           => [
                'label'       => esc_html__( 'Badge Text Color', 'wdc-wow-divi-carousel' ),
                'type'        => 'color-alpha',
                'tab_slug'    => 'advanced',
                'toggle_slug' => 'badge',
                'default'     => '#ffffff',
            ],

            'badge_bg'              => [
                'label'       => esc_html__( 'Badge Background', 'wdc-wow-divi-carousel' ),
                'type'        => 'color-alpha',
                'tab_slug'    => 'advanced',
                'toggle_slug' => 'badge',
                'default'     => '#2ea3f2',
            ],

            // Image design.
            'image_position'        => [
                'label'          => esc_html__( 'Image/Icon Position', 'wdc-wow-divi-carousel' ),
                'type'           => 'select',
                'tab_slug'       => 'advanced',
                'toggle_slug'    => 'image_icon',
                'mobile_options' => true,
                'default'        => 'top',
                'options'        => [
                    'top'   => esc_html__( 'Top', 'wdc-wow-divi-carousel' ),
                    'left'  => esc_html__( 'Left', 'wdc-wow-divi-carousel' ),
                    'right' => esc_html__( 'Right', 'wdc-wow-divi-carousel' ),
                ],
            ],

            'icon_color'            => [
                'label'       => esc_html__( 'Icon Color', 'wdc-wow-divi-carousel' ),
                'type'        => 'color-alpha',
                'tab_slug'    => 'advanced',
                'toggle_slug' => 'image_icon',
                'default'     => '#333',
                'show_if'     => [
                    'use_icon' => 'on',
                ],
            ],

            'icon_bg'               => [
                'label'       => esc_html__( 'Icon Background', 'wdc-wow-divi-carousel' ),
                'type'        => 'color-alpha',
                'tab_slug'    => 'advanced',
                'toggle_slug' => 'image_icon',
                'default'     => 'transparent',
                'show_if'     => [
                    'use_icon' => 'on',
                ],
            ],

            'icon_size'             => [
                'label'           => esc_html__( 'Icon Size', 'wdc-wow-divi-carousel' ),
                'type'            => 'range',
                'option_category' => 'basic_option',
                'allowed_units'   => ['em', 'rem', 'px', 'cm', '%', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw'],
                'default_unit'    => 'px',
                'default'         => '45px',
                'range_settings'  => [
                    'min'  => 0,
                    'step' => 1,
                    'max'  => 400,
                ],
                'toggle_slug'     => 'image_icon',
                'tab_slug'        => 'advanced',
                'mobile_options'  => true,
                'show_if'         => [
                    'use_icon' => 'on',
                ],
            ],

            'image_hover_animation' => [
                'label'       => esc_html__( 'Image Hover Animation', 'wdc-wow-divi-carousel' ),
                'type'        => 'select',
                'tab_slug'    => 'advanced',
                'toggle_slug' => 'image_icon',
                'default'     => 'none',
                'options'     => [
                    'none'         => esc_html__( 'None', 'wdc-wow-divi-carousel' ),
                    'zoom-in'      => esc_html__( 'Zoom In', 'wdc-wow-divi-carousel' ),
                    'zoom-out'     => esc_html__( 'Zoom Out', 'wdc-wow-divi-carousel' ),
                    'pulse'        => esc_html__( 'Pulse', 'wdc-wow-divi-carousel' ),
                    'bounce'       => esc_html__( 'Bounce', 'wdc-wow-divi-carousel' ),
                    'flash'        => esc_html__( 'Flash', 'wdc-wow-divi-carousel' ),
                    'rubberBand'   => esc_html__( 'Rubber Band', 'wdc-wow-divi-carousel' ),
                    'shake'        => esc_html__( 'Shake', 'wdc-wow-divi-carousel' ),
                    'swing'        => esc_html__( 'Swing', 'wdc-wow-divi-carousel' ),
                    'tada'         => esc_html__( 'Tada', 'wdc-wow-divi-carousel' ),
                    'wobble'       => esc_html__( 'Wobble', 'wdc-wow-divi-carousel' ),
                    'jello'        => esc_html__( 'Jello', 'wdc-wow-divi-carousel' ),
                    'heartBeat'    => esc_html__( 'Heart Beat', 'wdc-wow-divi-carousel' ),
                    'bounceIn'     => esc_html__( 'Bounce In', 'wdc-wow-divi-carousel' ),
                    'fadeIn'       => esc_html__( 'Fade In', 'wdc-wow-divi-carousel' ),
                    'flip'         => esc_html__( 'Flip', 'wdc-wow-divi-carousel' ),
                    'lightSpeedIn' => esc_html__( 'Light Speed In', 'wdc-wow-divi-carousel' ),
                    'rotateIn'     => esc_html__( 'Rotate In', 'wdc-wow-divi-carousel' ),
                    'slideInUp'    => esc_html__( 'Slide In Up', 'wdc-wow-divi-carousel' ),
                    'slideInDown'  => esc_html__( 'Slide In Down', 'wdc-wow-divi-carousel' ),
                ],
                'show_if'     => [
                    'use_icon' => 'off',
                ],
            ],

            'image_height'          => [
                'label'          => esc_html__( 'Image Height', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default_unit'   => 'px',
                'default'        => 'auto',
                'range_settings' => [
                    'min'  => 0,
                    'step' => 1,
                    'max'  => 500,
                ],
                'toggle_slug'    => 'image_icon',
                'tab_slug'       => 'advanced',
                'mobile_options' => true,
                'show_if'        => [
                    'use_icon' => 'off',
                ],
            ],

            'image_width'           => [
                'label'          => esc_html__( 'Image Width', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default'        => 'auto',
                'mobile_options' => true,
                'default_unit'   => '%',
                'range_settings' => [
                    'min'  => 0,
                    'step' => 1,
                    'max'  => 100,
                ],
                'toggle_slug'    => 'image_icon',
                'tab_slug'       => 'advanced',
                'show_if'        => [
                    'use_icon' => 'off',
                ],
            ],

            'image_spacing'         => [
                'label'          => esc_html__( 'Image/Icon Spacing', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default'        => '10px',
                'allowed_units'  => ['px'],
                'default_unit'   => 'px',
                'range_settings' => [
                    'min'  => 0,
                    'step' => 1,
                    'max'  => 100,
                ],
                'toggle_slug'    => 'image_icon',
                'tab_slug'       => 'advanced',
                'show_if'        => [
                    'image_position' => 'top',
                ],
            ],

            'icon_padding'          => [
                'label'          => esc_html__( 'Icon Padding', 'wdc-wow-divi-carousel' ),
                'type'           => 'custom_padding',
                'tab_slug'       => 'advanced',
                'toggle_slug'    => 'image_icon',
                'default'        => '0px|0px|0px|0px',
                'mobile_options' => true,
                'show_if'        => [
                    'use_icon' => 'on',
                ],
            ],

            // button.
            'btn_spacing_top'       => [
                'label'          => esc_html__( 'Spacing Top', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default'        => '15px',
                'default_unit'   => 'px',
                'range_settings' => [
                    'min'  => 0,
                    'step' => 1,
                    'max'  => 100,
                ],
                'toggle_slug'    => 'button',
                'tab_slug'       => 'advanced',
            ],

            // Card Text.
            'title_bottom_spacing'  => [
                'label'          => esc_html__( 'Title Spacing Bottom', 'wdc-wow-divi-carousel' ),
                'type'           => 'range',
                'default'        => '10px',
                'allowed_units'  => ['px'],
                'default_unit'   => 'px',
                'range_settings' => [
                    'min'  => 0,
                    'step' => 1,
                    'max'  => 100,
                ],
                'toggle_slug'    => 'texts',
                'tab_slug'       => 'advanced',
                'sub_toggle'     => 'title_tab',
            ],

            // Card settings.
            'content_alignment'     => [
                'label'            => esc_html__( 'Content Alignment', 'wdc-wow-divi-carousel' ),
                'type'             => 'text_align',
                'option_category'  => 'layout',
                'options'          => et_builder_get_text_orientation_options( ['justified'] ),
                'options_icon'     => 'module_align',
                'mobile_options'   => true,
                'default'          => 'left',
                'default_on_front' => 'left',
                'toggle_slug'      => 'card',
                'tab_slug'         => 'advanced',
            ],

            'content_padding'       => [
                'label'          => esc_html__( 'Content Padding', 'wdc-wow-divi-carousel' ),
                'type'           => 'custom_padding',
                'toggle_slug'    => 'card',
                'tab_slug'       => 'advanced',
                'default'        => '0px|0px|0px|0px',
                'mobile_options' => true,
            ],
        ];

        $tab_fields = $this->get_tab_fields();
        $overlay    = $this->get_overlay_option_fields( 'overlay', ['use_icon' => 'off'] );

        $label = [
            'admin_title' => [
                'label'       => esc_html__( 'Admin Label', 'wdc-wow-divi-carousel' ),
                'type'        => 'text',
                'description' => esc_html__( 'This will change the label of the item', 'wdc-wow-divi-carousel' ),
                'toggle_slug' => 'admin_label',
            ],
        ];

        return array_merge( $label, $content, $fields, $overlay, $tab_fields );
    }

    public function get_advanced_fields_config() {

        $advanced_fields                = [];
        $advanced_fields['text']        = false;
        $advanced_fields['text_shadow'] = false;
        $advanced_fields['filters']     = false;

        $advanced_fields['fonts']['badge'] = [
            'label'           => esc_html__( 'Badge', 'wdc-wow-divi-carousel' ),
            'css'             => [
                'main'      => '%%order_class%% .wdc-card-badge, .et-db #et-boc %%order_class%% .wdc-card-badge',
                'important' => 'all',
            ],
            'tab_slug'        => 'advanced',
            'toggle_slug'     => 'texts',
            'sub_toggle'      => 'badge',
            'hide_text_align' => true,
            'line_height'     => [
                'default'        => '1em',
                'range_settings' => [
                    'min'  => '1',
                    'max'  => '3',
                    'step' => '.1',
                ],
            ],
            'font_size'       => [
                'default' => '13px',
            ],
        ];

        $advanced_fields['fonts']['title'] = [
            'label'            => esc_html__( 'Title', 'wdc-wow-divi-carousel' ),
            'css'              => [
                'main'      => '%%order_class%% .wdc-card-title, .et-db #et-boc %%order_class%% .wdc-card-title',
                'important' => 'plugin_only',
            ],
            'tab_slug'         => 'advanced',
            'toggle_slug'      => 'texts',
            'sub_toggle'       => 'title_tab',
            'header_level'     => [
                'default' => 'h3',
            ],
            'options_priority' => [
                'toggle_text_color' => 9,
            ],
        ];

        $advanced_fields['fonts']['description'] = [
            'label'       => esc_html__( 'Description', 'wdc-wow-divi-carousel' ),
            'css'         => [
                'main'      => '%%order_class%% .wdc-card-desc, .et-db #et-boc %%order_class%% .wdc-card-desc',
                'important' => 'all',
            ],
            'important'   => 'all',
            'tab_slug'    => 'advanced',
            'toggle_slug' => 'texts',
            'sub_toggle'  => 'description_tab',
            'line_height' => [
                'range_settings' => [
                    'min'  => '1',
                    'max'  => '100',
                    'step' => '1',
                ],
            ],
            'font_size'   => [
                'default' => '14px',
            ],
        ];

        $advanced_fields['borders']['card'] = [
            'label_prefix' => esc_html__( 'Card', 'wdc-wow-divi-carousel' ),
            'toggle_slug'  => 'card',
            'css'          => [
                'main'      => [
                    'border_radii'  => '%%order_class%%',
                    'border_styles' => '%%order_class%%',
                ],
                'important' => 'all',
            ],
            'defaults'     => [
                'border_radii'  => 'on|0px|0px|0px|0px',
                'border_styles' => [
                    'width' => '0px',
                    'color' => '#333',
                    'style' => 'solid',
                ],
            ],
        ];

        $advanced_fields['borders']['image'] = [
            'label_prefix' => esc_html__( 'Image', 'wdc-wow-divi-carousel' ),
            'toggle_slug'  => 'image_icon',
            'css'          => [
                'main'      => [
                    'border_radii'  => '%%order_class%% .border-el',
                    'border_styles' => '%%order_class%% .border-el',
                ],
                'important' => 'all',
            ],
            'defaults'     => [
                'border_radii'  => 'on|0px|0px|0px|0px',
                'border_styles' => [
                    'width' => '0px',
                    'color' => '#333',
                    'style' => 'solid',
                ],
            ],
        ];

        $advanced_fields['borders']['badge'] = [
            'toggle_slug'  => 'badge',
            'label_prefix' => esc_html__( 'Badge', 'wdc-wow-divi-carousel' ),
            'css'          => [
                'main'      => [
                    'border_radii'  => '%%order_class%% .wdc-card-badge',
                    'border_styles' => '%%order_class%% .wdc-card-badge',
                ],
                'important' => 'all',
            ],
            'defaults'     => [
                'border_radii'  => 'on|0px|0px|0px|0px',
                'border_styles' => [
                    'width' => '0',
                    'color' => '#333',
                    'style' => 'solid',
                ],
            ],
        ];

        $advanced_fields['button']['button'] = [
            'label'          => esc_html__( 'Button', 'wdc-wow-divi-carousel' ),
            'css'            => [
                'main'      => '%%order_class%% .wdc-btn-card',
                'alignment' => '%%order_class%% .wdc-btn-card-wrap',
                'important' => 'all',
            ],
            'use_alignment'  => false,
            'box_shadow'     => [
                'css' => [
                    'main' => '%%order_class%% .wdc-btn-card',
                ],
            ],
            'borders'        => [
                'css' => [
                    'important' => 'all',
                ],
            ],
            'margin_padding' => [
                'css' => [
                    'important' => 'all',
                ],
            ],
            'use_alignment'  => true,
        ];

        $advanced_fields['margin_padding'] = [
            'css' => [
                'main'      => '%%order_class%% .wdc-card',
                'important' => true,
            ],
        ];

        return $advanced_fields;
    }

    public function render_badge() {

        if ( 'off' === $this->props['is_hide_badge'] ) {
            return sprintf(
                '<div class="wdc-card-badge pos--%1$s">%2$s</div>',
                $this->props['badge_position'],
                $this->props['badge_text']
            );
        }

    }

    public function render_figure() {

        if ( 'on' === $this->props['use_icon'] ) {
            return;
        }

        $photo                  = $this->props['photo'];
        $photo_alt              = $this->props['photo_alt'];
        $processed_overlay_icon = esc_attr( et_pb_process_font_icon( $this->props['overlay_icon'] ) );
        $overlay_icon           = !empty( $processed_overlay_icon ) ? $processed_overlay_icon : '';
        $data_schema            = $this->get_swapped_img_schema( 'photo', '' );
        $parent_module          = self::get_parent_modules( 'page' )['wdc_card_carousel'];
        $is_lazyload            = $parent_module->shortcode_atts['is_lazyload'];

        if ( !empty( $photo ) ) {
            wdc_inject_fa_icons( $this->props['overlay_icon'] );
            return sprintf(
                '<div class="wdc-card-figure">
                    %1$s
                    <div class="wdc-card-figure-inner border-el wdc-lightbox-ctrl">
                        <div class="wdc-overlay"><span class="wdc-overlay-icon">%4$s</span></div>
                        <img class="wdc-card-figure-img wdc-swapped-img" data-mfp-src="%2$s" %5$s="%2$s" %3$s alt="%6$s"/>
                    </div>
                </div>',
                $this->render_badge(),
                $photo,
                $data_schema,
                $overlay_icon,
                'on' === $is_lazyload ? 'data-lazy' : 'src',
                $photo_alt
            );
        }

    }

    public function render_title() {

        $title_text            = $this->props['title'];
        $title_level           = $this->props['title_level'];
        $processed_title_level = et_pb_process_header_level( $title_level, 'h3' );
        $processed_title_level = esc_html( $processed_title_level );

        if ( !empty( $title_text ) ) {
            return sprintf( '<%2$s class="wdc-card-title">%1$s</%2$s>', $title_text, $processed_title_level );
        }

    }

    public function render_description() {
        $description = $this->props['description'];

        if ( !empty( $description ) ) {
            return sprintf( '<p class="wdc-card-desc">%1$s</p>', $description );
        }

    }

    public function render_icon() {

        if ( 'off' === $this->props['use_icon'] ) {
            return;
        }

        $icon_name = esc_attr( et_pb_process_font_icon( $this->props['icon'] ) );
        wdc_inject_fa_icons( $this->props['icon'] );
        return sprintf(
            '<div class="wdc-card-icon-wrap"> %1$s
                <div class="wdc-card-icon border-el">
                    <i class="wdc-et-icon">%2$s</i>
                </div>
            </div>',
            $this->render_badge(),
            $icon_name
        );
    }

    public function render_custom_button() {

        if ( 'on' === $this->props['use_button'] ) {

            $button_custom = $this->props['custom_button'];
            $button_text   = isset( $this->props['button_text'] ) ? $this->props['button_text'] : 'Click Here';
            $button_link   = isset( $this->props['button_link'] ) ? $this->props['button_link'] : '#';
            $button_url    = trim( $button_link );
            $new_tab       = $this->props['is_new_wndow'];
            $button_rel    = $this->props['button_rel'];

            $custom_icon_values = et_pb_responsive_options()->get_property_values( $this->props, 'button_icon' );
            $custom_icon        = isset( $custom_icon_values['desktop'] ) ? $custom_icon_values['desktop'] : '';
            $custom_icon_tablet = isset( $custom_icon_values['tablet'] ) ? $custom_icon_values['tablet'] : '';
            $custom_icon_phone  = isset( $custom_icon_values['phone'] ) ? $custom_icon_values['phone'] : '';
            $multi_view         = et_pb_multi_view_options( $this );

            wdc_inject_fa_icons( $this->props['button_icon'] );

            $button = $this->render_button(
                [
                    'button_classname'    => ['wdc-btn-default', 'wdc-btn-card'],
                    'button_custom'       => $button_custom,
                    'button_text'         => $button_text,
                    'button_rel'          => $button_rel,
                    'button_text_escaped' => true,
                    'button_url'          => $button_url,
                    'custom_icon'         => $custom_icon,
                    'custom_icon_tablet'  => $custom_icon_tablet,
                    'custom_icon_phone'   => $custom_icon_phone,
                    'url_new_window'      => $new_tab,
                    'has_wrapper'         => false,
                    'multi_view_data'     => $multi_view->render_attrs(
                        [
                            'content'        => '{{button_text}}',
                            'hover_selector' => '%%order_class%% .dtq-btn-card',
                            'visibility'     => [
                                'button_text' => '__not_empty',
                            ],
                        ]
                    ),
                ]
            );

            return sprintf(
                '<div class="wdc-btn-card-wrap">
                    %1$s
                </div>',
                $button
            );
        }

    }

    public function render_content() {

        $title       = $this->props['title'];
        $description = $this->props['description'];
        $use_button  = $this->props['use_button'];

        if ( empty( $title ) && empty( $description ) && 'off' === $use_button ) {
            return false;
        }

        return sprintf(
            '<div class="wdc-card-content">%1$s %2$s %3$s</div>',
            $this->render_title(),
            $this->render_description(),
            $this->render_custom_button()
        );
    }

    public function render( $attrs, $content, $render_slug ) {

        global $wdc_card_child;
        global $wdc_uid_card;

        if ( empty( $wdc_uid_card ) && 0 !== $wdc_uid_card ) {
            $wdc_uid_card = 0;
        }

        $wdc_card_child[$wdc_uid_card][] = [
            'tab_title'    => !empty( $this->props['tab_title'] ) ? $this->props['tab_title'] : $this->props['title'],
            'tab_subtitle' => !empty( $this->props['tab_subtitle'] ) ? $this->props['tab_subtitle'] : $this->props['description'],
            'tab_thumb'    => !empty( $this->props['tab_thumb'] ) ? $this->props['tab_thumb'] : $this->props['photo'],
        ];

        $this->apply_css( $render_slug );

        // Module classnames.
        $this->remove_classname( 'et_pb_module' );
        $this->add_classname( 'wdc_et_pb_module' );

        $image_hover_animation = $this->props['image_hover_animation'];
        $use_icon              = $this->props['use_icon'];

        $classes = sprintf(
            'wdc-hover--%1$s use-icon-%2$s',
            $image_hover_animation,
            $use_icon
        );

        // Output.
        return sprintf(
            '<div class="wdc-carousel-item wdc-card wdc-swapped-img-selector %1$s">
			    %2$s %3$s %4$s
	    	</div>',
            $classes,
            $this->render_figure(),
            $this->render_icon(),
            $this->render_content()
        );
    }

    public function apply_css( $render_slug ) {

        $use_icon                       = $this->props['use_icon'];
        $content_alignment              = $this->props['content_alignment'];
        $image_width                    = $this->props['image_width'];
        $icon_padding                   = $this->props['icon_padding'];
        $icon_padding_tablet            = $this->props['icon_padding_tablet'];
        $icon_padding_phone             = $this->props['icon_padding_phone'];
        $icon_padding_last_edited       = $this->props['icon_padding_last_edited'];
        $icon_padding_responsive_status = et_pb_get_responsive_status( $icon_padding_last_edited );
        $image_position                 = $this->props['image_position'];
        $image_position_tablet          = $this->props['image_position_tablet'];
        $image_position_phone           = $this->props['image_position_phone'];
        $image_spacing                  = $this->props['image_spacing'];
        $image_height_tablet            = $this->props['image_height_tablet'];
        $image_height_last_edited       = $this->props['image_height_last_edited'];
        $image_height_responsive_status = et_pb_get_responsive_status( $image_height_last_edited );
        $image_width_tablet             = $this->props['image_width_tablet'];
        $image_width_phone              = $this->props['image_width_phone'];
        $image_width_last_edited        = $this->props['image_width_last_edited'];
        $image_width_responsive_status  = et_pb_get_responsive_status( $image_width_last_edited );

        $badge_pos                        = explode( '_', $this->props['badge_position'] );
        $badge_padding                    = $this->props['badge_padding'];
        $badge_offset_x_tablet            = $this->props['badge_offset_x_tablet'];
        $badge_offset_y_tablet            = $this->props['badge_offset_y_tablet'];
        $badge_offset_y_phone             = $this->props['badge_offset_y_phone'];
        $badge_offset_x_phone             = $this->props['badge_offset_x_phone'];
        $badge_offset_x_last_edited       = $this->props['badge_offset_x_last_edited'];
        $badge_offset_x_responsive_status = et_pb_get_responsive_status( $badge_offset_x_last_edited );
        $badge_offset_y_last_edited       = $this->props['badge_offset_y_last_edited'];
        $badge_offset_y_responsive_status = et_pb_get_responsive_status( $badge_offset_y_last_edited );

        $content_padding                   = $this->props['content_padding'];
        $content_padding_tablet            = $this->props['content_padding_tablet'];
        $content_padding_phone             = $this->props['content_padding_phone'];
        $content_padding_last_edited       = $this->props['content_padding_last_edited'];
        $content_padding_responsive_status = et_pb_get_responsive_status( $content_padding_last_edited );

        $button_custom_padding = $this->props['button_custom_padding'];
        $title_bottom_spacing  = $this->props['title_bottom_spacing'];
        $btn_spacing_top       = $this->props['btn_spacing_top'];

        if ( 'top' !== $image_position ) {

            if ( 'auto' === $image_width ) {
                $image_width = '50%';
            }

        } else {

            if ( 'auto' === $image_width ) {
                $image_width = '100%';
            }

        }

        if ( class_exists( 'ET_Builder_Module_Helper_Style_Processor' ) ) {
            $this->generate_styles(
                [
                    'utility_arg'    => 'icon_font_family',
                    'render_slug'    => $render_slug,
                    'base_attr_name' => 'icon',
                    'important'      => true,
                    'selector'       => '%%order_class%% .wdc-card-icon-wrap .wdc-et-icon',
                    'processor'      => [
                        'ET_Builder_Module_Helper_Style_Processor',
                        'process_extended_icon',
                    ],
                ]
            );
            $this->generate_styles(
                [
                    'utility_arg'    => 'icon_font_family',
                    'render_slug'    => $render_slug,
                    'base_attr_name' => 'overlay_icon',
                    'important'      => true,
                    'selector'       => '%%order_class%% .wdc-overlay .wdc-overlay-icon',
                    'processor'      => [
                        'ET_Builder_Module_Helper_Style_Processor',
                        'process_extended_icon',
                    ],
                ]
            );
        }

        if ( 'top' === $image_position ) {

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card',
                    'declaration' => 'flex-direction: column;',
                ]
            );

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card-content',
                    'declaration' => 'width: 100%;',
                ]
            );

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card',
                    'declaration' => $this->get_conditional_responsive_styles( [], $content_alignment, 'align-items' ),
                ]
            );

        } elseif ( 'right' === $image_position ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card',
                    'declaration' => 'flex-direction: row-reverse;',
                ]
            );
        } elseif ( 'left' === $image_position ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card',
                    'declaration' => 'flex-direction: row;',
                ]
            );
        }

        if ( 'top' === $image_position_tablet ) {

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    'declaration' => 'flex-direction: column;',
                ]
            );

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card-content',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    'declaration' => 'width: 100%;',
                ]
            );

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    'declaration' => $this->get_conditional_responsive_styles( [], $content_alignment, 'align-items' ),
                ]
            );

        } elseif ( 'right' === $image_position_tablet ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    'declaration' => 'flex-direction: row-reverse;',
                ]
            );
        } elseif ( 'left' === $image_position_tablet ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    'declaration' => 'flex-direction: row;',
                ]
            );
        }

        if ( 'top' === $image_position_phone ) {

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                    'declaration' => 'flex-direction: column;',
                ]
            );

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card-content',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                    'declaration' => 'width: 100%;',
                ]
            );

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                    'declaration' => $this->get_conditional_responsive_styles( [], $content_alignment, 'align-items' ),
                ]
            );

        } elseif ( 'right' === $image_position_phone ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                    'declaration' => 'flex-direction: row-reverse;',
                ]
            );
        } elseif ( 'left' === $image_position_phone ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                    'declaration' => 'flex-direction: row;',
                ]
            );
        }

        // Content Alignment.
        $this->get_responsive_styles(
            'content_alignment',
            '%%order_class%% .wdc-card',
            ['primary' => 'text-align'],
            ['default' => 'left'],
            $render_slug
        );

        // Button.
        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-btn-card-wrap',
                'declaration' => sprintf( 'padding-top: %1$s!important;', $btn_spacing_top ),
            ]
        );

        // Texts.
        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-card-title, .et-db #et-boc %%order_class%% .wdc-card-title',
                'declaration' => sprintf( 'padding-bottom: %1$s!important;', $title_bottom_spacing ),
            ]
        );

// Figure Spacing bottom.
        if ( 'top' === $image_position ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card-figure, %%order_class%% .wdc-card-icon-wrap',
                    'declaration' => sprintf( 'margin-bottom: %1$s;', $image_spacing ),
                ]
            );
        }

        // Icon Padding.
        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-card .wdc-card-icon',
                'declaration' => $this->wdc_process_padding( $icon_padding, false ),
            ]
        );

// Icon Padding tablet.
        if ( $icon_padding_tablet && $icon_padding_responsive_status ) {

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card .wdc-card-icon',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    'declaration' => $this->wdc_process_padding( $icon_padding_tablet, false ),
                ]
            );
        }

// Icon Padding phone.
        if ( $icon_padding_phone && $icon_padding_responsive_status ) {

            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card .wdc-card-icon',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                    'declaration' => $this->wdc_process_padding( $icon_padding_phone, false ),
                ]
            );

        }

        if ( 'off' === $use_icon ) {

            // Figure Height.
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card-figure',
                    'declaration' => sprintf( 'height: %1$s;', $this->props['image_height'] ),
                ]
            );

            if ( 'auto' !== $this->props['image_height'] ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-card-figure img',
                        'declaration' => 'height: 100%;',
                    ]
                );
            }

// Figure Height tablet.
            if ( $image_height_tablet && $image_height_responsive_status ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-card-figure',
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                        'declaration' => sprintf( 'height: %1$s;', $image_height_tablet ),
                    ]
                );
            }

            // Figure Height phone.
            $image_height_phone = $this->props['image_height_phone'];

            if ( $image_height_phone && $image_height_responsive_status ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-card-figure',
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                        'declaration' => sprintf( 'height: %1$s;', $image_height_phone ),
                    ]
                );
            }

            // Figure & Content width.
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card-figure',
                    'declaration' => sprintf( 'max-width: %1$s;width: %1$s;', $image_width ),
                ]
            );

// Figure & Content width tablet.
            if ( $image_width_tablet && $image_width_responsive_status ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-card-figure',
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                        'declaration' => sprintf( 'max-width: %1$s;width: %1$s;', $image_width_tablet ),
                    ]
                );
            }

// Figure & Content width phone.
            if ( $image_width_phone && $image_width_responsive_status ) {
                ET_Builder_Element::set_style(
                    $render_slug,
                    [
                        'selector'    => '%%order_class%% .wdc-card-figure',
                        'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                        'declaration' => sprintf( 'max-width: %1$s;width: %1$s;', $image_width_phone ),
                    ]
                );
            }

        }

        // Badge.
        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-card-badge',
                'declaration' => sprintf(
                    'background: %1$s; color: %2$s; %3$s',
                    $this->props['badge_bg'],
                    $this->props['badge_color'],
                    $this->wdc_process_padding( $badge_padding, false )
                ),
            ]
        );

        // Badge Offset x.
        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-card-badge',
                'declaration' => sprintf( '%1$s: %2$s;', $badge_pos[0], $this->props['badge_offset_x'] ),
            ]
        );

// Badge Offset x tablet.
        if ( $badge_offset_x_tablet && $badge_offset_x_responsive_status ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card-badge',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    'declaration' => sprintf( '%1$s: %2$s;', $badge_pos[0], $badge_offset_x_tablet ),
                ]
            );
        }

// Badge Offset x phone.
        if ( $badge_offset_x_phone && $badge_offset_x_responsive_status ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card-badge',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                    'declaration' => sprintf( '%1$s: %2$s;', $badge_pos[0], $badge_offset_x_phone ),
                ]
            );
        }

        // Badge Offset y.
        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-card-badge',
                'declaration' => sprintf( '%1$s: %2$s;', $badge_pos[1], $this->props['badge_offset_y'] ),
            ]
        );

// Badge Offset y tablet.
        if ( $badge_offset_y_tablet && $badge_offset_y_responsive_status ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card-badge',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    'declaration' => sprintf( '%1$s: %2$s;', $badge_pos[1], $badge_offset_y_tablet ),
                ]
            );
        }

// Badge Offset y phone.
        if ( $badge_offset_y_phone && $badge_offset_y_responsive_status ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card-badge',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                    'declaration' => sprintf( '%1$s: %2$s;', $badge_pos[1], $badge_offset_y_phone ),
                ]
            );
        }

        // Content padding.
        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-card-content',
                'declaration' => $this->wdc_process_padding( $content_padding, false ),
            ]
        );

// Content padding tablet.
        if ( $content_padding_tablet && $content_padding_responsive_status ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card-content',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
                    'declaration' => $this->wdc_process_padding( $content_padding_tablet, false ),
                ]
            );
        }

// Content padding phone.
        if ( $content_padding_phone && $content_padding_responsive_status ) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => '%%order_class%% .wdc-card-content',
                    'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
                    'declaration' => $this->wdc_process_padding( $content_padding_phone, false ),
                ]
            );
        }

        // Icon.
        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-card-icon',
                'declaration' => sprintf( 'background: %1$s;', $this->props['icon_bg'] ),
            ]
        );

        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => '%%order_class%% .wdc-card-icon i',
                'declaration' => sprintf( 'color: %1$s; font-size: %2$s;', $this->props['icon_color'], $this->props['icon_size'] ),
            ]
        );

        $this->get_buttons_styles( 'button', $render_slug, '%%order_class%% .wdc-btn-card-wrap .wdc-btn-card' );
        $this->get_overlay_style( $render_slug );

    }

}

new WDC_CardCarouselChild();
