<?php
class WDC_CardCarousel extends WDC_Builder_Module {

	protected $module_credits = array(
		'module_uri' => 'https://wowcarousel.com/modules/card-carousel/',
		'author'     => 'Wow Carousel',
		'author_uri' => 'https://divipeople.com/wow-divi-carousel/',
	);

	public function init() {

		$this->vb_support = 'on';
		$this->icon_path  = plugin_dir_path(__FILE__) . 'wdc-card-carousel.svg';
		$this->name       = esc_html__('Wow Card Carousel', 'wdc-wow-divi-carousel');
		$this->plural     = esc_html__('Wow Card Carousels', 'wdc-wow-divi-carousel');
		$this->slug       = 'wdc_card_carousel';
		$this->child_slug = 'wdc_card_carousel_child';

		$this->settings_modal_toggles = array(
			'general'  => array(
				'toggles' => array(
					'settings'     => array(
						'title'             => esc_html__('Carousel Settings', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'general'  => array(
								'name' => esc_html__('General', 'wdc-wow-divi-carousel'),
							),
							'advanced' => array(
								'name' => esc_html__('Advanced', 'wdc-wow-divi-carousel'),
							),
						),
					),
					'tab_settings' => esc_html__('Tab Settings', 'wdc-wow-divi-carousel'),
				),
			),

			'advanced' => array(
				'toggles' => array(
					'arrow'        => array(
						'title'             => esc_html__('Navigation', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'arrow_common' => array(
								'name' => esc_html__('Common', 'wdc-wow-divi-carousel'),
							),
							'arrow_left'   => array(
								'name' => esc_html__('Prev', 'wdc-wow-divi-carousel'),
							),
							'arrow_right'  => array(
								'name' => esc_html__('Next', 'wdc-wow-divi-carousel'),
							),
						),
					),
					'pagination'   => array(
						'title'             => esc_html__('Pagination', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'pagi_common' => array(
								'name' => esc_html__('Common', 'wdc-wow-divi-carousel'),
							),
							'pagi_active' => array(
								'name' => esc_html__('Active', 'wdc-wow-divi-carousel'),
							),
						),
					),

					'tab'          => array(
						'title'             => esc_html__('Tab Style', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'common' => array(
								'name' => esc_html__('Common', 'wdc-wow-divi-carousel'),
							),
							'active' => array(
								'name' => esc_html__('Active', 'wdc-wow-divi-carousel'),
							),
						),
					),

					'tab_elements' => array(
						'title'             => esc_html__('Tab Elements', 'wdc-wow-divi-carousel'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'title'    => array(
								'name' => esc_html__('Title', 'wdc-wow-divi-carousel'),
							),
							'subtitle' => array(
								'name' => esc_html__('Subtitle', 'wdc-wow-divi-carousel'),
							),
							'thumb'    => array(
								'name' => esc_html__('Thumbnail', 'wdc-wow-divi-carousel'),
							),
						),
					),
				),
			),
		);
	}

	public function get_fields() {

		$carousel_option = $this->get_carousel_option_fields('carousel', array('tab', 'lightbox', 'equal_height'));

		return $carousel_option;
	}

	public function get_advanced_fields_config() {

		$advanced_fields                 = array();
		$advanced_fields['text']         = false;
		$advanced_fields['borders']      = false;
		$advanced_fields['text_shadow']  = false;
		$advanced_fields['link_options'] = false;
		$advanced_fields['fonts']        = false;

		$advanced_fields['fonts']['title'] = array(
			'label'           => esc_html__('Title', 'wdc-wow-divi-carousel'),
			'css'             => array(
				'main'      => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item h2',
				'important' => 'all',
			),
			'tab_slug'        => 'advanced',
			'toggle_slug'     => 'tab_elements',
			'hide_text_align' => true,
			'sub_toggle'      => 'title',
		);

		$advanced_fields['fonts']['subtitle'] = array(
			'label'           => esc_html__('Title', 'wdc-wow-divi-carousel'),
			'css'             => array(
				'main'      => '%%order_class%% .wdc-carousel-nav .wdc-carousel-nav-item p',
				'important' => 'all',
			),
			'tab_slug'        => 'advanced',
			'hide_text_align' => true,
			'toggle_slug'     => 'tab_elements',
			'sub_toggle'      => 'subtitle',
		);

		return $advanced_fields;
	}


	public function render($attrs, $content, $render_slug) {

		$this->apply_css($render_slug);

		$sliding_dir      = $this->props['sliding_dir'];
		$content          = $this->props['content'];
		$is_center        = $this->props['is_center'];
		$center_mode_type = $this->props['center_mode_type'];
		$use_lightbox     = $this->props['use_lightbox'];
		$custom_cursor    = $this->props['custom_cursor'];
		$is_equal_height  = $this->props['is_equal_height'];
		$tab_placement    = $this->props['tab_placement'];
		$tab_position     = $this->props['tab_position'];
		$order_class      = self::get_module_order_class($render_slug);
		$order_number     = str_replace('_', '', str_replace($this->slug, '', $order_class));
		$classes          = array();

		global $wdc_card_child;
		global $wdc_uid_card;

		if (empty($wdc_uid_card) && 0 !== $wdc_uid_card) {
			$wdc_uid_card = 0;
		} else {
			++$wdc_uid_card;
		}

		if ('on' === $use_lightbox) {
			wp_enqueue_style('wdc-magnific');
			wp_enqueue_script('wdc-magnific');
		}

		array_push($classes, "wdc-lightbox-{$use_lightbox}");
		array_push($classes, "equal-height-{$is_equal_height}");

		if ('on' === $is_center) {
			array_push($classes, 'wdc-centered');
			array_push($classes, "wdc-centered--{$center_mode_type}");
		}

		if ('on' === $custom_cursor) {
			array_push($classes, 'wdc-cursor');
		}

		$parent_classes = 'top' === $tab_placement && 'normal' === $tab_position ? 'nav--top' : '';

		$output = sprintf(
			'<div class="wdc-carousel-parent %6$s" %2$s data-name="card" dir="%7$s">
                <div class="wdc-carousel wdc-card-carousel-%3$s  wdc-carousel-jq wdc-card-carousel wdc-carousel-frontend %4$s">
                    %1$s
                </div>
                %5$s
            </div>',
			$content,
			$this->get_carousel_options_data($order_number, 'card'),
			$order_number,
			join(' ', $classes),
			$this->render_carousel_nav($wdc_card_child, $order_number, $wdc_uid_card, 'card'),
			$parent_classes,
			$sliding_dir
		);

		return $output;
	}

	public function apply_css($render_slug) {
		$this->apply_carousel_css($render_slug);
		$this->apply_tab_css($render_slug);
	}
}

new WDC_CardCarousel();
