<?php
if ( ! class_exists( 'ET_Builder_Element' ) ) {
	return;
}

/**
 * Register all modules
 */
function wdc_register_modules() {

	$inactive_modules = get_option( 'wdc_inactive_modules', array() );
	$wdc_options      = get_option( 'wdc_options' );
	$wdcl_merge       = isset( $wdc_options['wdcl_merge'] ) ? $wdc_options['wdcl_merge'] : 'off';

	require_once plugin_dir_path( __FILE__ ) . 'modules/WowBuilder/WowBuilder.php';
	require_once plugin_dir_path( __FILE__ ) . 'modules/WowBuilder/WowBuilderModuleTypePostBased.php';

	if ( ! in_array( 'image-carousel', $inactive_modules, true ) ) {
		if ( 'on' === $wdcl_merge ) {
			require_once plugin_dir_path( __FILE__ ) . 'modules/ImageCarouselLite/ImageCarousel.php';
			require_once plugin_dir_path( __FILE__ ) . 'modules/ImageCarouselChildLite/ImageCarouselChild.php';
		} else {
			require_once plugin_dir_path( __FILE__ ) . 'modules/ImageCarousel/ImageCarousel.php';
			require_once plugin_dir_path( __FILE__ ) . 'modules/ImageCarouselChild/ImageCarouselChild.php';
		}
	}

	if ( ! in_array( 'card-carousel', $inactive_modules, true ) ) {
		require_once plugin_dir_path( __FILE__ ) . 'modules/CardCarousel/CardCarousel.php';
		require_once plugin_dir_path( __FILE__ ) . 'modules/CardCarouselChild/CardCarouselChild.php';
	}

	if ( ! in_array( 'team-carousel', $inactive_modules, true ) ) {
		require_once plugin_dir_path( __FILE__ ) . 'modules/TeamCarousel/TeamCarousel.php';
		require_once plugin_dir_path( __FILE__ ) . 'modules/TeamCarouselChild/TeamCarouselChild.php';
	}

	if ( ! in_array( 'twitter-feed', $inactive_modules, true ) ) {
		if ( 'on' === $wdcl_merge ) {
			require_once plugin_dir_path( __FILE__ ) . 'modules/TwitterFeedCarouselLite/TwitterFeedCarousel.php';
		} else {
			require_once plugin_dir_path( __FILE__ ) . 'modules/TwitterFeedCarousel/TwitterFeedCarousel.php';
		}
	}

	if ( ! in_array( 'content-carousel', $inactive_modules, true ) ) {
		require_once plugin_dir_path( __FILE__ ) . 'modules/ContentCarousel/ContentCarousel.php';
		require_once plugin_dir_path( __FILE__ ) . 'modules/ContentCarouselChild/ContentCarouselChild.php';
	}

	if ( ! in_array( 'logo-carousel', $inactive_modules, true ) ) {
		if ( 'on' === $wdcl_merge ) {
			require_once plugin_dir_path( __FILE__ ) . 'modules/LogoCarouselLite/LogoCarousel.php';
			require_once plugin_dir_path( __FILE__ ) . 'modules/LogoCarouselChildLite/LogoCarouselChild.php';
		} else {
			require_once plugin_dir_path( __FILE__ ) . 'modules/LogoCarousel/LogoCarousel.php';
			require_once plugin_dir_path( __FILE__ ) . 'modules/LogoCarouselChild/LogoCarouselChild.php';
		}
	}

	if ( ! in_array( 'google-reviews', $inactive_modules, true ) ) {
		require_once plugin_dir_path( __FILE__ ) . 'modules/GoogleReviews/GoogleReviews.php';
	}

	if ( ! in_array( 'divi-library', $inactive_modules, true ) ) {
		require_once plugin_dir_path( __FILE__ ) . 'modules/DiviLibrary/DiviLibrary.php';
		require_once plugin_dir_path( __FILE__ ) . 'modules/DiviLibraryChild/DiviLibraryChild.php';
	}

	if ( ! in_array( 'post-carousel', $inactive_modules, true ) ) {
		require_once plugin_dir_path( __FILE__ ) . 'modules/PostCarousel/PostCarousel.php';
		require_once plugin_dir_path( __FILE__ ) . 'modules/PostCarousel/WowPostHelper.php';
	}

	if ( ! in_array( 'testimonial-carousel', $inactive_modules, true ) ) {
		require_once plugin_dir_path( __FILE__ ) . 'modules/TestimonialCarousel/TestimonialCarousel.php';
		require_once plugin_dir_path( __FILE__ ) . 'modules/TestimonialCarouselChild/TestimonialCarouselChild.php';
	}

	if ( ! in_array( 'product-carousel', $inactive_modules, true ) ) {
		require_once plugin_dir_path( __FILE__ ) . 'modules/ProductCarousel/ProductCarousel.php';
		require_once plugin_dir_path( __FILE__ ) . 'modules/ProductCarousel/WowProductHelper.php';
	}

	if ( ! in_array( 'instagram-feed', $inactive_modules, true ) ) {
		require_once plugin_dir_path( __FILE__ ) . 'modules/InstagramFeed/InstagramFeed.php';
	}

	if ( ! in_array( 'video-carousel', $inactive_modules, true ) ) {
		require_once plugin_dir_path( __FILE__ ) . 'modules/VideoCarousel/VideoCarousel.php';
		require_once plugin_dir_path( __FILE__ ) . 'modules/VideoCarouselChild/VideoCarouselChild.php';
	}

}

// kickoff.
wdc_register_modules();
