<?php
defined( 'ABSPATH' ) || die();

/**
 * SVG Icon
 */
function wdc_white_svg_icon() {
	return 'data:image/svg+xml;base64,PHN2ZyBpZD0iTGF5ZXJfMSIgZGF0YS1uYW1lPSJMYXllciAxIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMTQuOTEgMTE0LjkxIj48ZGVmcz48c3R5bGU+LmNscy0xe2ZpbGw6I2ZmZjt9PC9zdHlsZT48L2RlZnM+PHRpdGxlPnN2ZzwvdGl0bGU+PHBhdGggY2xhc3M9ImNscy0xIiBkPSJNMTEwLjQ4LDM1LjMzbC0zLjkxLDUuOTRhNi41OCw2LjU4LDAsMCwwLS45LDUuMSw0OS40Niw0OS40NiwwLDEsMS05NC4zMy02LjhjMC4xMS0uMjguMjItMC41NiwwLjM0LTAuODRBNDkuNDIsNDkuNDIsMCwwLDEsOTMuNDUsMjMuNTZhNy41LDcuNSwwLDAsMCwxMC42MS4zM2gwQTU3LjE5LDU3LjE5LDAsMSwwLDExMC40OCwzNS4zM1ptLTguMTIsMS40MSw1LTcuNjZhMC4yMSwwLjIxLDAsMCwwLDAtLjA2bC02LDUuNjVDMTAxLjcxLDM1LjM1LDEwMiwzNiwxMDIuMzYsMzYuNzRaIiB0cmFuc2Zvcm09InRyYW5zbGF0ZSgwIDAuMDIpIi8+PHBhdGggY2xhc3M9ImNscy0xIiBkPSJNMTAuODMsMzguNzNoMC44NGMtMC4xMi4yOC0uMjMsMC41Ni0wLjM0LDAuODRaIiB0cmFuc2Zvcm09InRyYW5zbGF0ZSgwIDAuMDIpIi8+PHBhdGggY2xhc3M9ImNscy0xIiBkPSJNMTA3LjU4LDI4LjgybC0wLjE3LjI2LTUsNy42Nkw3My41OSw4MC4zOSw1OS4yOSw1Ni4xNmExLjA5LDEuMDksMCwwLDAtMS44NiwwbC0xNSwyNC4yNUwyMS4zNSw0NC43M2g2LjA2YTkuMzgsOS4zOCwwLDAsMSw4LjE4LDQuNzlMNDEuODcsNjAuNyw1MC42LDQ4LjI4YTkuNTMsOS41MywwLDAsMSwxNS42Ny4xMmw4LDExLjczLDI3LjA5LTI1LjQ2LDYtNS42NVoiIHRyYW5zZm9ybT0idHJhbnNsYXRlKDAgMC4wMikiLz48cGF0aCBjbGFzcz0iY2xzLTEiIGQ9Ik0xMDcuNTgsMjguODJsLTAuMTcuMjYtNSw3LjY2TDczLjU5LDgwLjM5LDU5LjI5LDU2LjE2YTEuMDksMS4wOSwwLDAsMC0xLjg2LDBsLTE1LDI0LjI1TDIxLjM1LDQ0LjczaDYuMDZhOS4zOCw5LjM4LDAsMCwxLDguMTgsNC43OUw0MS44Nyw2MC43LDUwLjYsNDguMjhhOS41Myw5LjUzLDAsMCwxLDE1LjY3LjEybDgsMTEuNzMsMjcuMDktMjUuNDYsNi01LjY1WiIgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMCAwLjAyKSIvPjwvc3ZnPg==';
}

function wdc_google_svg_icon() {
	return '<svg id="wdc-google-icon" height="36" viewBox="0 0 512 512" width="36" xmlns="http://www.w3.org/2000/svg"><g><path d="m120 256c0-25.367 6.989-49.13 19.131-69.477v-86.308h-86.308c-34.255 44.488-52.823 98.707-52.823 155.785s18.568 111.297 52.823 155.785h86.308v-86.308c-12.142-20.347-19.131-44.11-19.131-69.477z" fill="#fbbd00"/><path d="m256 392-60 60 60 60c57.079 0 111.297-18.568 155.785-52.823v-86.216h-86.216c-20.525 12.186-44.388 19.039-69.569 19.039z" fill="#0f9d58"/><path d="m139.131 325.477-86.308 86.308c6.782 8.808 14.167 17.243 22.158 25.235 48.352 48.351 112.639 74.98 181.019 74.98v-120c-49.624 0-93.117-26.72-116.869-66.523z" fill="#31aa52"/><path d="m512 256c0-15.575-1.41-31.179-4.192-46.377l-2.251-12.299h-249.557v120h121.452c-11.794 23.461-29.928 42.602-51.884 55.638l86.216 86.216c8.808-6.782 17.243-14.167 25.235-22.158 48.352-48.353 74.981-112.64 74.981-181.02z" fill="#3c79e6"/><path d="m352.167 159.833 10.606 10.606 84.853-84.852-10.606-10.606c-48.352-48.352-112.639-74.981-181.02-74.981l-60 60 60 60c36.326 0 70.479 14.146 96.167 39.833z" fill="#cf2d48"/><path d="m256 120v-120c-68.38 0-132.667 26.629-181.02 74.98-7.991 7.991-15.376 16.426-22.158 25.235l86.308 86.308c23.753-39.803 67.246-66.523 116.87-66.523z" fill="#eb4132"/></g></svg>';
}


/**
 * Divi Library
 */
function wdc_divi_library() {

	$layouts = array();

	$_layouts      = get_posts(
		array(
			'post_type'      => 'et_pb_layout',
			'post_status'    => 'publish',
			'posts_per_page' => -1,
			'orderby'        => 'title',
		)
	);
	$layouts['-1'] = esc_html__( '--Select a slide--', 'wdc-wow-divi-carousel' );
	if ( ! empty( $_layouts ) ) {
		$_layouts = wp_list_pluck( $_layouts, 'post_title', 'ID' );
		foreach ( $_layouts as $value => $title ) {
			$layouts[ $value ] = $title;
		}
	}

	return $layouts;
}

function wdc_is_configured() {
	if ( get_option( 'wdc_api_key' ) ) {
		return true;
	}

	return false;
}

function wdc_gmb_accounts_list() {

	$gmb = new \WowDiviCarousel\Api\Google_My_Business();
	$gmb->init();

	$accounts      = $gmb->get_accounts();
	$accounts_list = array();

	if ( empty( $accounts->accounts ) ) {
		return false;
	} elseif ( ! is_object( $accounts ) || count( $accounts->accounts->accounts ) < 1 ) {
		return false;
	} else {
		foreach ( $accounts->accounts->accounts as $account ) {
			$accounts_list[ $account->name ] = $account->name;
			return $accounts_list;
		}
	}
}

function wdc_gmb_locations_list() {

	$accounts = wdc_gmb_accounts_list();

	$gmb = new \WowDiviCarousel\Api\Google_My_Business();
	$gmb->init();

	if ( empty( $accounts ) ) {
		return false;
	}

	foreach ( $accounts as $account ) {

		$locations = $gmb->get_locations( $account );

		if ( empty( $locations->locations ) ) {

			return false;

		} elseif ( ! is_object( $locations ) || count( $locations->locations->locations ) < 1 ) {

			return false;

		} else {

			$location_list['none'] = esc_html__( 'Select a list', 'wdc-wow-divi-carousel' );

			foreach ( $locations->locations->locations as $location ) {
				$location_list[ $location->name ] = $location->locationName; // phpcs:ignore
			}

			return $location_list;
		}
	}
}

function wdc_time_format( $datetime, $full = false ) {

	$now  = new DateTime();
	$ago  = new DateTime( $datetime );
	$diff = $now->diff( $ago );

	$diff->w  = floor( $diff->d / 7 );
	$diff->d -= $diff->w * 7;

	$string = array(
		'y' => __( 'year', 'wdc-wow-divi-carousel' ),
		'm' => __( 'month', 'wdc-wow-divi-carousel' ),
		'w' => __( 'week', 'wdc-wow-divi-carousel' ),
		'd' => __( 'day', 'wdc-wow-divi-carousel' ),
		'h' => __( 'hour', 'wdc-wow-divi-carousel' ),
		'i' => __( 'minute', 'wdc-wow-divi-carousel' ),
		's' => __( 'second', 'wdc-wow-divi-carousel' ),
	);

	foreach ( $string as $k => &$v ) {
		if ( $diff->$k ) {
			$v = $diff->$k . ' ' . $v . ( $diff->$k > 1 ? 's' : '' );
		} else {
			unset( $string[ $k ] );
		}
	}

	if ( ! $full ) {
		$string = array_slice( $string, 0, 1 );
	}
	return $string ? implode( ', ', $string ) . ' ago' : 'just now';
}

function wdc_pre_placeholder() {
	echo '<div id="wdc-loader-wrapper" class="wdc-loader-wrapper">' . __( 'Loading...', 'wdc-wow-divi-carousel' ) . '</div>'; //phpcs:ignore
}

add_action( 'wp_footer', 'wdc_pre_placeholder' );


function wdc_global_assets_list( $global_list ) {

	$assets_list   = array();
	$assets_prefix = et_get_dynamic_assets_path();

	$assets_list['et_icons_fa'] = array(
		'css' => "{$assets_prefix}/css/icons_fa_all.css",
	);

	return array_merge( $global_list, $assets_list );
}

function wdc_inject_fa_icons( $icon_data ) {
	if ( function_exists( 'et_pb_maybe_fa_font_icon' ) && et_pb_maybe_fa_font_icon( $icon_data ) ) {
		add_filter( 'et_global_assets_list', 'wdc_global_assets_list' );
		add_filter( 'et_late_global_assets_list', 'wdc_global_assets_list' );
	}
}
