<?php
namespace WowDiviCarousel\Api;

class Google_Places_Reviews {

	private $place_id = '';

	private $api_key = '';

	private $api_url = 'https://maps.googleapis.com/maps/api';

	private static $instance;

	public static function get_instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	public function __construct() {
		$wdc_options = get_option( 'wdc_options' );

		if ( isset( $wdc_options['google_api_key'] ) ) {
			$this->api_key = $wdc_options['google_api_key'];
		}
	}

	private function get_place_id() {
		return set_place_id( $this->place_id );
	}

	public function set_place_id( $place_id ) {
		$this->place_id = $place_id;
		return $this->place_id;
	}

	public function get_reviews() {

		$args['timeout'] = 20;
		$args['placeid'] = $this->place_id;
		$args['key']     = $this->api_key;

		return $this->_apiCall( '/place/details/json', $args );
	}

	private function _apiCall( $endpoint, $args = array() ) {
		$url      = add_query_arg( $args, $this->api_url . $endpoint );
		$response = wp_remote_get( esc_url_raw( $url ) );

		if ( is_wp_error( $response ) ) {
			$error_message = $response->get_error_message();
			return $error_message;
		} else {
			$data = json_decode( wp_remote_retrieve_body( $response ) );
			if ( ! isset( $data->error ) ) {
				return $data;
			} else {
				return $data->error;
			}
		}
	}
}

Google_Places_Reviews::get_instance();
