<?php

namespace WowDiviCarousel;

defined( 'ABSPATH' ) || die();

class Admin {

	const MODULES_NONCE = 'wdc_save_admin';

	public function __construct() {
		add_action( 'admin_menu', array( __CLASS__, 'add_menu' ), 21 );
		add_action( 'admin_enqueue_scripts', array( __CLASS__, 'enqueue_scripts' ), 21 );
		add_action( 'wp_ajax_' . self::MODULES_NONCE, array( __CLASS__, 'save_data' ) );
		add_action( 'wdc_save_admin_data', array( __CLASS__, 'save_modules_data' ) );
		add_action( 'wdc_save_admin_data', array( __CLASS__, 'save_options_data' ) );
	}

	public static function add_menu() {
		add_menu_page(
			__( 'WowCarousel', 'wdc-wow-divi-carousel' ),
			__( 'WowCarousel', 'wdc-wow-divi-carousel' ),
			'manage_options',
			'wow-divi-carousel',
			array( __CLASS__, 'render_main' ),
			wdc_white_svg_icon(),
			110
		);

	}

	public static function enqueue_scripts() {

		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		// Module core support for theme builder
		wp_enqueue_style(
			'wdc-admin-module-core',
			WOW_DIVI_CAROUSEL_ASSETS . 'css/module-core.css',
			null,
			WOW_DIVI_CAROUSEL_VERSION
		);

		wp_enqueue_style(
			'wdc-admin',
			WOW_DIVI_CAROUSEL_ASSETS . 'admin/css/admin.css',
			null,
			WOW_DIVI_CAROUSEL_VERSION
		);

		wp_enqueue_script(
			'wdc-admin-js',
			WOW_DIVI_CAROUSEL_ASSETS . 'admin/js/admin.js',
			array( 'jquery' ),
			WOW_DIVI_CAROUSEL_VERSION,
			true
		);

		wp_localize_script(
			'wdc-admin-js',
			'WowDiviCarousel',
			array(
				'ajaxUrl' => admin_url( 'admin-ajax.php' ),
				'nonce'   => wp_create_nonce( self::MODULES_NONCE ),
				'action'  => self::MODULES_NONCE,
			)
		);

	}

	public static function save_data() {
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		if ( ! check_ajax_referer( self::MODULES_NONCE, 'nonce' ) ) {
			wp_send_json_error();
		}

		$posted_data = ! empty( $_POST['data'] ) ? $_POST['data'] : '';  //phpcs:ignore

		$data = array();

		parse_str( $posted_data, $data );

		do_action( 'wdc_save_admin_data', $data );

		wp_send_json_success();
	}

	public static function save_options_data( $data ) {
		$options = ! empty( $data['options'] ) ? $data['options'] : array();

		update_option( 'wdc_options', $options );
	}

	public static function save_modules_data( $data ) {
		$modules          = ! empty( $data['modules'] ) ? $data['modules'] : array();
		$inactive_modules = array_values( array_diff( array_keys( self::get_all_modules() ), $modules ) );
		self::save_inactive_modules( $inactive_modules );
	}

	public static function get_inactive_modules() {
		return get_option( 'wdc_inactive_modules', array() );
	}

	public static function save_inactive_modules( $modules = array() ) {
		update_option( 'wdc_inactive_modules', $modules );
	}

	private static function get_all_modules() {

		$modules_map = array(

			'image-carousel'   => array(
				'demo'  => 'https://demo.divipeople.com/plugins/wow-carousel/wow-image-carousel/',
				'title' => __( 'Image Carousel', 'wdc-wow-divi-carousel' ),
				'icon'  => '',
			),

			'logo-carousel'    => array(
				'demo'  => 'https://demo.divipeople.com/plugins/wow-carousel/wow-logo-carousel/',
				'title' => __( 'Logo Carousel', 'wdc-wow-divi-carousel' ),
				'icon'  => '',
			),

			'content-carousel' => array(
				'demo'  => 'https://demo.divipeople.com/plugins/wow-carousel/wow-content-carousel/',
				'title' => __( 'Content Carousel', 'wdc-wow-divi-carousel' ),
				'icon'  => '',
			),

			'card-carousel'    => array(
				'demo'  => 'https://demo.divipeople.com/plugins/wow-carousel/wow-card-carousel/',
				'title' => __( 'Card Carousel', 'wdc-wow-divi-carousel' ),
				'icon'  => '',
			),

			'team-carousel'    => array(
				'demo'  => 'https://demo.divipeople.com/plugins/wow-carousel/wow-team-carousel/',
				'title' => __( 'Team Carousel', 'wdc-wow-divi-carousel' ),
				'icon'  => '',
			),

			'testimonial'      => array(
				'demo'  => 'https://demo.divipeople.com/plugins/wow-carousel/wow-testimonial-carousel/',
				'title' => __( 'Testimonial Carousel', 'wdc-wow-divi-carousel' ),
				'icon'  => '',
			),

			'divi-library'     => array(
				'demo'  => 'https://demo.divipeople.com/plugins/wow-carousel/wow-smart-slider/',
				'title' => __( 'Divi Library Carousel', 'wdc-wow-divi-carousel' ),
				'icon'  => '',
			),

			'post-carousel'    => array(
				'demo'  => 'https://demo.divipeople.com/plugins/wow-carousel/wow-post-carousel/',
				'title' => __( 'Post Carousel', 'wdc-wow-divi-carousel' ),
				'icon'  => '',
			),

			'twitter-feed'     => array(
				'demo'  => 'https://demo.divipeople.com/plugins/wow-carousel/wow-twitter-feed/',
				'title' => __( 'Twitter Feed', 'wdc-wow-divi-carousel' ),
				'icon'  => '',
			),

			'product-carousel' => array(
				'demo'  => 'https://demo.divipeople.com/plugins/wow-carousel/wow-woocommerce-products/',
				'title' => __( 'Product Carousel', 'wdc-wow-divi-carousel' ),
				'icon'  => '',
			),

			'google-reviews'   => array(
				'demo'  => 'https://demo.divipeople.com/plugins/wow-carousel/wow-google-review/',
				'title' => __( 'Google Review', 'wdc-wow-divi-carousel' ),
				'icon'  => '',
			),

			'instagram-feed'   => array(
				'demo'  => 'https://demo.divipeople.com/plugins/wow-carousel/wow-instagram-feed/',
				'title' => __( 'Instagram Feed', 'wdc-wow-divi-carousel' ),
				'icon'  => '',
			),

			'video-carousel'   => array(
				'demo'  => 'https://demo.divipeople.com/plugins/wow-carousel/wow-video-carousel/',
				'title' => __( 'Video Carousel', 'wdc-wow-divi-carousel' ),
				'icon'  => '',
			),

		);

		return $modules_map;
	}

	public static function get_modules() {

		$modules_map = self::get_all_modules();

		uksort( $modules_map, array( __CLASS__, 'sort_modules' ) );

		return $modules_map;
	}

	public static function sort_modules( $k1, $k2 ) {
		return strcasecmp( $k1, $k2 );
	}

	public static function get_tabs() {

		$icon_url = WOW_DIVI_CAROUSEL_ASSETS . 'imgs/admin/';

		$tabs = array(
			'home'        => array(
				'title'    => esc_html__( 'Home', 'wdc-wow-divi-carousel' ),
				'icon'     => $icon_url . 'home.svg',
				'renderer' => array( __CLASS__, 'render_home' ),
			),

			'integration' => array(
				'title'    => esc_html__( 'Integration', 'wdc-wow-divi-carousel' ),
				'icon'     => $icon_url . 'settings.svg',
				'renderer' => array( __CLASS__, 'render_integration' ),
			),
		);

		return $tabs;
	}

	/**
	 * Load all templates
	 */
	private static function load_template( $template ) {
		$file = WOW_DIVI_CAROUSEL_PLUGIN_DIR . 'templates/admin/admin-' . $template . '.php';
		if ( is_readable( $file ) ) {
			include $file;
		}
	}

	/**
	 * Render main template
	 */
	public static function render_main() {
		self::load_template( 'main' );
	}

	/**
	 * Render home template
	 */
	public static function render_home() {
		self::load_template( 'home' );
	}

	/**
	 * Render integration template
	 */
	public static function render_integration() {
		self::load_template( 'integration' );
	}

}
