;(function($, WowDiviCarousel) {
    'use strict';

    var $tabsNav = $('.wdc-nav').find('.wdc-tabs-nav'),
        $tabsContent = $('.wdc-admin-tabs').find('.wdc-admin-tabs-content');

    $tabsNav.on('click', '.wdc-admin-nav-item-link', function(e) {
        console.log('work!');
        
        var $currentTab = $(e.currentTarget),
            tabTargetHash = e.currentTarget.hash,
            tabIdSelector = '#tab-content-' + tabTargetHash.substring(1),
            $currentTabContent = $tabsContent.find(tabIdSelector);

        e.preventDefault();

        $currentTab
            .addClass('active-tab')
            .siblings()
            .removeClass('active-tab');

        $currentTabContent
            .addClass('active-tab')
            .siblings()
            .removeClass('active-tab');

        window.location.hash = tabTargetHash;
    });

    if (window.location.hash) {
        $tabsNav.find('a[href="'+window.location.hash+'"]').click();
    }

    // Submit form
	var $adminForm = $('#wdc-admin-form'),
	    $saveButton = $adminForm.find('.wdc-btn-save');

    $adminForm.on('submit', function(e) {
        e.preventDefault();
        $.post({
            url: WowDiviCarousel.ajaxUrl,
            data: {
                nonce: WowDiviCarousel.nonce,
                action: WowDiviCarousel.action,
                data: $adminForm.serialize()
            },

            beforeSend: function() {
                $saveButton.text('Saving...');
            },

            success: function(response) {
                if ( response.success ) {
                    var t = setTimeout(function () {
                        $saveButton
                            .attr('disabled', true)
                            .text('Changes Saved');
                        clearTimeout(t);
                    }, 500);
                }
            }
            
        });
    });

    $adminForm.on('change', ':checkbox, :radio', function() {
        $saveButton.attr('disabled', false).text('Save Changes');
    });

    $adminForm.on('change', ':text', function() {
        $saveButton.attr('disabled', false).text('Save Changes');
    });

}(jQuery, window.WowDiviCarousel));