<?php
    $trigger_on_scroll_offset = get_post_meta(
        $post->ID, 'trigger_on_scroll-offset', true
    );
    if (empty($trigger_on_scroll_offset)) {
        $trigger_on_scroll_offset = '0';
    }
    $trigger_on_scroll_offset_units = get_post_meta(
        $post->ID, 'trigger_autotrigger-offset_units', true
    );
    if (empty($trigger_on_scroll_offset_units)) {
        $trigger_on_scroll_offset_units = 'px';
    }
?>
<div class="dipi_popup-sub">
    <label
        for="trigger_on_scroll-offset"
        class="dipi_popup-sub-lbl"
    >
        Set scrolling offset
    </label>
    <div class="dipi_popup-sub-val-container" >
        <input class="dipi_popup-sub-val" 
            type="text"
            name="trigger_on_scroll-offset"
            size = 5
            value="<?php echo esc_attr($trigger_on_scroll_offset); ?>"
        />
        <p class="dipi_popup-sub-descr">Offset</p>
    </div>
    <div class="dipi_popup-sub-val-container raido" >
        <div class="dipi_popup-sub-val-radio-grp">
            <div class="dipi_popup-sub-val-radio-container">
                <input
                    type="radio"
                    name="trigger_autotrigger-offset_units"
                    value="px"
                    <?php if ( $trigger_on_scroll_offset_units == 'px' ) { ?> checked<?php } ?>
                >
                <label>px</label>      
            </div>
            <div class="dipi_popup-sub-val-radio-container">
                <input type="radio"
                    name="trigger_autotrigger-offset_units"
                    value="per"
                    <?php if ( $trigger_on_scroll_offset_units == 'per' ) { ?> checked<?php } ?>
                >
                <label>%</label>
            </div>
        </div>
        <p class="dipi_popup-sub-descr">Units</p>
    </div>
</div>

<div></div> <!--Need to add this empty element to show bottom border-->

