<?php
/*
Plugin Name: Divi Pixel
Plugin URI:  https://www.divi-pixel.com
Description: Divi Pixel is an all-in-one solution for all Divi users, from absolute beginners to professionals.
Version:     2.24.0
Author:      Octolab OÜ
Author URI:  https://www.divi-pixel.com
License:     GPL2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: dipi-divi-pixel
Domain Path: /languages
 */

/*************
 * Constants *
 *************/
define('DIPI_PLUGIN_FILE', __FILE__);
define('DIPI_VERSION', '2.24.0');
define('DIPI_ITEM_ID', 32718);
define('DIPI_BASE', plugin_basename(DIPI_PLUGIN_FILE));
define('DIPI_DIR', plugin_dir_path(DIPI_PLUGIN_FILE));
define('DIPI_URI', plugins_url('/', DIPI_PLUGIN_FILE));
define('DIPI_PASSWORD_MASK', "************************");
define('DIPI_STORE_URL', 'https://www.divi-pixel.com');
define('DIPI_AUTHOR', 'Divi Pixel');

define('DIPI_INSTAGRAM_REDIRECT_URL', 'https://auth.divi-pixel.com/instagram');
define('DIPI_INSTAGRAM_AUTH_TYPE_BASIC', 'basic');
define('DIPI_INSTAGRAM_AUTH_TYPE_GRAPH', 'graph');

/*********************
 * Plugin Activation *
 *********************/
if (!is_network_admin()) {
    if (dipi_is_theme('Divi') || dipi_is_theme('Extra') || dipi_is_divi_builder_plugin_active()) {
        require_once plugin_dir_path(__FILE__) . 'includes/plugin.php';
    }
}

function dipi_is_divi_builder_plugin_active()
{
    $pluginList = get_option('active_plugins');
    $plugin = 'divi-builder/divi-builder.php';
    return in_array($plugin, $pluginList);
}

function is_divi_builder_active()
{
    if (!function_exists('is_plugin_active')) {
        include_once ABSPATH . 'wp-admin/includes/plugin.php';
    }
    return is_plugin_active('divi-builder/divi-builder.php');
}

function dipi_is_theme($target)
{
    $theme = wp_get_theme();

    if ($theme->name == $target || stripos($theme->parent_theme, $target) !== false) {
        return true;
    }

    if (apply_filters('divi_ghoster_ghosted_theme', '') == $target) {
        return true;
    }

    // List of known third party clones of the Divi theme
    $themes = ['Maestro'];
    if (in_array($theme->name, $themes) || in_array($theme->parent_theme, $themes)) {
        return true;
    }

    return false;
}

if (!function_exists('dipi_is_vb')) {
    function dipi_is_vb()
    {
        return function_exists('et_core_is_fb_enabled') && et_core_is_fb_enabled();
    }
}
